/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.CubeRequestMetrics;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.SQLQueryMetrics;
import com.cognos.xqe.cache.CacheMetricsTracker;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.relational.jdbc.util.DirectAccessJDBCValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TextValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.rsapi.RSAPIResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSetToListAdaptor;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.SetSelections;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.IPipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.pipeline.PipelineResultSet;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.CachePopulator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ExecuteQueryStrategyLogMsg;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPCommonMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPQueryResultIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.QueryExecutionTupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCompoundKeyMapping;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryExecuteMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPQueryGroup;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.TupleValueGroupIterator;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QueryType;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateCacheLoader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDirtyDataCompensation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationMetrics;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCellsNotFoundException;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateSelector;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.combination.BlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementManager;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderAggregateCombination;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderAggregateSelection;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderCombination;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryResult;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.v5provider.V5ProviderSelection;
import com.cognos.xqe.runtree.olap.mdx.v5provider.XQueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.IPushdownAdapter;
import com.cognos.xqe.runtree.olap.mdx.v5provider.pushdown.ROLAPPushdownAdapter;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.ClosableIterator;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ConfigurationValues;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.primitive.HashMapLongObject;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import com.cognos.xqe.util.primitive.HashMapObjectLong;
import com.cognos.xqe.util.primitive.IteratorLong;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import com.ibm.icu.text.NumberFormat;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class ROLAPQueryStrategy
extends V5ProviderQueryStrategy {
    private static final String MEMBER_GROUP_PCH_LEAF = "PCH_Leaf";
    private MeasurePrefetchManager prefetchManager = null;
    private Hierarchy[] cubeHierarchies = null;
    private int cubeMeasureHierarchyIndex = -1;
    private HashMapObjectInt<String> hierToIndex = null;
    private String cubeletHint = null;
    private ROLAPQueryExecuteMetrics lastQueryMetrics = null;
    private boolean isSystemGenerated = false;
    private static final IPushdownAdapter PUSHDOWN_ADAPTER = new ROLAPPushdownAdapter();
    private static final int MAX_NUM_AGGREGATES = 64;

    @Override
    public IPushdownAdapter getPushdownAdapter() {
        return PUSHDOWN_ADAPTER;
    }

    public void setSystemGenerated(boolean systemGenerated) {
        this.isSystemGenerated = systemGenerated;
    }

    private boolean isOverfetchingAllowed() {
        return !this.getPushDownMode() || this.mPushdownManager.isOverfetchingAllowed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void executeAndFetchFromStore(CrossJoinedSet reqSet, IResultSet resultSet, ICube iCube) throws InterpreterException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCExecutionInQueryStrategy", ZipiContext.getQRDName());
        try {
            this.tryToExecuteAndFetchFromStore(reqSet, resultSet, iCube);
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToExecuteAndFetchFromStore(CrossJoinedSet reqSet, IResultSet resultSet, ICube iCube) throws InterpreterException {
        if (reqSet.size() < 0L) {
            NumberFormat nf = NumberFormat.getInstance();
            throw new XQERuntimeException(XQEMessageKeys.ROL_OrdinalSpaceTooLarge, nf.format(reqSet.noOverflowSize()));
        }
        TraceContext traceCtx = TraceContext.enter();
        traceCtx.addAttribute("rolapCube", this.getCube().getName());
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started execution of Query Strategy.");
        ROLAPQueryExecuteMetrics queryMetrics = new ROLAPQueryExecuteMetrics(resultSet.cellCount());
        XQueryStrategy queryStrategyProfiler = (XQueryStrategy)this.getInfoData().getQueryStrategyProfileNode();
        queryMetrics.setProfileNode(queryStrategyProfiler);
        this.lastQueryMetrics = queryMetrics;
        long startTime = System.nanoTime();
        ROLAPCube cube = (ROLAPCube)this.getCube();
        queryStrategyProfiler.begin();
        boolean needToRemoveCubeName = false;
        try {
            needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
            IBlockTupleStorage blockStorage = cube.getBlockTupleStorage();
            Hierarchy[] hierarchies = this.getCubeHierarchies();
            int measuresIndex = this.getCubeMeasuresHierarchyIndex();
            ISet setToFetch = reqSet;
            IMember[] measuresMembers = reqSet.getMembers(hierarchies[measuresIndex]);
            this.prefetchManager = new MeasurePrefetchManager(measuresMembers, measuresIndex);
            if (this.getPushDownMode() && this.mPushdownManager.executePushdown(setToFetch, measuresMembers, resultSet, blockStorage)) {
                this.mPushdownManager.setPushdownExecutionFinished(true);
                return;
            }
            if (setToFetch.isEmpty()) {
                return;
            }
            if ((setToFetch = this.populateResultSetFromCache(setToFetch, resultSet, blockStorage, cube.getAggregateCache(), queryMetrics, cube)) == null || setToFetch.isEmpty()) {
                return;
            }
            setToFetch = this.prefetchManager.injectPrefetchMeasures(hierarchies, setToFetch, cube.getConfigMeasuresThreshold());
            if (cube instanceof ROLAPBaseCube) {
                SetSelections setSel = new SetSelections(setToFetch);
                this.executeColdCacheToTupleStorage(setSel, resultSet, blockStorage, queryMetrics, QueryType.USER_REPORT_QUERY);
            }
        }
        finally {
            ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
            if (queryMetrics.getDataCacheHits() > 0) {
                this.incrementCacheHits(queryMetrics.getDataCacheHits());
            }
            cube.getMetrics().recordQueryTime(queryMetrics.getDataQueryTimeAsNano(), System.nanoTime() - startTime);
            if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
                ExecuteQueryStrategyLogMsg logMsg = new ExecuteQueryStrategyLogMsg(reqSet.size(), queryMetrics);
                logMsg.setReportName(ROLAPQueryStrategy.getReportName());
                ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", logMsg.toString());
            }
            TestEnvironmentOptions.TestHitCountTracker.updateFromQueryMetrics(queryMetrics);
            RequestEnvironment reqEnv = (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment();
            CubeRequestMetrics reqMetrics = reqEnv.getRequestMetrics().getCubeMetrics(cube);
            reqMetrics.update(queryMetrics);
            if (resultSet instanceof PipelineResultSet) {
                reqMetrics.incrementPipelineWaitTime(((PipelineResultSet)resultSet).getTotalCellEnqueueWaitTime());
            }
            queryStrategyProfiler.end();
            traceCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISet populateResultSetFromCache(ISet setToFetch, IResultSet resultSet, IBlockTupleStorage dataCache, IBlockTupleStorage aggregateCache, ROLAPQueryExecuteMetrics queryMetrics, ROLAPCube cube) throws InterpreterException {
        List<AggregateDefinition> aggDefinitions;
        WorkloadLogger logger = cube.getWorkloadLogger();
        boolean isLogging = logger.isLoggingQueries();
        CrossJoinedSet setToFetchBeforeDataCache = (CrossJoinedSet)setToFetch;
        IHierarchy[] hierarchies = null;
        MemberLevelInfo preDataCacheLevelInfo = null;
        if (null != setToFetchBeforeDataCache) {
            hierarchies = setToFetchBeforeDataCache.getHierarchies();
            preDataCacheLevelInfo = ((CrossJoinedSet)setToFetch).getMemberLevelInfo();
        }
        BlockTupleStorageFetchResult dataCacheFetchResult = null;
        if (dataCache != null) {
            queryMetrics.notifyOperationStart(XQueryStrategy.Operation.DATA_CACHE_RETRIEVAL);
            HighPrecisionStopWatch timer = new HighPrecisionStopWatch(true);
            try {
                dataCacheFetchResult = dataCache.getTupleValues(setToFetch, new ResultSetToListAdaptor(resultSet), this.cubeletHint);
                setToFetch = dataCacheFetchResult.createSet();
            }
            finally {
                queryMetrics.notifyOperationEnd(XQueryStrategy.Operation.DATA_CACHE_RETRIEVAL, resultSet.cellCount());
                BigInteger returnSetSize = BigInteger.ZERO;
                if (setToFetch != null && setToFetch.size() != 0L) {
                    returnSetSize = ((CrossJoinedSet)setToFetch).noOverflowSize();
                }
                queryMetrics.setDataCacheMetrics(setToFetchBeforeDataCache.noOverflowSize(), returnSetSize, timer.getElapsedTimeInMilliseconds());
            }
        }
        if (isLogging && queryMetrics.getDataCacheHits() > 0) {
            Dimension measuresDim = (Dimension)cube.getMeasureDimension();
            IMember[] measuresMembers = setToFetchBeforeDataCache.getMembers(measuresDim);
            long postDataCacheCrossJoinSetSize = 0L;
            MemberLevelInfo postDataCacheLevelInfo = null;
            if (null != setToFetch) {
                postDataCacheCrossJoinSetSize = setToFetch.size();
                postDataCacheLevelInfo = ((CrossJoinedSet)setToFetch).getMemberLevelInfo();
            }
            if (0L == postDataCacheCrossJoinSetSize) {
                logger.logFullDataCacheHit(measuresMembers, preDataCacheLevelInfo, hierarchies);
            } else {
                logger.logPartialDataCacheHit(measuresMembers, preDataCacheLevelInfo, postDataCacheLevelInfo, hierarchies);
            }
        }
        if (aggregateCache != null && setToFetch != null && !setToFetch.isEmpty() && (aggDefinitions = ((AggregateCubeletStorage)aggregateCache).getAvailableAggregateDefinitions(true)).size() > 0) {
            long aggregateCacheHits;
            long aggregateCacheAccesses;
            long aggregateStartTime;
            AggregateSelector.AggregateSelection aggregateSelection;
            ISet origSet;
            block25: {
                origSet = setToFetch;
                aggregateSelection = null;
                setToFetch = BlockTupleStorageUtil.generateCrossJoinedSetInCubeHierarchyOrder(setToFetch);
                queryMetrics.notifyOperationStart(XQueryStrategy.Operation.AGGREGATE_CACHE_RETRIEVAL);
                aggregateStartTime = System.currentTimeMillis();
                aggregateCacheAccesses = setToFetch.size();
                aggregateCacheHits = 0L;
                try {
                    AggregateSelector aggregateSelector = new AggregateSelector(aggDefinitions);
                    aggregateSelector.setAggregateCache((AggregateCubeletStorage)aggregateCache);
                    aggregateSelection = aggregateSelector.select((CrossJoinedSet)setToFetch);
                    if (aggregateSelection == null) break block25;
                    if (resultSet.isPipelining()) {
                        try {
                            ((IPipelineResultSet)resultSet).doNotTrackAddedCellsAsPossibleFutureDuplicates();
                        }
                        catch (InterruptedException e) {
                            throw new XQERuntimeException(e);
                        }
                    }
                    if (aggregateSelection.isDirectMatch()) {
                        BlockTupleStorageFetchResult fetchResult = aggregateCache.getTupleValues(setToFetch, new ResultSetToListAdaptor(resultSet), aggregateSelection.getAggregateDefintion().getName());
                        if ((setToFetch = fetchResult.createSet()).size() != 0L) {
                            AggregateCellsNotFoundException e = new AggregateCellsNotFoundException(XQEMessageKeys.EXE_AggregateDidNotSolveEntireQuery, UniqueNameGenerator.createUniqueName(aggregateSelection.getAggregateDefintion().getName()), this.getCube().getUniqueName());
                            throw e;
                        }
                    } else {
                        IMember[][] querySetMembers = null;
                        querySetMembers = dataCacheFetchResult != null ? dataCacheFetchResult.getSelectionsToFetch() : setToFetch.getMembers(setToFetch.getHierarchies());
                        AggregateCalculationEngine calcEngine = new AggregateCalculationEngine((CrossJoinedSet)setToFetch);
                        AggregateCalculationMetrics metrics = new AggregateCalculationMetrics();
                        calcEngine.setSourceData(aggregateSelection.getAggregateDefintion().getStorageLocation(), aggregateSelection, querySetMembers, metrics);
                        setToFetch = calcEngine.calculate(resultSet, metrics);
                        queryMetrics.setAggregateCalculationMetrics(metrics);
                        if (dataCache != null) {
                            List<IResultSet> rsList = Arrays.asList(calcEngine.getCalculatedResultSet(), calcEngine.getOverfetchResultSet());
                            CachePopulator.startPopulation(cube, dataCache, origSet, rsList);
                        }
                    }
                    aggregateCacheHits = aggregateCacheAccesses;
                }
                catch (AggregateCellsNotFoundException e) {
                    setToFetch = origSet;
                    aggregateSelection = null;
                    ROLAPLog.logError("ROLAPCubes.AggregateCache", "ROLAPQueryStrategy is skipping aggregate cache fetch because of exception: ", e);
                }
                finally {
                    queryMetrics.notifyOperationEnd(XQueryStrategy.Operation.AGGREGATE_CACHE_RETRIEVAL, resultSet.cellCount());
                }
            }
            long totalInMemoryAggregateTime = System.currentTimeMillis() - aggregateStartTime;
            queryMetrics.setInMemoryAggregateMetrics(totalInMemoryAggregateTime, ((CrossJoinedSet)origSet).noOverflowSize(), aggregateCacheHits > 0L);
            cube.getDataCacheInContext().recordInMemoryAggregateCacheStats(aggregateCacheHits, aggregateCacheAccesses);
            ROLAPQueryStrategy.incrementCacheMisses(queryMetrics.getAggrCacheHits(), this.getInfoData(), (ROLAPCube)this.getCube());
            if (null != aggregateSelection && isLogging) {
                logger.logAggregateCacheHit((CrossJoinedSet)origSet, aggregateSelection.getAggregateDefintion().getName(), totalInMemoryAggregateTime, queryMetrics.getAggrCacheHits());
            }
        }
        return setToFetch;
    }

    private Collection<SetSelections> createSetSelectionPerCombination(Collection<IMember>[] originalSelections, Collection<IMember> measures) throws InterpreterException {
        ArrayList<SetSelections> returnSelections = new ArrayList<SetSelections>();
        SetSelections newSetSelection = SetSelections.createSetSelections(originalSelections, measures, this.getCubeMeasuresHierarchyIndex());
        List<V5ProviderCombination> combinations = this.prepareV5ProviderCombinations(newSetSelection, true);
        for (V5ProviderCombination combination : combinations) {
            Collection<IMember>[] selections = V5ProviderSelection.getSelectionsFromCombination(combination.getSelections());
            returnSelections.add(new SetSelections(selections));
        }
        return returnSelections;
    }

    private void executeV5ProviderColdCacheImpl(SetSelections modifiedSetSel, IResultSet resultSet, ROLAPQueryExecuteMetrics queryMetrics, ROLAPQueryGroup groupQueryOut, ArrayList<TupleValueIterator> tupleValueIteratorListOut, ArrayList<RSAPIResultSet> rsapiResultSetsToReleaseOut) throws InterpreterException {
        ROLAPBaseCube cube = (ROLAPBaseCube)this.getCube();
        if (!cube.getConfigIsDisableExternalAggregates()) {
            ROLAPMetaAggregateCube[] aggrCubes = cube.getModelCube().getAggregateCubes();
            List<V5ProviderCombination> combinations = null;
            for (ROLAPMetaAggregateCube aggrCube : aggrCubes) {
                SetSelections coveredSet;
                if (combinations == null) {
                    combinations = this.prepareV5ProviderCombinations(modifiedSetSel, true);
                }
                if ((coveredSet = this.v5ProviderCoveredSetsByAggregate(aggrCube, modifiedSetSel, combinations)) == null) continue;
                List<V5ProviderCombination> alreadyCalculatedCombinations = null;
                boolean isSetSelFullyCovered = false;
                if (modifiedSetSel != null && modifiedSetSel.size() == coveredSet.size()) {
                    isSetSelFullyCovered = true;
                    alreadyCalculatedCombinations = combinations;
                }
                this.executeV5ProviderQueries(coveredSet, resultSet, true, groupQueryOut, tupleValueIteratorListOut, rsapiResultSetsToReleaseOut, queryMetrics, alreadyCalculatedCombinations);
                if (isSetSelFullyCovered) {
                    return;
                }
                combinations = null;
                modifiedSetSel = modifiedSetSel.selectionExcept(coveredSet, this.getCubeHierarchies());
            }
        }
        this.executeV5ProviderQueries(modifiedSetSel, resultSet, false, groupQueryOut, tupleValueIteratorListOut, rsapiResultSetsToReleaseOut, queryMetrics, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeColdCacheToTupleStorage(SetSelections origSetSel, IResultSet resultSet, IBlockTupleStorage blockStorage, ROLAPQueryExecuteMetrics queryMetrics, QueryType queryType) throws InterpreterException {
        ROLAPBaseCube cube = (ROLAPBaseCube)this.getCube();
        ArrayList<TupleValueIterator> tupleValueIteratorList = new ArrayList<TupleValueIterator>();
        ArrayList<RSAPIResultSet> rsapiResultSetsToRelease = new ArrayList<RSAPIResultSet>();
        ROLAPQueryGroup groupQuery = new ROLAPQueryGroup();
        try {
            SetSelections[] setSelections;
            if (!cube.getConfigIsDisableExternalAggregates() && cube.getModelCube().getAggregateCubes().length > 0) {
                setSelections = this.generateSetSelectionsToPreventIncompleteSetsCustom(origSetSel);
                origSetSel = this.updateSetSelectionForDiscardedPrefetchMeasures(origSetSel, setSelections);
            } else {
                setSelections = new SetSelections[]{origSetSel};
            }
            for (SetSelections setSel : setSelections) {
                this.executeV5ProviderColdCacheImpl(setSel, resultSet, queryMetrics, groupQuery, tupleValueIteratorList, rsapiResultSetsToRelease);
            }
            this.populateTupleStorageFromTupleValueIterators(origSetSel, tupleValueIteratorList, groupQuery, queryType, blockStorage);
        }
        finally {
            for (TupleValueIterator tupleValueIterator : tupleValueIteratorList) {
                try {
                    tupleValueIterator.close();
                    if (this.isSystemGenerated) continue;
                    ROLAPQueryStrategy.incrementCacheMisses(tupleValueIterator.getCellValueCount(), this.getInfoData(), (ROLAPCube)this.getCube());
                }
                catch (Throwable ex) {
                    ROLAPLog.logError("Exception", "v5Exception caught in TupleValueIterator.close()", ex);
                }
            }
            for (RSAPIResultSet rs : rsapiResultSetsToRelease) {
                rs.release();
            }
        }
    }

    private Collection<IMember> getMeasuresSatisfiedByAggregateUsingCombination(List<V5ProviderSelection> selections, ROLAPMetaAggregateCube aggregateCube) {
        int measuresIndex = -1;
        ArrayList<ROLAPCompoundKeyMapping> compoundKeyMappings = null;
        for (int i = 0; i < selections.size(); ++i) {
            List<IMember> memberList = selections.get(i).getMembersList();
            IMember measureVar = memberList.get(0);
            if (measureVar.getDimension().isMeasuresDimension()) {
                measuresIndex = i;
                continue;
            }
            ROLAPLevel level = (ROLAPLevel)measureVar.getLevel();
            if (level.isAllLevel()) continue;
            if (compoundKeyMappings == null) {
                compoundKeyMappings = new ArrayList<ROLAPCompoundKeyMapping>();
            }
            ROLAPCompoundKeyMapping mapping = new ROLAPCompoundKeyMapping(false);
            mapping.setLevel(level);
            compoundKeyMappings.add(mapping);
        }
        HashSet<IMember> matchedMeasures = new HashSet<IMember>();
        if (measuresIndex >= 0) {
            ROLAPBaseCube cube = (ROLAPBaseCube)this.getCube();
            List<IMember> measureSelections = selections.get(measuresIndex).getMembersList();
            for (IMember measure : measureSelections) {
                ROLAPMeasure[] measureList = new ROLAPMeasure[]{(ROLAPMeasure)measure};
                if (!ROLAPQuery.doesAggregateSatisfyQuery(aggregateCube, measureList, false, compoundKeyMappings, cube, null)) continue;
                matchedMeasures.add(measure);
            }
        }
        return matchedMeasures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SetSelections v5ProviderCoveredSetsByAggregate(ROLAPMetaAggregateCube aggregateCube, SetSelections setSel, List<V5ProviderCombination> combinations) throws InterpreterException {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCDetermineOfCoveredSetByAggregates", ZipiContext.getQRDName());
        try {
            SetSelections setSelections = this.tryToFindCoveredSetsByAggregate(aggregateCube, setSel, combinations);
            return setSelections;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SetSelections tryToFindCoveredSetsByAggregate(ROLAPMetaAggregateCube aggregateCube, SetSelections setSel, List<V5ProviderCombination> combinations) throws InterpreterException {
        long startTime = System.currentTimeMillis();
        SetSelections coveredSet = null;
        Hierarchy[] hierarchies = this.getCubeHierarchies();
        int measuresIdx = this.getCubeMeasuresHierarchyIndex();
        boolean returnOriginalSetSelection = true;
        try {
            for (int i = 0; i < combinations.size(); ++i) {
                Collection<IMember>[] newModifiedSelections;
                V5ProviderCombination combination = combinations.get(i);
                Collection<IMember> matchedMeasures = this.getMeasuresSatisfiedByAggregateUsingCombination(combination.getSelections(), aggregateCube);
                if (matchedMeasures.size() <= 0) continue;
                if (this.prefetchManager != null && this.prefetchManager.isQueryOnlyForPrefetchedMeasures(matchedMeasures)) {
                    SetSelections setSelections = null;
                    return setSelections;
                }
                Collection<IMember>[] selections = setSel.getSelections(hierarchies);
                boolean measuresAreModified = selections[measuresIdx].size() != matchedMeasures.size() || !matchedMeasures.containsAll(selections[measuresIdx]);
                Collection<IMember>[] modifiedSelections = V5ProviderSelection.getSelectionsFromCombination(combination.getSelections());
                if (measuresAreModified) {
                    returnOriginalSetSelection = false;
                    modifiedSelections[measuresIdx] = matchedMeasures;
                }
                if (aggregateCube.hasAggregateSlice() && (newModifiedSelections = this.updateSelectionsBySlice(aggregateCube, modifiedSelections)) != null) {
                    returnOriginalSetSelection = false;
                    if (newModifiedSelections.length == 0) continue;
                    modifiedSelections = newModifiedSelections;
                }
                if (returnOriginalSetSelection) {
                    coveredSet = setSel;
                } else {
                    coveredSet = new SetSelections(modifiedSelections);
                    if (coveredSet.size() != setSel.size() && !ROLAPMeasure.containsCustomMeasures(modifiedSelections[measuresIdx]) && setSel.numHierarchiesReduced(coveredSet, hierarchies) >= 2) {
                        if (ROLAPLog.isOn("ROLAPQuery", LogLevel.TRACE)) {
                            ROLAPLog.logTrace("ROLAPQuery", "Determined running query against aggregate cube: " + aggregateCube.getName() + " would not reduce the query set.");
                        }
                        coveredSet = null;
                    }
                }
                SetSelections setSelections = coveredSet;
                return setSelections;
            }
            SetSelections setSelections = coveredSet;
            return setSelections;
        }
        finally {
            if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
                long setSize = 0L;
                if (coveredSet != null) {
                    setSize = coveredSet.size();
                }
                ROLAPLog.log("ROLAPQuery.Performance", "v5Time to determine covered set by the aggregate: " + (System.currentTimeMillis() - startTime) + "v5ms, size of covered set: " + setSize + ", v5name: " + aggregateCube.getName());
            }
        }
    }

    protected String generateQueryName(int i) {
        return ROLAPQueryStrategy.getReportName() + ": Query" + i;
    }

    private Collection<IMember>[] updateSelectionsBySlice(ROLAPMetaAggregateCube aggregateCube, Collection<IMember>[] selections) {
        HashMapObjectInt<String> hierToIndexMap = this.getHierToIndexMap();
        Collection<IMember>[] newSelections = null;
        for (ROLAPMetaAggregateDimensionRef dimRef : aggregateCube.getAggregateDimensionRefs()) {
            for (ROLAPMetaAggregateHierarchyRef aggrHierarchy : dimRef.getAggregateHierarchyRefs()) {
                if (aggrHierarchy.getAggregateSlice() == null) continue;
                IHierarchy hierarchy = this.getCube().getHierarchy(aggrHierarchy.getName());
                int hierIdx = hierToIndexMap.get(hierarchy.getUniqueName());
                ILevel sliceLevel = aggrHierarchy.getAggregateSliceLevel(hierarchy);
                HashSet<IMember> intersectSet = new HashSet<IMember>();
                if (sliceLevel != null) {
                    for (IMember member : selections[hierIdx]) {
                        IMember parent;
                        ILevel level = member.getLevel();
                        if (sliceLevel.getIndex() == level.getIndex()) {
                            if (!aggrHierarchy.getAggregateSlice().containsMember(member)) continue;
                            intersectSet.add(member);
                            continue;
                        }
                        if (sliceLevel.getIndex() > level.getIndex()) {
                            ArrayList<IMember> descendants = ((ROLAPMemberProxy)member).getDescendants(sliceLevel);
                            boolean matching = true;
                            for (IMember descendantMember : descendants) {
                                if (aggrHierarchy.getAggregateSlice().containsMember(descendantMember)) continue;
                                matching = false;
                                break;
                            }
                            if (!matching) continue;
                            intersectSet.add(member);
                            continue;
                        }
                        for (parent = member.getParent(); parent != null && !parent.getLevel().equals(sliceLevel); parent = parent.getParent()) {
                        }
                        if (!aggrHierarchy.getAggregateSlice().containsMember(parent)) continue;
                        intersectSet.add(member);
                    }
                }
                if (intersectSet.isEmpty()) {
                    return (Collection[])ArrayCast.uncheckedCast(new Collection[0]);
                }
                if (intersectSet.size() == selections[hierIdx].size()) continue;
                if (newSelections == null) {
                    newSelections = SetSelections.copySelections(selections);
                }
                newSelections[hierIdx] = intersectSet;
            }
        }
        return newSelections;
    }

    private void populateHierarchyInfo() {
        if (this.cubeHierarchies == null) {
            List<IHierarchy> cubeHierarchiesList = ((Cube)this.getCube()).getHierarchies();
            this.cubeHierarchies = cubeHierarchiesList.toArray(new Hierarchy[0]);
            this.hierToIndex = new HashMapObjectInt();
            for (int i = 0; i < cubeHierarchiesList.size(); ++i) {
                Hierarchy hier = (Hierarchy)cubeHierarchiesList.get(i);
                this.hierToIndex.put(hier.getUniqueName(), i);
            }
            IDimension measuresDim = this.getCube().getMeasureDimension();
            this.cubeMeasureHierarchyIndex = this.getHierToIndexMap().get(measuresDim.getDefaultHierarchy().getUniqueName());
        }
    }

    @Override
    public HashMapObjectInt<String> getHierToIndexMap() {
        if (this.hierToIndex == null) {
            this.populateHierarchyInfo();
        }
        return this.hierToIndex;
    }

    public Hierarchy[] getCubeHierarchies() {
        if (this.cubeHierarchies == null) {
            this.populateHierarchyInfo();
        }
        return this.cubeHierarchies;
    }

    public int getCubeMeasuresHierarchyIndex() {
        if (this.cubeHierarchies == null) {
            this.populateHierarchyInfo();
        }
        return this.cubeMeasureHierarchyIndex;
    }

    private void incrementCacheHits(long hitCount) {
        ROLAPCubeMetrics cubeMetrics;
        CacheMetricsTracker metricsTracker = ((Cube)this.getCube()).getTupleStorageMetrics();
        if (metricsTracker != null) {
            metricsTracker.incrementHits(hitCount);
        }
        if ((cubeMetrics = ((ROLAPCube)this.getCube()).getMetrics()) != null) {
            cubeMetrics.recordDataCacheAccess(hitCount, hitCount);
        }
    }

    protected static void incrementCacheMisses(long missCount, QueryContext info, ROLAPCube cube) {
        ROLAPCubeMetrics cubeMetrics;
        CacheMetricsTracker metricsTracker = cube.getTupleStorageMetrics();
        if (metricsTracker != null) {
            metricsTracker.incrementMisses(missCount);
        }
        if ((cubeMetrics = cube.getMetrics()) != null) {
            cubeMetrics.recordDataCacheAccess(0L, missCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeV5ProviderQueries(SetSelections setToFetch, IResultSet resultSet, boolean isAgainstAggrTable, ROLAPQueryGroup groupQueryOut, ArrayList<TupleValueIterator> tupleValueIteratorListOut, ArrayList<RSAPIResultSet> rsapiResultSetsToReleaseOut, ROLAPQueryExecuteMetrics queryMetrics, List<V5ProviderCombination> combinations) throws InterpreterException {
        boolean delayedQueryExecution = ROLAPQueryStrategy.getConfigDelayedQueryExecution();
        if (!delayedQueryExecution && ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
            ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started executing to datasource");
            if (ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPQuery.Performance", "Requested set: " + setToFetch.getSet().toString());
            }
        }
        ROLAPBaseCube cube = (ROLAPBaseCube)this.getCube();
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        int origQueryCount = groupQueryOut.queryCount();
        this.buildROLAPQueries(setToFetch, isAgainstAggrTable, this.isOverfetchingAllowed(), true, groupQueryOut, combinations);
        try {
            boolean canReuseTupleValue = resultSet instanceof AggregateCacheLoader.MetricsOnlyResultSet;
            for (int i = origQueryCount; i < groupQueryOut.queryCount(); ++i) {
                if (cancelManager != null && cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                ROLAPQuery query = (ROLAPQuery)groupQueryOut.getQuery(i);
                if (delayedQueryExecution) {
                    QueryExecutionTupleValueIterator tupleValueIterator = new QueryExecutionTupleValueIterator(this.getHierToIndexMap(), query, resultSet, queryMetrics, false, rsapiResultSetsToReleaseOut, this, setToFetch);
                    tupleValueIterator.setReuseTupleObjects(canReuseTupleValue, cube);
                    tupleValueIteratorListOut.add(tupleValueIterator);
                    continue;
                }
                V5ProviderQueryResult v5Result = this.executeIndividualQuery(rsapiResultSetsToReleaseOut, queryMetrics, cube, query);
                try {
                    TupleValueIterator tupleValueIterator = new TupleValueIterator(this.getHierToIndexMap(), v5Result, query, resultSet, queryMetrics, false);
                    tupleValueIterator.setReuseTupleObjects(canReuseTupleValue, cube);
                    tupleValueIteratorListOut.add(tupleValueIterator);
                    v5Result = null;
                    if (tupleValueIterator.hasNext()) continue;
                    ROLAPQueryStrategy.logMsgNoResultForQuery(query, null);
                    continue;
                }
                catch (RuntimeException ex) {
                    if (v5Result != null) {
                        v5Result.release();
                        v5Result = null;
                    }
                    throw ex;
                }
                catch (Throwable ex) {
                    if (v5Result != null) {
                        v5Result.release();
                        v5Result = null;
                    }
                    throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
                }
            }
            if (delayedQueryExecution && ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPQuery.Performance", "Built delayed query execution tupleValue iterator.  The query is run the first time hasNext() is called on the iterator.");
            }
        }
        finally {
            if (!delayedQueryExecution && ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO)) {
                int nQueries = -1;
                if (combinations != null) {
                    nQueries = combinations.size();
                }
                ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", "Finished executing to datasource with " + nQueries + " v5queries.");
            }
        }
    }

    private static boolean getConfigDelayedQueryExecution() {
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean delayedQueryExecution = xqeConfig.getBooleanProperty("rolap.delayedQueryExecution[@enabled]", true);
        return delayedQueryExecution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V5ProviderQueryResult executeIndividualQuery(List<RSAPIResultSet> rsapiResultSetsToReleaseOut, ROLAPQueryExecuteMetrics queryMetrics, ROLAPBaseCube cube, ROLAPQuery query) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCExecutingToDatasource");
        try {
            V5ProviderQueryResult v5ProviderQueryResult = this.tryToExecuteIndividualQuery(rsapiResultSetsToReleaseOut, queryMetrics, cube, query);
            return v5ProviderQueryResult;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    private V5ProviderQueryResult tryToExecuteIndividualQuery(List<RSAPIResultSet> rsapiResultSetsToReleaseOut, ROLAPQueryExecuteMetrics queryMetrics, ROLAPBaseCube cube, ROLAPQuery query) {
        long startTime = System.currentTimeMillis();
        HighPrecisionStopWatch dataQueryStartTime = new HighPrecisionStopWatch(true);
        V5ProviderQueryResult v5Result = query.execute(null);
        IROLAPQueryResultIterator result = null;
        if (v5Result != null) {
            result = v5Result.getProviderQueryResultIter();
            MultiRequestContext context = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext();
            RSAPIResultSet rs = context.removeResultset(result.getRSAPIDataset());
            if (rs != null) {
                rsapiResultSetsToReleaseOut.add(rs);
            }
        }
        if (!this.isSystemGenerated) {
            ROLAPQueryStrategy.recordCacheMissInfo(cube, startTime);
        }
        query.getQueryMetrics().setSqlExectuteTime(dataQueryStartTime.getElapsedTimeInMilliseconds());
        return v5Result;
    }

    private void populateTupleStorageFromTupleValueIterators(SetSelections setToFetch, ArrayList<TupleValueIterator> tupleValueIteratorList, ROLAPQueryGroup groupQuery, QueryType queryType, IBlockTupleStorage blockTupleStorage) throws InterpreterException {
        block9: {
            IExecutionEnvironment execEnv = ExecutionEnvironmentContext.getExecutionEnvironment();
            RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
            CancelManager cancelManager = execEnv.getCancelManager();
            if (tupleValueIteratorList.size() <= 0) break block9;
            ROLAPBaseCube cube = (ROLAPBaseCube)this.getCube();
            WorkloadLogger workloadLogger = cube.getWorkloadLogger();
            for (int i = 0; i < tupleValueIteratorList.size(); ++i) {
                workloadLogger.logQueryType(reqEnv, ((ROLAPQuery)groupQuery.getQuery(i)).getID(), queryType);
            }
            if (!this.getPushDownMode()) {
                List<Iterator<TupleValue>> tvList = CollectionCast.uncheckedCast(tupleValueIteratorList);
                TupleValueGroupIterator groupIterator = new TupleValueGroupIterator(tvList);
                groupIterator.setPeformNotifyOps(true);
                if (blockTupleStorage != null) {
                    blockTupleStorage.putTupleValues(setToFetch.getSet(), groupIterator, this.cubeletHint);
                } else {
                    while (groupIterator.hasNext()) {
                        if (cancelManager != null && cancelManager.isRequestCancelled()) {
                            throw new OperationCanceledException();
                        }
                        groupIterator.next();
                    }
                }
                for (int i = 0; i < tupleValueIteratorList.size(); ++i) {
                    workloadLogger.logCellInfo(reqEnv, ((ROLAPQuery)groupQuery.getQuery(i)).getID(), tupleValueIteratorList.get((int)i).cellValueCount);
                }
            } else {
                for (TupleValueIterator tvi : tupleValueIteratorList) {
                    tvi.notifyStart();
                    ((ROLAPPushdownAdapter)this.getPushdownAdapter()).cachePushdownResult(blockTupleStorage, tvi, setToFetch, this);
                    tvi.notifyEnd();
                }
            }
        }
    }

    protected HashMap<String, ArrayList<IMember>>[] buildHierarchyIndexToMemberGroups(SetSelections setSel, boolean isAgainstAggrTable) {
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        boolean queryIncludesTID = IncrementManager.queryWillIncludeTidRange((ROLAPCube)this.getCube());
        Hierarchy[] hierarchies = this.getCubeHierarchies();
        int measuresIndex = this.getCubeMeasuresHierarchyIndex();
        int hierCount = hierarchies.length;
        Collection<IMember>[] selectionsByHierarchy = setSel.getSelections(hierarchies);
        HashMap[] hierarchyIndexToMemberGroups = (HashMap[])ArrayCast.uncheckedCast(new HashMap[hierCount]);
        for (int i = 0; i < hierCount; ++i) {
            HashMap<String, ArrayList<IMember>> memberGroup;
            hierarchyIndexToMemberGroups[i] = memberGroup = new HashMap<String, ArrayList<IMember>>();
            ROLAPMetaHierarchy metaHierarchy = ((IROLAPHierarchy)((Object)hierarchies[i])).getMetaHierarchy();
            boolean isRecursive = metaHierarchy != null && metaHierarchy.isRecursive();
            boolean isMeasure = i == measuresIndex;
            Iterator<IMember> members = selectionsByHierarchy[i].iterator();
            int j = 0;
            while (members.hasNext()) {
                if (cancelManager != null && cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                IMember member = members.next();
                String mergeKey = this.generateMemberGroupKey(member, isMeasure, isRecursive, isAgainstAggrTable, queryIncludesTID);
                ArrayList<IMember> memberGrouping = (ArrayList<IMember>)memberGroup.get(mergeKey);
                if (memberGrouping == null) {
                    memberGrouping = new ArrayList<IMember>();
                    memberGroup.put(mergeKey, memberGrouping);
                }
                memberGrouping.add(member);
                ++j;
            }
        }
        return hierarchyIndexToMemberGroups;
    }

    private String generateMemberGroupKey(IMember member, boolean isMeasure, boolean isRecursiveHierachy, boolean isAgainstAggrTable, boolean queryIncludesTID) {
        Level level = (Level)member.getLevel();
        String mergeKey = String.valueOf(level.getIndex());
        if (!isAgainstAggrTable || queryIncludesTID) {
            if (isMeasure) {
                if (((IROLAPMeasure)member).isSemiAggregate()) {
                    mergeKey = "Asym" + member.getID() + ":" + level.getIndex();
                }
            } else if (isRecursiveHierachy) {
                String memberID = null;
                if (member instanceof IROLAPMember) {
                    if (((IROLAPMember)member).isLeaf()) {
                        return MEMBER_GROUP_PCH_LEAF;
                    }
                    memberID = String.valueOf(((IROLAPMember)member).getROLAPOrdinal());
                } else {
                    memberID = member.getName();
                }
                mergeKey = mergeKey + " " + memberID;
            }
        }
        return mergeKey;
    }

    private List<V5ProviderCombination> prepareV5ProviderCombinations(SetSelections setSel, boolean isAgainstAggrTable) throws InterpreterException {
        ArrayList<V5ProviderCombination> combinations = new ArrayList<V5ProviderCombination>();
        Hierarchy[] hierarchies = this.getCubeHierarchies();
        int hierCount = hierarchies.length;
        this.buildFLAggregatesRulesMap(setSel, hierarchies, this.getCubeMeasuresHierarchyIndex());
        HashMap<String, ArrayList<IMember>>[] hierarchyIndexToMemberGroups = this.buildHierarchyIndexToMemberGroups(setSel, isAgainstAggrTable);
        int[] groupIndexes = new int[hierCount];
        int[] groupCount = new int[hierCount];
        Object[][] hierIndexToKeyArray = new Object[hierCount][];
        for (int i = 0; i < hierCount; ++i) {
            groupIndexes[i] = 0;
            groupCount[i] = hierarchyIndexToMemberGroups[i].size();
            if (groupCount[i] == 0) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_HierarchyMissingMemberInTuple, hierarchies[i].getUniqueName());
            }
            hierIndexToKeyArray[i] = hierarchyIndexToMemberGroups[i].keySet().toArray();
        }
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        boolean notDone = true;
        boolean[] flag = new boolean[hierCount];
        int[] idx = new int[hierCount];
        while (notDone) {
            int i;
            V5ProviderCombination combination = new V5ProviderCombination();
            HashSet firstLastAggregatesDimensions = null;
            for (int i2 = 0; i2 < hierCount; ++i2) {
                if (cancelManager != null && cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                IDimension dim = null;
                ArrayList<IMember> hierSels = hierarchyIndexToMemberGroups[i2].get(hierIndexToKeyArray[i2][groupIndexes[i2]]);
                IROLAPHierarchy roh = null;
                if (hierSels instanceof List) {
                    Object obj;
                    List hierSelsAsList = hierSels;
                    if (hierSelsAsList.size() > 1) {
                        obj = hierSelsAsList.get(0);
                        if (obj instanceof IROLAPMember) {
                            roh = ((IROLAPMember)obj).getROLAPHierarchy();
                            dim = roh.getDimension();
                            if (dim.isMeasuresDimension() && this.firstLastAggregatesMeasureMap.containsKey(obj)) {
                                firstLastAggregatesDimensions = (HashSet)this.firstLastAggregatesMeasureMap.get(obj);
                            }
                            if (roh.isRecursive() && !((String)hierIndexToKeyArray[i2][groupIndexes[i2]]).contains(MEMBER_GROUP_PCH_LEAF) && (!isAgainstAggrTable || IncrementManager.queryWillIncludeTidRange((ROLAPCube)this.getCube())) && idx[i2] < hierSelsAsList.size()) {
                                int n = i2;
                                int n2 = idx[n];
                                idx[n] = n2 + 1;
                                hierSels = hierSelsAsList.get(n2);
                                flag[i2] = idx[i2] < hierSelsAsList.size();
                            }
                        }
                    } else {
                        obj = hierSelsAsList.get(0);
                        if (obj instanceof IROLAPMember && (dim = (roh = ((IROLAPMember)obj).getROLAPHierarchy()).getDimension()).isMeasuresDimension() && this.firstLastAggregatesMeasureMap.containsKey(obj)) {
                            firstLastAggregatesDimensions = (HashSet)this.firstLastAggregatesMeasureMap.get(obj);
                        }
                    }
                }
                V5ProviderSelection v5ProviderSelections = new V5ProviderSelection(hierSels);
                combination.addSelection(v5ProviderSelections);
            }
            boolean rollIndexes = true;
            for (i = 0; i < hierCount; ++i) {
                if (!flag[i]) continue;
                rollIndexes = false;
                break;
            }
            if (rollIndexes) {
                for (i = hierCount - 1; i >= 0; --i) {
                    int n = i;
                    groupIndexes[n] = groupIndexes[n] + 1;
                    idx[i] = 0;
                    if (groupIndexes[i] != groupCount[i]) break;
                    if (i == 0) {
                        notDone = false;
                    }
                    groupIndexes[i] = 0;
                }
            }
            if (this.firstLastAggregateRules != null && !this.firstLastAggregateRules.isEmpty()) {
                combination = this.updateCombinationWithSemiAggregateRule(combination, firstLastAggregatesDimensions);
            }
            combinations.add(combination);
        }
        if (this.firstLastAggregateRules != null && !this.firstLastAggregateRules.isEmpty()) {
            return this.handleFirstLastAggregatesInCombinations(combinations, hierCount);
        }
        return combinations;
    }

    private V5ProviderCombination updateCombinationWithSemiAggregateRule(V5ProviderCombination combination, HashSet<IDimension> firstLastAggregatesDimensions) {
        IDimension dim;
        IMember firstMember;
        V5ProviderCombination result = new V5ProviderCombination();
        HashSet<IDimension> dimsProjectNotAllLevelMemberInCurrentCombination = new HashSet<IDimension>();
        block0: for (V5ProviderSelection aSelection : combination.getSelections()) {
            firstMember = aSelection.getFirstMember();
            dim = firstMember.getDimension();
            for (HashSet refDims : this.firstLastAggregatesMeasureMap.values()) {
                if (!refDims.contains(dim) || dim.getHierarchyCount() <= 1) continue;
                if (((Level)firstMember.getLevel()).isAllLevel()) continue block0;
                dimsProjectNotAllLevelMemberInCurrentCombination.add(firstMember.getDimension());
                continue block0;
            }
        }
        for (V5ProviderSelection aSelection : combination.getSelections()) {
            firstMember = aSelection.getFirstMember();
            dim = firstMember.getDimension();
            boolean isAllLevelMember = ((Level)firstMember.getLevel()).isAllLevel();
            boolean bConvert = false;
            if (dim != null && firstLastAggregatesDimensions != null && firstLastAggregatesDimensions.contains(dim)) {
                bConvert = true;
            }
            if (firstMember instanceof NullMember) {
                bConvert = false;
            }
            if (bConvert && isAllLevelMember) {
                if (dimsProjectNotAllLevelMemberInCurrentCombination.contains(firstMember.getDimension())) {
                    bConvert = false;
                } else if (!dim.getDefaultHierarchy().equals(firstMember.getHierarchy())) {
                    bConvert = false;
                }
            }
            if (bConvert) {
                V5ProviderAggregateSelection aggregateSelection = new V5ProviderAggregateSelection((Object)aSelection.getMembersList(), dim);
                result.addSelection(aggregateSelection);
                continue;
            }
            result.addSelection(aSelection);
        }
        return result;
    }

    @Override
    public ROLAPQuery combinationToV5ProviderQuery(int index, List<V5ProviderSelection> selections, boolean isAgainstAggrTable, boolean isOverFetchingAllowed, boolean isCustomAggregateAllowed) {
        return this.combinationToV5ProviderQuery(index, selections, isAgainstAggrTable, isOverFetchingAllowed, isCustomAggregateAllowed, null, null);
    }

    public ROLAPQuery combinationToV5ProviderQuery(int index, List<V5ProviderSelection> selections, boolean isAgainstAggrTable, boolean isOverfetchingAllowed, boolean isCustomAggregateAllowed, HashMap<Level, HashSet<IROLAPCommonMember>> levelToSelectionsMap, HashMap<Level, ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>>> levelToLevelKeysMap) {
        ROLAPQuery result = null;
        String queryName = this.generateQueryName(index);
        boolean isAtLowestLevels = true;
        ROLAPBaseCube cube = (ROLAPBaseCube)this.getCube();
        IMember[] outputTuple = new IMember[this.getCubeHierarchies().length];
        HashMapObjectInt<String> hierToIndexMap = this.getHierToIndexMap();
        int measuresIndex = -1;
        result = new ROLAPQuery(queryName, cube.getSchema(), cube, false);
        if (isAgainstAggrTable) {
            result.getQueryMetrics().setQueryType(SQLQueryMetrics.QueryType.AggregateTable);
        } else {
            result.getQueryMetrics().setQueryType(SQLQueryMetrics.QueryType.Fact);
        }
        result.setXmdxNodeId(this.getInfoData().getXmdxSelectId());
        int predicateThresholdPercent = cube.getConfigPredicateThreshold();
        HashSet<ROLAPLevel> levels = new HashSet<ROLAPLevel>();
        boolean cubeHasPCH = cube.isPCH();
        HashSet<ROLAPDimension> joinedDimensions = new HashSet<ROLAPDimension>();
        List<V5ProviderSelection> selectionList = selections;
        for (int i = 0; i < selectionList.size(); ++i) {
            List<IMember> memberList = selectionList.get(i).getMembersList();
            IMember mem = memberList.get(0);
            if (memberList.size() == 1) {
                int tupleIndex = hierToIndexMap.get(mem.getHierarchy().getUniqueName());
                outputTuple[tupleIndex] = mem;
            }
            if (mem.getDimension().isMeasuresDimension()) {
                measuresIndex = i;
            }
            if (i == measuresIndex) continue;
            ROLAPLevel level = (ROLAPLevel)mem.getLevel();
            levels.add(level);
            if (!(level.isAllLevel() || memberList.size() == 1 && mem instanceof NullMember)) {
                boolean completeLevel;
                boolean isPCH = ((ROLAPHierarchy)level.getHierarchy()).isParentChild();
                joinedDimensions.add((ROLAPDimension)level.getHierarchy().getDimension());
                ROLAPCompoundKeyMapping keyMapping = new ROLAPCompoundKeyMapping(predicateThresholdPercent, isOverfetchingAllowed);
                boolean bl = completeLevel = memberList.size() == level.getCardinality();
                if (!completeLevel || cubeHasPCH) {
                    HashSet<IROLAPCommonMember> memberSelections = null;
                    if (levelToSelectionsMap != null && !isPCH) {
                        memberSelections = levelToSelectionsMap.get(level);
                    }
                    if (memberSelections == null) {
                        keyMapping.addMemberSelections(memberList);
                        if (levelToSelectionsMap != null && !isPCH) {
                            levelToSelectionsMap.put(level, keyMapping.getRequestedMembers());
                        }
                    } else {
                        keyMapping.setMemberSelections(level, memberSelections);
                    }
                } else {
                    keyMapping.addAllMembersFromLevel(level);
                }
                ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>> levelKeys = null;
                if (levelToLevelKeysMap != null && !isPCH && (levelKeys = levelToLevelKeysMap.get(level)) == null) {
                    levelKeys = keyMapping.getSelectionsLevelKeys();
                    levelToLevelKeysMap.put(level, levelKeys);
                }
                keyMapping.addToQuery(result, levelKeys);
            }
            if (level.isBottomLevel()) continue;
            isAtLowestLevels = false;
        }
        List<IMember> measuresSelections = selections.get(measuresIndex).getMembersList();
        boolean checkedHierCoverage = false;
        for (IMember measure : measuresSelections) {
            boolean addMeasure = true;
            AggregateTypeEnum aggrType = measure.getRegularAggregate();
            if (aggrType == AggregateTypeEnum.UNKNOWN) {
                if (isCustomAggregateAllowed) {
                    if (!checkedHierCoverage) {
                        if (isAtLowestLevels) {
                            int nbrHierarchy = 0;
                            for (IDimension dim : measure.getDimension().getCube().getDimensions()) {
                                if (dim.isMeasuresDimension()) continue;
                                nbrHierarchy += dim.getHierarchyCount();
                            }
                            if (nbrHierarchy > levels.size()) {
                                isAtLowestLevels = false;
                            }
                        }
                        result.setIsAtLowestLevels(isAtLowestLevels);
                        checkedHierCoverage = true;
                    }
                    addMeasure = isAgainstAggrTable || isAtLowestLevels;
                } else {
                    addMeasure = false;
                }
            }
            if (!addMeasure) continue;
            result.addMeasure((ROLAPMeasure)measure);
        }
        if (result.measureSelections.size() == 0) {
            return null;
        }
        if (cube.getModelCube().isDbContainsDirtyData()) {
            HashSet<String> fmFiltersToAdd = new HashSet<String>();
            for (IDimension dim : cube.getDimensions()) {
                ROLAPMetaDimension metaDim;
                ROLAPMetaDirtyDataCompensation dirtyDataComp;
                ROLAPDimension rolapDim = (ROLAPDimension)dim;
                if (rolapDim.isMeasuresDimension() || joinedDimensions.contains(rolapDim) || rolapDim.getType() == DimensionTypeEnum.INTERNAL || null == (dirtyDataComp = (metaDim = rolapDim.getMetaDimension()).getDirtyDataCompensation())) continue;
                joinedDimensions.add(rolapDim);
                fmFiltersToAdd.add(dirtyDataComp.getFMFilter());
            }
            for (String fmFilter : fmFiltersToAdd) {
                result.addJoinFilter(fmFilter);
            }
        }
        result.setOutputTuple(outputTuple);
        return result;
    }

    private long getAggrCubeMaskToMeasures(ROLAPMetaAggregateCube[] aggrCubes, Collection<IMember> measures, HashMapLongObject<Collection<IMember>> aggrCubeMaskToMeasures) {
        HashMapObjectLong<IMember> measureToAggrCubeMask = new HashMapObjectLong<IMember>(0L);
        long bitMask = 1L;
        long aggrCubesWithSlicers = 0L;
        for (ROLAPMetaAggregateCube aggrCube : aggrCubes) {
            if (aggrCube.hasAggregateSlice()) {
                aggrCubesWithSlicers |= bitMask;
            }
            for (IMember measure : measures) {
                if (aggrCube.getAggregateMeasure((ROLAPMeasure)measure) == null) continue;
                long measureCubes = measureToAggrCubeMask.get(measure);
                measureToAggrCubeMask.put(measure, measureCubes |= bitMask);
            }
            bitMask <<= 1;
        }
        ArrayList<IMember> requestedMeasures = new ArrayList<IMember>();
        ArrayList<IMember> prefetchMeasures = new ArrayList<IMember>();
        ROLAPQueryStrategy.splitMeasures(measures, this.prefetchManager, requestedMeasures, prefetchMeasures);
        boolean allowCubeMasksToBeDowngraded = ConfigurationValues.getBoolean("GroupMeasuresIntoFewerDBAggregateQueries", true);
        ROLAPQueryStrategy.populateCubeMaskToMeasures(aggrCubeMaskToMeasures, measureToAggrCubeMask, requestedMeasures, allowCubeMasksToBeDowngraded);
        ROLAPQueryStrategy.populateCubeMaskToMeasures(aggrCubeMaskToMeasures, measureToAggrCubeMask, prefetchMeasures, false);
        return aggrCubesWithSlicers;
    }

    private static void populateCubeMaskToMeasures(HashMapLongObject<Collection<IMember>> aggrCubeMaskToMeasures, HashMapObjectLong<IMember> measureToAggrCubeMask, Collection<IMember> measures, boolean allowMasksToBeDowngraded) {
        for (IMember measure : measures) {
            Collection<IMember> measuresWithMask;
            long cubeMask = measureToAggrCubeMask.get(measure);
            if (allowMasksToBeDowngraded) {
                cubeMask = ROLAPQueryStrategy.getBestFitMask(aggrCubeMaskToMeasures, cubeMask);
            }
            if ((measuresWithMask = aggrCubeMaskToMeasures.get(cubeMask)) == null) {
                measuresWithMask = new HashSet<IMember>();
                aggrCubeMaskToMeasures.put(cubeMask, measuresWithMask);
            }
            measuresWithMask.add(measure);
        }
    }

    private static void splitMeasures(Collection<IMember> measures, MeasurePrefetchManager prefetchMgr, List<IMember> requestedMeasures, List<IMember> prefetchMeasures) {
        ArrayList<IMember> singleMeasureList = new ArrayList<IMember>(1);
        for (IMember measure : measures) {
            singleMeasureList.clear();
            singleMeasureList.add(measure);
            if (prefetchMgr != null && prefetchMgr.isQueryOnlyForPrefetchedMeasures(singleMeasureList)) {
                prefetchMeasures.add(measure);
                continue;
            }
            requestedMeasures.add(measure);
        }
    }

    private static long getBestFitMask(HashMapLongObject<Collection<IMember>> aggrCubeMaskToMeasures, long measureCubeMask) {
        if (aggrCubeMaskToMeasures.get(measureCubeMask) != null) {
            return measureCubeMask;
        }
        long bestFitMask = 0L;
        long originalMask = 0L;
        int numSetBitsInBestFitMask = 0;
        IteratorLong existingCubeMaskIter = aggrCubeMaskToMeasures.keySetIterator();
        while (existingCubeMaskIter.hasNext()) {
            long mask = existingCubeMaskIter.next();
            long maskWithThisMeasure = mask & measureCubeMask;
            int setBits = Long.bitCount(maskWithThisMeasure);
            if (setBits <= numSetBitsInBestFitMask) continue;
            numSetBitsInBestFitMask = setBits;
            bestFitMask = maskWithThisMeasure;
            originalMask = mask;
        }
        long maskToUse = measureCubeMask;
        if (numSetBitsInBestFitMask > 0) {
            if ((bestFitMask & originalMask) == 0L) {
                throw new IllegalStateException("Downgrading measures to mask that has no bits in common...should never happen.");
            }
            Collection<IMember> measures = aggrCubeMaskToMeasures.remove(originalMask);
            Collection<IMember> bestFitMaskMeasures = aggrCubeMaskToMeasures.get(bestFitMask);
            if (bestFitMaskMeasures == null) {
                aggrCubeMaskToMeasures.put(bestFitMask, measures);
            } else {
                bestFitMaskMeasures.addAll(measures);
            }
            maskToUse = bestFitMask;
        }
        return maskToUse;
    }

    private void generateSelectionsBasedOnMeasuresAndSlicers(ROLAPMetaAggregateCube[] aggrCubes, Collection<IMember> measuresIn, Collection<IMember>[] selectionsIn, Collection<SetSelections> setSelectionsOut) throws InterpreterException {
        HashMapLongObject<Collection<IMember>> aggrCubeMaskToMeasures = new HashMapLongObject<Collection<IMember>>();
        long aggrCubesWithSlicersMask = this.getAggrCubeMaskToMeasures(aggrCubes, measuresIn, aggrCubeMaskToMeasures);
        IteratorLong it = aggrCubeMaskToMeasures.keySetIterator();
        while (it.hasNext()) {
            Object setSelections;
            long aggrCubeMask = it.next();
            Collection<IMember> measuresWithMask = aggrCubeMaskToMeasures.get(aggrCubeMask);
            if (this.prefetchManager != null && this.prefetchManager.isQueryOnlyForPrefetchedMeasures(measuresWithMask)) continue;
            if ((aggrCubeMask & aggrCubesWithSlicersMask) == 0L) {
                setSelections = SetSelections.createSetSelections(selectionsIn, measuresWithMask, this.getCubeMeasuresHierarchyIndex());
                setSelectionsOut.add((SetSelections)setSelections);
                continue;
            }
            setSelections = this.createSetSelectionPerCombination(selectionsIn, measuresWithMask);
            setSelectionsOut.addAll((Collection<SetSelections>)setSelections);
        }
    }

    private SetSelections updateSetSelectionForDiscardedPrefetchMeasures(SetSelections origSetSelections, SetSelections[] setSelections) {
        if (this.prefetchManager == null || !this.prefetchManager.addedPrefetchMeasures()) {
            return origSetSelections;
        }
        Hierarchy[] hierarchies = this.getCubeHierarchies();
        int measuresIndex = this.getCubeMeasuresHierarchyIndex();
        HashSet<IMember> reducedMeasures = new HashSet<IMember>();
        Collection<IMember>[] originalSelections = origSetSelections.getSelections(hierarchies);
        for (SetSelections setSelection : setSelections) {
            reducedMeasures.addAll(setSelection.getSelections(hierarchies)[measuresIndex]);
        }
        if (reducedMeasures.containsAll(originalSelections[measuresIndex])) {
            return origSetSelections;
        }
        return SetSelections.createSetSelections(originalSelections, reducedMeasures, measuresIndex);
    }

    private void separateMeasuresByType(Collection<IMember> measures, Collection<IMember> customAggrsOut, Collection<IMember> semiAggrsOut, Collection<IMember> otherAggrsOut) {
        for (IMember member : measures) {
            ROLAPMeasure measure = (ROLAPMeasure)member;
            if (measure.isSemiAggregate()) {
                if (measure.containsNonFirstLastAggregateRule()) {
                    semiAggrsOut.add(measure);
                    continue;
                }
                otherAggrsOut.add(measure);
                continue;
            }
            AggregateTypeEnum aggrType = measure.getRegularAggregate();
            if (aggrType == AggregateTypeEnum.UNKNOWN) {
                customAggrsOut.add(measure);
                continue;
            }
            otherAggrsOut.add(measure);
        }
    }

    private SetSelections[] generateSetSelectionsToPreventIncompleteSetsCustom(SetSelections setSel) throws InterpreterException {
        ROLAPMetaAggregateCube[] aggrCubes = ((ROLAPBaseCube)this.getCube()).getModelCube().getAggregateCubes();
        if (aggrCubes == null || aggrCubes.length == 0) {
            return new SetSelections[]{setSel};
        }
        if (aggrCubes.length > 64) {
            ROLAPLog.logError("ROLAPQuery", "Dynamic Cubes can only process 64 aggregate cubes due to using an 8 byte long bitmask.  Only the first aggregate cubes will be considered.");
            ROLAPMetaAggregateCube[] newAggrCubes = new ROLAPMetaAggregateCube[64];
            System.arraycopy(aggrCubes, 0, newAggrCubes, 0, 64);
            aggrCubes = newAggrCubes;
        }
        Hierarchy[] hierarchies = this.getCubeHierarchies();
        int measuresIndex = this.getCubeMeasuresHierarchyIndex();
        ArrayList<SetSelections> returnSelectionList = new ArrayList<SetSelections>();
        ArrayList<IMember> customAggrs = new ArrayList<IMember>();
        ArrayList<IMember> semiAggrs = new ArrayList<IMember>();
        ArrayList<IMember> otherAggrs = new ArrayList<IMember>();
        Collection<IMember>[] origSelections = setSel.getSelections(hierarchies);
        this.separateMeasuresByType(origSelections[measuresIndex], customAggrs, semiAggrs, otherAggrs);
        if (this.prefetchManager != null && this.prefetchManager.isQueryOnlyForPrefetchedMeasures(otherAggrs)) {
            otherAggrs.clear();
        }
        if (otherAggrs.size() > 0) {
            this.generateSelectionsBasedOnMeasuresAndSlicers(aggrCubes, otherAggrs, origSelections, returnSelectionList);
        }
        if (customAggrs.size() > 0) {
            this.generateSelectionsBasedOnMeasuresAndSlicers(aggrCubes, customAggrs, origSelections, returnSelectionList);
        }
        if (semiAggrs.size() > 0) {
            this.generateSelectionsBasedOnMeasuresAndSlicers(aggrCubes, semiAggrs, origSelections, returnSelectionList);
        }
        return returnSelectionList.toArray(new SetSelections[0]);
    }

    protected static void recordCacheMissInfo(ROLAPBaseCube cube, long startTime) {
        long execTime = System.currentTimeMillis() - startTime;
        CacheMetricsTracker metricsTracker = cube.getTupleStorageMetrics();
        if (metricsTracker != null) {
            metricsTracker.incrementAvgMissTime(execTime);
            metricsTracker.incrementMissData(1L);
        }
    }

    public static void logMsgNoResultForQuery(IROLAPQuery query, XQERuntimeException ex) {
        ROLAPLog.logTrace("ROLAPQuery", "No result for query " + query.getName());
        if (ex != null) {
            ROLAPLog.logError("ROLAPQuery", "", ex);
        }
    }

    public final ROLAPQueryExecuteMetrics getLastQueryMetrics() {
        return this.lastQueryMetrics;
    }

    @Override
    public final void setCubeletHint(String aCubeletHint) {
        this.cubeletHint = aCubeletHint;
    }

    @Override
    public final String getCubeletHint() {
        return this.cubeletHint;
    }

    public void buildROLAPQueries(SetSelections setToFetch, boolean isAgainstAggrTable, boolean isOverFetchingAllowed, boolean isCustomAggregateAllowed, ROLAPQueryGroup groupQueryOut, List<V5ProviderCombination> combinations) throws InterpreterException {
        if (combinations == null) {
            combinations = this.prepareV5ProviderCombinations(setToFetch, isAgainstAggrTable);
        }
        int numberOfCombinations = combinations.size();
        ResourceMonitor.checkNumberOfDBQueries(numberOfCombinations);
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        HashMap<Level, HashSet<IROLAPCommonMember>> levelToSelectionsMap = new HashMap<Level, HashSet<IROLAPCommonMember>>();
        HashMap<Level, ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>>> levelToLevelKeysMap = new HashMap<Level, ArrayList<Map<ROLAPMetaAttribute, HashSet<IValue>>>>();
        int origQueryCount = groupQueryOut.queryCount();
        int comboIndex = origQueryCount + 1;
        for (V5ProviderCombination combination : combinations) {
            if (cancelManager != null && cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            ROLAPQuery query = null;
            query = this.combinationToV5ProviderQuery(comboIndex, combination.getSelections(), isAgainstAggrTable, isOverFetchingAllowed, isCustomAggregateAllowed, levelToSelectionsMap, levelToLevelKeysMap);
            if (combination instanceof V5ProviderAggregateCombination) {
                query.setFLAggregateMemberFilter((V5ProviderAggregateCombination)combination);
            }
            if (query == null) continue;
            if (this.getPushDownMode()) {
                query.setPushdownManager(this.mPushdownManager);
            }
            groupQueryOut.addQuery(query);
            ++comboIndex;
        }
    }

    private static final class MeasurePrefetchManager {
        private static final int PERCENTAGE_FACTOR = 100;
        private static final String AVOID_MSG = "Measures prefetch optimization avoided a query for only prefetched measures: ";
        static final double DEFAULT_MEASURES_THRESHOLD = 0.3;
        private final IMember[] requestedMeasures;
        private final IMember[] unrequestedMeasuresToInject;
        private final int measureIdx;
        private boolean addedPrefetchMeasures = false;

        MeasurePrefetchManager(IMember[] measuresMembers, int measIdx) {
            this.measureIdx = measIdx;
            this.requestedMeasures = measuresMembers;
            this.unrequestedMeasuresToInject = this.getUnlistedSupportedMeasures(measuresMembers);
        }

        public boolean addedPrefetchMeasures() {
            return this.addedPrefetchMeasures;
        }

        public ISet injectPrefetchMeasures(Hierarchy[] hierarchies, ISet setToFetch, int measuresThreshold) {
            if (this.unrequestedMeasuresToInject.length > 0 && MeasurePrefetchManager.optPrefetchAllMeasures(this.unrequestedMeasuresToInject, this.requestedMeasures, measuresThreshold) && this.unrequestedMeasuresToInject != null && this.unrequestedMeasuresToInject.length > 0) {
                HashSet<IMember>[] selections = ((Set)setToFetch).selectionsInHierarchies(hierarchies);
                selections[this.measureIdx].addAll(Arrays.asList(this.unrequestedMeasuresToInject));
                setToFetch = BlockTupleStorageUtil.createCjsFromMemberSelections(selections);
                this.addedPrefetchMeasures = true;
                if (ROLAPLog.isOn("ROLAPQuery", LogLevel.INFO)) {
                    ROLAPLog.log("ROLAPQuery", "Measures prefetch optimization added measures: " + Arrays.toString(this.unrequestedMeasuresToInject));
                }
            }
            return setToFetch;
        }

        public boolean isQueryOnlyForPrefetchedMeasures(Collection<IMember> queryMeasures) {
            boolean onlyPrefetchMeasures;
            if (this.unrequestedMeasuresToInject.length == 0) {
                return false;
            }
            HashSet<IMember> modifiableQueryMeasures = new HashSet<IMember>(queryMeasures);
            boolean bl = onlyPrefetchMeasures = !modifiableQueryMeasures.removeAll(Arrays.asList(this.requestedMeasures));
            if (onlyPrefetchMeasures && ROLAPLog.isOn("ROLAPQuery", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPQuery", AVOID_MSG + modifiableQueryMeasures);
            }
            return onlyPrefetchMeasures;
        }

        private IMember[] getUnlistedSupportedMeasures(IMember[] measuresSelections) {
            List<IMember> mbrList = this.getAllMeasuresFromCube(measuresSelections);
            MeasurePrefetchManager.removeUnsupportedMeasureTypes(mbrList);
            this.removeAlreadySelectedMeasures(measuresSelections, mbrList);
            return mbrList.toArray(new IMember[mbrList.size()]);
        }

        private void removeAlreadySelectedMeasures(IMember[] measuresSelections, List<IMember> mbrList) {
            for (int meaIdx = 0; meaIdx < measuresSelections.length; ++meaIdx) {
                IMember selectedMeasure = measuresSelections[meaIdx];
                for (int i = 0; i < mbrList.size(); ++i) {
                    ROLAPMeasure rm = (ROLAPMeasure)mbrList.get(i);
                    if (!rm.getName().equals(selectedMeasure.getName())) continue;
                    mbrList.remove(i);
                }
            }
        }

        private static void removeUnsupportedMeasureTypes(List<IMember> mbrList) {
            ListIterator<IMember> listIterator = mbrList.listIterator();
            while (listIterator.hasNext()) {
                ROLAPMeasure rm = (ROLAPMeasure)listIterator.next();
                if (rm.isCalculatedMember()) {
                    listIterator.remove();
                    continue;
                }
                if (rm.isSemiAggregate()) {
                    listIterator.remove();
                    continue;
                }
                if (rm.getRegularAggregate() == AggregateTypeEnum.UNSUPPORTED || rm.getRegularAggregate() == AggregateTypeEnum.CALCULATED) {
                    listIterator.remove();
                    continue;
                }
                if (rm.isVisible()) continue;
                listIterator.remove();
            }
        }

        private List<IMember> getAllMeasuresFromCube(IMember[] measuresSelections) {
            List<IMember> mbrList = new ArrayList<IMember>();
            if (measuresSelections.length > 0) {
                ROLAPDimension mDim = ((ROLAPMeasure)measuresSelections[0]).getROLAPDimension();
                mbrList = ((ROLAPLevel)mDim.getLevel(0)).getMembers(false, true);
            }
            return mbrList;
        }

        private static double getMeasuresThreshold(int measuresThreshold) {
            double threshold = 0.3;
            int arg = measuresThreshold;
            if (arg < 0) {
                arg = 0;
            } else if (arg > 100) {
                arg = 100;
            }
            threshold = (double)arg / 100.0;
            return threshold;
        }

        private static boolean optPrefetchAllMeasures(IMember[] unlistedMeasures, IMember[] listedMeasureSet, int measuresThreshold) {
            int measureCount = unlistedMeasures.length + listedMeasureSet.length;
            double thr = Math.round((double)measureCount * MeasurePrefetchManager.getMeasuresThreshold(measuresThreshold));
            return (double)listedMeasureSet.length >= thr;
        }
    }

    public static class TupleValueIterator
    implements ClosableIterator<TupleValue> {
        private final boolean queryTraceLoggingOn = ROLAPLog.isOn("ROLAPQuery", LogLevel.TRACE);
        private final boolean performanceInfoLoggingOn = ROLAPLog.isOn("ROLAPQuery.Performance", LogLevel.INFO);
        private static final String NEWLINE = System.getProperty("line.separator");
        private V5ProviderQueryResult queryResult;
        protected final ROLAPQuery query;
        private final IResultSet queryResultSet;
        private IValue[] currentRow = null;
        private IMember[] currentTuple = null;
        private TupleValue nextTupleValue = null;
        private int measureSelIdx;
        FormatId[] measureFormatIds;
        long cellValueCount = 0L;
        long initialRsSize;
        private long rowCount;
        private long discardedRowCount;
        private TupleOrdinalCalculationCache ordinalCalcCache;
        private final List<long[]> cachedOrdinalList;
        private final int[] keyMappingIndexToMemberIndex;
        private final int measureTupleIndex;
        private int measuresOffset;
        private final boolean isMetricsOnlyResultSet;
        private TupleValue commonTupleValue = null;
        private DoubleValue commonDoubleValue = null;
        private boolean hasMoreData = true;
        protected final ROLAPQueryExecuteMetrics queryMetrics;
        private HighPrecisionStopWatch dataQueryStartTime;
        private final boolean callNotifyEndAtClose;
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();

        public TupleValueIterator(HashMapObjectInt<String> hierToIndexMap, V5ProviderQueryResult queryResultIter, ROLAPQuery queryObj, IResultSet resultSet, ROLAPQueryExecuteMetrics metrics, boolean internallyManageNotifyStartAndEnd) {
            this(hierToIndexMap, queryObj, resultSet, metrics, internallyManageNotifyStartAndEnd);
            this.initializeForFetch(queryResultIter);
        }

        public TupleValueIterator(HashMapObjectInt<String> hierToIndexMap, ROLAPQuery queryObj, IResultSet resultSet, ROLAPQueryExecuteMetrics metrics, boolean internallyManageNotifyStartAndEnd) {
            this.queryMetrics = metrics;
            this.callNotifyEndAtClose = internallyManageNotifyStartAndEnd;
            this.query = queryObj;
            this.queryResultSet = resultSet;
            this.isMetricsOnlyResultSet = this.queryResultSet instanceof AggregateCacheLoader.MetricsOnlyResultSet;
            this.cachedOrdinalList = new ArrayList<long[]>();
            ArrayList<ROLAPCompoundKeyMapping> compoundKeyMappings = this.query.compoundKeyMappings;
            if (compoundKeyMappings != null) {
                this.keyMappingIndexToMemberIndex = new int[compoundKeyMappings.size()];
                for (int j = 0; j < compoundKeyMappings.size(); ++j) {
                    int tupleIndex;
                    ROLAPCompoundKeyMapping mapping = compoundKeyMappings.get(j);
                    this.keyMappingIndexToMemberIndex[j] = tupleIndex = hierToIndexMap.get(mapping.getLevel().getHierarchy().getUniqueName());
                }
            } else {
                this.keyMappingIndexToMemberIndex = new int[0];
            }
            if (!this.query.measureSelections.isEmpty()) {
                IMember measure = this.query.measureSelections.get(0);
                this.measureTupleIndex = hierToIndexMap.get(measure.getHierarchy().getUniqueName());
            } else {
                this.measureTupleIndex = -1;
            }
        }

        protected void initializeForFetch(V5ProviderQueryResult queryResultIter) {
            try {
                this.queryResult = queryResultIter;
                this.currentTuple = this.query.getOutputTuple();
                this.measureSelIdx = Integer.MAX_VALUE;
                this.measuresOffset = this.query.getMeasuresOffset();
                if (this.queryResultSet != null) {
                    this.initialRsSize = this.queryResultSet.cellCount();
                }
                this.ordinalCalcCache = this.queryResultSet != null && this.queryResultSet.getMetadata() != null ? new TupleOrdinalCalculationCache(this.queryResultSet.getMetadata().getQuerySet()) : null;
                this.cacheMeasureFormats();
                int numFormatCols = 0;
                if (this.queryResult != null) {
                    FormatId[] colFormatIds = this.queryResult.getProviderQueryResultIter().getColumnFormat();
                    numFormatCols = colFormatIds.length;
                }
                this.currentRow = new IValue[numFormatCols];
                if (this.callNotifyEndAtClose) {
                    this.notifyStart();
                }
            }
            catch (RuntimeException ex) {
                this.close();
                throw ex;
            }
            catch (Throwable ex) {
                this.close();
                throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
            }
        }

        protected void notifyStart() {
            if (this.performanceInfoLoggingOn) {
                ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPQuery.Performance", "Started iterating result set for data query: " + this.query.getName());
            }
            XQueryStrategy.Operation operation = XQueryStrategy.Operation.CUBE_RETRIEVAL;
            if (this.query.usingExternalAggregateTable()) {
                operation = XQueryStrategy.Operation.AGGREGATE_CUBE_RETRIEVAL;
            } else {
                this.queryMetrics.notifyOperationStart(XQueryStrategy.Operation.AGGREGATE_CUBE_RETRIEVAL);
            }
            this.dataQueryStartTime = new HighPrecisionStopWatch(true);
            this.queryMetrics.notifyOperationStart(operation);
        }

        protected void notifyEnd() {
            long fetchTimeInMillis = this.dataQueryStartTime.getElapsedTimeInMilliseconds();
            if (this.isQueryExecutePartOfFetch()) {
                fetchTimeInMillis -= this.query.getQueryMetrics().getSqlExectuteTime();
            }
            this.query.getQueryMetrics().setRowFetchData(fetchTimeInMillis, this.rowCount, this.discardedRowCount, this.measureFormatIds.length);
            XQueryStrategy.Operation operation = XQueryStrategy.Operation.CUBE_RETRIEVAL;
            if (this.query.usingExternalAggregateTable()) {
                operation = XQueryStrategy.Operation.AGGREGATE_CUBE_RETRIEVAL;
            }
            int cellCount = 0;
            if (this.queryResultSet != null) {
                cellCount = this.queryResultSet.cellCount();
            }
            this.queryMetrics.notifyOperationEnd(operation, cellCount, this.query.isPushdownQuery());
            this.queryMetrics.getSqlQueryMetrics().add(this.query.getQueryMetrics());
            if (this.performanceInfoLoggingOn) {
                ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPQuery.Performance", String.format("Finished iterating result set for data query: %s" + NEWLINE + "  Iterated %d rows from the database" + NEWLINE + "  Discarded %d rows overfetched due to filter simplification" + NEWLINE + "  Fetched %d total values from %d measure columns", this.query.getName(), this.rowCount, this.discardedRowCount, this.cellValueCount, this.measureFormatIds.length));
            }
        }

        private void cacheMeasureFormats() {
            this.measureFormatIds = new FormatId[this.query.measureSelections.size()];
            int i = 0;
            for (ROLAPMeasure measure : this.query.measureSelections) {
                FormatId formatId = measure.getFormatId();
                if (formatId != null) {
                    this.measureFormatIds[i++] = formatId;
                    continue;
                }
                String measureFormat = (String)measure.getProperty("format");
                formatId = FormatId.DEFAULT_NUMBER_FORMAT_FID;
                if (measureFormat != null) {
                    formatId = FormatService.getInstance().registerV5Format(measureFormat, null);
                }
                this.measureFormatIds[i++] = formatId;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.nextTupleValue == null && this.hasMoreData) {
                this.nextTupleValue = this.getNext();
            }
            this.hasMoreData = this.nextTupleValue != null;
            return this.hasMoreData;
        }

        @Override
        public TupleValue next() {
            if (this.cancelManager != null && this.cancelManager.isRequestCancelled()) {
                throw new OperationCanceledException();
            }
            if (this.nextTupleValue == null && this.hasMoreData) {
                this.nextTupleValue = this.getNext();
            }
            TupleValue retTupleValue = this.nextTupleValue;
            this.nextTupleValue = null;
            this.hasMoreData = retTupleValue != null;
            return retTupleValue;
        }

        private TupleValue getNext() {
            if (this.queryResult == null) {
                return null;
            }
            TupleValue tupValue = this.getNextMeasure();
            if (tupValue != null) {
                return tupValue;
            }
            IROLAPQueryResultIterator queryResultIter = this.queryResult.getProviderQueryResultIter();
            FormatId[] formatIds = queryResultIter.getColumnFormat();
            while (queryResultIter.hasNext()) {
                ++this.rowCount;
                IValue[] values = queryResultIter.next().getColumns();
                if (values.length > 0) {
                    for (int j = 0; j < this.currentRow.length; ++j) {
                        IValue v = values[j];
                        if (v instanceof TextValue) {
                            ((TextValue)v).setCollator(null);
                        }
                        if (v instanceof DirectAccessJDBCValue && v.getDataType().getJDBCType() == 8 && !FormatId.isDefaultFormatId(formatIds[j])) {
                            ((DoubleValue)((DirectAccessJDBCValue)v).getValue()).setFormatId(formatIds[j]);
                        }
                        this.currentRow[j] = v;
                    }
                }
                boolean haveMatch = true;
                ArrayList<ROLAPCompoundKeyMapping> compoundKeyMappings = this.query.compoundKeyMappings;
                if (compoundKeyMappings != null) {
                    for (int j = 0; j < compoundKeyMappings.size() && haveMatch; ++j) {
                        ROLAPCompoundKeyMapping mapping = compoundKeyMappings.get(j);
                        IMember member = mapping.getMemberForRowResult(this.currentRow);
                        if (member != null) {
                            int tupleIndex = this.keyMappingIndexToMemberIndex[j];
                            this.currentTuple[tupleIndex] = member;
                            continue;
                        }
                        if (mapping.hasRecursiveHierarchy() && !mapping.isPchSelectionForLeafMembersOnly()) continue;
                        haveMatch = false;
                    }
                }
                if (!haveMatch) {
                    ++this.discardedRowCount;
                    if (!this.queryTraceLoggingOn) continue;
                    ROLAPLog.logTrace("ROLAPQuery", "TupleValueIterator: Row does not match a key mapping: " + Arrays.toString(this.currentRow));
                    continue;
                }
                this.measureSelIdx = 0;
                tupValue = this.getNextMeasure();
                if (tupValue == null) continue;
                return tupValue;
            }
            return tupValue;
        }

        private TupleValue getNextMeasure() {
            TupleValue tupValueWithNextMeasure = null;
            ArrayList<ROLAPMeasure> measuresSelections = this.query.measureSelections;
            while (this.measureSelIdx < measuresSelections.size() && tupValueWithNextMeasure == null) {
                IMember measure;
                this.currentTuple[this.measureTupleIndex] = measure = (IMember)measuresSelections.get(this.measureSelIdx);
                if (this.measuresOffset + this.measureSelIdx >= this.currentRow.length) {
                    ROLAPLog.logError("ROLAPQuery", " Error Index =" + (this.measuresOffset + this.measureSelIdx) + " of row " + Arrays.toString(this.currentRow));
                } else {
                    try {
                        IValue value = this.currentRow[this.measuresOffset + this.measureSelIdx];
                        if (value != null && value.getDataType().isNumeric()) {
                            double theValue = 0.0;
                            theValue = value instanceof DirectAccessJDBCValue ? ((DirectAccessJDBCValue)value).getDouble() : ((Value)value).getDouble();
                            if (theValue != 0.0 || !value.isNull()) {
                                DoubleValue doubleValue;
                                if (this.commonTupleValue == null) {
                                    Tuple dataTuple = new Tuple((IMember[])this.currentTuple.clone(), false, measure.getDimension().getCube());
                                    doubleValue = DataValueFactory.createDoubleValue();
                                    tupValueWithNextMeasure = new TupleValue(dataTuple, new Cell(-1L, doubleValue));
                                } else {
                                    tupValueWithNextMeasure = this.commonTupleValue;
                                    doubleValue = this.commonDoubleValue;
                                }
                                doubleValue.set(theValue);
                                boolean bFormatIdSet = false;
                                if (value instanceof DirectAccessJDBCValue && value.getDataType().getJDBCType() == 8) {
                                    FormatId fId = ((DoubleValue)((DirectAccessJDBCValue)value).getValue()).getFormatId();
                                    if (!FormatId.isDefaultFormatId(this.measureFormatIds[this.measureSelIdx])) {
                                        doubleValue.setFormatId(this.measureFormatIds[this.measureSelIdx]);
                                        bFormatIdSet = true;
                                    } else if (!FormatId.isDefaultFormatId(fId)) {
                                        doubleValue.setFormatId(fId);
                                        bFormatIdSet = true;
                                    }
                                }
                                if (!bFormatIdSet) {
                                    doubleValue.setFormatId(this.measureFormatIds[this.measureSelIdx]);
                                }
                                ++this.cellValueCount;
                                if (this.queryResultSet != null) {
                                    List<long[]> ordinals = this.queryResultSet.getTupleOrdinals(tupValueWithNextMeasure.getTuple(), this.ordinalCalcCache, this.cachedOrdinalList);
                                    Cell c = null;
                                    boolean calc = false;
                                    if (!this.isMetricsOnlyResultSet) {
                                        c = new Cell(doubleValue);
                                        calc = c.isCalculation();
                                    }
                                    this.queryResultSet.addCell(ordinals, c, calc, false);
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        ROLAPLog.logError("ROLAPQuery", " DataProvider processing output gave up on " + Arrays.toString(this.currentRow) + " at " + (this.measuresOffset + this.measureSelIdx), e);
                    }
                }
                ++this.measureSelIdx;
            }
            return tupValueWithNextMeasure;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() {
            if (null != this.queryResult) {
                this.queryResult.release();
                this.queryResult = null;
                if (this.callNotifyEndAtClose) {
                    this.notifyEnd();
                }
            }
        }

        public long getCellValueCount() {
            return this.cellValueCount;
        }

        public long getNumResultSetCellsAdded() {
            if (this.queryResultSet == null) {
                return 0L;
            }
            return (long)this.queryResultSet.cellCount() - this.initialRsSize;
        }

        protected boolean isQueryExecutePartOfFetch() {
            return false;
        }

        public void setReuseTupleObjects(boolean reuse, ICube cube) {
            ROLAPLog.getLogger("ROLAPQuery.Performance", LogLevel.TRACE).log(LogLevel.TRACE, "Settting reuse tuple objects to " + reuse);
            if (reuse) {
                Tuple commonTuple = new Tuple(this.query.getOutputTuple(), false, cube);
                this.commonDoubleValue = DataValueFactory.createDoubleValue();
                Cell commonCell = new Cell(0L, this.commonDoubleValue);
                this.commonTupleValue = new TupleValue(commonTuple, commonCell);
            } else {
                this.commonTupleValue = null;
                this.commonDoubleValue = null;
            }
        }
    }
}

