/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IAggregateRule;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.XMdxCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Block;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Interpreter;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAbstractHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.transformation.olap.util.SolveOrderUtil;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocaleUtility;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ROLAPRelativeTimeMember
extends ROLAPCalculatedMember {
    public static final String UNDERSCORE = "_";
    public static final String CURRENT = "Current";
    public static final String PRIOR = "Prior";
    public static final String NEXT = "Next";
    public static final String SPACE = " ";
    public static final String UNDERSCORE_TO_UNDERSCORE_DATE = "_to_Date";
    public static final String TO_SPACE_DATE = "to Date";
    public static final String CHANGE = "Change";
    public static final String GROWTH = "Growth";
    public static final String LEFT_PARENTHESIS = "(";
    public static final String RIGHT_PARENTHESIS = ")";
    public static final String DIVISION_SYMBOL = "/";
    public static final String DOT = ".";
    private static final String COMMA = ",";
    public static final String AGGREGATE_FUNCTION_NAME = "AGGREGATE";
    public static final String CURRENTMEMBER_FUNCTION_NAME = "CURRENTMEMBER";
    public static final String PERIODSTODATE_FUNCTION_NAME = "PERIODSTODATE";
    public static final String DUMMY_MEASURES = "[Dummy Measures]";
    public static final String LEFT_BRACE = "{";
    public static final String RIGHT_BRACE = "}";
    public static final int TYPE_NOT_RELATIVE_TIME = 0;
    public static final int TYPE_CURRENT_PERIOD = 1;
    public static final int TYPE_PRIOR_PERIOD = 2;
    public static final int TYPE_PERIOD_TO_DATE = 3;
    public static final int TYPE_PRIOR_PERIOD_TO_DATE = 4;
    public static final int TYPE_PERIOD_TO_DATE_CHANGE = 5;
    public static final int TYPE_PERIOD_TO_DATE_GROWTH = 6;
    public static final int TYPE_PERIOD_CHILD_REF = 7;
    public static final int TYPE_PERIOD_TO_DATE_LAST_CHILD = 8;
    public static final int TYPE_NEXT_PERIOD = 9;
    public static final int TYPE_NEXT_PERIOD_TO_DATE = 10;
    public static final int TYPE_NEXT_PERIOD_TO_DATE_CHANGE = 11;
    public static final int TYPE_NEXT_PERIOD_TO_DATE_GROWTH = 12;
    public static final int TYPE_CUSTOM_SIMPLE = 13;
    public static final int TYPE_CUSTOM_PERIOD_TO_DATE = 14;
    public static final int TYPE_CUSTOM_ROLLING_TOTAL = 15;
    public static final String PERIOD_TO_DATE_GROWTH_FORMAT_STR = "&lt;formatGroup&gt;&lt;percentFormat decimalSize='2' decimalDelimiter='.' percentSymbol='%'/&gt;&lt;/formatGroup&gt;";
    private final int relaTimeMemberType;
    private final IMember referenceMember;
    private IMember ptdLastChild;
    private String mdxExpression;
    private XMdxCalculatedMember runtree = null;
    private String optimizedMdxExpression;
    private XMdxCalculatedMember optimizedRuntree = null;
    private ROLAPMetaObject metaRelativeTimeMember;

    public ROLAPRelativeTimeMember(String name, ILevel level, Object calculationStr, String[] identifiers, int rtMemberType, IMember refMember, ROLAPMetaObject pMetaRelativeTimeMember) throws MetadataException {
        super(name, level, calculationStr, identifiers, (ROLAPMetaCalculatedMember)null);
        this.children = this.createOrderedMap();
        this.gotAllChildren = true;
        this.referenceMember = refMember;
        this.relaTimeMemberType = rtMemberType;
        this.metaRelativeTimeMember = pMetaRelativeTimeMember;
    }

    @Override
    public Object getCalcMemberResult(InterpreterContext interpreterContext, Interpreter interpreter) throws InterpreterException {
        Block retBlock = null;
        if (this.referenceMember != null && !this.isExtendedCalculatedMemberWithFormula()) {
            retBlock = new Block(interpreterContext, this.referenceMember);
        } else {
            Map<String, CalculatedMember> calculationsMap = interpreterContext.getCalculationEngine().getAllCalcedMembers();
            for (CalculatedMember calc : calculationsMap.values()) {
                if (calc.getOriginalCalculatedMember() != this) continue;
                return calc.getCalcMemberResult(interpreterContext, interpreter);
            }
            boolean useOptimizedPTDExpression = true;
            ROLAPCube cube = (ROLAPCube)interpreterContext.getCube();
            if (!cube.isVirtual()) {
                IMember[] measuresInContext;
                CrossJoinedSet contextSet = interpreterContext.getContextSet();
                for (IMember measure : measuresInContext = contextSet.getMembers(interpreterContext.getCube().getMeasuresHierarchy())) {
                    AggregateTypeEnum regularAggregate = measure.getRegularAggregate();
                    if (regularAggregate != AggregateTypeEnum.SUM && regularAggregate != AggregateTypeEnum.MIN && regularAggregate != AggregateTypeEnum.MAX) {
                        useOptimizedPTDExpression = false;
                    } else {
                        IAggregateRule[] rules = measure.getAggregateRules();
                        if (rules.length <= 0) continue;
                        useOptimizedPTDExpression = false;
                    }
                    break;
                }
            } else {
                useOptimizedPTDExpression = false;
            }
            if (useOptimizedPTDExpression) {
                this.setRuntreeCalculatedMember(this.optimizedRuntree);
            } else {
                this.setRuntreeCalculatedMember(this.runtree);
            }
            retBlock = (Block)super.getCalcMemberResult(interpreterContext, interpreter);
        }
        return retBlock;
    }

    public void generatePTDRuntreeNode(ILevel level, IMember member) {
        if (this.relaTimeMemberType != 3 && this.relaTimeMemberType != 4 && this.relaTimeMemberType != 8 && this.relaTimeMemberType != 10 && this.relaTimeMemberType != 14) {
            return;
        }
        this.mdxExpression = this.generatePtdMdxExpression(level, member, false);
        this.runtree = this.generateXMdxCalculatedMember(this.mdxExpression, (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment());
        this.optimizedMdxExpression = this.generatePtdMdxExpression(level, member, true);
        this.optimizedRuntree = this.generateXMdxCalculatedMember(this.optimizedMdxExpression, (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment());
    }

    private String generatePtdMdxExpression(ILevel level, IMember member, boolean genOptimizedExp) {
        String retMdxExp;
        ROLAPAbstractHierarchy hierarchy = (ROLAPAbstractHierarchy)this.getHierarchy();
        String measureUniqueName = DUMMY_MEASURES;
        IHierarchy measuresHierarchy = this.getDimension().getCube().getMeasuresHierarchy();
        if (measuresHierarchy != null) {
            measureUniqueName = measuresHierarchy.getUniqueName();
        }
        if (genOptimizedExp) {
            List<IMember> ptdOptimalSet = hierarchy.getOptimalPeriodsToDateMembers(level, member);
            StringBuilder ptdOptimalSetStr = new StringBuilder();
            for (IMember ptdSetMember : ptdOptimalSet) {
                if (ptdOptimalSetStr.length() > 0) {
                    ptdOptimalSetStr.append(COMMA);
                }
                ptdOptimalSetStr.append(ptdSetMember.getUniqueName());
            }
            retMdxExp = "AGGREGATE({" + ptdOptimalSetStr + RIGHT_BRACE + COMMA + measureUniqueName + DOT + CURRENTMEMBER_FUNCTION_NAME + RIGHT_PARENTHESIS;
        } else {
            retMdxExp = "AGGREGATE(PERIODSTODATE( " + level.getUniqueName() + COMMA + member.getUniqueName() + ") " + COMMA + measureUniqueName + DOT + CURRENTMEMBER_FUNCTION_NAME + RIGHT_PARENTHESIS;
        }
        return retMdxExp;
    }

    public void generateChangeOrGrowthRuntreeNode(IMember currentPTD, IMember priorPTD) {
        String currentPTDMdxExp = ((ROLAPRelativeTimeMember)currentPTD).getUniqueName();
        String priorPTDMdxExp = ((ROLAPRelativeTimeMember)priorPTD).getUniqueName();
        this.generateChangeOrGrowthMdxExpression(currentPTDMdxExp, priorPTDMdxExp, false);
        this.generateChangeOrGrowthMdxExpression(currentPTDMdxExp, priorPTDMdxExp, true);
    }

    private void generateChangeOrGrowthMdxExpression(String currentPTDMdxExp, String priorPTDMdxExp, boolean genOptimizedExp) {
        String mdx = " (" + currentPTDMdxExp + RIGHT_PARENTHESIS + " - " + LEFT_PARENTHESIS + priorPTDMdxExp + RIGHT_PARENTHESIS;
        if (this.relaTimeMemberType == 6 || this.relaTimeMemberType == 12) {
            mdx = LEFT_PARENTHESIS + mdx + RIGHT_PARENTHESIS + DIVISION_SYMBOL + priorPTDMdxExp;
        }
        if (this.relaTimeMemberType == 6 || this.relaTimeMemberType == 12) {
            FormatId growthFormatId = ROLAPMetaMeasure.generateFormatId(PERIOD_TO_DATE_GROWTH_FORMAT_STR);
            this.setFormatId(growthFormatId);
        }
        XMdxCalculatedMember calcMemberRunTreeNode = this.generateXMdxCalculatedMember(mdx, (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment());
        if (genOptimizedExp) {
            this.optimizedMdxExpression = mdx;
            this.optimizedRuntree = calcMemberRunTreeNode;
        } else {
            this.mdxExpression = mdx;
            this.runtree = calcMemberRunTreeNode;
        }
    }

    @Override
    public boolean isExtendedCalculatedMember() {
        return true;
    }

    @Override
    public boolean isExtendedCalculatedMemberTypeChildRef() {
        return this.relaTimeMemberType == 7;
    }

    @Override
    public boolean isExtendedCalculatedMemberWithFormula() {
        return this.relaTimeMemberType == 3 || this.relaTimeMemberType == 4 || this.relaTimeMemberType == 8 || this.relaTimeMemberType == 5 || this.relaTimeMemberType == 6 || this.relaTimeMemberType == 10 || this.relaTimeMemberType == 11 || this.relaTimeMemberType == 12 || this.relaTimeMemberType == 14 || this.relaTimeMemberType == 15;
    }

    public IMember getPtdLastChild() {
        return this.ptdLastChild;
    }

    public void setPtdLastChild(IMember lastChild) {
        this.ptdLastChild = lastChild;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        if (this.metaRelativeTimeMember != null) {
            ILocalizedString captions = this.metaRelativeTimeMember.getCaptions();
            if (captions == null) {
                captions = this.metaRelativeTimeMember.getNames();
            }
            if (captions == null) {
                captions = AbstractSingleLocaleString.getSingleLocaleString(this.getROLAPDimension().getROLAPCube().getDefaultLocale(), this.getCaption());
            }
            if (captions != null) {
                String defaultLocale = captions.getDefaultLocale();
                String defaultCaption = captions.toString();
                if (defaultCaption != null && this.referenceMember != null) {
                    defaultCaption = defaultCaption + " (" + this.referenceMember.getCaption() + RIGHT_PARENTHESIS;
                }
                LocalizedString captionsWithReference = new LocalizedString(defaultLocale, defaultCaption);
                for (String locale : captions.getSupportedLocales()) {
                    String value = captions.toString(locale);
                    if (value != null && this.referenceMember != null) {
                        value = value + " (" + this.referenceMember.getCaption() + RIGHT_PARENTHESIS;
                    }
                    captionsWithReference.put(locale, value);
                }
                captions = captionsWithReference;
            }
            return captions;
        }
        IROLAPLevel l = (IROLAPLevel)this.getLevel();
        Locale supportedLocale = LocaleUtility.getSupportedLocale(runLocale, l.getLocalizedCaption(), this.getDefaultLocale());
        String caption = ROLAPRelativeTimeMember.getMemberCaption(this.relaTimeMemberType, l.getCaption(), l.getType(), this.referenceMember.getCaption(), supportedLocale);
        ILocalizedString locCaption = AbstractSingleLocaleString.getSingleLocaleString(supportedLocale, caption);
        return locCaption;
    }

    @Override
    public String getCaption() {
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        if (this.metaRelativeTimeMember != null) {
            String locale = LocaleConverter.localeToStr(runLocale);
            String theCaption = this.metaRelativeTimeMember.getCaption(locale);
            if (theCaption == null) {
                theCaption = this.metaRelativeTimeMember.getCaption(this.metaRelativeTimeMember.getDefaultLocale());
            }
            if (theCaption != null) {
                if (this.referenceMember != null) {
                    theCaption = theCaption + " (" + this.referenceMember.getCaption() + RIGHT_PARENTHESIS;
                }
                return theCaption;
            }
            if (this.caption != null) {
                return this.caption;
            }
            return this.getName();
        }
        IROLAPLevel l = (IROLAPLevel)this.getLevel();
        Locale supportedLocale = LocaleUtility.getSupportedLocale(runLocale, l.getLocalizedCaption(), this.getDefaultLocale());
        String caption = ROLAPRelativeTimeMember.getMemberCaption(this.relaTimeMemberType, l.getCaption(), l.getType(), this.referenceMember.getCaption(), supportedLocale);
        return caption;
    }

    public static String getMemberName(int memberType, String levelName) {
        String memberName = null;
        switch (memberType) {
            case 1: {
                memberName = "_Current_" + levelName;
                break;
            }
            case 2: {
                memberName = "_Prior_" + levelName;
                break;
            }
            case 3: 
            case 8: {
                memberName = UNDERSCORE + levelName + UNDERSCORE_TO_UNDERSCORE_DATE;
                break;
            }
            case 4: {
                memberName = "_Prior_" + levelName + UNDERSCORE_TO_UNDERSCORE_DATE;
                break;
            }
            case 5: {
                memberName = UNDERSCORE + levelName + UNDERSCORE_TO_UNDERSCORE_DATE + UNDERSCORE + CHANGE;
                break;
            }
            case 6: {
                memberName = UNDERSCORE + levelName + UNDERSCORE_TO_UNDERSCORE_DATE + UNDERSCORE + GROWTH;
                break;
            }
            case 9: {
                memberName = "_Next_" + levelName;
                break;
            }
            case 10: {
                memberName = "_Next_" + levelName + UNDERSCORE_TO_UNDERSCORE_DATE;
                break;
            }
            case 11: {
                memberName = "_Next_" + levelName + UNDERSCORE_TO_UNDERSCORE_DATE + UNDERSCORE + CHANGE;
                break;
            }
            case 12: {
                memberName = "_Next_" + levelName + UNDERSCORE_TO_UNDERSCORE_DATE + UNDERSCORE + GROWTH;
                break;
            }
            default: {
                memberName = "";
            }
        }
        return memberName;
    }

    public static String getMemberName(int memberID, ILevel level) {
        return ROLAPRelativeTimeMember.getMemberName(memberID, level.getName());
    }

    public static String getMemberCaption(int memberType, String levelCaption, int levelType, String refMemberCaption, Locale locale) {
        IMessageKey.Param1 key = null;
        block0 : switch (memberType) {
            case 1: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_CurrentYear;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_CurrentHalfYear;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_CurrentQuarter;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_CurrentMonth;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_CurrentWeek;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_CurrentDay;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_CurrentHour;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_CurrentMinute;
                        break block0;
                    }
                    case 12: {
                        key = XQEMessageKeys.RRT_CurrentSecond;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_CurrentPeriod;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_CurrentSeason;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_CurrentHoliday;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_CurrentSemester;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_CurrentTrimester;
                        break block0;
                    }
                }
                break;
            }
            case 2: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_PriorYear;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_PriorHalfYear;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_PriorQuarter;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_PriorMonth;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_PriorWeek;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_PriorDay;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_PriorHour;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_PriorMinute;
                        break block0;
                    }
                    case 12: {
                        key = XQEMessageKeys.RRT_PriorSecond;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_PriorPeriod;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_PriorSeason;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_PriorHoliday;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_PriorSemester;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_PriorTrimester;
                        break block0;
                    }
                }
                break;
            }
            case 9: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_NextYear;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_NextHalfYear;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_NextQuarter;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_NextMonth;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_NextWeek;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_NextDay;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_NextHour;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_NextMinute;
                        break block0;
                    }
                    case 12: {
                        key = XQEMessageKeys.RRT_NextSecond;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_NextPeriod;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_NextSeason;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_NextHoliday;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_NextSemester;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_NextTrimester;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_CurrentYearToDate;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_CurrentHalfYearToDate;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_CurrentQuarterToDate;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_CurrentMonthToDate;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_CurrentWeekToDate;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_CurrentDayToDate;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_CurrentHourToDate;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_CurrentMinuteToDate;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_CurrentPeriodToDate;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_CurrentSeasonToDate;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_CurrentHolidayToDate;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_CurrentSemesterToDate;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_CurrentTrimesterToDate;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                switch (levelType) {
                    case 5: {
                        key = XQEMessageKeys.RRT_HalfYearToDate;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_QuarterToDate;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_MonthToDate;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_WeekToDate;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_DayToDate;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_HourToDate;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_MinuteToDate;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_PeriodToDate;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_SeasonToDate;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_HolidayToDate;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_SemesterToDate;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_TrimesterToDate;
                        break block0;
                    }
                }
                break;
            }
            case 4: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_PriorYearToDate;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_PriorHalfYearToDate;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_PriorQuarterToDate;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_PriorMonthToDate;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_PriorWeekToDate;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_PriorDayToDate;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_PriorHourToDate;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_PriorMinuteToDate;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_PriorPeriodToDate;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_PriorSeasonToDate;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_PriorHolidayToDate;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_PriorSemesterToDate;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_PriorTrimesterToDate;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_YearToDateChange;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_HalfYearToDateChange;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_QuarterToDateChange;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_MonthToDateChange;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_WeekToDateChange;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_DayToDateChange;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_HourToDateChange;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_MinuteToDateChange;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_PeriodToDateChange;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_SeasonToDateChange;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_HolidayToDateChange;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_SemesterToDateChange;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_TrimesterToDateChange;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_YearToDatePercentageGrowth;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_HalfYearToDatePercentageGrowth;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_QuarterToDatePercentageGrowth;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_MonthToDatePercentageGrowth;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_WeekToDatePercentageGrowth;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_DayToDatePercentageGrowth;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_HourToDatePercentageGrowth;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_MinuteToDatePercentageGrowth;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_PeriodToDatePercentageGrowth;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_SeasonToDatePercentageGrowth;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_HolidayToDatePercentageGrowth;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_SemesterToDatePercentageGrowth;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_TrimesterToDatePercentageGrowth;
                        break block0;
                    }
                }
                break;
            }
            case 10: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_NextYearToDate;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_NextHalfYearToDate;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_NextQuarterToDate;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_NextMonthToDate;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_NextWeekToDate;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_NextDayToDate;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_NextHourToDate;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_NextMinuteToDate;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_NextPeriodToDate;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_NextSeasonToDate;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_NextHolidayToDate;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_NextSemesterToDate;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_NextTrimesterToDate;
                        break block0;
                    }
                }
                break;
            }
            case 11: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_NextYearToDateChange;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_NextHalfYearToDateChange;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_NextQuarterToDateChange;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_NextMonthToDateChange;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_NextWeekToDateChange;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_NextDayToDateChange;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_NextHourToDateChange;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_NextMinuteToDateChange;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_NextPeriodToDateChange;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_NextSeasonToDateChange;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_NextHolidayToDateChange;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_NextSemesterToDateChange;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_NextTrimesterToDateChange;
                        break block0;
                    }
                }
                break;
            }
            case 12: {
                switch (levelType) {
                    case 4: {
                        key = XQEMessageKeys.RRT_NextYearToDatePercentageGrowth;
                        break block0;
                    }
                    case 5: {
                        key = XQEMessageKeys.RRT_NextHalfYearToDatePercentageGrowth;
                        break block0;
                    }
                    case 6: {
                        key = XQEMessageKeys.RRT_NextQuarterToDatePercentageGrowth;
                        break block0;
                    }
                    case 7: {
                        key = XQEMessageKeys.RRT_NextMonthToDatePercentageGrowth;
                        break block0;
                    }
                    case 8: {
                        key = XQEMessageKeys.RRT_NextWeekToDatePercentageGrowth;
                        break block0;
                    }
                    case 9: {
                        key = XQEMessageKeys.RRT_NextDayToDatePercentageGrowth;
                        break block0;
                    }
                    case 10: {
                        key = XQEMessageKeys.RRT_NextHourToDatePercentageGrowth;
                        break block0;
                    }
                    case 11: {
                        key = XQEMessageKeys.RRT_NextMinuteToDatePercentageGrowth;
                        break block0;
                    }
                    case 13: {
                        key = XQEMessageKeys.RRT_NextPeriodToDatePercentageGrowth;
                        break block0;
                    }
                    case 14: {
                        key = XQEMessageKeys.RRT_NextSeasonToDatePercentageGrowth;
                        break block0;
                    }
                    case 15: {
                        key = XQEMessageKeys.RRT_NextHolidayToDatePercentageGrowth;
                        break block0;
                    }
                    case 16: {
                        key = XQEMessageKeys.RRT_NextSemesterToDatePercentageGrowth;
                        break block0;
                    }
                    case 17: {
                        key = XQEMessageKeys.RRT_NextTrimesterToDatePercentageGrowth;
                        break block0;
                    }
                }
                break;
            }
        }
        String memberCaption = refMemberCaption;
        if (key != null) {
            memberCaption = XQEMessages.getMessage(key, locale, memberCaption);
        }
        return memberCaption;
    }

    public static String getMemberCaption(int memberType, String levelCaption, int levelType, String refMemberCaption, String locale) {
        return ROLAPRelativeTimeMember.getMemberCaption(memberType, levelCaption, levelType, refMemberCaption, LocaleConverter.strToLocale(locale));
    }

    public static String getMemberCaption(int memberType, ILevel level, IMember refMember, String locale) {
        return ROLAPRelativeTimeMember.getMemberCaption(memberType, level.getCaption(), ((IROLAPLevel)level).getType(), refMember.getCaption(), locale);
    }

    @Override
    public Object getBusinessKey() {
        if (this.isExtendedCalculatedMemberWithFormula()) {
            return null;
        }
        if (this.referenceMember != null) {
            return this.referenceMember.getBusinessKey();
        }
        return null;
    }

    @Override
    public String getDescription() {
        if (this.isExtendedCalculatedMemberWithFormula()) {
            return null;
        }
        if (this.referenceMember != null) {
            return this.referenceMember.getDescription();
        }
        return null;
    }

    @Override
    public List<IMember> getAllChildren(String cubeName) throws MetadataException, ProviderException {
        boolean isPeriodToDateMember;
        List<IMember> list = this.getChildren();
        boolean bl = isPeriodToDateMember = this.relaTimeMemberType == 3 || this.relaTimeMemberType == 4 || this.relaTimeMemberType == 8 || this.relaTimeMemberType == 10 || this.relaTimeMemberType == 14 || this.relaTimeMemberType == 15;
        if (isPeriodToDateMember) {
            List<ROLAPCalculatedMember> calcs = this.getROLAPHierarchy().getROLAPCalculatedMembers(cubeName);
            for (ROLAPCalculatedMember calc : calcs) {
                if (calc.getParent() != this || !calc.isExtendedCalculatedMember()) continue;
                ROLAPRelativeTimeMember rtMember = (ROLAPRelativeTimeMember)calc;
                if (rtMember.relaTimeMemberType != 8) continue;
                list.add(calc);
                break;
            }
        }
        return list;
    }

    @Override
    public void addChildMember(IMember child) {
        if (this.gotAllChildren) {
            this.children.put(child);
        }
    }

    public String getMdxExpression() {
        return this.mdxExpression;
    }

    public String getOptimzedMdxExpression() {
        return this.optimizedMdxExpression;
    }

    public IMember getReferenceMember() {
        return this.referenceMember;
    }

    public void generateRollingTotalRuntreeNode(List<IMember> rollingPeriodsMembers) {
        ROLAPAbstractHierarchy hierarchy = (ROLAPAbstractHierarchy)this.getHierarchy();
        String measureUniqueName = DUMMY_MEASURES;
        IHierarchy measuresHierarchy = this.getDimension().getCube().getMeasuresHierarchy();
        if (measuresHierarchy != null) {
            measureUniqueName = measuresHierarchy.getUniqueName();
        }
        StringBuilder rollingPeriodsSetStr = new StringBuilder();
        for (IMember rollingPeriodsMember : rollingPeriodsMembers) {
            if (rollingPeriodsSetStr.length() > 0) {
                rollingPeriodsSetStr.append(COMMA);
            }
            rollingPeriodsSetStr.append(rollingPeriodsMember.getUniqueName());
        }
        String mdx = "AGGREGATE({" + rollingPeriodsSetStr + RIGHT_BRACE + COMMA + measureUniqueName + DOT + CURRENTMEMBER_FUNCTION_NAME + RIGHT_PARENTHESIS;
        XMdxCalculatedMember calcMemberRunTreeNode = this.generateXMdxCalculatedMember(mdx, (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment());
        this.optimizedMdxExpression = mdx;
        this.optimizedRuntree = calcMemberRunTreeNode;
        this.mdxExpression = mdx;
        this.runtree = calcMemberRunTreeNode;
    }

    public void generateLTDRuntreeNode(IMember refMember, IMember member, IMember[] siblings) {
        if (this.relaTimeMemberType != 14) {
            return;
        }
        this.mdxExpression = this.generateLtdMdxExpression(refMember, member, siblings, true);
        this.runtree = this.generateXMdxCalculatedMember(this.mdxExpression, (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment());
        this.optimizedMdxExpression = this.generateLtdMdxExpression(refMember, member, siblings, false);
        this.optimizedRuntree = this.generateXMdxCalculatedMember(this.mdxExpression, (RequestEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment());
    }

    private String generateLtdMdxExpression(IMember refMember, IMember member, IMember[] siblings, boolean genOptimizedExp) {
        String retMdxExp;
        ROLAPAbstractHierarchy hierarchy = (ROLAPAbstractHierarchy)this.getHierarchy();
        String measureUniqueName = DUMMY_MEASURES;
        IHierarchy measuresHierarchy = this.getDimension().getCube().getMeasuresHierarchy();
        if (measuresHierarchy != null) {
            measureUniqueName = measuresHierarchy.getUniqueName();
        }
        StringBuilder prevMembersSetStr = new StringBuilder();
        for (IMember mem : siblings) {
            if (mem == refMember) break;
            if (prevMembersSetStr.length() > 0) {
                prevMembersSetStr.append(COMMA);
            }
            prevMembersSetStr.append(mem.getUniqueName());
        }
        if (genOptimizedExp) {
            List<IMember> ptdOptimalSet = hierarchy.getOptimalPeriodsToDateMembers(refMember.getLevel(), member);
            StringBuilder ptdOptimalSetStr = new StringBuilder();
            for (IMember ptdSetMember : ptdOptimalSet) {
                if (ptdOptimalSetStr.length() > 0) {
                    ptdOptimalSetStr.append(COMMA);
                }
                ptdOptimalSetStr.append(ptdSetMember.getUniqueName());
            }
            StringBuilder setStr = prevMembersSetStr;
            if (prevMembersSetStr.length() > 0) {
                if (ptdOptimalSetStr.length() > 0) {
                    setStr.append(COMMA);
                    setStr.append((CharSequence)ptdOptimalSetStr);
                }
            } else {
                setStr = ptdOptimalSetStr;
            }
            retMdxExp = "AGGREGATE({" + setStr + RIGHT_BRACE + COMMA + measureUniqueName + DOT + CURRENTMEMBER_FUNCTION_NAME + RIGHT_PARENTHESIS;
        } else {
            retMdxExp = "AGGREGATE(";
            if (prevMembersSetStr.length() > 0) {
                retMdxExp = retMdxExp + "UNION( SET( " + prevMembersSetStr + RIGHT_PARENTHESIS + COMMA;
            }
            retMdxExp = retMdxExp + "PERIODSTODATE(" + refMember.getLevel().getUniqueName() + COMMA + member.getUniqueName() + RIGHT_PARENTHESIS;
            if (prevMembersSetStr.length() > 0) {
                retMdxExp = retMdxExp + RIGHT_PARENTHESIS;
            }
            retMdxExp = retMdxExp + COMMA + measureUniqueName + DOT + CURRENTMEMBER_FUNCTION_NAME + RIGHT_PARENTHESIS;
        }
        return retMdxExp;
    }

    @Override
    public void setSolveOrder(int solveOrd) {
        if (this.relaTimeMemberType == 6 || this.relaTimeMemberType == 5 || this.relaTimeMemberType == 12 || this.relaTimeMemberType == 11) {
            super.setSolveOrder(SolveOrderUtil.getRelativeTimePTDChangeOrGrowthSolveOrder());
        } else {
            super.setSolveOrder(-1);
        }
    }

    public boolean isAddPeriodToDateLastChildEnabled() {
        return ROLAPCubeManager.getInstance().getConfig().isAddPeriodToDateLastChildEnabled();
    }

    public boolean isCustomRollingTotalMember() {
        return this.relaTimeMemberType == 15;
    }
}

