/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.mfw4j.utilities.IMFWCMRequestExecutor;
import com.cognos.pogo.bibus.SoapFaultException;
import com.cognos.pogo.contentmanager.CMClass;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.bibushandler.content.CMException;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeNameWrapper;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.context.Context;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Element;

public class ROLAPAccessAccountManager
implements IMFWCMRequestExecutor {
    private static final boolean ACCT_MANAGER_DEBUG_MODE;
    private static final String DATASOURCEACCESSACCOUNT_PROPERTY = "dataSourceAccessAccount";
    private static final String CAMPASSPORT_ELEMENT_NAME = "CAMPassport";
    private static final String ID_ELEMENT_NAME = "id";
    private static final String ITEM_ELEMENT_NAME = "item";
    private static final String SEARCHPATH_ELEMENT_NAME = "searchPath";
    private static final String CREDENTIAL_STEP = "/credential";
    protected static final String CAM_ELEMENT_NAME = "CAM";
    protected static final String ACTION_ELEMENT_NAME = "action";
    public static final String ANONYMOUS_CAMID = "CAMID(\"::Anonymous\")";
    public static final String CAMCREDENTIALPATH_ELEMENT_NAME = "CAMCredentialPath";
    protected static final String SEARCH_PATH = "~";
    protected static final String APOS = "'";
    protected Element validBiBusHeader;
    protected BIBusEnvelope validBIBusEnvelope;
    private String mCubeName;
    private String mDataSourcePath;
    private String mCAMPassport;

    public ROLAPAccessAccountManager(String cubeName, String dataSourcePath) {
        this.mCubeName = cubeName;
        this.mDataSourcePath = dataSourcePath;
    }

    public ROLAPAccessAccountManager(ROLAPAccessAccountManager accountManager) {
        this.mCubeName = accountManager.mCubeName;
        this.mDataSourcePath = accountManager.mDataSourcePath;
    }

    public synchronized void setUpBiBusEnvelope(boolean setUp) {
        Element id;
        Element camPassportElem;
        Element camElem;
        if (setUp || this.validBIBusEnvelope == null) {
            String accessAccount = null;
            try {
                ROLAPLog.log("ROLAPCubes.Management", String.format("Signing into the access account for cube '%s'", this.mCubeName));
                accessAccount = this.getDataSourceAccessAccount();
                this.validBIBusEnvelope = ContentManager.logonToAccessAccount(accessAccount);
                this.validBiBusHeader = this.validBIBusEnvelope.getBIBusHeader().createCopy();
            }
            catch (CMException e) {
                String details = null;
                Throwable cause = e.getCause();
                details = cause instanceof SoapFaultException ? ((SoapFaultException)cause).getDetail() : cause.getMessage();
                ROLAPLog.logError("ROLAPCubes.Management", "Error logging into access account '" + accessAccount + "', error details: '" + details + APOS);
                if (accessAccount == null || accessAccount.isEmpty()) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_AccessAccountNotSpecified, (Throwable)e, (Object)new ROLAPCubeNameWrapper(this.mCubeName));
                }
                if (details != null && details.contains("CM-HDR-4012") && details.contains(CREDENTIAL_STEP)) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_UserCredentialNotStored, (Throwable)e, (Object)new ROLAPCubeNameWrapper(this.mCubeName));
                }
                throw new XQERuntimeException(XQEMessageKeys.ROL_UnableToLogonToAccessAccount, (Throwable)e, (Object)new ROLAPCubeNameWrapper(this.mCubeName));
            }
        }
        if (null != (camElem = this.validBiBusHeader.element(CAM_ELEMENT_NAME)) && null != (camPassportElem = camElem.element(CAMPASSPORT_ELEMENT_NAME)) && null != (id = camPassportElem.element(ID_ELEMENT_NAME))) {
            this.mCAMPassport = id.getText();
        }
    }

    private String getDataSourceAccessAccount() {
        String account = null;
        try {
            Element item;
            Element dsAccessAccount;
            CMClass cls;
            List<CMClass> resultList = ContentManager.getProperties(this.mDataSourcePath, DATASOURCEACCESSACCOUNT_PROPERTY);
            Iterator<CMClass> it = resultList.iterator();
            if (it.hasNext() && ((cls = it.next()).getCMClassName().equals("cm:rolapDataSource") || cls.getCMClassName().equals("cm:rolapVirtualDataSource")) && (dsAccessAccount = (item = cls.getItemElement()).element(DATASOURCEACCESSACCOUNT_PROPERTY)).hasContent() && ANONYMOUS_CAMID.equals(account = dsAccessAccount.element("value").element(ITEM_ELEMENT_NAME).element(SEARCHPATH_ELEMENT_NAME).element("value").getText())) {
                account = null;
            }
        }
        catch (CMException ce) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_UnableToRetrieveAccessAccount, ce.getCause(), (Object)new ROLAPCubeNameWrapper(this.mCubeName));
        }
        return account;
    }

    public synchronized void logoffAccessAccount() {
        if (this.validBiBusHeader != null) {
            try {
                ContentManager.logOffAccessAccount(this.validBiBusHeader);
            }
            catch (CMException e) {
                ROLAPLog.logError("ROLAPCubes.Security", "Failed to logoff access account.", e.getCause());
            }
            finally {
                this.validBiBusHeader = null;
                this.validBIBusEnvelope = null;
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void execute(Runnable operations) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public BIBusEnvelope getEnvelope() {
        AccessAccountContext.checkCallingFromAcctManager(this.mCubeName);
        this.setUpBiBusEnvelope(false);
        return this.validBIBusEnvelope;
    }

    public Element getHeader() {
        ROLAPContext.setRelQueryExecuting();
        AccessAccountContext.checkCallingFromAcctManager(this.mCubeName);
        this.setUpBiBusEnvelope(false);
        return (Element)this.validBiBusHeader.clone();
    }

    public String getPassport() {
        AccessAccountContext.checkCallingFromAcctManager(this.mCubeName);
        this.setUpBiBusEnvelope(false);
        return this.mCAMPassport;
    }

    public void setPassport(String passport) {
        this.mCAMPassport = passport;
    }

    static {
        boolean bl = ACCT_MANAGER_DEBUG_MODE = System.getProperty("acctManagerDebugMode") != null;
        if (ACCT_MANAGER_DEBUG_MODE) {
            XQEDebugLog.err.println("Running in Account Manager Debug Mode");
        }
    }

    static class AccessAccountContext
    extends Context {
        private String mName;

        AccessAccountContext(String cubeName) {
            this.mName = cubeName;
        }

        @Override
        protected boolean isTransferable() {
            return false;
        }

        @Override
        protected Context transferableClone() throws UnsupportedOperationException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void onEnter() {
        }

        @Override
        protected void onExit() {
        }

        public static AccessAccountContext enter(String name) {
            AccessAccountContext ctx = new AccessAccountContext(name);
            Context.enter(ctx);
            return ctx;
        }

        public static AccessAccountContext exit() {
            return (AccessAccountContext)Context.exit(AccessAccountContext.class);
        }

        public static void checkCallingFromAcctManager(String name) {
            AccessAccountContext context = AccessAccountContext.getCurrent(AccessAccountContext.class);
            if (context == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Using access account for cube " + name + " requires that we use an encompassing " + AccessAccountContext.class.getSimpleName() + ".execute() call so that we could re-log in and retry the operation if the passport has expired or have become invalid due to CM failover.");
            }
            if (context.getName() == null || !context.getName().equals(name)) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Account context name '" + context.getName() + "' does not match expected name '" + name + ROLAPAccessAccountManager.APOS);
            }
        }

        private String getName() {
            return this.mName;
        }
    }

    private static class SimulatedLogonException
    extends RuntimeException {
        private SimulatedLogonException() {
        }
    }
}

