/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeAction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheManager;
import com.cognos.xqe.trace.TraceContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;

public class ROLAPCacheUpdater {
    private boolean mNewCacheLockAcquired;
    private boolean mStateLockAcquired;
    private boolean mCurrentCacheLockAcquired;
    private ROLAPCacheBase mCache;
    private ROLAPCube mCube;
    private LinkedList<ROLAPCacheUpdater> mDependentStates = new LinkedList();
    private LinkedList<ROLAPCacheUpdater> mReverseDependentStates = new LinkedList();
    private IROLAPCacheProcessor mProcessor;
    private boolean mUseCube;
    private boolean mUseInstance;
    private ROLAPCubeAction mCubeAction;
    private ROLAPCubeReservation mReservation;
    private ArrayList<ROLAPCubeReservation> mMissingLeafReservations;

    ROLAPCacheUpdater(ROLAPCube cube, IROLAPCacheProcessor processor, ROLAPCubeAction cubeAction) {
        this.mCube = cube;
        this.mProcessor = processor;
        this.mUseCube = true;
        this.mCubeAction = cubeAction;
        this.mUseInstance = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void synchronizeUpdate(ROLAPCube cube, IROLAPCacheProcessor processor, ROLAPCubeAction cubeAction) {
        QueryEnvironmentHelper envHelper = cube.setUpExecutionEnvironment(true, true);
        try {
            ROLAPCacheUpdater updater = new ROLAPCacheUpdater(cube, processor, cubeAction);
            updater.synchronizeUpdate();
        }
        finally {
            envHelper.tearDownEnvironment();
        }
    }

    private void synchronizeUpdate() {
        RuntimeException exception = null;
        try {
            AtomicLong waitTime = new AtomicLong(ROLAPCubeManager.setUpAdminWait());
            this.acquireNewCacheLock(new HashMap<ROLAPCube, ROLAPCacheUpdater>(), false, waitTime);
            if (!this.mCube.isRunning()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CubeNotRunning, this.mCube.getName());
            }
            this.waitForCacheCreationPermission(waitTime);
            this.buildCache();
            try {
                this.acquireCurrentCacheLock(waitTime);
                this.replaceCurrentCache();
            }
            finally {
                this.releaseCurrentCacheLock();
            }
            this.releaseNewCacheLock(exception);
        }
        catch (Throwable ex) {
            try {
                exception = XQERuntimeException.wrap(ex);
                throw (XQERuntimeException)exception;
            }
            catch (Throwable throwable) {
                this.releaseNewCacheLock(exception);
                throw throwable;
            }
        }
        this.postUpdateActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireNewCacheLock(HashMap<ROLAPCube, ROLAPCacheUpdater> latestUpdaterInstances, boolean dependent, AtomicLong waitTime) {
        boolean cubeSeenFirstTime = false;
        if (!dependent) {
            this.mCube.getMessages().addMessage(this.mProcessor.getStartMessage());
        }
        TreeMap<String, ROLAPCube> sortedDependents = new TreeMap<String, ROLAPCube>();
        for (ROLAPCube rOLAPCube : this.mCube.getDependentCubes()) {
            sortedDependents.put(rOLAPCube.getName(), rOLAPCube);
        }
        ROLAPCacheUpdater prevInstance = latestUpdaterInstances.get(this.mCube);
        if (prevInstance == null) {
            cubeSeenFirstTime = true;
        } else {
            prevInstance.setUseInstance(false);
        }
        latestUpdaterInstances.put(this.mCube, this);
        for (String cubeName : sortedDependents.keySet()) {
            ROLAPCube cube = (ROLAPCube)sortedDependents.get(cubeName);
            ROLAPCacheUpdater depState = new ROLAPCacheUpdater(cube, this.mProcessor, this.mCubeAction);
            this.mDependentStates.addLast(depState);
            this.mReverseDependentStates.addFirst(depState);
            depState.acquireNewCacheLock(latestUpdaterInstances, true, waitTime);
        }
        this.mCube.acquireStateLock();
        this.mStateLockAcquired = true;
        if (dependent) {
            if (this.mCube.isRunning()) {
                if (cubeSeenFirstTime) {
                    TraceContext traceContext = TraceContext.enter();
                    traceContext.addAttribute("rolapCube", this.mCube.getName());
                    try {
                        this.mCube.getMessages().addMessage(this.mProcessor.getIndirectStartMessage(), this.mProcessor.getCube().getName());
                    }
                    finally {
                        traceContext.exit();
                    }
                }
                this.mCube.acquireNewCacheLock(waitTime);
                this.mNewCacheLockAcquired = true;
            } else {
                this.mUseCube = false;
            }
        } else {
            this.mCube.acquireNewCacheLock(waitTime);
            this.mNewCacheLockAcquired = true;
        }
    }

    private void waitForCacheCreationPermission(AtomicLong waitTime) {
        if (this.useInstance()) {
            this.mCube.waitUntilNewCacheCanBeCreated(this.mProcessor.getCacheManager(this.mCube), waitTime);
        }
        for (ROLAPCacheUpdater depState : this.mDependentStates) {
            if (!depState.useCube()) continue;
            depState.waitForCacheCreationPermission(waitTime);
        }
    }

    private void buildCache() {
        if (this.useInstance()) {
            this.mCache = this.mProcessor.buildCache(this);
        }
        for (ROLAPCacheUpdater depState : this.mDependentStates) {
            if (!depState.useCube()) continue;
            depState.buildCache();
        }
    }

    private void releaseNewCacheLock(Throwable ex) {
        if (ex != null && this.useInstance()) {
            TraceContext traceContext = TraceContext.enter();
            traceContext.addAttribute("rolapCube", this.mCube.getName());
            try {
                this.mCube.getMessages().addMessage(this.mProcessor.getFailedMessage(), ex);
            }
            finally {
                traceContext.exit();
            }
        }
        if (this.mNewCacheLockAcquired) {
            this.mCube.releaseNewCacheLock();
            this.mNewCacheLockAcquired = false;
        }
        if (this.mStateLockAcquired) {
            this.mCube.releaseStateLock();
            this.mStateLockAcquired = false;
        }
        for (ROLAPCacheUpdater depState : this.mReverseDependentStates) {
            depState.releaseNewCacheLock(ex);
        }
    }

    private void acquireCurrentCacheLock(AtomicLong waitTime) {
        for (ROLAPCacheUpdater depState : this.mDependentStates) {
            if (!depState.useCube()) continue;
            depState.acquireCurrentCacheLock(waitTime);
        }
        this.mCube.acquireCurrentCacheLock(waitTime);
        this.mCurrentCacheLockAcquired = true;
    }

    private void replaceCurrentCache() {
        if (this.useInstance()) {
            this.mProcessor.setCurrentCache(this, this.mCache);
            TraceContext traceContext = TraceContext.enter();
            traceContext.addAttribute("rolapCube", this.mCube.getName());
            try {
                this.mCube.getMessages().addMessage(this.mProcessor.getSuccessMessage());
            }
            finally {
                traceContext.exit();
            }
        }
        for (ROLAPCacheUpdater depState : this.mDependentStates) {
            if (!depState.useCube()) continue;
            depState.replaceCurrentCache();
        }
    }

    private void releaseCurrentCacheLock() {
        if (this.mCurrentCacheLockAcquired) {
            this.mCube.releaseCurrentCacheLock();
            this.mCurrentCacheLockAcquired = false;
        }
        for (ROLAPCacheUpdater depState : this.mReverseDependentStates) {
            if (!depState.useCube()) continue;
            depState.releaseCurrentCacheLock();
        }
    }

    private void postUpdateActions() {
        if (this.useInstance()) {
            this.mProcessor.postUpdateActions(this.mCube);
        }
        for (ROLAPCacheUpdater depState : this.mDependentStates) {
            if (!depState.useCube()) continue;
            depState.postUpdateActions();
        }
    }

    private boolean useCube() {
        return this.mUseCube;
    }

    private void setUseInstance(boolean useInstance) {
        this.mUseInstance = useInstance;
    }

    private boolean useInstance() {
        return this.mUseInstance;
    }

    public void setReservation(ROLAPCubeReservation res) {
        this.mReservation = res;
    }

    public ROLAPCubeReservation getReservation() {
        return this.mReservation;
    }

    public ROLAPCube getCube() {
        return this.mCube;
    }

    public ROLAPCubeAction getCubeAction() {
        return this.mCubeAction;
    }

    public ArrayList<ROLAPCubeReservation> getMissingLeafReservations() {
        return this.mMissingLeafReservations;
    }

    public void setMissingLeafReservations(ArrayList<ROLAPCubeReservation> missingRes) {
        this.mMissingLeafReservations = missingRes;
    }

    public static interface IROLAPCacheProcessor {
        public ROLAPCacheBase buildCache(ROLAPCacheUpdater var1);

        public void setCurrentCache(ROLAPCacheUpdater var1, ROLAPCacheBase var2);

        public ROLAPCacheManager<?> getCacheManager(ROLAPCube var1);

        public void postUpdateActions(ROLAPCube var1);

        public ROLAPCube getCube();

        public IMessageKey.Param0 getSuccessMessage();

        public IMessageKey.Param0 getFailedMessage();

        public IMessageKey.Param0 getStartMessage();

        public IMessageKey.Param1 getIndirectStartMessage();
    }
}

