/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.cclcfgapi.CCLConfigurationException;
import com.cognos.cclcfgapi.ICCLConfiguration;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationFactory;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfigurationDefaultProperties;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMessages;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.configuration.ConversionException;
import org.dom4j.Element;

public final class ROLAPConfiguration {
    private static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPCubes.Management");
    private static final String PARSING_ERROR = "Error parsing configuration setting ";
    private static final String LOG_MSG_PARAMETER_IS_IGNORED = "The request to set the parameter \"%s\" to the value \"%s\" is being ignored ";
    public static final String LOG_MSG_SERVER_PARAMETER_IS_IGNORED = "The request to set the parameter \"%s\" to the value \"%s\" is being ignored because the parameter is specified in xqe.rolap.dev.config.xml.";
    private static final String LOG_MSG_CUBE_PARAMETER_IS_IGNORED = "The request to set the parameter \"%s\" to the value \"%s\" is being ignored because the parameter is specified for the cube \"%s\" in xqe.rolap.dev.config.xml.";
    private static final String ROLAP = "Rolap";
    public static final String DEV_CONFIG_FILE = "/xqe.rolap.dev.config.xml";
    public static final int DEFAULT_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT = 0;
    public static final int DEFAULT_INITIAL_JVM_HEAP_SIZE = 1024;
    public static final int DEFAULT_MAX_JVM_HEAP_SIZE = 1024;
    public static final int DEFAULT_ADMIN_COMMAND_TIMEOUT = 120;
    public static final String DEFAULT_ADDITIONAL_JVM_ARGS = "";
    public static final String DEFAULT_CUBE_CONFIGURATIONS = "<crn:value xmlns:crn=\"http://developer.cognos.com/schemas/crconfig/1/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:type=\"SOAP-ENC:Array\"><value xsi:type=\"SOAP-ENC:Array\" xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" SOAP-ENC:arrayType=\"cm:baseROLAPCubeConfiguration[0]\"/></crn:value>";
    public static final String DEFAULT_MEMBER_CACHE_FOLDER = "";
    private static final int DEFAULT_IO_BUFFER_SIZE = 32768;
    public static final int DEFAULT_RESULT_SET_CACHE_QUERY_TIME_THRESHOLD = 50;
    public static final int MIN_RESULT_SET_CACHE_QUERY_TIME_THRESHOLD = 0;
    public static final int MAX_RESULT_SET_CACHE_QUERY_TIME_THRESHOLD = 1000;
    public static final String MEMBER_CACHE_FOLDER_STATIC_LOCATION = File.separator + "MemberStorage" + File.separator + "Rolap";
    public static final String RESULT_SET_CACHE_FOLDER_STATIC_LOCATION = File.separator + "ResultSetStorage" + File.separator + "Rolap";
    private boolean manualCubeStart = false;
    private int multiDimensionalQuerySizeLimit = 0;
    private int initialJVMHeapSize = 1024;
    private int maxJVMHeapSize = 1024;
    private String additionalJVMArgs = "";
    private String memberCacheFolder = "";
    private int adminCommandTimeout = 120;
    private int resultSetCacheQueryTimeThreshold = 50;
    private boolean resultSetCacheEncrypted = false;
    private final HashMap<String, ROLAPCubeConfiguration> cubeConfigurations = new HashMap();
    private final Map<String, String> localServerParameterMap = new HashMap<String, String>();
    private final Map<String, Map<String, String>> localCubeParameterMaps = new HashMap<String, Map<String, String>>();
    private Set<String> cubesConfiguredInCM = new HashSet<String>();
    private static final String NAMESPACE = "";
    public static final String ROLAP_BASE_CUBE_TYPE = "rolapCubeConfiguration";
    public static final String ROLAP_VIRTUAL_CUBE_TYPE = "rolapVirtualCubeConfiguration";
    public static final QName ROLAP_CONFIG_QNAME = new QName("", "rolapConfig");
    public static final QName MANUAL_CUBE_START_QNAME = new QName("", "qsManualCubeStart");
    public static final QName JVM_INITIAL_HEAP_SIZE_QNAME = new QName("", "qsInitialJVMHeapSize");
    public static final QName JVM_MAX_HEAP_SIZE_QNAME = new QName("", "qsJVMHeapSizeLimit");
    public static final QName JVM_ADDITIONAL_ARGS_QNAME = new QName("", "qsAdditionalJVMArguments");
    public static final QName QS_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME = new QName("", "qsMultiDimensionalQuerySizeLimit");
    public static final QName MEMBER_CACHE_FOLDER_QNAME = new QName("", "qsROLAPMemberCacheAliasRoot");
    public static final QName ADMIN_COMMAND_TIMEOUT_QNAME = new QName("", "qsROLAPCubeAdministrationCommandTimeout");
    public static final QName CUBE_QNAME = new QName("", "cube");
    public static final QName DATASOURCE_NAME_QNAME = new QName("", "dataSourceName");
    public static final QName DATASOURCE_TYPE_QNAME = new QName("", "type");
    public static final QName DISABLED_QNAME = new QName("", "disabled");
    public static final QName VIRTUAL_QNAME = new QName("", "virtual");
    public static final QName ENABLE_DYNAMIC_MEMBER_CACHING_QNAME = new QName("", "enableDynamicMemberCaching");
    public static final QName MEMBER_CACHE_LIMIT_QNAME = new QName("", "memberCacheLimit");
    public static final QName STARTUP_TRIGGER_NAME_QNAME = new QName("", "startupTriggerName");
    public static final QName DISABLE_RESULT_SET_CACHE_QNAME = new QName("", "disableResultSetCache");
    public static final QName RESULT_SET_CACHE_FOLDER_QNAME = new QName("", "resultSetCacheFolder");
    public static final QName RESULT_SET_CACHE_SIZE_LIMIT_QNAME = new QName("", "resultSetCacheSizeLimit");
    public static final QName RESULT_SET_CACHE_QUERY_TIME_THRESHOLD_QNAME = new QName("", "qsResultSetCacheQueryTimeThreshold");
    public static final QName RESULT_SET_CACHE_ENCRYPTED_QNAME = new QName("", "resultSetCacheEncrypted");
    public static final QName PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME = new QName("", "predicateMemberReferenceThreshold");
    public static final QName DATA_CACHE_SIZE_LIMIT_QNAME = new QName("", "dataCacheSizeLimit");
    public static final QName AGGREGATE_CACHE_SIZE_LIMIT_QNAME = new QName("", "aggregateCacheSize");
    public static final QName AGGREGATE_LOGGING_ENABLED_QNAME = new QName("", "aggregateLoggingEnabled");
    public static final QName MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME = new QName("", "multiDimensionalQuerySizeLimit");
    public static final QName DISABLE_EXTERNAL_AGGREGATES_QNAME = new QName("", "disableExternalAggregates");
    public static final QName MAX_HIERARCHY_LOAD_THREADS_QNAME = new QName("", "maxHierarchyLoadThreads");
    public static final QName MAX_AGGREGATE_LOAD_THREADS_QNAME = new QName("", "maxAggregateLoadThreads");
    public static final QName MEASURES_THRESHOLD_QNAME = new QName("", "measuresThreshold");
    public static final QName AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME = new QName("", "automaticAggregateOptimizationEnabled");
    public static final QName POST_IN_MEMORY_TRIGGER_NAME_QNAME = new QName("", "postInMemoryTriggerName");
    private final XQEConfiguration configuration;
    private static final String[] UNSUPPORTED_ADV_PROPERTIES = new String[]{"qsMaxCubeLoadThreads", "qsMaxAggregateLoadThreads", "qsMeasuresThreshold"};

    public ROLAPConfiguration() {
        try {
            ICCLConfiguration config = XQECCLConfigurationFactory.getInstance();
            config.init();
            String value = config.getValue("encryptTemporaryFiles", false);
            if ("true".equals(value)) {
                this.resultSetCacheEncrypted = true;
            }
        }
        catch (CCLConfigurationException ex) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL, (Throwable)ex);
        }
        this.configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
    }

    protected void setManualCubeStart(boolean manual) {
        this.manualCubeStart = manual;
    }

    protected void setMultiDimensionalQuerySizeLimit(int size) {
        if (size < 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, QS_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getLocalPart(), Integer.toString(size));
        }
        this.multiDimensionalQuerySizeLimit = size;
    }

    protected void setInitialJVMHeapSize(int size) {
        if (size <= 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, JVM_INITIAL_HEAP_SIZE_QNAME.getLocalPart(), Integer.toString(size));
        }
        this.initialJVMHeapSize = size;
    }

    protected void setMaxJVMHeapSize(int size) {
        if (size <= 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, JVM_MAX_HEAP_SIZE_QNAME.getLocalPart(), Integer.toString(size));
        }
        this.maxJVMHeapSize = size;
    }

    protected void setAdditionalJVMArgs(String args) {
        this.additionalJVMArgs = args;
    }

    public void setMemberCacheFolder(String aliasRootName) {
    }

    public void setAdminCommandTimeout(int timeout) {
        if (timeout < 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, ADMIN_COMMAND_TIMEOUT_QNAME.getLocalPart(), Integer.toString(timeout));
        }
        this.adminCommandTimeout = timeout;
    }

    public void addCubeConfiguration(ROLAPCubeConfiguration cubeConfiguration) {
        this.cubeConfigurations.put(cubeConfiguration.getName(), cubeConfiguration);
        cubeConfiguration.setServerConfiguration(this);
    }

    public void removeCubeConfiguration(String cubeName) {
        this.cubeConfigurations.remove(cubeName);
    }

    private ArrayList<Properties> parseCubeConfigurations(String config) {
        XMLStreamReader reader = null;
        ArrayList<Properties> configList = new ArrayList<Properties>();
        try {
            reader = StaxUtil.createXMLStreamReader(config);
            StaxUtil.moveToElement(reader);
            boolean parsingParam = false;
            QName lastParam = null;
            int event = reader.next();
            while (event != 8) {
                block4 : switch (event) {
                    case 1: {
                        QName qName = reader.getName();
                        if (qName.getLocalPart().equals("item") || qName.getLocalPart().equals("value")) {
                            for (int i = 0; i < reader.getAttributeCount(); ++i) {
                                String attrValue;
                                if (!reader.getAttributeName(i).getLocalPart().equals(DATASOURCE_TYPE_QNAME.getLocalPart()) || !(attrValue = reader.getAttributeValue(i)).endsWith(ROLAP_BASE_CUBE_TYPE) && !attrValue.endsWith(ROLAP_VIRTUAL_CUBE_TYPE)) continue;
                                Properties props = new Properties();
                                props.put(DATASOURCE_TYPE_QNAME, attrValue);
                                configList.add(props);
                                parsingParam = false;
                                break block4;
                            }
                            break;
                        }
                        if (!qName.equals(DATA_CACHE_SIZE_LIMIT_QNAME) && !qName.equals(AGGREGATE_CACHE_SIZE_LIMIT_QNAME) && !qName.equals(AGGREGATE_LOGGING_ENABLED_QNAME) && !qName.equals(MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME) && !qName.equals(DATASOURCE_NAME_QNAME) && !qName.equals(DISABLED_QNAME) && !qName.equals(DISABLE_EXTERNAL_AGGREGATES_QNAME) && !qName.equals(DISABLE_RESULT_SET_CACHE_QNAME) && !qName.equals(RESULT_SET_CACHE_SIZE_LIMIT_QNAME) && !qName.equals(PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME) && !qName.equals(STARTUP_TRIGGER_NAME_QNAME) && !qName.equals(ENABLE_DYNAMIC_MEMBER_CACHING_QNAME) && !qName.equals(MAX_HIERARCHY_LOAD_THREADS_QNAME) && !qName.equals(MAX_AGGREGATE_LOAD_THREADS_QNAME) && !qName.equals(MEASURES_THRESHOLD_QNAME) && !qName.equals(AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME) && !qName.equals(POST_IN_MEMORY_TRIGGER_NAME_QNAME) && !qName.equals(MEMBER_CACHE_LIMIT_QNAME)) break;
                        configList.get(configList.size() - 1).put(qName, "");
                        lastParam = qName;
                        parsingParam = true;
                        break;
                    }
                    case 4: {
                        if (parsingParam) {
                            StringBuilder textBuffer = new StringBuilder(reader.getText());
                            while (reader.hasNext() && reader.next() == 4) {
                                textBuffer.append(reader.getText());
                            }
                            configList.get(configList.size() - 1).put(lastParam, textBuffer.toString());
                        }
                        parsingParam = false;
                        break;
                    }
                    default: {
                        parsingParam = false;
                    }
                }
                event = reader.next();
            }
            ArrayList<Properties> arrayList = configList;
            return arrayList;
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void updateCubeConfigurations(String config) {
        ArrayList<Properties> configList = this.parseCubeConfigurations(config);
        this.updateCubeConfigurations(configList);
    }

    protected void updateCubeConfigurations(ArrayList<Properties> configList) {
        HashSet<String> latestCubesConfiguredInCM = new HashSet<String>();
        for (Properties props : configList) {
            boolean isVirtualCube;
            String cubeName = (String)props.get(DATASOURCE_NAME_QNAME);
            latestCubesConfiguredInCM.add(cubeName);
            String dataSourceType = (String)props.get(DATASOURCE_TYPE_QNAME);
            boolean bl = isVirtualCube = dataSourceType != null && dataSourceType.endsWith(ROLAP_VIRTUAL_CUBE_TYPE);
            if (this.isParameterSpecifiedInLocalConfigFile(cubeName, VIRTUAL_QNAME.getLocalPart())) {
                LOGGER.log(String.format(LOG_MSG_CUBE_PARAMETER_IS_IGNORED, VIRTUAL_QNAME.getLocalPart(), isVirtualCube, cubeName));
            }
            ROLAPCubeConfiguration cubeConfig = this.createCubeConfiguration(cubeName, isVirtualCube);
            Set<Object> keys = props.keySet();
            for (QName qName : keys) {
                String value = (String)props.get(qName);
                if (this.isParameterSpecifiedInLocalConfigFile(cubeName, qName.getLocalPart())) {
                    LOGGER.log(String.format(LOG_MSG_CUBE_PARAMETER_IS_IGNORED, qName.getLocalPart(), value, cubeName));
                    continue;
                }
                if (qName.equals(DATA_CACHE_SIZE_LIMIT_QNAME)) {
                    cubeConfig.setMaxDataCacheSize(Integer.parseInt(value));
                    continue;
                }
                if (qName.equals(AGGREGATE_CACHE_SIZE_LIMIT_QNAME)) {
                    cubeConfig.setMaxAggregateCacheSize(Integer.parseInt(value));
                    continue;
                }
                if (qName.equals(DISABLED_QNAME)) {
                    cubeConfig.setDisabled("true".equals(value));
                    continue;
                }
                if (qName.equals(DISABLE_EXTERNAL_AGGREGATES_QNAME)) {
                    cubeConfig.setDisableExternalAggregates("true".equals(value));
                    continue;
                }
                if (qName.equals(AGGREGATE_LOGGING_ENABLED_QNAME)) {
                    cubeConfig.setAggregateLoggingEnabled("true".equals(value));
                    continue;
                }
                if (qName.equals(DISABLE_RESULT_SET_CACHE_QNAME)) {
                    cubeConfig.setDisableResultSetCache("true".equals(value));
                    continue;
                }
                if (qName.equals(RESULT_SET_CACHE_SIZE_LIMIT_QNAME)) {
                    cubeConfig.setResultSetCacheSizeLimit(Integer.parseInt(value));
                    continue;
                }
                if (qName.equals(MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME)) {
                    cubeConfig.setMultiDimensionalQuerySizeLimit(Integer.parseInt(value));
                    continue;
                }
                if (qName.equals(PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME)) {
                    cubeConfig.setPredicateThreshold(Integer.parseInt(value));
                    continue;
                }
                if (qName.equals(STARTUP_TRIGGER_NAME_QNAME)) {
                    cubeConfig.setStartupTriggerName(value);
                    continue;
                }
                if (qName.equals(MAX_HIERARCHY_LOAD_THREADS_QNAME)) {
                    cubeConfig.setMaxHierarchyLoadThreads(Integer.parseInt(value));
                    continue;
                }
                if (qName.equals(MAX_AGGREGATE_LOAD_THREADS_QNAME)) {
                    cubeConfig.setMaxAggregateLoadThreads(Integer.parseInt(value));
                    continue;
                }
                if (qName.equals(MEASURES_THRESHOLD_QNAME)) {
                    cubeConfig.setMeasuresThreshold(Integer.parseInt(value));
                    continue;
                }
                if (qName.equals(AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME)) {
                    cubeConfig.setAutoAggrOptimization(value);
                    continue;
                }
                if (!qName.equals(POST_IN_MEMORY_TRIGGER_NAME_QNAME)) continue;
                cubeConfig.setPostInMemoryTriggerName(value);
            }
            this.addCubeConfiguration(cubeConfig);
        }
        for (String cubeConfiguredInCM : this.cubesConfiguredInCM) {
            if (latestCubesConfiguredInCM.contains(cubeConfiguredInCM)) continue;
            this.cubeConfigurations.remove(cubeConfiguredInCM);
        }
        this.cubesConfiguredInCM = latestCubesConfiguredInCM;
    }

    public boolean isParameterSpecifiedInLocalConfigFile(String parameterName) {
        return this.localServerParameterMap.get(parameterName) != null;
    }

    private boolean isParameterSpecifiedInLocalConfigFile(String cubeName, String parameterName) {
        Map<String, String> localCubeParameterMap = this.localCubeParameterMaps.get(cubeName);
        if (localCubeParameterMap == null) {
            return false;
        }
        return localCubeParameterMap.get(parameterName) != null;
    }

    public boolean isManualCubeStart() {
        return this.manualCubeStart;
    }

    public int getMultiDimensionalQuerySizeLimit() {
        return this.multiDimensionalQuerySizeLimit;
    }

    public int getInitialJVMHeapSize() {
        return this.initialJVMHeapSize;
    }

    public int getMaxJVMHeapSize() {
        return this.maxJVMHeapSize;
    }

    public String getAdditionalJVMArgs() {
        return this.additionalJVMArgs;
    }

    public String getMemberCacheFolder() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return config.getXqeTempDirectory() + MEMBER_CACHE_FOLDER_STATIC_LOCATION;
    }

    public String getResultSetCacheFolder() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return config.getXqeTempDirectory() + RESULT_SET_CACHE_FOLDER_STATIC_LOCATION;
    }

    public int getIOBufferSize() {
        return 32768;
    }

    public int getAdminCommandTimeout() {
        return this.adminCommandTimeout;
    }

    public int getActualAdminCommandTimeout() {
        if (this.adminCommandTimeout == 0) {
            return Integer.MAX_VALUE;
        }
        return this.adminCommandTimeout;
    }

    public int getResultSetCacheQueryTimeThreshold() {
        return this.resultSetCacheQueryTimeThreshold;
    }

    public void setResultSetCacheQueryTimeThreshold(int time) {
        if (time < 0 || time > 1000) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidConfigurationSetting, RESULT_SET_CACHE_QUERY_TIME_THRESHOLD_QNAME.getLocalPart(), Integer.toString(time));
        }
        this.resultSetCacheQueryTimeThreshold = time;
    }

    public boolean isResultSetCacheEncrypted() {
        return this.resultSetCacheEncrypted;
    }

    public void setResultSetCacheEncrypted(boolean encrypted) {
        this.resultSetCacheEncrypted = encrypted;
    }

    public Collection<ROLAPCubeConfiguration> getCubeConfigurations() {
        return this.cubeConfigurations.values();
    }

    public ROLAPCubeConfiguration getCubeConfiguration(String cubeName) {
        return this.cubeConfigurations.get(cubeName);
    }

    private boolean readLocalConfig() {
        XQEConfiguration xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        File devConfigFile = new File(xqeConfig.getConfigDirectory() + DEV_CONFIG_FILE);
        if (!devConfigFile.exists()) {
            return false;
        }
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(devConfigFile);
            XMLStreamReader reader = StaxUtil.createXMLStreamReader(fileStream);
            StaxUtil.moveToElement(reader);
            reader.require(1, ROLAP_CONFIG_QNAME.getNamespaceURI(), ROLAP_CONFIG_QNAME.getLocalPart());
            String manualStartVal = reader.getAttributeValue(MANUAL_CUBE_START_QNAME.getNamespaceURI(), MANUAL_CUBE_START_QNAME.getLocalPart());
            this.localServerParameterMap.put(MANUAL_CUBE_START_QNAME.getLocalPart(), manualStartVal);
            if ("true".equals(manualStartVal)) {
                this.manualCubeStart = true;
            }
            String qsMultiDimensionalQuerySizeLimitVal = reader.getAttributeValue(QS_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getNamespaceURI(), QS_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getLocalPart());
            this.localServerParameterMap.put(QS_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getLocalPart(), qsMultiDimensionalQuerySizeLimitVal);
            if (qsMultiDimensionalQuerySizeLimitVal != null) {
                this.multiDimensionalQuerySizeLimit = Integer.parseInt(qsMultiDimensionalQuerySizeLimitVal);
            }
            String initialJVMHeapSizeVal = reader.getAttributeValue(JVM_INITIAL_HEAP_SIZE_QNAME.getNamespaceURI(), JVM_INITIAL_HEAP_SIZE_QNAME.getLocalPart());
            this.localServerParameterMap.put(JVM_INITIAL_HEAP_SIZE_QNAME.getLocalPart(), initialJVMHeapSizeVal);
            if (initialJVMHeapSizeVal != null) {
                this.initialJVMHeapSize = Integer.parseInt(initialJVMHeapSizeVal);
            }
            String maxJVMHeapSizeVal = reader.getAttributeValue(JVM_MAX_HEAP_SIZE_QNAME.getNamespaceURI(), JVM_MAX_HEAP_SIZE_QNAME.getLocalPart());
            this.localServerParameterMap.put(JVM_MAX_HEAP_SIZE_QNAME.getLocalPart(), maxJVMHeapSizeVal);
            if (maxJVMHeapSizeVal != null) {
                this.maxJVMHeapSize = Integer.parseInt(maxJVMHeapSizeVal);
            }
            String additionalJVMArgsVal = reader.getAttributeValue(JVM_ADDITIONAL_ARGS_QNAME.getNamespaceURI(), JVM_ADDITIONAL_ARGS_QNAME.getLocalPart());
            this.localServerParameterMap.put(JVM_ADDITIONAL_ARGS_QNAME.getLocalPart(), additionalJVMArgsVal);
            if (additionalJVMArgsVal != null) {
                this.additionalJVMArgs = additionalJVMArgsVal;
            }
            String memberCacheFolderVal = reader.getAttributeValue(MEMBER_CACHE_FOLDER_QNAME.getNamespaceURI(), MEMBER_CACHE_FOLDER_QNAME.getLocalPart());
            this.localServerParameterMap.put(MEMBER_CACHE_FOLDER_QNAME.getLocalPart(), memberCacheFolderVal);
            if (memberCacheFolderVal != null) {
                this.memberCacheFolder = memberCacheFolderVal;
            }
            String adminCommandTimeoutVal = reader.getAttributeValue(ADMIN_COMMAND_TIMEOUT_QNAME.getNamespaceURI(), ADMIN_COMMAND_TIMEOUT_QNAME.getLocalPart());
            this.localServerParameterMap.put(ADMIN_COMMAND_TIMEOUT_QNAME.getLocalPart(), adminCommandTimeoutVal);
            if (adminCommandTimeoutVal != null) {
                this.adminCommandTimeout = Integer.parseInt(adminCommandTimeoutVal);
            }
            String resultSetCacheQueryTimeThresholdVal = reader.getAttributeValue(RESULT_SET_CACHE_QUERY_TIME_THRESHOLD_QNAME.getNamespaceURI(), RESULT_SET_CACHE_QUERY_TIME_THRESHOLD_QNAME.getLocalPart());
            this.localServerParameterMap.put(RESULT_SET_CACHE_QUERY_TIME_THRESHOLD_QNAME.getLocalPart(), resultSetCacheQueryTimeThresholdVal);
            if (resultSetCacheQueryTimeThresholdVal != null) {
                this.resultSetCacheQueryTimeThreshold = Integer.parseInt(resultSetCacheQueryTimeThresholdVal);
            }
            String resultSetCacheEncryptedVal = reader.getAttributeValue(RESULT_SET_CACHE_ENCRYPTED_QNAME.getNamespaceURI(), RESULT_SET_CACHE_ENCRYPTED_QNAME.getLocalPart());
            this.localServerParameterMap.put(RESULT_SET_CACHE_ENCRYPTED_QNAME.getLocalPart(), resultSetCacheEncryptedVal);
            if ("true".equals(resultSetCacheEncryptedVal)) {
                this.resultSetCacheEncrypted = true;
            }
            ChildElementIterator childIter = new ChildElementIterator(reader);
            while (childIter.next()) {
                reader.require(1, CUBE_QNAME.getNamespaceURI(), CUBE_QNAME.getLocalPart());
                String cubeName = reader.getAttributeValue(DATASOURCE_NAME_QNAME.getNamespaceURI(), DATASOURCE_NAME_QNAME.getLocalPart());
                HashMap<String, String> localCubeParameterMap = new HashMap<String, String>();
                this.localCubeParameterMaps.put(cubeName, localCubeParameterMap);
                localCubeParameterMap.put(DATASOURCE_NAME_QNAME.getLocalPart(), cubeName);
                String disabled = reader.getAttributeValue(DISABLED_QNAME.getNamespaceURI(), DISABLED_QNAME.getLocalPart());
                localCubeParameterMap.put(DISABLED_QNAME.getLocalPart(), disabled);
                String virtual = reader.getAttributeValue(VIRTUAL_QNAME.getNamespaceURI(), VIRTUAL_QNAME.getLocalPart());
                localCubeParameterMap.put(VIRTUAL_QNAME.getLocalPart(), virtual);
                String enableDynamicMemberCaching = reader.getAttributeValue(ENABLE_DYNAMIC_MEMBER_CACHING_QNAME.getNamespaceURI(), ENABLE_DYNAMIC_MEMBER_CACHING_QNAME.getLocalPart());
                localCubeParameterMap.put(ENABLE_DYNAMIC_MEMBER_CACHING_QNAME.getLocalPart(), enableDynamicMemberCaching);
                String memberCacheLimitVal = reader.getAttributeValue(MEMBER_CACHE_LIMIT_QNAME.getNamespaceURI(), MEMBER_CACHE_LIMIT_QNAME.getLocalPart());
                localCubeParameterMap.put(MEMBER_CACHE_LIMIT_QNAME.getLocalPart(), memberCacheLimitVal);
                String startupTriggerName = reader.getAttributeValue(STARTUP_TRIGGER_NAME_QNAME.getNamespaceURI(), STARTUP_TRIGGER_NAME_QNAME.getLocalPart());
                localCubeParameterMap.put(STARTUP_TRIGGER_NAME_QNAME.getLocalPart(), startupTriggerName);
                String disableResultSetCache = reader.getAttributeValue(DISABLE_RESULT_SET_CACHE_QNAME.getNamespaceURI(), DISABLE_RESULT_SET_CACHE_QNAME.getLocalPart());
                localCubeParameterMap.put(DISABLE_RESULT_SET_CACHE_QNAME.getLocalPart(), disableResultSetCache);
                String resultSetCacheSizeLimitVal = reader.getAttributeValue(RESULT_SET_CACHE_SIZE_LIMIT_QNAME.getNamespaceURI(), RESULT_SET_CACHE_SIZE_LIMIT_QNAME.getLocalPart());
                localCubeParameterMap.put(RESULT_SET_CACHE_SIZE_LIMIT_QNAME.getLocalPart(), resultSetCacheSizeLimitVal);
                String predicateThresholdVal = reader.getAttributeValue(PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME.getNamespaceURI(), PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME.getLocalPart());
                localCubeParameterMap.put(PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME.getLocalPart(), predicateThresholdVal);
                String disableExternalAggregates = reader.getAttributeValue(DISABLE_EXTERNAL_AGGREGATES_QNAME.getNamespaceURI(), DISABLE_EXTERNAL_AGGREGATES_QNAME.getLocalPart());
                localCubeParameterMap.put(DISABLE_EXTERNAL_AGGREGATES_QNAME.getLocalPart(), disableExternalAggregates);
                String aggregateLoggingEnabled = reader.getAttributeValue(AGGREGATE_LOGGING_ENABLED_QNAME.getNamespaceURI(), AGGREGATE_LOGGING_ENABLED_QNAME.getLocalPart());
                localCubeParameterMap.put(AGGREGATE_LOGGING_ENABLED_QNAME.getLocalPart(), aggregateLoggingEnabled);
                String multiDimensionalQuerySizeLimitVal = reader.getAttributeValue(MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getNamespaceURI(), MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getLocalPart());
                localCubeParameterMap.put(MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getLocalPart(), multiDimensionalQuerySizeLimitVal);
                String maxDataCacheSizeVal = reader.getAttributeValue(DATA_CACHE_SIZE_LIMIT_QNAME.getNamespaceURI(), DATA_CACHE_SIZE_LIMIT_QNAME.getLocalPart());
                localCubeParameterMap.put(DATA_CACHE_SIZE_LIMIT_QNAME.getLocalPart(), maxDataCacheSizeVal);
                String maxAggregateCacheSizeVal = reader.getAttributeValue(AGGREGATE_CACHE_SIZE_LIMIT_QNAME.getNamespaceURI(), AGGREGATE_CACHE_SIZE_LIMIT_QNAME.getLocalPart());
                localCubeParameterMap.put(AGGREGATE_CACHE_SIZE_LIMIT_QNAME.getLocalPart(), maxAggregateCacheSizeVal);
                String maxHierarchyLoadThreadsVal = reader.getAttributeValue(MAX_HIERARCHY_LOAD_THREADS_QNAME.getNamespaceURI(), MAX_HIERARCHY_LOAD_THREADS_QNAME.getLocalPart());
                localCubeParameterMap.put(MAX_HIERARCHY_LOAD_THREADS_QNAME.getLocalPart(), maxHierarchyLoadThreadsVal);
                String maxAggregateLoadThreadsVal = reader.getAttributeValue(MAX_AGGREGATE_LOAD_THREADS_QNAME.getNamespaceURI(), MAX_AGGREGATE_LOAD_THREADS_QNAME.getLocalPart());
                localCubeParameterMap.put(MAX_AGGREGATE_LOAD_THREADS_QNAME.getLocalPart(), maxAggregateLoadThreadsVal);
                String measuresThresholdVal = reader.getAttributeValue(MEASURES_THRESHOLD_QNAME.getNamespaceURI(), MEASURES_THRESHOLD_QNAME.getLocalPart());
                localCubeParameterMap.put(MEASURES_THRESHOLD_QNAME.getLocalPart(), measuresThresholdVal);
                String autoAggrOptimizationVal = reader.getAttributeValue(AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME.getNamespaceURI(), AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME.getLocalPart());
                localCubeParameterMap.put(AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME.getLocalPart(), autoAggrOptimizationVal);
                String postInMemoryTriggerNameVal = reader.getAttributeValue(POST_IN_MEMORY_TRIGGER_NAME_QNAME.getNamespaceURI(), POST_IN_MEMORY_TRIGGER_NAME_QNAME.getLocalPart());
                localCubeParameterMap.put(POST_IN_MEMORY_TRIGGER_NAME_QNAME.getLocalPart(), postInMemoryTriggerNameVal);
                ROLAPCubeConfiguration config = this.createCubeConfiguration(cubeName, "true".equals(virtual));
                this.addCubeConfiguration(config);
                StaxUtil.moveToEndElement(reader);
            }
            reader.require(2, ROLAP_CONFIG_QNAME.getNamespaceURI(), ROLAP_CONFIG_QNAME.getLocalPart());
        }
        catch (XQERuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new XQERuntimeException(XQEMessageKeys.CFG_FileLoadError, ex, devConfigFile.getPath());
        }
        finally {
            if (null != fileStream) {
                try {
                    ((InputStream)fileStream).close();
                    fileStream = null;
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public ROLAPCubeConfiguration createCubeConfiguration(String cubeName, boolean isVirtual) {
        String postInMemoryTriggerNameVal;
        String autoAggrOptimizationVal;
        String measuresThresholdVal;
        String maxAggregateLoadThreadsVal;
        String maxHierarchyLoadThreadsVal;
        String maxAggregateCacheSizeVal;
        String maxDataCacheSizeVal;
        String predicateThresholdVal;
        ROLAPCubeConfiguration config = new ROLAPCubeConfiguration(cubeName, isVirtual);
        config.setServerConfiguration(this);
        Map<String, String> localCubeParameterMap = this.localCubeParameterMaps.get(cubeName);
        if (localCubeParameterMap == null) {
            return config;
        }
        String disabled = localCubeParameterMap.get(DISABLED_QNAME.getLocalPart());
        config.setDisabled("true".equals(disabled));
        String virtual = localCubeParameterMap.get(VIRTUAL_QNAME.getLocalPart());
        config.setVirtual("true".equals(virtual));
        String startupTriggerName = localCubeParameterMap.get(STARTUP_TRIGGER_NAME_QNAME.getLocalPart());
        if (startupTriggerName != null) {
            config.setStartupTriggerName(startupTriggerName);
        }
        String disableResultSetCache = localCubeParameterMap.get(DISABLE_RESULT_SET_CACHE_QNAME.getLocalPart());
        config.setDisableResultSetCache("true".equals(disableResultSetCache));
        String resultSetCacheSizeLimitVal = localCubeParameterMap.get(RESULT_SET_CACHE_SIZE_LIMIT_QNAME.getLocalPart());
        if (resultSetCacheSizeLimitVal != null) {
            config.setResultSetCacheSizeLimit(Integer.parseInt(resultSetCacheSizeLimitVal));
        }
        if ((predicateThresholdVal = localCubeParameterMap.get(PREDICATE_MEMBER_REFERENCE_THRESHOLD_QNAME.getLocalPart())) != null) {
            int predicateThreshold = Integer.parseInt(predicateThresholdVal);
            config.setPredicateThreshold(predicateThreshold);
        }
        String disableExternalAggregates = localCubeParameterMap.get(DISABLE_EXTERNAL_AGGREGATES_QNAME.getLocalPart());
        config.setDisableExternalAggregates("true".equals(disableExternalAggregates));
        String aggregateLoggingEnabled = localCubeParameterMap.get(AGGREGATE_LOGGING_ENABLED_QNAME.getLocalPart());
        config.setAggregateLoggingEnabled("true".equals(aggregateLoggingEnabled));
        String multiDimensionalQuerySizeLimitVal = localCubeParameterMap.get(MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.getLocalPart());
        if (multiDimensionalQuerySizeLimitVal != null) {
            int iMultiDimensionalQuerySizeLimit = Integer.parseInt(multiDimensionalQuerySizeLimitVal);
            config.setMultiDimensionalQuerySizeLimit(iMultiDimensionalQuerySizeLimit);
        }
        if ((maxDataCacheSizeVal = localCubeParameterMap.get(DATA_CACHE_SIZE_LIMIT_QNAME.getLocalPart())) != null) {
            int maxDataCacheSize = Integer.parseInt(maxDataCacheSizeVal);
            config.setMaxDataCacheSize(maxDataCacheSize);
        }
        if ((maxAggregateCacheSizeVal = localCubeParameterMap.get(AGGREGATE_CACHE_SIZE_LIMIT_QNAME.getLocalPart())) != null) {
            int maxAggregateCacheSize = Integer.parseInt(maxAggregateCacheSizeVal);
            config.setMaxAggregateCacheSize(maxAggregateCacheSize);
        }
        if ((maxHierarchyLoadThreadsVal = localCubeParameterMap.get(MAX_HIERARCHY_LOAD_THREADS_QNAME.getLocalPart())) != null) {
            int maxHierarchyLoadThreads = Integer.parseInt(maxHierarchyLoadThreadsVal);
            config.setMaxHierarchyLoadThreads(maxHierarchyLoadThreads);
        }
        if ((maxAggregateLoadThreadsVal = localCubeParameterMap.get(MAX_AGGREGATE_LOAD_THREADS_QNAME.getLocalPart())) != null) {
            int maxAggregateLoadThreads = Integer.parseInt(maxAggregateLoadThreadsVal);
            config.setMaxAggregateLoadThreads(maxAggregateLoadThreads);
        }
        if ((measuresThresholdVal = localCubeParameterMap.get(MEASURES_THRESHOLD_QNAME.getLocalPart())) != null) {
            int measuresThreshold = Integer.parseInt(measuresThresholdVal);
            config.setMeasuresThreshold(measuresThreshold);
        }
        if ((autoAggrOptimizationVal = localCubeParameterMap.get(AUTOMATIC_AGGREGATE_OPTIMIZATION_QNAME.getLocalPart())) != null) {
            config.setAutoAggrOptimization(autoAggrOptimizationVal);
        }
        if ((postInMemoryTriggerNameVal = localCubeParameterMap.get(POST_IN_MEMORY_TRIGGER_NAME_QNAME.getLocalPart())) != null) {
            config.setPostInMemoryTriggerName(postInMemoryTriggerNameVal);
        }
        return config;
    }

    public static ROLAPConfiguration loadLocalConfig() {
        ROLAPConfiguration conf = new ROLAPConfiguration();
        if (!conf.readLocalConfig()) {
            return null;
        }
        return conf;
    }

    private boolean readConfig(Element doc) {
        return false;
    }

    public static ROLAPConfiguration loadConfig(Element doc) {
        ROLAPConfiguration conf = new ROLAPConfiguration();
        if (!conf.readConfig(doc)) {
            return null;
        }
        return conf;
    }

    public String dump() {
        StringBuilder s = new StringBuilder();
        s.append("[ROLAPConfiguration:");
        s.append(JVM_INITIAL_HEAP_SIZE_QNAME.toString() + "=" + this.getInitialJVMHeapSize() + ",");
        s.append(JVM_MAX_HEAP_SIZE_QNAME.toString() + "=" + this.getMaxJVMHeapSize() + ",");
        s.append(JVM_ADDITIONAL_ARGS_QNAME.toString() + "=" + this.getAdditionalJVMArgs() + ",");
        s.append(MANUAL_CUBE_START_QNAME.toString() + "=" + this.isManualCubeStart() + ",");
        s.append(QS_MULTI_DIMENSIONAL_QUERY_SIZE_LIMIT_QNAME.toString() + "=" + this.getMultiDimensionalQuerySizeLimit() + ",");
        s.append(MEMBER_CACHE_FOLDER_QNAME.toString() + "=" + this.getMemberCacheFolder() + ",");
        s.append(ADMIN_COMMAND_TIMEOUT_QNAME.toString() + "=" + this.getAdminCommandTimeout() + ",");
        s.append(RESULT_SET_CACHE_QUERY_TIME_THRESHOLD_QNAME.toString() + "=" + this.getResultSetCacheQueryTimeThreshold() + ",");
        Set<String> cubes = this.cubeConfigurations.keySet();
        for (String c : cubes) {
            s.append(this.cubeConfigurations.get(c).dump());
        }
        s.append("]\n");
        return s.toString();
    }

    public int getMaxValidationThreads() {
        try {
            return this.configuration.getIntProperty("qsMaxValidationThreads", ROLAPConfigurationDefaultProperties.DEFAULT_MAX_VALIDATION_THREADS);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsMaxValidationThreads", (Throwable)e);
            return ROLAPConfigurationDefaultProperties.DEFAULT_MAX_VALIDATION_THREADS;
        }
    }

    public int getAdvisorMaxNumberWorkloadQueriesConsidered() {
        try {
            return this.configuration.getIntProperty("qsAdvisorMaxNumberWorkloadQueriesConsidered", 100);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAdvisorMaxNumberWorkloadQueriesConsidered", (Throwable)e);
            return 100;
        }
    }

    public int getAdvisorMaxNumberInMemoryAggregates() {
        try {
            return this.configuration.getIntProperty("qsAdvisorMaxNumberInMemoryAggregates", 50);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAdvisorMaxNumberInMemoryAggregates", (Throwable)e);
            return 50;
        }
    }

    public int getAdvisorMaxNumberInDBAggregates() {
        try {
            return this.configuration.getIntProperty("qsAdvisorMaxNumberInDBAggregates", 25);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAdvisorMaxNumberInDBAggregates", (Throwable)e);
            return 25;
        }
    }

    public boolean isAdvisorEnableTestFeatures() {
        try {
            return this.configuration.getBooleanProperty("qsAdvisorEnableTestFeatures", false);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAdvisorEnableTestFeatures", (Throwable)e);
            return false;
        }
    }

    public boolean isAdvisorConsolidateAggregatesMore() {
        try {
            return this.configuration.getBooleanProperty("qsAdvisorConsolidateAggregatesMore", false);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAdvisorConsolidateAggregatesMore", (Throwable)e);
            return false;
        }
    }

    public boolean isAdvisorExcludeNonAdditiveMeasures() {
        try {
            return this.configuration.getBooleanProperty("qsAdvisorExcludeNonAdditiveMeasures", false);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAdvisorExcludeNonAdditiveMeasures", (Throwable)e);
            return false;
        }
    }

    public long getAdvisorSessionTimeoutInMs() {
        try {
            return this.configuration.getLongProperty("qsAdvisorSessionTimeoutInMs", 5000L);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAdvisorSessionTimeoutInMs", (Throwable)e);
            return 5000L;
        }
    }

    public String getAutomaticAggregateOptimizationStartTime() {
        try {
            return this.configuration.getStringProperty("qsAutomaticAggregateOptimizationStartTime", "");
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAutomaticAggregateOptimizationStartTime", (Throwable)e);
            return "";
        }
    }

    public int getAutomaticAggregateOptimizationMaxConcurrentCubeTasks() {
        try {
            return this.configuration.getIntegerProperty("qsAutomaticAggregateOptimizationMaxConcurrentCubeTasks", 1);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAutomaticAggregateOptimizationMaxConcurrentCubeTasks", (Throwable)e);
            return 1;
        }
    }

    public long getAdvisorMaxNumberOfInMemoryAggregateCells() {
        long value = 300000000L;
        try {
            value = this.configuration.getLongProperty("qsAdvisorMaxNumberOfInMemoryAggregateCells", 300000000L);
            if (value < 0L) {
                value = 300000000L;
            }
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAdvisorMaxNumberOfInMemoryAggregateCells", (Throwable)e);
        }
        return value;
    }

    public int getSecurityMaxCachedMembers() {
        try {
            return this.configuration.getIntProperty("qsSecurityMaxCachedMembers", 1000000);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsSecurityMaxCachedMembers", (Throwable)e);
            return 1000000;
        }
    }

    public int getCubeStartDelayOnRecovery() {
        try {
            int val = this.configuration.getIntProperty("qsCubeStartDelayOnRecovery", 300);
            if (val < 0 || val > 3600) {
                LOGGER.log(String.format("The value for parameter '%s' - '%s' is not in the range [%d, %d]; the default value '%d' will be used.", "qsCubeStartDelayOnRecovery", val, 0, 3600, 300));
                return 300;
            }
            return val;
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsCubeStartDelayOnRecovery", (Throwable)e);
            return 300;
        }
    }

    public void setCubeStartDelayOnRecovery(int delay) {
        this.configuration.setProperty("qsCubeStartDelayOnRecovery", delay);
    }

    public boolean isVCMergeNonExistentMeasuresAsErrors() {
        try {
            return this.configuration.getBooleanProperty("qsVirtualCubeMergeNonExistentValuesAsErrors", false);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsVirtualCubeMergeNonExistentValuesAsErrors", (Throwable)e);
            return false;
        }
    }

    public boolean isSecuredHierarchyMemberRollupAllowed() {
        try {
            return this.configuration.getBooleanProperty("qsAllowSecuredHierarchyMemberRollup", false);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsAllowSecuredHierarchyMemberRollup", (Throwable)e);
            return false;
        }
    }

    public boolean isCalculatedMemberLUNReturned() {
        try {
            return this.configuration.getBooleanProperty("qsReturnCalculatedMemberLUN", false);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsReturnCalculatedMemberLUN", (Throwable)e);
            return false;
        }
    }

    public boolean isAggrSetMultiLevel() {
        try {
            return this.configuration.getBooleanProperty("qsDetermineMultiLevelsInAggregateSet", true);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsDetermineMultiLevelsInAggregateSet", (Throwable)e);
            return true;
        }
    }

    public boolean isAddPeriodToDateLastChildEnabled() {
        try {
            return this.configuration.getBooleanProperty("qsEnableAddPeriodToDateLastChild", true);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsEnableAddPeriodToDateLastChild", (Throwable)e);
            return true;
        }
    }

    public boolean isVCFirstLastAggregateRulesEnabled() {
        try {
            return this.configuration.getBooleanProperty("qsEnableAggregationRulesVirtualCube", true);
        }
        catch (ConversionException e) {
            LOGGER.log("Error parsing configuration setting qsEnableAggregationRulesVirtualCube", (Throwable)e);
            return true;
        }
    }

    public static void logAdvancedSettings(Properties props) {
        if (LOGGER != null && LOGGER.isOn()) {
            String s = ROLAPConfigurationDefaultProperties.logAdvancedSettings(props);
            LOGGER.log(s);
        }
    }

    public void reportUnsupportedProperties(ROLAPCubeMessages messages) {
        for (String propString : UNSUPPORTED_ADV_PROPERTIES) {
            if (this.configuration.getPropertyValue(propString, null) == null) continue;
            messages.addMessage(XQEMessageKeys.RLU_AdvPropertyNoLongerSupported, propString);
        }
    }
}

