/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailMessages;
import com.cognos.developer.schemas.bibus._3.FaultDetail;
import com.cognos.developer.schemas.bibus._3.FaultDetailMessage;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.bibushandler.ROLAPBIBusXMLHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import com.cognos.xqe.trace.XQEDebugLog;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ROLAPCubeCommandResult
implements IROLAPCommandResult {
    private Map<String, ResultDetails> results = new TreeMap<String, ResultDetails>();
    public static final String OPENING_RESULT_TAG = "<dcAdminCommandResult>";
    public static final String CLOSING_RESULT_TAG = "</dcAdminCommandResult>";
    private static final QName QN_MESSAGES = DocumentHelper.createQName((String)"messages");
    private static final QName QN_MESSAGE = DocumentHelper.createQName((String)"message");
    private static final QName QN_SEVERITY = DocumentHelper.createQName((String)"severity");
    private static final QName QN_BUS_FAULT_DETAIL = DocumentHelper.createQName((String)"faultDetail", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_BUS_FAULT_DETAIL_MESSAGE = DocumentHelper.createQName((String)"faultDetailMessage", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_BUS_ASYNCH_DETAIL_MESSAGES = DocumentHelper.createQName((String)"asynchDetailMessages", (Namespace)BIBusEnvelope.NS_BUS);
    private static final int MESSAGE_NO = 2;
    private static final String MESSAGE_SEPARATOR = " : ";
    private static final String SUCCESS = "SUCCESS";
    private static final String FAILURE = "FAILURE";

    public void setCommandResult(String cube, boolean success, String message) {
        this.results.put(cube, new ResultDetails(success, message));
    }

    public Map<String, ResultDetails> getResultMap() {
        return this.results;
    }

    @Override
    public void render(Element resultElement, String commandName) {
        Element detailsElement = null;
        int cubeResultCount = this.results.size();
        if (cubeResultCount > 0) {
            detailsElement = resultElement.addElement(ROLAPBIBusXMLHelper.QN_BUS_DETAILS);
            detailsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            detailsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, ROLAPBIBusXMLHelper.QN_BUS_ASYNCH_DETAIL.getQualifiedName() + "[" + cubeResultCount + "]");
            Set<Map.Entry<String, ResultDetails>> cubeResultEntries = this.results.entrySet();
            for (Map.Entry<String, ResultDetails> cubeResultEntry : cubeResultEntries) {
                String cubeName = cubeResultEntry.getKey();
                ResultDetails cubeRes = cubeResultEntry.getValue();
                Element itemElement = detailsElement.addElement(BIBusEnvelope.ITEM);
                itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, QN_BUS_ASYNCH_DETAIL_MESSAGES.getQualifiedName());
                Element messagesElement = itemElement.addElement(QN_MESSAGES);
                messagesElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
                messagesElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, QN_BUS_FAULT_DETAIL.getQualifiedName() + "[" + 1 + "]");
                ROLAPCubeCommandResult.addItemFaultDetailElement(messagesElement, commandName, cubeName, cubeRes);
            }
        }
    }

    private static Element addItemFaultDetailElement(Element messagesElement, String commandName, String cubeName, ResultDetails cubeResult) {
        Element itemElement = messagesElement.addElement(BIBusEnvelope.ITEM);
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, QN_BUS_FAULT_DETAIL.getQualifiedName());
        Element messageElement = itemElement.addElement(QN_MESSAGE);
        messageElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
        messageElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, QN_BUS_FAULT_DETAIL_MESSAGE.getQualifiedName() + "[" + 1 + "]");
        ROLAPCubeCommandResult.addItemFaultDetailMessageElement(messageElement, commandName, cubeName, cubeResult);
        Element severityElement = itemElement.addElement(QN_SEVERITY);
        severityElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        if (cubeResult.isSuccess()) {
            severityElement.addText(SUCCESS);
        } else {
            severityElement.addText(FAILURE);
        }
        return itemElement;
    }

    private static Element addItemFaultDetailMessageElement(Element parentElement, String commandName, String cubeName, ResultDetails cubeResult) {
        Element itemElement = parentElement.addElement(BIBusEnvelope.ITEM);
        itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, QN_BUS_FAULT_DETAIL_MESSAGE.getQualifiedName());
        Element messageElement = itemElement.addElement(QN_MESSAGE);
        messageElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
        messageElement.addText(cubeName + MESSAGE_SEPARATOR + cubeResult.getMessage());
        return itemElement;
    }

    @Override
    public void renderSimpleXML(PrintWriter xmlWriter) {
        for (Map.Entry<String, ResultDetails> entry : this.results.entrySet()) {
            xmlWriter.println("\t<cube name=\"" + StringEscapeUtils.escapeXml((String)entry.getKey()) + "\" success=\"" + entry.getValue().isSuccess() + "\" message=\"" + StringEscapeUtils.escapeXml((String)entry.getValue().getMessage()) + "\"/>");
        }
    }

    @Override
    public void renderPlain(PrintStream out) {
        for (Map.Entry<String, ResultDetails> entry : this.results.entrySet()) {
            out.print(entry.getKey() + MESSAGE_SEPARATOR);
            if (entry.getValue().isSuccess()) {
                out.print(SUCCESS);
            } else {
                out.print(FAILURE);
            }
            out.println(MESSAGE_SEPARATOR + entry.getValue().getMessage());
        }
    }

    @Override
    public void load(AsynchDetail[] details) {
        for (AsynchDetail detail : details) {
            FaultDetail[] faultDetails;
            AsynchDetailMessages detailMessages = (AsynchDetailMessages)detail;
            for (FaultDetail faultDetail : faultDetails = detailMessages.getMessages()) {
                FaultDetailMessage[] faultDetailMessages;
                for (FaultDetailMessage faultDetailMessage : faultDetailMessages = faultDetail.getMessage()) {
                    String message = faultDetailMessage.getMessage();
                    String[] parts = message.split(MESSAGE_SEPARATOR);
                    if (parts == null || parts.length != 2) {
                        XQEDebugLog.err.println("Unexpected message format: " + parts);
                        continue;
                    }
                    String severity = faultDetail.getSeverity();
                    this.setCommandResult(parts[0], severity.equals(SUCCESS), parts[1]);
                }
            }
        }
    }

    public class ResultDetails {
        private boolean mSuccess;
        private String mMessage;

        ResultDetails(boolean success, String message) {
            this.mSuccess = success;
            this.mMessage = message;
        }

        public boolean isSuccess() {
            return this.mSuccess;
        }

        public String getMessage() {
            return this.mMessage;
        }
    }
}

