/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeNameWrapper;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ROLAPCubeMessages {
    private static final Locale LOG_MESSAGE_LOCALE = Locale.getDefault();
    private static CompositeType messageDetailsCompositeType;
    private static TabularType messageDetailsTabularType;
    private static CompositeType messagesCompositeType;
    private static TabularType messagesTabularType;
    private static final String ID_NAME = "id";
    private static final String MESSAGE_NAME = "message";
    public static final String MESSAGE_DETAILS_NAME = "messageDetails";
    private static final String MESSAGE_TIMESTAMP = "timestamp";
    private static final String[] MESSAGE_FIELD_NAMES;
    public static final String MESSAGE_DETAIL_NAME_FIELD = "name";
    public static final String MESSAGE_DETAIL_VALUE_FIELD = "value";
    public static final String XML_CUBES = "cubes";
    public static final String XML_CUBE = "cube";
    public static final String XML_SIZE = "size";
    private static final String[] MESSAGE_DETAILS_FIELD_NAMES;
    private long mCleanupPeriod;
    private static final String SEPARATOR = "; ";
    private ConcurrentLinkedQueue<Message> mMessages = new ConcurrentLinkedQueue();

    public ROLAPCubeMessages() {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        this.mCleanupPeriod = 1000L * xqeConfiguration.getLongProperty("rolap.adminMessageExpiry[@value]", 86400L);
    }

    public static TabularType getDefinition() {
        return messagesTabularType;
    }

    public TabularData getValues() {
        this.clearExpiredMessages();
        TabularDataSupport tds = new TabularDataSupport(messagesTabularType);
        long fieldId = 0L;
        List<Message> sortedList = this.sortMessages();
        for (Message message : sortedList) {
            CompositeDataSupport cds;
            TabularDataSupport td = new TabularDataSupport(messageDetailsTabularType);
            Throwable e = message.getException();
            int i = 0;
            AtomicInteger id = new AtomicInteger(0);
            this.addMessageComponent(td, i, message.getKey(), message.getArguments());
            ++i;
            while (e != null) {
                if (e instanceof XQERuntimeException) {
                    XQERuntimeException xe = (XQERuntimeException)e;
                    this.addMessageComponent(td, i, xe.getMessageKey(), xe.getArguments());
                } else {
                    this.addMessageComponentField(td, String.format("m%d-str", i), ROLAPCubeMessages.getNonEmptyMessage(e));
                }
                e = e.getCause();
                ++i;
            }
            try {
                cds = new CompositeDataSupport(messagesCompositeType, MESSAGE_FIELD_NAMES, new Object[]{new Long(fieldId), new Date(message.getTimestamp()), td});
                ++fieldId;
            }
            catch (OpenDataException oe) {
                throw new XQERuntimeException(oe);
            }
            tds.put(cds);
        }
        return tds;
    }

    public String[] getRenderedMessages() {
        this.clearExpiredMessages();
        LinkedList<String> list = new LinkedList<String>();
        List<Message> sortedList = this.sortMessages();
        for (Message message : sortedList) {
            StringBuilder renderedMessage = new StringBuilder(new Date(message.getTimestamp()).toString());
            renderedMessage.append(' ');
            IMessageKey key = message.getKey();
            String[] msgArgs = message.getArguments();
            if (key instanceof IMessageKey.Param0) {
                renderedMessage.append(XQEMessages.getMessage((IMessageKey.Param0)key, XQEMessages.getCurrProductLocale()));
            } else if (key instanceof IMessageKey.Param1) {
                renderedMessage.append(XQEMessages.getMessage((IMessageKey.Param1)key, XQEMessages.getCurrProductLocale(), msgArgs[0]));
            } else if (key instanceof IMessageKey.Param2) {
                renderedMessage.append(XQEMessages.getMessage((IMessageKey.Param2)key, XQEMessages.getCurrProductLocale(), msgArgs[0], msgArgs[1]));
            } else if (key instanceof IMessageKey.Param3) {
                renderedMessage.append(XQEMessages.getMessage((IMessageKey.Param3)key, XQEMessages.getCurrProductLocale(), msgArgs[0], msgArgs[1], msgArgs[2]));
            }
            for (Throwable e = message.getException(); e != null; e = e.getCause()) {
                renderedMessage.append(SEPARATOR);
                if (e instanceof XQERuntimeException) {
                    XQERuntimeException xe = (XQERuntimeException)e;
                    renderedMessage.append(xe.getLocalizedMessage());
                    continue;
                }
                renderedMessage.append(ROLAPCubeMessages.getNonEmptyMessage(e));
            }
            list.add(renderedMessage.toString());
        }
        return list.toArray(new String[0]);
    }

    private static String getNonEmptyMessage(Throwable e) {
        String val = e.getLocalizedMessage();
        if (val == null) {
            return e.toString();
        }
        return val;
    }

    private List<Message> sortMessages() {
        LinkedList<Message> list = new LinkedList<Message>();
        for (Message m : this.mMessages) {
            list.addFirst(m);
        }
        Collections.sort(list);
        return list;
    }

    private void clearExpiredMessages() {
        Iterator<Message> it = this.mMessages.iterator();
        long currTime = System.currentTimeMillis();
        while (it.hasNext()) {
            Message message = it.next();
            if (currTime - message.getTimestamp() <= this.mCleanupPeriod) continue;
            it.remove();
        }
    }

    public void addMessage(IMessageKey.Param0 key) {
        this.addMessage(System.currentTimeMillis(), key);
    }

    public void addMessage(IMessageKey.Param0 key, Throwable ex) {
        this.addMessage(System.currentTimeMillis(), key, ex);
    }

    public void addMessage(long timestamp, IMessageKey.Param0 key) {
        this.addMessage(timestamp, key, null);
    }

    public void addMessage(long timestamp, IMessageKey.Param0 key, Throwable ex) {
        this.mMessages.add(new Message(timestamp, key, null, ex));
        ROLAPCubeMessages.logMessage(XQEMessages.getMessage(key, LOG_MESSAGE_LOCALE), ex);
    }

    public void addMessage(IMessageKey.Param1 key, String param1) {
        this.addMessage(System.currentTimeMillis(), key, param1);
    }

    public void addMessage(IMessageKey.Param1 key, String param1, Throwable ex) {
        this.addMessage(System.currentTimeMillis(), key, param1, ex);
    }

    public void addMessage(long timestamp, IMessageKey.Param1 key, String param1) {
        this.addMessage(timestamp, key, param1, null);
    }

    public void addMessage(long timestamp, IMessageKey.Param1 key, String param1, Throwable ex) {
        String[] args = new String[]{param1};
        this.mMessages.add(new Message(timestamp, key, args, ex));
        ROLAPCubeMessages.logMessage(XQEMessages.getMessage(key, LOG_MESSAGE_LOCALE, param1), ex);
    }

    public void addMessage(IMessageKey.Param2 key, String param1, String param2) {
        this.addMessage(System.currentTimeMillis(), key, param1, param2);
    }

    public void addMessage(IMessageKey.Param2 key, String param1, String param2, Throwable ex) {
        this.addMessage(System.currentTimeMillis(), key, param1, param2, ex);
    }

    public void addMessage(long timestamp, IMessageKey.Param2 key, String param1, String param2) {
        this.addMessage(timestamp, key, param1, param2, null);
    }

    public void addMessage(long timestamp, IMessageKey.Param2 key, String param1, String param2, Throwable ex) {
        String[] args = new String[]{param1, param2};
        this.mMessages.add(new Message(timestamp, key, args, ex));
        ROLAPCubeMessages.logMessage(XQEMessages.getMessage(key, LOG_MESSAGE_LOCALE, param1, param2), ex);
    }

    public void addMessage(IMessageKey.Param3 key, String param1, String param2, String param3) {
        this.addMessage(System.currentTimeMillis(), key, param1, param2, param3);
    }

    public void addMessage(IMessageKey.Param3 key, String param1, String param2, String param3, Throwable ex) {
        this.addMessage(System.currentTimeMillis(), key, param1, param2, param3, ex);
    }

    public void addMessage(long timestamp, IMessageKey.Param3 key, String param1, String param2, String param3) {
        this.addMessage(timestamp, key, param1, param2, param3, null);
    }

    public void addMessage(long timestamp, IMessageKey.Param3 key, String param1, String param2, String param3, Throwable ex) {
        String[] args = new String[]{param1, param2, param3};
        this.mMessages.add(new Message(timestamp, key, args, ex));
        ROLAPCubeMessages.logMessage(XQEMessages.getMessage(key, LOG_MESSAGE_LOCALE, param1, param2, param3), ex);
    }

    private void addMessageComponent(TabularData td, int i, IMessageKey key, Object[] args) {
        this.addMessageComponentField(td, String.format("m%d-file", i), key.getBundleFileName());
        this.addMessageComponentField(td, String.format("m%d-id", i), ROLAPCubeMessages.getKeyName(key));
        if (args != null) {
            for (int pos = 0; pos < args.length; ++pos) {
                String val = "";
                if (args[pos] != null) {
                    if (args[pos] instanceof ROLAPCubeNameWrapper) {
                        ROLAPCubeNameWrapper cube = (ROLAPCubeNameWrapper)args[pos];
                        this.addMessageComponentField(td, String.format("m%d-p%d-c", i, pos), this.toXML(cube));
                        continue;
                    }
                    val = args[pos].toString();
                    val = args[pos].toString();
                }
                this.addMessageComponentField(td, String.format("m%d-p%d", i, pos), val);
            }
        }
    }

    private void addMessageComponentField(TabularData td, String name, String value) {
        try {
            CompositeDataSupport cds = new CompositeDataSupport(messageDetailsCompositeType, MESSAGE_DETAILS_FIELD_NAMES, new Object[]{name, value});
            td.put(cds);
        }
        catch (OpenDataException e) {
            throw new XQERuntimeException(e);
        }
    }

    public static String getKeyName(IMessageKey key) {
        return key.getBundleKeyPrefix() + "_" + key.toString();
    }

    public long getTimeout() {
        return this.mCleanupPeriod;
    }

    public void setTimeout(long timeout) {
        this.mCleanupPeriod = timeout;
    }

    private static void logMessage(String message, Throwable th) {
        if (th == null) {
            ROLAPLog.log("ROLAPCubes.Info", message);
            ROLAPLog.logWarn("ROLAPCubes.Audit", message);
        } else {
            ROLAPLog.logError("ROLAPCubes.Info", message, th);
            ROLAPLog.logError("ROLAPCubes.Audit", message, th);
        }
    }

    private String toXML(ROLAPCubeNameWrapper messageCube) {
        Document document = DocumentHelper.createDocument();
        Element cubes = document.addElement(XML_CUBES);
        cubes.addAttribute(XML_SIZE, Integer.toString(messageCube.size()));
        for (String name : messageCube.getNames()) {
            Element cube = cubes.addElement(XML_CUBE);
            cube.addText(name);
        }
        return document.asXML();
    }

    public Message[] getMessages() {
        return this.mMessages.toArray(new Message[0]);
    }

    static {
        MESSAGE_FIELD_NAMES = new String[]{ID_NAME, MESSAGE_TIMESTAMP, MESSAGE_DETAILS_NAME};
        MESSAGE_DETAILS_FIELD_NAMES = new String[]{MESSAGE_DETAIL_NAME_FIELD, MESSAGE_DETAIL_VALUE_FIELD};
        try {
            messageDetailsCompositeType = new CompositeType(MESSAGE_DETAILS_NAME, MESSAGE_DETAILS_NAME, MESSAGE_DETAILS_FIELD_NAMES, new String[]{"Field name", "Field value"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING});
            messageDetailsTabularType = new TabularType(MESSAGE_DETAILS_NAME, MESSAGE_DETAILS_NAME, messageDetailsCompositeType, new String[]{MESSAGE_DETAIL_NAME_FIELD});
            messagesCompositeType = new CompositeType(MESSAGE_NAME, MESSAGE_NAME, MESSAGE_FIELD_NAMES, new String[]{"Message ID", "Timestamp", MESSAGE_DETAILS_NAME}, new OpenType[]{SimpleType.LONG, SimpleType.DATE, messageDetailsTabularType});
            messagesTabularType = new TabularType(MESSAGE_NAME, MESSAGE_NAME, messagesCompositeType, new String[]{ID_NAME});
        }
        catch (OpenDataException e) {
            throw new XQERuntimeException(e);
        }
    }

    public class Message
    implements Comparable<Message> {
        private long timestamp;
        private IMessageKey key;
        private String[] arguments;
        private Throwable ex;

        Message(long t, IMessageKey k, String[] args, Throwable e) {
            this.timestamp = t;
            this.key = k;
            this.ex = e;
            this.arguments = args;
        }

        long getTimestamp() {
            return this.timestamp;
        }

        public IMessageKey getKey() {
            return this.key;
        }

        public String[] getArguments() {
            return this.arguments;
        }

        Throwable getException() {
            return this.ex;
        }

        @Override
        public int compareTo(Message arg) {
            if (null == arg) {
                return -1;
            }
            if (this.getTimestamp() == arg.getTimestamp()) {
                return 0;
            }
            if (this.getTimestamp() < arg.getTimestamp()) {
                return 1;
            }
            return -1;
        }
    }
}

