/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailUnstructuredData;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.bibushandler.ROLAPBIBusXMLHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeMetrics;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ROLAPCubeMetricResult
implements IROLAPCommandResult {
    private static final String NAME_ATTR = "name";
    private static final String VALUE_ATTR = "value";
    private static final String EQ_QUOTE = "=\"";
    private static final String CUBE_OPEN = "<cube name=\"";
    private static final String CUBE_CLOSE = "</cube>";
    private static final String VALUE = "\" value=\"";
    private static final String METRIC_NAME = "metric";
    private static final String METRIC = "<metric name=\"";
    private static final String CUBE_TAG_END = "\">";
    private static final String TAG_END = "\"/>";
    private static final String TAB = "\t";
    private static final QName QN_BUS_ASYNCH_DETAIL_UNSTRUCTURED_DATA = DocumentHelper.createQName((String)"asynchDetailUnstructuredData", (Namespace)BIBusEnvelope.NS_BUS);
    Map<String, Map<String, Object>> metrics = new TreeMap<String, Map<String, Object>>();

    public void addMetric(String cube, String metric, Object value) {
        Map<String, Object> cubeEntry = this.metrics.get(cube);
        if (cubeEntry == null) {
            cubeEntry = new TreeMap<String, Object>();
            this.metrics.put(cube, cubeEntry);
        }
        if (value == null) {
            value = "";
        }
        cubeEntry.put(metric, value);
    }

    @Override
    public void render(Element resultElement, String commandName) {
        Element detailsElement = null;
        int cubeResultCount = this.metrics.size();
        if (cubeResultCount > 0) {
            detailsElement = resultElement.addElement(ROLAPBIBusXMLHelper.QN_BUS_DETAILS);
            detailsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            detailsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, ROLAPBIBusXMLHelper.QN_BUS_ASYNCH_DETAIL.getQualifiedName() + "[" + cubeResultCount + "]");
            Set<Map.Entry<String, Map<String, Object>>> cubeResultEntries = this.metrics.entrySet();
            for (Map.Entry<String, Map<String, Object>> cubeResultEntry : cubeResultEntries) {
                Map<String, Object> cubeMetrics = cubeResultEntry.getValue();
                Element metricElement = detailsElement.addElement(BIBusEnvelope.ITEM);
                metricElement.addAttribute(SOAPEnvelope.XSI_TYPE, QN_BUS_ASYNCH_DETAIL_UNSTRUCTURED_DATA.getQualifiedName());
                Element dataElement = metricElement.addElement("data");
                dataElement.addAttribute(SOAPEnvelope.XSI_TYPE, BIBusEnvelope.NS_BUS.getPrefix() + ":xmlEncodedXML");
                StringBuilder str = new StringBuilder();
                str.append(CUBE_OPEN).append(cubeResultEntry.getKey()).append(CUBE_TAG_END);
                for (Map.Entry<String, Object> metric : cubeMetrics.entrySet()) {
                    str.append(METRIC).append(metric.getKey()).append(VALUE).append(metric.getValue().toString()).append(TAG_END);
                }
                str.append(CUBE_CLOSE);
                dataElement.addText(str.toString());
            }
        }
    }

    @Override
    public void renderSimpleXML(PrintWriter xmlWriter) {
        for (Map.Entry<String, Map<String, Object>> entry : this.metrics.entrySet()) {
            xmlWriter.println("\t<cube name=\"" + StringEscapeUtils.escapeXml((String)entry.getKey()) + CUBE_TAG_END);
            for (Map.Entry<String, Object> metric : entry.getValue().entrySet()) {
                xmlWriter.println("\t\t<metric name=\"" + metric.getKey() + VALUE + StringEscapeUtils.escapeXml((String)metric.getValue().toString()) + TAG_END);
            }
            xmlWriter.println("\t</cube>");
        }
    }

    @Override
    public void renderPlain(PrintStream out) {
        for (Map.Entry<String, Map<String, Object>> entry : this.metrics.entrySet()) {
            out.println("Metrics for cube " + entry.getKey() + ":");
            for (Map.Entry<String, Object> metric : entry.getValue().entrySet()) {
                out.println(TAB + metric.getKey() + "=" + ROLAPCubeMetrics.Metric.format(metric.getKey(), metric.getValue().toString()));
            }
            out.println();
        }
    }

    @Override
    public void load(AsynchDetail[] details) {
        for (AsynchDetail detail : details) {
            AsynchDetailUnstructuredData data = (AsynchDetailUnstructuredData)detail;
            XmlEncodedXML xml = data.getData();
            String text = xml.get_value();
            try {
                Document doc = DocumentHelper.parseText((String)text);
                Element cube = doc.getRootElement();
                String cubeName = cube.attributeValue(NAME_ATTR);
                List metricList = cube.elements(METRIC_NAME);
                for (Element metric : metricList) {
                    this.addMetric(cubeName, metric.attributeValue(NAME_ATTR), metric.attributeValue(VALUE_ATTR));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error parsing metrics text", e);
            }
        }
    }
}

