/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin;

import com.cognos.developer.schemas.bibus._3.AsynchDetail;
import com.cognos.developer.schemas.bibus._3.AsynchDetailROLAPDataSourceState;
import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.pogo.pdk.SOAPEnvelope;
import com.cognos.xqe.bibushandler.ROLAPBIBusXMLHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCommandResult;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringEscapeUtils;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;

public class ROLAPCubeStateResult
implements IROLAPCommandResult {
    private Map<String, String> states = new TreeMap<String, String>();
    private static final QName QN_BUS_ASYNCH_DETAIL_ROLAP_DATA_SOURCE_STATE = DocumentHelper.createQName((String)"asynchDetailROLAPDataSourceState", (Namespace)BIBusEnvelope.NS_BUS);
    private static final QName QN_DATA_SOURCE_NAME = DocumentHelper.createQName((String)"dataSourceName");
    private static final QName QN_STATE = DocumentHelper.createQName((String)"state");

    public void setState(String cube, String state) {
        this.states.put(cube, state);
    }

    public Map<String, String> getStates() {
        return this.states;
    }

    @Override
    public void render(Element resultElement, String commandName) {
        Element detailsElement = null;
        int cubeResultCount = this.states.size();
        if (cubeResultCount > 0) {
            detailsElement = resultElement.addElement(ROLAPBIBusXMLHelper.QN_BUS_DETAILS);
            detailsElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.SOAP_ENC_ARRAY);
            detailsElement.addAttribute(SOAPEnvelope.SOAP_ENC_ARRAYTYPE, ROLAPBIBusXMLHelper.QN_BUS_ASYNCH_DETAIL.getQualifiedName() + "[" + cubeResultCount + "]");
            Set<Map.Entry<String, String>> cubeResultEntries = this.states.entrySet();
            for (Map.Entry<String, String> cubeResultEntry : cubeResultEntries) {
                String cubeName = cubeResultEntry.getKey();
                String cubeRes = cubeResultEntry.getValue();
                Element itemElement = detailsElement.addElement(BIBusEnvelope.ITEM);
                itemElement.addAttribute(SOAPEnvelope.XSI_TYPE, QN_BUS_ASYNCH_DETAIL_ROLAP_DATA_SOURCE_STATE.getQualifiedName());
                Element dataSourceNameElement = itemElement.addElement(QN_DATA_SOURCE_NAME);
                dataSourceNameElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                dataSourceNameElement.addText(cubeName);
                Element stateElement = itemElement.addElement(QN_STATE);
                stateElement.addAttribute(SOAPEnvelope.XSI_TYPE, SOAPEnvelope.XSD_STRING);
                stateElement.addText(cubeRes);
            }
        }
    }

    @Override
    public void renderSimpleXML(PrintWriter xmlWriter) {
        for (Map.Entry<String, String> entry : this.states.entrySet()) {
            xmlWriter.println("\t<cube name=\"" + StringEscapeUtils.escapeXml((String)entry.getKey()) + "\" state=\"" + StringEscapeUtils.escapeXml((String)entry.getValue()) + "\"/>");
        }
    }

    @Override
    public void renderPlain(PrintStream out) {
        out.println("Cube states:");
        for (Map.Entry<String, String> entry : this.states.entrySet()) {
            out.println("\t" + entry.getKey() + " : " + entry.getValue());
        }
    }

    @Override
    public void load(AsynchDetail[] details) {
        for (AsynchDetail detail : details) {
            AsynchDetailROLAPDataSourceState cubeDetail = (AsynchDetailROLAPDataSourceState)detail;
            String cubeName = cubeDetail.getDataSourceName();
            String cubeState = cubeDetail.getState();
            this.setState(cubeName, cubeState);
        }
    }
}

