/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionValueConstraintInt;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionValueConstraintLong;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorProgressPoint;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorPropertyName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRecommendations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUnitTestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetricsFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadSummary;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelHandler;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelReason;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorGetRecommendationResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.recommendation.RecommendationFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.AutonomicStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.LastAggregateLoadStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.ModelBasedLowerSlicesStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.ModelBasedUpperSlicesStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.UserDefinedAggregatesStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.WorkloadBasedStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ConfigurationValues;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class Advisor {
    private ROLAPBaseCube cube = null;
    private ROLAPMetaCube metaCube = null;
    private AggregateAdvisor aggregateAdvisor = null;
    private Properties properties;
    private Map<String, String> options = null;
    private AdvisorRequestParameters requestParameters = new AdvisorRequestParameters();
    private AdvisorUnitTestParameters unitTestParameters = new AdvisorUnitTestParameters();
    private QuerySummaryInfoLog querySummaryInfoLog = null;
    private volatile AggregateAdvisorState state = AggregateAdvisorState.STARTED;
    private ReentrantLock stopLock = new ReentrantLock();
    private AdvisorCancelHandler advisorCancelHandler = new AdvisorCancelHandler();
    private List<XQERuntimeException> messages = new ArrayList<XQERuntimeException>();
    private HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
    private Date recommendationStartTime;
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");
    private static final String EQUALS_SEPARATOR = " = ";
    private static final String TRUE_STR = "true";
    private volatile AdvisorRecommendations recommendations = null;
    private List<AggregateAdvisorProgressPoint> progress = new ArrayList<AggregateAdvisorProgressPoint>();
    private int lastProgressPointIndexReturned = 0;
    private HighPrecisionStopWatch progressStopWatch = new HighPrecisionStopWatch();
    private AdvisorProgressTimer progressTimer;
    private volatile boolean bCompletedPostRecommendationSteps = false;
    private volatile boolean bSaveBackupResults = false;

    public AggregateAdvisorState getState() {
        return this.state;
    }

    public void setState(AggregateAdvisorState s) {
        this.state = s;
    }

    public Advisor(ROLAPBaseCube theCube, Properties theProperties, Map<String, String> theOptions) {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Advisor constructor - begin"));
        this.cube = theCube;
        this.properties = theProperties == null ? new Properties() : theProperties;
        this.options = theOptions;
        this.captureUserOptions();
        this.captureAdvancedSettings();
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Advisor constructor - end"));
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getProperty(AggregateAdvisorPropertyName propertyName) {
        return this.properties.getProperty(propertyName.toString());
    }

    public void setProperty(AggregateAdvisorPropertyName propertyName, String propertyValue) {
        this.properties.setProperty(propertyName.toString(), propertyValue);
    }

    public synchronized void updateRecommendationName(String cubeName, String recommendationID, String recommendationName) throws Exception {
        INFO_LOGGER.log(String.format("Updating the name of the recommendation in memory and on disk for the cube %s with id %s to %s", cubeName, recommendationID, recommendationName));
        INFO_LOGGER.log("Updating the name of the recommendation in memory");
        this.setProperty(AggregateAdvisorPropertyName.RECOMMENDATION_NAME, recommendationName);
        String recommendationFileName = RecommendationFileUtility.getRecommendationFileName(cubeName, recommendationID);
        File recommendationFile = new File(recommendationFileName);
        if (recommendationFile.exists()) {
            INFO_LOGGER.log(String.format("Updating the name of the recommendation on disk since the file %s exists", recommendationFileName));
            RecommendationFileUtility.updateRecommendationName(cubeName, recommendationID, recommendationName);
        } else {
            INFO_LOGGER.log(String.format("Not updating the name of the recommendation on disk since the file %s does not exist", recommendationFileName));
        }
    }

    public AdvisorRequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public QuerySummaryInfoLog getQuerySummaryInfoLog() {
        return this.querySummaryInfoLog;
    }

    public void setQuerySummaryInfoLog(QuerySummaryInfoLog theQuerySummaryInfoLog) {
        this.querySummaryInfoLog = theQuerySummaryInfoLog;
    }

    public void setUnitTestParameters(AdvisorUnitTestParameters aUnitTestParameters) {
        this.unitTestParameters = aUnitTestParameters;
    }

    public void addMessage(XQERuntimeException exception) {
        this.messages.add(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AdvisorRecommendations recommend() throws Exception {
        this.bCompletedPostRecommendationSteps = false;
        this.messages = new ArrayList<XQERuntimeException>();
        ArrayList<Aggregate> candidateAggregates = new ArrayList<Aggregate>();
        boolean completedAllStrategies = false;
        String startTimeString = this.getProperty(AggregateAdvisorPropertyName.START_TIME);
        this.recommendationStartTime = startTimeString != null ? new Date(Long.parseLong(startTimeString)) : Calendar.getInstance().getTime();
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend aggregates for cube " + this.cube.getName()));
        INFO_LOGGER.log(AdvisorTrace.heading("Request parameters") + AdvisorTrace.formatRequestParameters(this.requestParameters));
        if (this.unitTestParameters.haveParametersChanged()) {
            String msg = AdvisorTrace.heading("Unit test parameters") + AdvisorTrace.formatUnitTestParameters(this.unitTestParameters);
            INFO_LOGGER.log(msg);
        }
        this.stopWatch.start();
        try {
            block13: {
                try {
                    envHelper.setCMRequestExecutor(this.cube.getAccountManager());
                    envHelper.setInternalUse(true);
                    envHelper.setUpEnvironment(true);
                    ROLAPContext.setRelQueryExecuting();
                    boolean makeRecommendations = this.setup();
                    if (!this.unitTestParameters.getDesiredDatabaseAggregates().isEmpty()) {
                        makeRecommendations = false;
                    }
                    if (makeRecommendations) {
                        this.aggregateAdvisor.initializeExistingInDatabaseAggregates();
                        this.aggregateAdvisor.determineFactRowCount();
                        this.aggregateAdvisor.setupSampling();
                        this.executeRecommendationStrategies(candidateAggregates);
                        completedAllStrategies = true;
                    }
                }
                catch (Exception e) {
                    if (this.advisorCancelHandler.isAdvisorThreadCanceled()) {
                        INFO_LOGGER.log(LogLevel.ERROR, (Throwable)e);
                    } else {
                        this.messages.add(Advisor.buildError(e));
                    }
                    candidateAggregates.clear();
                    AdvisorRecommendations savedRecommendations = this.getRecommendations();
                    if (savedRecommendations == null) break block13;
                    candidateAggregates.addAll(savedRecommendations.getAggregates());
                }
            }
            this.saveRecommendations(candidateAggregates, true, completedAllStrategies);
            INFO_LOGGER.log(AdvisorTrace.majorHeading("Advisor results"));
            AdvisorMetrics metrics = this.aggregateAdvisor.getMetrics();
            metrics.logEvent("TotalAdvisorRun", this.stopWatch.getElapsedTimeInMilliseconds());
            INFO_LOGGER.log(AdvisorTrace.heading("Advisor metrics") + '\n' + metrics.toTraceString());
            CubeCardinalityMetrics cubeCardinalityMetrics = this.aggregateAdvisor.getCubeCardinalityMetrics();
            INFO_LOGGER.log(AdvisorTrace.formatSliceCardinalities(cubeCardinalityMetrics));
            try {
                CubeCardinalityMetricsFileUtility.writeAdvisorMetrics(this.metaCube, cubeCardinalityMetrics);
            }
            catch (Exception ex) {
                INFO_LOGGER.log("Failed to write advisor metrics so next advisor run won't get a performance boost");
            }
            if (this.requestParameters.getIncludeWorkloadInfo()) {
                INFO_LOGGER.log(AdvisorTrace.formatQueryCoverage(this.aggregateAdvisor.getSliceUsageAggregates(), this.getRecommendations().getAggregates()));
            }
            INFO_LOGGER.log("Show mapping from in-memory aggregates to what they will be derived from:\n" + AdvisorTrace.formatAggregateCoverageAnalysis(this.getRecommendations().getInMemoryAggregates(), this.getRecommendations().getInDatabaseAggregates(), this.aggregateAdvisor));
            this.postRecommendationSteps();
        }
        finally {
            envHelper.tearDownEnvironment();
        }
        return this.getRecommendations();
    }

    private boolean setup() throws Exception {
        if (this.unitTestParameters.getModel() == null) {
            INFO_LOGGER.log("Get the cube metadata from the server");
            this.metaCube = this.cube.getModelCube();
            if (this.metaCube == null) {
                this.metaCube = this.cube.loadSchema().getCubes()[0];
                INFO_LOGGER.log("Load a copy of the cube metadata from content store");
            }
        } else {
            this.metaCube = this.unitTestParameters.getModel();
            INFO_LOGGER.log("Use cube metadata provided by test program");
        }
        this.aggregateAdvisor = new AggregateAdvisor(this.cube, this.metaCube, this, this.requestParameters, this.unitTestParameters);
        String cubeMetadataInfo = AdvisorTrace.formatMetadata(this.metaCube, this.aggregateAdvisor);
        INFO_LOGGER.log(cubeMetadataInfo);
        if (this.aggregateAdvisor.getSupportedMeasures().isEmpty()) {
            this.messages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_UnableToRecommendDueToMeasureAggregateType, this.metaCube.getName())));
            return false;
        }
        if (!this.validateParameters()) {
            return false;
        }
        if (this.requestParameters.getIncludeWorkloadInfo() && !this.aggregateAdvisor.isCubeAutonomic()) {
            boolean haveWorkload = this.initializeWorkloadSummary();
            if (this.aggregateAdvisor.getRequestParameters().getUseWorkloadOnly() && !haveWorkload) {
                INFO_LOGGER.log("Requested to only analyze workload but no workload available. ");
                if (!this.hasUserDefinedAggregates()) {
                    return false;
                }
            }
        }
        this.aggregateAdvisor.determineLevelCardinalities();
        CubeCardinalityMetrics cubeCardinalityMetrics = this.aggregateAdvisor.getCubeCardinalityMetrics();
        String hierarchyCardinalityInfo = AdvisorTrace.formatHierarchyCardinalities(cubeCardinalityMetrics);
        String levelCardinalityInfo = AdvisorTrace.formatLevelCardinalities(cubeCardinalityMetrics);
        INFO_LOGGER.log(hierarchyCardinalityInfo + levelCardinalityInfo);
        INFO_LOGGER.log(AdvisorTrace.formatSliceCardinalities(cubeCardinalityMetrics));
        return true;
    }

    private boolean hasUserDefinedAggregates() {
        return this.metaCube.getUserDefinedInMemoryAggregates().length > 0 || !this.aggregateAdvisor.getUnitTestParameters().getUserDefinedAggregates().isEmpty();
    }

    private boolean validateParameters() {
        if (this.requestParameters.getInMemoryAggregatesLimit() == 0L && this.requestParameters.getInDatabaseAggregatesLimit() == 0L) {
            INFO_LOGGER.log("Invalid parameters - asking for neither in-memory nor in-database aggregates.");
            this.messages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorParametersErrorNoAggregatesRequested)));
            return false;
        }
        if (this.aggregateAdvisor.getRequestParameters().getUserDefinedAggregatesOnly() && this.requestParameters.getInMemoryAggregatesLimit() == 0L) {
            INFO_LOGGER.log("Invalid parameters - asking for user defined aggregates only but not in-memory aggregates.");
            this.messages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorParametersErrorRequestedUserDefinedOnlyButNotInMemory)));
            return false;
        }
        return true;
    }

    private synchronized void setCompletedPostRecommendationSteps(boolean completed) {
        this.bCompletedPostRecommendationSteps = completed;
    }

    private synchronized void postRecommendationSteps() {
        if (!this.bCompletedPostRecommendationSteps) {
            this.getRecommendations().determineDependencies();
            this.getRecommendations().sortInDatabaseAggregates();
            if (INFO_LOGGER.isOn()) {
                INFO_LOGGER.log(this.getRecommendations().formatForTrace());
            }
            this.storeBackupResults();
            this.bCompletedPostRecommendationSteps = true;
        }
    }

    private static List<Aggregate> copyAggregates(List<Aggregate> aggregates) {
        ArrayList<Aggregate> aggregatesToReturn = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            Aggregate aggregateToReturn = aggregate.copy();
            aggregatesToReturn.add(aggregateToReturn);
        }
        return aggregatesToReturn;
    }

    public void saveRecommendations(List<Aggregate> aggregates) {
        this.saveRecommendations(aggregates, false, false);
    }

    private void saveRecommendations(List<Aggregate> aggregates, boolean isFinal, boolean completedAllStrategies) {
        List<Aggregate> aggregatesToSave = Advisor.copyAggregates(aggregates);
        ArrayList<Aggregate> inDatabaseAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> inMemoryAggregates = new ArrayList<Aggregate>();
        this.aggregateAdvisor.assignAggregates(aggregatesToSave, inMemoryAggregates, inDatabaseAggregates);
        inDatabaseAggregates.addAll(this.unitTestParameters.getDesiredDatabaseAggregates());
        if (isFinal && this.requestParameters.getInDatabaseAggregatesLimit() > 0L && inDatabaseAggregates.isEmpty()) {
            if (!completedAllStrategies) {
                this.messages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCompletedWithNoDBRecommendations, this.getCubeName())));
            } else if (this.aggregateAdvisor.getExistingInDatabaseAggregates().isEmpty()) {
                this.messages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCompletedWithNoDBRecommendations, this.getCubeName())));
            } else {
                this.messages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCompletedWithNoNewDBRecommendations, this.getCubeName())));
            }
        }
        ArrayList<XQERuntimeException> messagesToSave = new ArrayList<XQERuntimeException>(this.messages);
        this.validateRecommendations(inMemoryAggregates, inDatabaseAggregates, messagesToSave);
        AdvisorRecommendations recommendationsToSave = new AdvisorRecommendations(this.cube.getName(), this.requestParameters, inDatabaseAggregates, inMemoryAggregates, messagesToSave, this.aggregateAdvisor.getExistingInDatabaseAggregates(), this.recommendationStartTime);
        recommendationsToSave.setAdvisorMetrics(this.aggregateAdvisor.getMetrics());
        this.setRecommendations(recommendationsToSave);
        if (this.getState() == AggregateAdvisorState.EXECUTING && recommendationsToSave.getAggregates().size() > 0) {
            this.setState(AggregateAdvisorState.OPTIMIZING);
            INFO_LOGGER.log("Change advisor state to " + this.getState().toString());
        }
    }

    private void validateRecommendations(List<Aggregate> inMemoryAggregates, List<Aggregate> inDatabaseAggregates, List<XQERuntimeException> currentMessages) {
        long maxNumberOfInMemoryAggregateCells = this.requestParameters.getMaxNumberOfInMemoryAggregateCells();
        for (Aggregate inMemoryAggregate : inMemoryAggregates) {
            long numberOfInMemoryAggregateCells = inMemoryAggregate.getNumberOfCells();
            if (numberOfInMemoryAggregateCells <= maxNumberOfInMemoryAggregateCells) continue;
            currentMessages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorInMemoryAggregateHasLargeNumberOfCells, inMemoryAggregate.getName())));
        }
        long totalSize = 0L;
        for (Aggregate aggregate : inMemoryAggregates) {
            totalSize += aggregate.getEstimatedSize();
            if (this.aggregateAdvisor.isAggregateSmallRelativetoFact(aggregate)) continue;
            currentMessages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorInMemoryAggregateIsLargeComparedToFact, aggregate.getName())));
        }
        if (totalSize > this.requestParameters.getInMemoryAggregatesLimit()) {
            currentMessages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorInMemoryAggregatesExceedInMemoryCacheLimit, String.valueOf(totalSize), String.valueOf(this.requestParameters.getInMemoryAggregatesLimit()))));
        }
    }

    private void executeRecommendationStrategies(List<Aggregate> aggregates) {
        UserDefinedAggregatesStrategy userDefinedAggregatesStrategy = new UserDefinedAggregatesStrategy(this.metaCube, this.aggregateAdvisor);
        userDefinedAggregatesStrategy.recommendAggregates(aggregates);
        if (this.aggregateAdvisor.getRequestParameters().getUserDefinedAggregatesOnly()) {
            if (this.requestParameters.getInDatabaseAggregatesLimit() > 0L) {
                ModelBasedLowerSlicesStrategy lowerStrategy = new ModelBasedLowerSlicesStrategy(this.metaCube, this.aggregateAdvisor);
                lowerStrategy.recommendAggregates(aggregates);
            }
            return;
        }
        LastAggregateLoadStrategy lastAggregateLoadStrategy = new LastAggregateLoadStrategy(this.metaCube, this.aggregateAdvisor);
        lastAggregateLoadStrategy.recommendAggregates(aggregates);
        this.aggregateAdvisor.adjustSliceCardinalityMetricsBasedOnFactChange();
        if (this.requestParameters.getIncludeWorkloadInfo()) {
            if (this.aggregateAdvisor.isCubeAutonomic()) {
                AutonomicStrategy autonomicStrategy = new AutonomicStrategy(this.metaCube, this.aggregateAdvisor);
                autonomicStrategy.recommendAggregates(aggregates);
            } else {
                WorkloadBasedStrategy strategy = new WorkloadBasedStrategy(this.metaCube, this.aggregateAdvisor);
                strategy.recommendAggregates(aggregates);
                this.aggregateAdvisor.getWorkloadSummary().tearDown();
            }
        }
        if (this.aggregateAdvisor.getRequestParameters().getUseWorkloadOnly()) {
            INFO_LOGGER.log("Requested to only analyze workload. Do not recommend aggregates based on the model (high aggregates).");
        } else {
            ModelBasedUpperSlicesStrategy upperStrategy = new ModelBasedUpperSlicesStrategy(this.metaCube, this.aggregateAdvisor);
            upperStrategy.recommendAggregates(aggregates);
        }
        ModelBasedLowerSlicesStrategy lowerStrategy = new ModelBasedLowerSlicesStrategy(this.metaCube, this.aggregateAdvisor);
        lowerStrategy.recommendAggregates(aggregates);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(String sessionID, AdvisorCancelReason cancelReason) {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.getCubeName());
        try {
            INFO_LOGGER.log(String.format("Stop advisor process associated with session %s began.", sessionID));
            this.stopLock.lockInterruptibly();
            try {
                if (!this.getState().isDone()) {
                    this.advisorCancelHandler.cancelAdvisor(cancelReason);
                    if (cancelReason == AdvisorCancelReason.RUN_TIME_LIMIT_REACHED || cancelReason == AdvisorCancelReason.STOP_REQUEST) {
                        this.postRecommendationSteps();
                    }
                    this.setCompletedPostRecommendationSteps(true);
                } else {
                    INFO_LOGGER.log("The advisor is already stopped.");
                }
                INFO_LOGGER.log(String.format("Stop advisor process associated with session %s ended.", sessionID));
            }
            finally {
                this.stopLock.unlock();
            }
        }
        catch (Exception ex) {
            INFO_LOGGER.log(String.format("Stop advisor process associated with session %s failed.", sessionID), (Throwable)ex);
            throw XQERuntimeException.wrap(ex);
        }
        finally {
            traceContext.exit();
        }
    }

    public synchronized void setStoreBackupResults(boolean save) {
        this.bSaveBackupResults = save;
    }

    protected void setAggregateAdvisor(AggregateAdvisor anAggregateAdvisor) {
        this.aggregateAdvisor = anAggregateAdvisor;
    }

    private synchronized void storeBackupResults() {
        try {
            AdvisorRecommendations recs = this.getRecommendations();
            if (this.bSaveBackupResults && recs != null) {
                AdvisorGetRecommendationResult result = new AdvisorGetRecommendationResult(AggregateAdvisorState.COMPLETED, this.options, this.properties, null, recs, AdvisorManager.getFinalMessage(this), this.getMessages());
                String cubeName = this.getCubeName();
                String recommendationID = this.getProperty(AggregateAdvisorPropertyName.RECOMMENDATION_ID);
                String userID = this.getProperty(AggregateAdvisorPropertyName.USER_ID);
                boolean isAutonomicRecommendation = "IBM_System".equals(userID);
                if (isAutonomicRecommendation) {
                    RecommendationFileUtility.deleteAutonomicRecommendationFiles(cubeName);
                }
                RecommendationFileUtility.storeRecommendation(cubeName, recommendationID, isAutonomicRecommendation, result);
                this.setStoreBackupResults(false);
                INFO_LOGGER.log("Completed backup of advisor results.");
            }
        }
        catch (Exception e) {
            ROLAPLog.logError("ROLAPAggregateAdvisor", "Advisor encountered unexpected error when backing up results to file: ", e);
        }
    }

    private boolean initializeWorkloadSummary() {
        if (this.unitTestParameters.getWorkloadSummary() != null) {
            this.aggregateAdvisor.setWorkloadSummary(this.unitTestParameters.getWorkloadSummary());
            return true;
        }
        WorkloadSummary workloadSummary = new WorkloadSummary();
        this.aggregateAdvisor.setWorkloadSummary(workloadSummary);
        if (this.unitTestParameters.getWorkloadDirectory().length() > 0) {
            workloadSummary.setTestMode(this.unitTestParameters.getWorkloadDirectory());
        }
        boolean haveWorkload = false;
        INFO_LOGGER.log("Initialize workload.");
        boolean initialized = false;
        try {
            initialized = workloadSummary.initialize(this.cube.getName(), this.requestParameters);
            if (!initialized) {
                INFO_LOGGER.log("Initialize workload failed.");
                this.messages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_Advisor_NoWorkloadExists)));
            } else if (!workloadSummary.containsWorkloads()) {
                INFO_LOGGER.log("Initialize workload succeeded but there is no information to analyze.");
                this.messages.add(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_Advisor_NoWorkloadEmpty)));
            } else {
                INFO_LOGGER.log("Initialize workload succeeded and there is information to analyze.");
                haveWorkload = true;
            }
        }
        catch (XQERuntimeException ex) {
            this.messages.add(Advisor.buildNotification(ex));
        }
        return haveWorkload;
    }

    public String getCubeName() {
        String cubeName = null;
        if (null != this.cube) {
            cubeName = this.cube.getName();
        }
        return cubeName;
    }

    public List<XQERuntimeException> getMessages() {
        return this.messages;
    }

    public static XQERuntimeException buildError(Exception ex) {
        INFO_LOGGER.log(LogLevel.ERROR, (Throwable)ex);
        if (ex instanceof XQERuntimeException) {
            return new XQERuntimeException(XQEMessageKeys.ROL_AdvisorInternalError, (Throwable)ex, ex.getLocalizedMessage());
        }
        return new XQERuntimeException(XQEMessageKeys.ROL_AdvisorInternalError, (Throwable)ex, XQEException.getStackTraceString(ex));
    }

    public static XQERuntimeException buildNotification(XQERuntimeException ex) {
        return new XQERuntimeException(XQEMessageKeys.ROL_AdvisorMessage, (Throwable)ex, ex.getLocalizedMessage());
    }

    private void captureAdvancedSettings() {
        try {
            ROLAPConfiguration rolapConfiguration = new ROLAPConfiguration();
            this.requestParameters.setMaxWorkloadQueriesToConsider(rolapConfiguration.getAdvisorMaxNumberWorkloadQueriesConsidered());
            this.requestParameters.setMaxNumberOfInMemoryAggregates(rolapConfiguration.getAdvisorMaxNumberInMemoryAggregates());
            this.requestParameters.setMaxNumberOfInDatabaseAggregates(rolapConfiguration.getAdvisorMaxNumberInDBAggregates());
            this.requestParameters.setEnableTestFeatures(rolapConfiguration.isAdvisorEnableTestFeatures());
            this.requestParameters.setIncludeAllAdditiveMeasures(rolapConfiguration.isAdvisorConsolidateAggregatesMore());
            this.requestParameters.setExcludeNonAdditiveMeasures(rolapConfiguration.isAdvisorExcludeNonAdditiveMeasures());
            this.requestParameters.setInMemoryAggregatesMustMatchInDatabaseAggregates(ConfigurationValues.getBoolean("qsAutomaticAggregateOptimizationMatchInDatabaseAggregates", false));
            this.requestParameters.setMaxNumberOfInMemoryAggregateCells(rolapConfiguration.getAdvisorMaxNumberOfInMemoryAggregateCells());
        }
        catch (Exception e) {
            INFO_LOGGER.log("Could not get configuration Advanced Settings. Will use defaults.", (Throwable)e);
        }
    }

    private void captureUserOptions() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nAdvisor input options: \n");
        if (this.options != null) {
            for (Map.Entry<String, String> element : this.options.entrySet()) {
                sb.append(element.getKey() + EQUALS_SEPARATOR + element.getValue() + '\n');
            }
        }
        INFO_LOGGER.log(sb.toString());
        if (this.options != null) {
            String value = "";
            value = this.options.get(AggregateAdvisorOptionName.INCLUDE_WORKLOAD_INFO.toString());
            if (value != null && value.compareTo(TRUE_STR) == 0) {
                this.requestParameters.setIncludeWorkloadInfo(true);
            }
            if ((value = this.options.get(AggregateAdvisorOptionName.USE_WORKLOAD_ONLY.toString())) != null && value.compareTo(TRUE_STR) == 0) {
                this.requestParameters.setUseWorkloadOnly(true);
                this.requestParameters.setIncludeWorkloadInfo(true);
            }
            if ((value = this.options.get(AggregateAdvisorOptionName.USER_DEFINED_AGGREGATES_ONLY.toString())) != null && value.compareTo(TRUE_STR) == 0) {
                this.requestParameters.setUserDefinedAggregatesOnly(true);
            }
            if ((value = this.options.get(AggregateAdvisorOptionName.IN_MEMORY_AGGREGATES_LIMIT.toString())) != null) {
                try {
                    long lValue = Long.parseLong(value);
                    if (lValue < AggregateAdvisorOptionValueConstraintLong.IN_MEMORY_AGGREGATES_LIMIT.getMinValue()) {
                        lValue = AggregateAdvisorOptionValueConstraintLong.IN_MEMORY_AGGREGATES_LIMIT.getMinValue();
                    }
                    this.requestParameters.setInMemoryAggregatesLimit(lValue);
                }
                catch (NumberFormatException lValue) {
                    // empty catch block
                }
            }
            if ((value = this.options.get(AggregateAdvisorOptionName.IN_DATABASE_AGGREGATES_LIMIT.toString())) != null) {
                try {
                    long lValue = Long.parseLong(value);
                    if (lValue < AggregateAdvisorOptionValueConstraintLong.IN_DATABASE_AGGREGATES_LIMIT.getMinValue()) {
                        lValue = AggregateAdvisorOptionValueConstraintLong.IN_DATABASE_AGGREGATES_LIMIT.getMinValue();
                    }
                    this.requestParameters.setInDatabaseAggregatesLimit(lValue);
                }
                catch (NumberFormatException lValue) {
                    // empty catch block
                }
            }
            if ((value = this.options.get(AggregateAdvisorOptionName.RUN_TIME_LIMIT.toString())) != null) {
                try {
                    int lValue = Integer.parseInt(value);
                    if (lValue < AggregateAdvisorOptionValueConstraintInt.RUN_TIME_LIMIT.getMinValue()) {
                        lValue = AggregateAdvisorOptionValueConstraintInt.RUN_TIME_LIMIT.getMinValue();
                    }
                    this.requestParameters.setRunTimeLimit(lValue);
                }
                catch (NumberFormatException lValue) {
                    // empty catch block
                }
            }
            if (this.requestParameters.getIncludeWorkloadInfo()) {
                StringTokenizer tokenizer;
                value = this.options.get(AggregateAdvisorOptionName.START_TIME.toString());
                if (value != null) {
                    try {
                        long lValue = Long.parseLong(value);
                        if (lValue < AggregateAdvisorOptionValueConstraintLong.START_TIME.getMinValue()) {
                            lValue = AggregateAdvisorOptionValueConstraintLong.START_TIME.getMinValue();
                        }
                        this.requestParameters.setStartTime(lValue);
                    }
                    catch (NumberFormatException lValue) {
                        // empty catch block
                    }
                }
                if ((value = this.options.get(AggregateAdvisorOptionName.END_TIME.toString())) != null) {
                    try {
                        long lValue = Long.parseLong(value);
                        if (lValue < AggregateAdvisorOptionValueConstraintLong.END_TIME.getMinValue()) {
                            lValue = AggregateAdvisorOptionValueConstraintLong.END_TIME.getMinValue();
                        }
                        this.requestParameters.setEndTime(lValue);
                    }
                    catch (NumberFormatException lValue) {
                        // empty catch block
                    }
                }
                if ((value = this.options.get(AggregateAdvisorOptionName.DAYS_OF_THE_WEEK.toString())) != null) {
                    try {
                        int lValue = Integer.parseInt(value);
                        if (lValue < AggregateAdvisorOptionValueConstraintInt.DAYS_OF_THE_WEEK.getMinValue()) {
                            lValue = AggregateAdvisorOptionValueConstraintInt.DAYS_OF_THE_WEEK.getMinValue();
                        }
                        this.requestParameters.setDaysOfTheWeek(lValue);
                    }
                    catch (NumberFormatException lValue) {
                        // empty catch block
                    }
                }
                if ((value = this.options.get(AggregateAdvisorOptionName.REPORT_USAGE.toString())) != null) {
                    try {
                        int lValue = Integer.parseInt(value);
                        if (lValue < AggregateAdvisorOptionValueConstraintInt.REPORT_USAGE.getMinValue()) {
                            lValue = AggregateAdvisorOptionValueConstraintInt.REPORT_USAGE.getMinValue();
                        }
                        this.requestParameters.setReportUsage(lValue);
                    }
                    catch (NumberFormatException lValue) {
                        // empty catch block
                    }
                }
                String semiColon = ";";
                value = this.options.get(AggregateAdvisorOptionName.REPORT_NAMES.toString());
                if (value != null) {
                    tokenizer = new StringTokenizer(value, ";");
                    while (tokenizer.hasMoreTokens()) {
                        this.requestParameters.addReportName(tokenizer.nextToken());
                    }
                }
                if ((value = this.options.get(AggregateAdvisorOptionName.PACKAGE_NAMES.toString())) != null) {
                    tokenizer = new StringTokenizer(value, ";");
                    while (tokenizer.hasMoreTokens()) {
                        this.requestParameters.addPackageName(tokenizer.nextToken());
                    }
                }
                if ((value = this.options.get(AggregateAdvisorOptionName.USER_NAMES.toString())) != null) {
                    tokenizer = new StringTokenizer(value, ";");
                    while (tokenizer.hasMoreTokens()) {
                        this.requestParameters.addUserName(tokenizer.nextToken());
                    }
                }
            }
        }
    }

    public AdvisorCancelHandler getAdvisorCancelHandler() {
        return this.advisorCancelHandler;
    }

    public AdvisorRecommendations getRecommendations() {
        return this.recommendations;
    }

    private void setRecommendations(AdvisorRecommendations theRecommendations) {
        this.recommendations = theRecommendations;
    }

    public void startProgressTimer() {
        this.progressStopWatch.start();
        this.progressTimer = new AdvisorProgressTimer();
        this.progressTimer.runProgressTimer();
    }

    public void stopProgressTimer() {
        this.progressTimer.stopProgressTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AggregateAdvisorProgressPoint> getProgressPoints() {
        ArrayList<AggregateAdvisorProgressPoint> progressPoints = new ArrayList<AggregateAdvisorProgressPoint>();
        List<AggregateAdvisorProgressPoint> list = this.progress;
        synchronized (list) {
            int numOfPoints = this.progress.size() - this.lastProgressPointIndexReturned;
            if (numOfPoints > 0) {
                int fromIndex = this.lastProgressPointIndexReturned;
                this.lastProgressPointIndexReturned = this.progress.size();
                progressPoints.addAll(this.progress.subList(fromIndex, this.lastProgressPointIndexReturned));
            }
        }
        return progressPoints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProgressPoint(AggregateAdvisorProgressPoint progressPoint) {
        List<AggregateAdvisorProgressPoint> list = this.progress;
        synchronized (list) {
            this.progress.add(progressPoint);
        }
    }

    public final class AdvisorProgressTimer {
        private ScheduledExecutorService schedExecService = Executors.newScheduledThreadPool(1);
        private ScheduledFuture<?> schedFuture = null;

        public void runProgressTimer() {
            Runnable doProgress = new Runnable(){

                @Override
                public void run() {
                    AdvisorProgressTimer.this.addProgress();
                    if (Advisor.this.getState() == AggregateAdvisorState.COMPLETED && AdvisorProgressTimer.this.schedFuture != null) {
                        AdvisorProgressTimer.this.schedFuture.cancel(true);
                        INFO_LOGGER.log("Advisor complete, stop progress timer.");
                    }
                }
            };
            long initialDelay = 1L;
            long period = 3L;
            this.schedFuture = this.schedExecService.scheduleAtFixedRate(doProgress, 1L, 3L, TimeUnit.SECONDS);
        }

        public void stopProgressTimer() {
            this.addProgress();
            if (this.schedFuture != null) {
                this.schedFuture.cancel(true);
                INFO_LOGGER.log("Received request to stop progress timer.");
            }
            this.schedExecService.shutdownNow();
        }

        private void addProgress() {
            int time = (int)Advisor.this.progressStopWatch.getElapsedTimeInSeconds();
            int timeDivisor = 5;
            int timeValue = time / 5 + 1;
            int value = timeValue + Advisor.this.aggregateAdvisor.getProgessValue();
            Advisor.this.addProgressPoint(new AggregateAdvisorProgressPoint(time, value));
        }
    }
}

