/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorOptionName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorPropertyName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorRecommendationSource;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.exception.XQEException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Advisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRecommendTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRecommendations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelHandler;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelReason;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCommandResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorGetCurrentWorkloadResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorGetRecommendationResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorRetrieveInitialRecommendationsResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorRetrieveSubsequentRecommendationsResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorStoreRecommendationResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.recommendation.RecommendationFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.dom4j.Element;

public class AdvisorManager {
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");
    private static final String INFO_LOG_MSG_WORKLOAD_DATA = "AdvisorManager.getCurrentWorkloadForAggregateAdvisor for cube name %s";
    private static final String COMMUNICATION_ERROR_MESSAGE_CLIENT_DID_NOT_PROVIDE_CUBE_NAME = "The client did not provide the cube name.";
    private static final String COMMUNICATION_ERROR_MESSAGE_CLIENT_DID_NOT_PROVIDE_RECOMMENDATIONS = "The client did not provide the set of recommendations.";
    private ROLAPConfiguration rolapConfiguration = new ROLAPConfiguration();
    private Map<String, String> sessionIDToRecommendationIDMap = new ConcurrentHashMap<String, String>();
    private Map<String, Advisor> recommendationIDToAdvisorMap = new ConcurrentHashMap<String, Advisor>();
    private Map<String, AdvisorCommandResult> sessionIDToCommandResultMap = new ConcurrentHashMap<String, AdvisorCommandResult>();
    private Map<Advisor, AtomicLong> advisorToLastSessionAccessTimeMap = new ConcurrentHashMap<Advisor, AtomicLong>();
    private static SingletonHelper<AdvisorManager> singletonHelper = new SingletonHelper<AdvisorManager>(){

        @Override
        protected AdvisorManager newInstance() {
            return new AdvisorManager();
        }

        @Override
        protected void initializeImpl(AdvisorManager theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(AdvisorManager theInstance) {
            theInstance.release();
        }
    };

    private void initialize() {
    }

    private void release() {
    }

    public static AdvisorManager getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    public AdvisorCommandResult startAdvisor(String sessionID, String cubeName, Properties properties, Map<String, String> options) {
        Advisor advisor = this.getAdvisor(sessionID, true);
        try {
            if (advisor == null) {
                ROLAPCube defaultCube = this.getDefaultCube(cubeName);
                String recommendationID = RecommendationFileUtility.generateRecommendationID();
                AdvisorManager.addProperties(properties, cubeName, System.currentTimeMillis(), sessionID, recommendationID, AggregateAdvisorRecommendationSource.SERVER.toString());
                advisor = AdvisorManager.createAdvisor((ROLAPBaseCube)defaultCube, properties, options);
                this.startAdvisorRecommendTask(advisor, sessionID);
                AdvisorCommandResult result = this.getAggregateRecommendationsResult(advisor);
                if (!advisor.getState().isDone()) {
                    this.storeAdvisor(sessionID, recommendationID, advisor);
                }
                return result;
            }
            return new AdvisorCommandResult(advisor.getState(), Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorHasBeenStarted)));
        }
        catch (Exception e) {
            this.removeAdvisor(sessionID);
            return new AdvisorCommandResult(AggregateAdvisorState.COMPLETED, Advisor.buildError(e));
        }
    }

    private ROLAPCube getDefaultCube(String cubeName) {
        String advisorCubeName;
        ROLAPCube defaultCube = AdvisorManager.getROLAPCube(cubeName);
        if (!cubeName.equals(defaultCube.getName(advisorCubeName = defaultCube.getName(defaultCube.getDefaultLocale())))) {
            defaultCube = AdvisorManager.getROLAPCube(advisorCubeName);
        }
        return defaultCube;
    }

    public AdvisorCommandResult getAggregateRecommendations(String sessionID) {
        Advisor advisor = this.getAdvisor(sessionID, true);
        if (advisor != null) {
            try {
                AdvisorCommandResult result = this.getAggregateRecommendationsResult(advisor);
                if (result.getState() == AggregateAdvisorState.COMPLETED) {
                    this.removeAdvisor(sessionID);
                }
                return result;
            }
            catch (Exception e) {
                this.removeAdvisor(sessionID);
                return new AdvisorCommandResult(AggregateAdvisorState.COMPLETED, Advisor.buildError(e));
            }
        }
        return new AdvisorCommandResult(AggregateAdvisorState.COMPLETED, Advisor.buildError(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorNotExists)));
    }

    protected WorkloadParser createWorkloadParser() {
        return new WorkloadParser();
    }

    public AdvisorCommandResult getCurrentWorkloadForAggregateAdvisor(String cubeName) {
        INFO_LOGGER.log("AdvisorManager.getCurrentWorkloadForAggregateAdvisor for cube name " + cubeName + ".");
        AdvisorGetCurrentWorkloadResult result = new AdvisorGetCurrentWorkloadResult(AggregateAdvisorState.COMPLETED);
        ROLAPCube cube = AdvisorManager.getROLAPCube(cubeName);
        if (cube.isAutonomicAggregateOptimizationEnabled()) {
            result.addUserName("IBM_System");
            return result;
        }
        WorkloadParser logParser = this.createWorkloadParser();
        if (logParser.initializeParsing(cube.getName(cube.getDefaultLocale()))) {
            HashSet<String> uniquePackageNames = new HashSet<String>();
            HashSet<String> uniqueReportNames = new HashSet<String>();
            HashSet<String> uniqueUserNames = new HashSet<String>();
            List<WorkloadParser.WorkloadReportTraceData> reportTraces = logParser.getReportTraces();
            Date startTime = null;
            Date endTime = null;
            Date workloadTime = null;
            for (WorkloadParser.WorkloadReportTraceData data : reportTraces) {
                uniquePackageNames.add(data.getPackageName());
                uniqueReportNames.add(data.getReportName());
                uniqueUserNames.add(data.getUserName());
                workloadTime = data.getDateTime();
                if (null == startTime) {
                    startTime = workloadTime;
                } else if (workloadTime.before(startTime)) {
                    startTime = workloadTime;
                }
                if (null == endTime) {
                    endTime = workloadTime;
                    continue;
                }
                if (!workloadTime.after(endTime)) continue;
                endTime = workloadTime;
            }
            INFO_LOGGER.log(String.format("AdvisorManager.getCurrentWorkloadForAggregateAdvisor for cube name %s.  Package names are: %s", cubeName, ((Object)uniquePackageNames).toString()));
            for (String uniquePackageName : uniquePackageNames) {
                result.addPackageName(uniquePackageName);
            }
            INFO_LOGGER.log(String.format("AdvisorManager.getCurrentWorkloadForAggregateAdvisor for cube name %s.  Report names are: %s", cubeName, ((Object)uniqueReportNames).toString()));
            for (String uniqueReportName : uniqueReportNames) {
                result.addReportName(uniqueReportName);
            }
            INFO_LOGGER.log(String.format("AdvisorManager.getCurrentWorkloadForAggregateAdvisor for cube name %s.  User names are: %s", cubeName, ((Object)uniqueUserNames).toString()));
            for (String uniqueUserName : uniqueUserNames) {
                result.addUserName(uniqueUserName);
            }
            if (reportTraces.size() > 1) {
                if (null != startTime) {
                    INFO_LOGGER.log(String.format("AdvisorManager.getCurrentWorkloadForAggregateAdvisor for cube name %s.  Start date is %s", cubeName, startTime.toString()));
                    result.setStartTime(startTime.getTime());
                }
                if (null != endTime) {
                    INFO_LOGGER.log(String.format("AdvisorManager.getCurrentWorkloadForAggregateAdvisor for cube name %s.  End date is %s", cubeName, endTime.toString()));
                    result.setEndTime(endTime.getTime());
                }
            }
        }
        logParser.tearDown();
        return result;
    }

    public AdvisorCommandResult stopAdvisor(String sessionID, boolean getRecommendations) {
        Advisor advisor = this.getAdvisor(sessionID, true);
        if (advisor != null) {
            try {
                AggregateAdvisorState stateBeforeStop = advisor.getState();
                AdvisorCancelReason cancelReason = null;
                cancelReason = getRecommendations ? AdvisorCancelReason.STOP_REQUEST : AdvisorCancelReason.CANCEL_REQUEST;
                advisor.stop(sessionID, cancelReason);
                AdvisorGetRecommendationResult result = null;
                if (getRecommendations) {
                    if (!stateBeforeStop.isOptimizing() && !stateBeforeStop.isDone()) {
                        ROLAPLog.log("ROLAPAggregateAdvisor", "Contrary to protocol, the aggregate advisor client requested that the advisor stop before the advisor generated an initial set of recommendations.  There may not be any recommendations returned.");
                    }
                    result = new AdvisorGetRecommendationResult(AggregateAdvisorState.COMPLETED, advisor.getOptions(), advisor.getProperties(), advisor.getProgressPoints(), advisor.getRecommendations(), AdvisorManager.getFinalMessage(advisor), advisor.getMessages());
                } else {
                    result = new AdvisorGetRecommendationResult(AggregateAdvisorState.COMPLETED, advisor.getOptions(), advisor.getProperties(), null, AdvisorManager.getFinalMessage(advisor));
                }
                this.removeAdvisor(sessionID);
                return result;
            }
            catch (Exception e) {
                this.removeAdvisor(sessionID);
                return new AdvisorCommandResult(AggregateAdvisorState.COMPLETED, Advisor.buildError(e));
            }
        }
        return new AdvisorCommandResult(AggregateAdvisorState.COMPLETED, Advisor.buildError(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorNotExists)));
    }

    public AdvisorCommandResult retrieveInitialAggregateAdvisorRecommendations(String sessionID, Map<String, String> options) {
        AdvisorCommandResult result = null;
        try {
            String userID = options.get(AggregateAdvisorOptionName.USER_ID.toString());
            INFO_LOGGER.log(String.format("Retrieving the initial set of recommendations for session %s (user %s)", sessionID, userID));
            result = this.getCommandResult(sessionID);
            if (result == null) {
                List<AdvisorGetRecommendationResult> runningAdvisorResults = this.getRunningAdvisorResults(userID);
                List<String> runningAdvisorRecommendationIDs = AdvisorManager.getRecommendationIDs(runningAdvisorResults);
                List<File> recommendationFiles = RecommendationFileUtility.getRecommendationFiles(runningAdvisorRecommendationIDs);
                AdvisorRetrieveSubsequentRecommendationsResult resultToStore = new AdvisorRetrieveSubsequentRecommendationsResult(recommendationFiles);
                INFO_LOGGER.log(String.format("Storing the result containing %,d recommendation files for session %s", recommendationFiles.size(), sessionID));
                this.storeCommandResult(sessionID, resultToStore);
                result = new AdvisorRetrieveInitialRecommendationsResult(runningAdvisorResults);
            } else {
                INFO_LOGGER.log(String.format("Removing the result containing the recommendation files for session %s since the communication protocol is not being followed.", sessionID));
                this.removeCommandResult(sessionID);
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, "The client attempted to retrieve the initial set of recommendations again."));
            }
        }
        catch (Exception ex) {
            this.removeCommandResult(sessionID);
            String innerExceptionMessage = AdvisorManager.getExceptionMessage(ex);
            result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandFailed, (Throwable)ex, (Object)"retrieveInitialAggregateAdvisorRecommendations", (Object)innerExceptionMessage));
        }
        return result;
    }

    public AdvisorCommandResult retrieveSubsequentAggregateAdvisorRecommendations(String sessionID) {
        AdvisorCommandResult result = null;
        try {
            INFO_LOGGER.log(String.format("Retrieving the subsequent set of recommendations for session %s", sessionID));
            result = this.getCommandResult(sessionID);
            if (result != null) {
                if (result instanceof AdvisorRetrieveSubsequentRecommendationsResult) {
                    AdvisorRetrieveSubsequentRecommendationsResult retrieveSubsequentRecommendationsResult = (AdvisorRetrieveSubsequentRecommendationsResult)result;
                    retrieveSubsequentRecommendationsResult.determineRecommendationFilesToReturn();
                }
                if (result.getState().isDone()) {
                    INFO_LOGGER.log(String.format("Removing the result containing the recommendation files for session %s", sessionID));
                    this.removeCommandResult(sessionID);
                }
            } else {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, "The client attempted to retrieve a subsequent set of recommendations before retrieving the initial set of recommendations."));
            }
        }
        catch (Exception ex) {
            this.removeCommandResult(sessionID);
            String innerExceptionMessage = AdvisorManager.getExceptionMessage(ex);
            result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandFailed, (Throwable)ex, (Object)"retrieveSubsequentAggregateAdvisorRecommendations", (Object)innerExceptionMessage));
        }
        return result;
    }

    public AdvisorCommandResult storeAggregateAdvisorRecommendation(String sessionID, Properties properties, Element recommendationsElement) {
        AdvisorCommandResult result = null;
        try {
            String cubeName = properties.getProperty(AggregateAdvisorPropertyName.CUBE_NAME.toString());
            if (cubeName == null || cubeName.isEmpty()) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, COMMUNICATION_ERROR_MESSAGE_CLIENT_DID_NOT_PROVIDE_CUBE_NAME));
            } else if (recommendationsElement == null || recommendationsElement.nodeCount() == 0) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, COMMUNICATION_ERROR_MESSAGE_CLIENT_DID_NOT_PROVIDE_RECOMMENDATIONS));
            } else {
                String recommendationID = RecommendationFileUtility.generateRecommendationID();
                AdvisorManager.addProperties(properties, cubeName, System.currentTimeMillis(), sessionID, recommendationID, AggregateAdvisorRecommendationSource.CLIENT.toString());
                ArrayList<String> messages = new ArrayList<String>();
                messages.add(new XQERuntimeException(XQEMessageKeys.ROL_RecommendationsWereSelectedByUser, properties.getProperty(AggregateAdvisorPropertyName.USER_ID.toString())).getLocalizedMessage());
                RecommendationFileUtility.storeRecommendation(cubeName, recommendationID, AggregateAdvisorState.COMPLETED, messages, null, properties, recommendationsElement);
                String recommendationFileName = RecommendationFileUtility.getRecommendationFileName(cubeName, recommendationID);
                File recommendationFile = new File(recommendationFileName);
                result = new AdvisorStoreRecommendationResult(AggregateAdvisorState.SUCCEEDED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandSucceeded, "storeAggregateAdvisorRecommendation"), recommendationFile);
            }
        }
        catch (Exception ex) {
            String innerExceptionMessage = AdvisorManager.getExceptionMessage(ex);
            result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandFailed, (Throwable)ex, (Object)"storeAggregateAdvisorRecommendation", (Object)innerExceptionMessage));
        }
        return result;
    }

    public AdvisorCommandResult migrateAggregateAdvisorRecommendation(String sessionID, String state, List<String> messages, Map<String, String> options, Properties properties, Element recommendationsElement) {
        AdvisorCommandResult result = null;
        try {
            String cubeName = properties.getProperty(AggregateAdvisorPropertyName.CUBE_NAME.toString());
            String startTime = properties.getProperty(AggregateAdvisorPropertyName.START_TIME.toString());
            AggregateAdvisorState aggregateAdvisorState = AggregateAdvisorState.getValue(state);
            if (cubeName == null || cubeName.isEmpty()) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, COMMUNICATION_ERROR_MESSAGE_CLIENT_DID_NOT_PROVIDE_CUBE_NAME));
            } else if (!AdvisorManager.isLong(startTime)) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, String.format("The client provided an invalid value (\"%s\") for the start time.", startTime)));
            } else if (aggregateAdvisorState == null) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, String.format("The client provided an invalid value (\"%s\") for the state.", state)));
            } else if (messages == null || messages.isEmpty()) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, "The client did not provide the messages."));
            } else if (recommendationsElement == null || recommendationsElement.nodeCount() == 0) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, COMMUNICATION_ERROR_MESSAGE_CLIENT_DID_NOT_PROVIDE_RECOMMENDATIONS));
            } else {
                String recommendationID = RecommendationFileUtility.generateRecommendationID();
                AdvisorManager.addProperties(properties, cubeName, Long.parseLong(startTime), sessionID, recommendationID, AggregateAdvisorRecommendationSource.CLIENT_SERVER.toString());
                RecommendationFileUtility.storeRecommendation(cubeName, recommendationID, aggregateAdvisorState, messages, options, properties, recommendationsElement);
                result = new AdvisorCommandResult(AggregateAdvisorState.SUCCEEDED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandSucceeded, "migrateAggregateAdvisorRecommendation"));
            }
        }
        catch (Exception ex) {
            String innerExceptionMessage = AdvisorManager.getExceptionMessage(ex);
            result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandFailed, (Throwable)ex, (Object)"migrateAggregateAdvisorRecommendation", (Object)innerExceptionMessage));
        }
        return result;
    }

    public AdvisorCommandResult updateAggregateAdvisorRecommendationName(String sessionID, String cubeName, String recommendationID, String recommendationName) {
        AdvisorCommandResult result = null;
        try {
            if (cubeName == null || cubeName.isEmpty()) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, COMMUNICATION_ERROR_MESSAGE_CLIENT_DID_NOT_PROVIDE_CUBE_NAME));
            } else if (recommendationID == null || recommendationID.isEmpty()) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, "The client did not provide the recommendation ID."));
            } else if (recommendationName == null || recommendationName.isEmpty()) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, "The client did not provide the recommendation name."));
            } else {
                INFO_LOGGER.log(String.format("Updating the name of the recommendation for the cube %s with id %s to %s", cubeName, recommendationID, recommendationName));
                String recommendationIDAssociatedWithSessionID = this.sessionIDToRecommendationIDMap.get(sessionID);
                Advisor advisor = this.recommendationIDToAdvisorMap.get(recommendationID);
                if (advisor == null) {
                    INFO_LOGGER.log("The recommendation to be updated is not in the process of being generated.");
                    RecommendationFileUtility.updateRecommendationName(cubeName, recommendationID, recommendationName);
                    result = new AdvisorCommandResult(AggregateAdvisorState.SUCCEEDED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandSucceeded, "updateAggregateAdvisorRecommendationName"));
                } else {
                    if (recommendationID.equals(recommendationIDAssociatedWithSessionID)) {
                        INFO_LOGGER.log("The recommendation to be updated is in the process of being generated for this session.");
                        this.updateLastSessionAccessTime(advisor);
                    } else {
                        INFO_LOGGER.log(String.format("The recommendation to be updated is in the process of being generated for another session, not the session with id %s.", sessionID));
                    }
                    advisor.updateRecommendationName(cubeName, recommendationID, recommendationName);
                    result = new AdvisorCommandResult(AggregateAdvisorState.SUCCEEDED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandSucceeded, "updateAggregateAdvisorRecommendationName"));
                }
            }
        }
        catch (Exception ex) {
            String innerExceptionMessage = AdvisorManager.getExceptionMessage(ex);
            result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandFailed, (Throwable)ex, (Object)"updateAggregateAdvisorRecommendationName", (Object)innerExceptionMessage));
        }
        return result;
    }

    public AdvisorCommandResult deleteAggregateAdvisorRecommendations(String cubeName, List<String> recommendationIDs) {
        AdvisorCommandResult result = null;
        try {
            if (cubeName == null || cubeName.isEmpty()) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, COMMUNICATION_ERROR_MESSAGE_CLIENT_DID_NOT_PROVIDE_CUBE_NAME));
            } else {
                INFO_LOGGER.log(String.format("Deleting the recommendations for the cube %s with ids %s", cubeName, recommendationIDs));
                for (String recommendationID : recommendationIDs) {
                    String recommendationFileName = RecommendationFileUtility.getRecommendationFileName(cubeName, recommendationID);
                    INFO_LOGGER.log(LogLevel.TRACE, String.format("Deleting the recommendation file %s", recommendationFileName));
                    boolean deleted = RecommendationFileUtility.deleteRecommendationFile(cubeName, recommendationID);
                    if (deleted) {
                        INFO_LOGGER.log(LogLevel.TRACE, String.format("Deleting the recommendation file %s succeeded.", recommendationFileName));
                        continue;
                    }
                    INFO_LOGGER.log(LogLevel.TRACE, String.format("Deleting the recommendation file %s failed.", recommendationFileName));
                }
                result = new AdvisorCommandResult(AggregateAdvisorState.SUCCEEDED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandSucceeded, "deleteAggregateAdvisorRecommendations"));
            }
        }
        catch (Exception ex) {
            String innerExceptionMessage = AdvisorManager.getExceptionMessage(ex);
            result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandFailed, (Throwable)ex, (Object)"deleteAggregateAdvisorRecommendations", (Object)innerExceptionMessage));
        }
        return result;
    }

    public AdvisorCommandResult replaceAggregateAdvisorSession(String oldSessionID, String newSessionID) {
        AdvisorCommandResult result = null;
        try {
            if (oldSessionID == null || oldSessionID.isEmpty()) {
                result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, "The client did not provide the ID of the session to replace."));
            } else {
                INFO_LOGGER.log(String.format("Replacing session %s with %s", oldSessionID, newSessionID));
                Advisor advisor = this.getAdvisor(oldSessionID, false);
                if (advisor == null) {
                    INFO_LOGGER.log(String.format("Replacing session %s with %s failed because session %s is not associated with an advisor.", oldSessionID, newSessionID, oldSessionID));
                    result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommunicationErrorDetected, String.format("The client requested to replace session %s with session %s but session %s is not associated with an advisor.", oldSessionID, newSessionID, oldSessionID)));
                } else {
                    String recommendationID = advisor.getProperty(AggregateAdvisorPropertyName.RECOMMENDATION_ID);
                    this.removeAdvisor(oldSessionID);
                    this.storeAdvisor(newSessionID, recommendationID, advisor);
                    advisor.setProperty(AggregateAdvisorPropertyName.SESSION_ID, newSessionID);
                    INFO_LOGGER.log(String.format("Replacing session %s with %s succeeded.", oldSessionID, newSessionID));
                    result = new AdvisorCommandResult(AggregateAdvisorState.SUCCEEDED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandSucceeded, "replaceAggregateAdvisorSession"));
                }
            }
        }
        catch (Exception ex) {
            String innerExceptionMessage = AdvisorManager.getExceptionMessage(ex);
            result = new AdvisorCommandResult(AggregateAdvisorState.FAILED, new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandFailed, (Throwable)ex, (Object)"replaceAggregateAdvisorSession", (Object)innerExceptionMessage));
        }
        return result;
    }

    private static ROLAPCube getROLAPCube(String cubeName) {
        ROLAPCubeManager cubeManager = ROLAPCubeManager.getInstance();
        ROLAPCube cube = cubeManager.getCube(cubeName);
        if (cube == null) {
            cubeManager.addCube(cubeName);
            cube = (ROLAPBaseCube)cubeManager.getCube(cubeName);
        }
        return cube;
    }

    public static XQERuntimeException getFinalMessage(Advisor advisor) {
        XQERuntimeException message = null;
        AdvisorCancelHandler advisorCancelHandler = advisor.getAdvisorCancelHandler();
        if (!advisorCancelHandler.isAdvisorThreadCanceled()) {
            String cubeName = advisor.getCubeName();
            AdvisorRecommendations finalRecommendations = advisor.getRecommendations();
            message = finalRecommendations == null || finalRecommendations.getAggregates().isEmpty() ? new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCompletedWithNoRecommendations, cubeName) : new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCompletedWithRecommendations, cubeName);
        } else {
            AdvisorCancelReason cancelReason = advisorCancelHandler.getAdvisorCancelReason();
            switch (cancelReason) {
                case CANCEL_REQUEST: {
                    message = new XQERuntimeException(XQEMessageKeys.ROL_AdvisorTerminatedDueToCancelRequest);
                    break;
                }
                case STOP_REQUEST: {
                    message = new XQERuntimeException(XQEMessageKeys.ROL_AdvisorTerminatedDueToStopRequest);
                    break;
                }
                case RUN_TIME_LIMIT_REACHED: {
                    message = new XQERuntimeException(XQEMessageKeys.ROL_AdvisorTerminatedDueToTimeLimit);
                    break;
                }
            }
        }
        return message;
    }

    public AdvisorCommandResult getAggregateRecommendationsResult(Advisor advisor) {
        AdvisorGetRecommendationResult result = null;
        AggregateAdvisorState state = advisor.getState();
        switch (state) {
            case STARTED: 
            case EXECUTING: 
            case OPTIMIZING: {
                result = new AdvisorGetRecommendationResult(state, advisor.getOptions(), advisor.getProperties(), advisor.getProgressPoints(), Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorIsRecommending)));
                break;
            }
            case COMPLETED: {
                result = new AdvisorGetRecommendationResult(state, advisor.getOptions(), advisor.getProperties(), advisor.getProgressPoints(), advisor.getRecommendations(), AdvisorManager.getFinalMessage(advisor), advisor.getMessages());
                break;
            }
        }
        return result;
    }

    private void startAdvisorRecommendTask(Advisor advisor, String sessionID) throws Exception {
        AdvisorRecommendTask recommendTask = new AdvisorRecommendTask(advisor, sessionID);
        ExecutorService executorService = Executors.newFixedThreadPool(1);
        try {
            executorService.submit(recommendTask);
            ROLAPLog.log("ROLAPAggregateAdvisor", String.format("The task that recommends aggregates for the cube %s and session %s was submitted for execution.", advisor.getCubeName(), sessionID));
        }
        catch (Exception ex) {
            ROLAPLog.logError("ROLAPAggregateAdvisor", String.format("The task that recommends aggregates for the cube %s and session %s can not be scheduled for execution.", advisor.getCubeName(), sessionID), ex);
            throw ex;
        }
    }

    private void storeAdvisor(String sessionID, String recommendationID, Advisor advisor) {
        this.sessionIDToRecommendationIDMap.put(sessionID, recommendationID);
        INFO_LOGGER.log(String.format("Added a mapping from session %s to recommendation %s", sessionID, recommendationID));
        this.recommendationIDToAdvisorMap.put(recommendationID, advisor);
        INFO_LOGGER.log(String.format("Added a mapping from recommendation %s to the advisor", recommendationID));
        this.storeLastSessionAccessTime(advisor);
    }

    private Advisor getAdvisor(String sessionID, boolean hasSessionID) {
        Advisor advisor = null;
        String recommendationID = this.sessionIDToRecommendationIDMap.get(sessionID);
        if (recommendationID != null) {
            advisor = this.recommendationIDToAdvisorMap.get(recommendationID);
        }
        if (advisor != null && hasSessionID) {
            this.updateLastSessionAccessTime(advisor);
        }
        return advisor;
    }

    private void removeAdvisor(String sessionID) {
        String recommendationID = this.sessionIDToRecommendationIDMap.get(sessionID);
        if (recommendationID != null) {
            Advisor advisor = this.recommendationIDToAdvisorMap.get(recommendationID);
            if (advisor != null) {
                this.removeLastSessionAccessTime(advisor);
            }
            this.recommendationIDToAdvisorMap.remove(recommendationID);
            INFO_LOGGER.log(String.format("Removed the mapping from recommendation %s to the advisor", recommendationID));
        }
        this.sessionIDToRecommendationIDMap.remove(sessionID);
        INFO_LOGGER.log(String.format("Removed the mapping from session %s to recommendation %s", sessionID, recommendationID));
    }

    private void storeLastSessionAccessTime(Advisor advisor) {
        AtomicLong lastSessionAccessTime = new AtomicLong(System.currentTimeMillis());
        this.advisorToLastSessionAccessTimeMap.put(advisor, lastSessionAccessTime);
        INFO_LOGGER.log(String.format("Added a mapping from the advisor (recommendation %s) to the last session access time", advisor.getProperty(AggregateAdvisorPropertyName.RECOMMENDATION_ID)));
    }

    private void updateLastSessionAccessTime(Advisor advisor) {
        AtomicLong lastSessionAccessTime = this.advisorToLastSessionAccessTimeMap.get(advisor);
        if (lastSessionAccessTime != null) {
            lastSessionAccessTime.set(System.currentTimeMillis());
        }
    }

    private boolean hasSessionTimedOut(Advisor advisor) {
        long sessionTimeout;
        boolean hasSessionTimedOut = false;
        long lastSessionAccessTime = this.getLastSessionAccessTime(advisor);
        long currentTime = System.currentTimeMillis();
        long sessionIdleTime = currentTime - lastSessionAccessTime;
        if (sessionIdleTime > (sessionTimeout = this.rolapConfiguration.getAdvisorSessionTimeoutInMs())) {
            hasSessionTimedOut = true;
        }
        INFO_LOGGER.log(String.format("The session associated with the advisor is %s, the advisor was last accessed by the session at %s, the current time is %s, the session was idle for %,d ms, and the session timeout is %,d ms.", advisor.getProperty(AggregateAdvisorPropertyName.SESSION_ID), lastSessionAccessTime, currentTime, sessionIdleTime, sessionTimeout));
        return hasSessionTimedOut;
    }

    private long getLastSessionAccessTime(Advisor advisor) {
        long valueToReturn = Long.MAX_VALUE;
        AtomicLong lastSessionAccessTime = this.advisorToLastSessionAccessTimeMap.get(advisor);
        if (lastSessionAccessTime != null) {
            valueToReturn = lastSessionAccessTime.get();
        }
        return valueToReturn;
    }

    private void removeLastSessionAccessTime(Advisor advisor) {
        this.advisorToLastSessionAccessTimeMap.remove(advisor);
        INFO_LOGGER.log(String.format("Removed the mapping from the advisor (recommendation %s) to the last session access time", advisor.getProperty(AggregateAdvisorPropertyName.RECOMMENDATION_ID)));
    }

    private void storeCommandResult(String sessionID, AdvisorCommandResult commandResult) {
        this.sessionIDToCommandResultMap.put(sessionID, commandResult);
    }

    private AdvisorCommandResult getCommandResult(String sessionID) {
        return this.sessionIDToCommandResultMap.get(sessionID);
    }

    private void removeCommandResult(String sessionID) {
        this.sessionIDToCommandResultMap.remove(sessionID);
    }

    private List<AdvisorGetRecommendationResult> getRunningAdvisorResults(String userID) {
        ArrayList<AdvisorGetRecommendationResult> results = new ArrayList<AdvisorGetRecommendationResult>();
        Collection<Advisor> advisors = this.recommendationIDToAdvisorMap.values();
        int advisorCount = advisors.size();
        INFO_LOGGER.log(String.format("Iteration of %,d advisors began", advisorCount));
        for (Advisor advisor : advisors) {
            AggregateAdvisorState state = advisor.getState();
            String userIDThatStartedAdvisor = advisor.getProperty(AggregateAdvisorPropertyName.USER_ID);
            String recommendationID = advisor.getProperty(AggregateAdvisorPropertyName.RECOMMENDATION_ID);
            INFO_LOGGER.log(String.format("Determining if info about the advisor (recommendation %s) should be returned", recommendationID));
            INFO_LOGGER.log(String.format("The state of the advisor is %s, and the user who started the advisor is %s.", new Object[]{state, userIDThatStartedAdvisor}));
            if (!state.isDone() && userIDThatStartedAdvisor.equals(userID) && this.hasSessionTimedOut(advisor)) {
                AdvisorGetRecommendationResult result = new AdvisorGetRecommendationResult(state, advisor.getOptions(), advisor.getProperties(), null, Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorIsRecommending)));
                results.add(result);
                INFO_LOGGER.log(String.format("Determined that info about the advisor (recommendation %s) should be returned", recommendationID));
                continue;
            }
            INFO_LOGGER.log(String.format("Determined that info about the advisor (recommendation %s) should not be returned", recommendationID));
        }
        INFO_LOGGER.log(String.format("Iteration of %,d advisors ended", advisorCount));
        return results;
    }

    private static List<String> getRecommendationIDs(List<AdvisorGetRecommendationResult> results) {
        ArrayList<String> recommendationIDs = new ArrayList<String>();
        for (AdvisorGetRecommendationResult result : results) {
            Properties properties = result.getProperties();
            String recommendationID = properties.getProperty(AggregateAdvisorPropertyName.RECOMMENDATION_ID.toString());
            recommendationIDs.add(recommendationID);
        }
        return recommendationIDs;
    }

    private static void addProperties(Properties properties, String cubeName, long startTime, String sessionID, String recommendationID, String recommendationSource) {
        properties.setProperty(AggregateAdvisorPropertyName.CUBE_NAME.toString(), cubeName);
        properties.setProperty(AggregateAdvisorPropertyName.START_TIME.toString(), String.valueOf(startTime));
        properties.setProperty(AggregateAdvisorPropertyName.SESSION_ID.toString(), sessionID);
        properties.setProperty(AggregateAdvisorPropertyName.RECOMMENDATION_ID.toString(), recommendationID);
        properties.setProperty(AggregateAdvisorPropertyName.RECOMMENDATION_SOURCE.toString(), recommendationSource);
        if (!properties.containsKey(AggregateAdvisorPropertyName.USER_ID.toString())) {
            properties.setProperty(AggregateAdvisorPropertyName.USER_ID.toString(), "Anonymous");
        }
        if (!properties.containsKey(AggregateAdvisorPropertyName.RECOMMENDATION_NAME.toString())) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS z");
            properties.setProperty(AggregateAdvisorPropertyName.RECOMMENDATION_NAME.toString(), String.format("%s - %s", cubeName, dateFormat.format(new Date(startTime))));
        }
    }

    private static Advisor createAdvisor(ROLAPBaseCube cube, Properties properties, Map<String, String> options) {
        Advisor advisor = new Advisor(cube, properties, options);
        if (cube.getConfigAutoAggrOptimizationEnum() == ROLAPCubeConfiguration.AutoAggrOptimization.On) {
            QuerySummaryInfoLog querySummaryInfoLog = null;
            WorkloadLogger workloadLogger = cube.getWorkloadLogger();
            if (workloadLogger instanceof QuerySummaryInfoLogger) {
                QuerySummaryInfoLogger querySummaryInfoLogger = (QuerySummaryInfoLogger)workloadLogger;
                querySummaryInfoLog = querySummaryInfoLogger.getQuerySummaryInfoLog();
            }
            if (querySummaryInfoLog == null || querySummaryInfoLog.isEmpty()) {
                try {
                    querySummaryInfoLog = QuerySummaryFileUtility.readQuerySummaryFile(AdvisorManager.getMetaCube(cube));
                }
                catch (Exception ex) {
                    INFO_LOGGER.log(LogLevel.WARN, "The summary information about queries could not be read from disk.", (Throwable)ex);
                }
            }
            advisor.setQuerySummaryInfoLog(querySummaryInfoLog);
        }
        advisor.setStoreBackupResults(true);
        return advisor;
    }

    private static ROLAPMetaCube getMetaCube(ROLAPBaseCube cube) throws Exception {
        ROLAPMetaCube metaCube = cube.getModelCube();
        if (metaCube == null) {
            ROLAPMetaCube[] rolapMetaCubes;
            String cubeName = cube.getName();
            ROLAPMetaMdSchema rolapMetaMdSchema = cube.loadSchema();
            for (ROLAPMetaCube rolapMetaCube : rolapMetaCubes = rolapMetaMdSchema.getCubes()) {
                if (!cubeName.equalsIgnoreCase(rolapMetaCube.getName())) continue;
                metaCube = rolapMetaCube;
                break;
            }
        }
        return metaCube;
    }

    private static String getExceptionMessage(Exception exception) {
        String exceptionMessage = null;
        exceptionMessage = exception instanceof XQERuntimeException ? exception.getLocalizedMessage() : XQEException.getStackTraceString(exception);
        return exceptionMessage;
    }

    private static boolean isLong(String string) {
        try {
            Long.parseLong(string);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }
}

