/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorEvent;
import java.text.DecimalFormat;
import java.util.HashMap;

public class AdvisorMetrics {
    public static final String TOTAL_ADVISOR_RUN = "TotalAdvisorRun";
    public static final String GET_FACT_CARDINALITY = "getFactCardinality";
    public static final String GET_SLICE_CARDINALITY = "getSliceCardinality";
    public static final String GET_LEVEL_CARDINALITY = "getLevelCardinality";
    public static final String SETUP_SAMPLING = "SetupSampling";
    public static final String USER_DEFINED_AGGREGATES_STRATEGY = "UserDefinedAggregatesStrategy";
    public static final String LAST_AGGREGATE_LOAD_STRATEGY = "LastAggregateLoadStrategy";
    public static final String AUTONOMIC_STRATEGY = "AutonomicStrategy";
    public static final String WORKLOAD_BASED_STRATEGY = "WorkloadBasedStrategy";
    public static final String MODEL_BASED_UPPER_SLICES_STRATEGY = "ModelBasedUpperSlicesStrategy";
    public static final String MODEL_BASED_LOWER_SLICES_STRATEGY = "ModelBasedLowerSlicesStrategy";
    public static final String CONSOLIDATE_AGGREGATES_STRATEGY = "ConsolidateAggregatesStrategy";
    public static final String DEEP_SLICES_CONSIDER_DIMENSION_SLICES = "considerDimensionSlices";
    public static final String DEEP_SLICES_CONSIDER_HIERARCHY_SLICES = "considerHierarchySlices";
    public static final String DEEP_SLICES_CONSIDER_UNCOVERED_AGGREGATES = "considerUncoveredAdditiveAggregates";
    public static final String DEEP_SLICES_GENERALIZE_CANDIDATE_AGGREGATES = "generalizeCandidateAggregates";
    public static final String DEEP_SLICES_STACK_AGGREGATES = "recommendStackedAggregates";
    public static final double THOUSAND = 1000.0;
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#,##0.000s");
    private static final String FORMAT_DESCRIPTION_TIME_COUNT = "%-32s %15s %,10d \n";
    private static final String FORMAT_DESCRIPTION_TIME = "%-32s %15s \n";
    private HashMap<String, AdvisorEvent> taskTime = new HashMap();
    private double dimensionSliceCoverage = 0.0;
    private double coverage = 0.0;

    public void logEvent(String eventKey, long time) {
        AdvisorEvent event = this.taskTime.get(eventKey);
        if (event == null) {
            event = new AdvisorEvent();
            this.taskTime.put(eventKey, event);
        }
        event.log(time);
    }

    public int getEventCount(String eventKey) {
        AdvisorEvent event = this.taskTime.get(eventKey);
        if (event == null) {
            event = new AdvisorEvent();
        }
        return event.getCount();
    }

    public double getEventTimeInSeconds(String eventKey) {
        AdvisorEvent event = this.taskTime.get(eventKey);
        if (event == null) {
            event = new AdvisorEvent();
        }
        return (double)event.getTime() / 1000.0;
    }

    public double getCoverage() {
        return this.coverage;
    }

    public void setCoverage(double newCoverage) {
        this.coverage = newCoverage;
    }

    public double getDimensionSliceCoverage() {
        return this.dimensionSliceCoverage;
    }

    public void setDimensionSliceCoverage(double newDimensionSliceCoverage) {
        this.dimensionSliceCoverage = newDimensionSliceCoverage;
    }

    public String toTraceString() {
        double totalTime = this.getEventTimeInSeconds(TOTAL_ADVISOR_RUN);
        double databaseTime = this.getEventTimeInSeconds(GET_FACT_CARDINALITY) + this.getEventTimeInSeconds(GET_SLICE_CARDINALITY) + this.getEventTimeInSeconds(GET_LEVEL_CARDINALITY);
        double advisorTime = totalTime - databaseTime;
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(FORMAT_DESCRIPTION_TIME, "Total Advisor time", TIME_FORMAT.format(totalTime)));
        sb.append(String.format(FORMAT_DESCRIPTION_TIME, "  Advisor specific time", TIME_FORMAT.format(advisorTime)));
        sb.append(String.format(FORMAT_DESCRIPTION_TIME, "  Database time", TIME_FORMAT.format(databaseTime)));
        sb.append(this.formatMetric(GET_FACT_CARDINALITY, "    Get fact cardinality"));
        sb.append(this.formatMetric(GET_SLICE_CARDINALITY, "    Get slice cardinality"));
        sb.append(this.formatMetric(GET_LEVEL_CARDINALITY, "    Get level cardinality"));
        sb.append('\n');
        double otherTime = totalTime - this.getEventTimeInSeconds(SETUP_SAMPLING) - this.getEventTimeInSeconds(AUTONOMIC_STRATEGY) - this.getEventTimeInSeconds(WORKLOAD_BASED_STRATEGY) - this.getEventTimeInSeconds(MODEL_BASED_UPPER_SLICES_STRATEGY) - this.getEventTimeInSeconds(MODEL_BASED_LOWER_SLICES_STRATEGY);
        sb.append(String.format(FORMAT_DESCRIPTION_TIME, "Time by phase", TIME_FORMAT.format(totalTime)));
        sb.append(this.formatMetric(SETUP_SAMPLING, "  Setup sampling"));
        sb.append(this.formatMetric(AUTONOMIC_STRATEGY, "  Autonomic strategy"));
        sb.append(this.formatMetric(WORKLOAD_BASED_STRATEGY, "  Workload based strategy"));
        sb.append(this.formatMetric(MODEL_BASED_UPPER_SLICES_STRATEGY, "  Upper slices strategy"));
        sb.append(this.formatMetric(MODEL_BASED_LOWER_SLICES_STRATEGY, "  Lower slices strategy"));
        sb.append(String.format(FORMAT_DESCRIPTION_TIME, "  Other activity", TIME_FORMAT.format(otherTime)));
        sb.append(this.formatMetric(CONSOLIDATE_AGGREGATES_STRATEGY, "Consolidate aggregates"));
        sb.append('\n');
        double otherDeepSlicesTime = this.getEventTimeInSeconds(MODEL_BASED_LOWER_SLICES_STRATEGY) - this.getEventTimeInSeconds(DEEP_SLICES_CONSIDER_DIMENSION_SLICES) - this.getEventTimeInSeconds(DEEP_SLICES_CONSIDER_HIERARCHY_SLICES) - this.getEventTimeInSeconds(DEEP_SLICES_CONSIDER_UNCOVERED_AGGREGATES) - this.getEventTimeInSeconds(DEEP_SLICES_STACK_AGGREGATES);
        sb.append(this.formatMetric(MODEL_BASED_LOWER_SLICES_STRATEGY, "Lower slices strategy"));
        sb.append(this.formatMetric(DEEP_SLICES_CONSIDER_DIMENSION_SLICES, "  Consider dimension slices"));
        sb.append(this.formatMetric(DEEP_SLICES_CONSIDER_HIERARCHY_SLICES, "  Consider hierarchy slices"));
        sb.append(this.formatMetric(DEEP_SLICES_CONSIDER_UNCOVERED_AGGREGATES, "  Consider uncovered candidates"));
        sb.append(this.formatMetric(DEEP_SLICES_STACK_AGGREGATES, "  Consider stacked candidates"));
        sb.append(String.format(FORMAT_DESCRIPTION_TIME, "  Other deep slice activity", TIME_FORMAT.format(otherDeepSlicesTime)));
        sb.append(this.formatMetric(DEEP_SLICES_GENERALIZE_CANDIDATE_AGGREGATES, "Generalize candidates"));
        sb.append('\n');
        sb.append("Model coverage \n");
        sb.append(String.format(FORMAT_DESCRIPTION_TIME, "  Dimension slice coverage", this.coverageAsString(this.dimensionSliceCoverage)));
        sb.append(String.format(FORMAT_DESCRIPTION_TIME, "  Hierarchy slice coverage", this.coverageAsString(this.coverage)));
        return sb.toString();
    }

    private String formatMetric(String metric, String description) {
        String text = this.getEventCount(metric) > 1 ? String.format(FORMAT_DESCRIPTION_TIME_COUNT, description, TIME_FORMAT.format(this.getEventTimeInSeconds(metric)), this.getEventCount(metric)) : String.format(FORMAT_DESCRIPTION_TIME, description, TIME_FORMAT.format(this.getEventTimeInSeconds(metric)));
        return text;
    }

    private String coverageAsString(double number) {
        return String.format("%.1f", number) + '%';
    }
}

