/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class AdvisorRequestParameters {
    private static final long ONE_GB = 0x40000000L;
    private static final long TEN_GB = 0x280000000L;
    private static final int SIXTY_MINS = 60;
    private boolean includeWorkloadInfo = false;
    private boolean useWorkloadOnly = false;
    private boolean userDefinedAggregatesOnly = false;
    private long inMemoryAggregatesLimit = 0x40000000L;
    private long inDatabaseAggregatesLimit = 0x280000000L;
    private int runTimeLimit = 60;
    private long startTime = 1L;
    private long endTime = System.currentTimeMillis();
    private int daysOfTheWeek = 0;
    private int reportUsage = Integer.MAX_VALUE;
    private List<String> reportNames = new ArrayList<String>();
    private List<String> packageNames = new ArrayList<String>();
    private List<String> userNames = new ArrayList<String>();
    private int maxNumberOfInMemoryAggregates = 50;
    private int maxNumberOfInDatabaseAggregates = 25;
    private int maxWorkloadQueriesToConsider = 100;
    private boolean includeAllAdditiveMeasures = false;
    private boolean enableTestFeatures = false;
    private boolean isExcludeNonAdditiveMeasures = false;
    private boolean inMemoryAggregatesMustMatchInDatabaseAggregates = false;
    private long maxNumberOfInMemoryAggregateCells;

    public void setIncludeWorkloadInfo(boolean flag) {
        this.includeWorkloadInfo = flag;
    }

    public boolean getIncludeWorkloadInfo() {
        return this.includeWorkloadInfo;
    }

    public void setUseWorkloadOnly(boolean flag) {
        this.useWorkloadOnly = flag;
    }

    public boolean getUseWorkloadOnly() {
        return this.useWorkloadOnly;
    }

    public void setUserDefinedAggregatesOnly(boolean flag) {
        this.userDefinedAggregatesOnly = flag;
    }

    public boolean getUserDefinedAggregatesOnly() {
        return this.userDefinedAggregatesOnly;
    }

    public long getInMemoryAggregatesLimit() {
        return this.inMemoryAggregatesLimit;
    }

    public void setInMemoryAggregatesLimit(long limit) {
        this.inMemoryAggregatesLimit = limit;
    }

    public boolean isInDatabaseAggregatesRequested() {
        return this.inDatabaseAggregatesLimit > 0L;
    }

    public long getInDatabaseAggregatesLimit() {
        return this.inDatabaseAggregatesLimit;
    }

    public void setInDatabaseAggregatesLimit(long limit) {
        this.inDatabaseAggregatesLimit = limit;
    }

    public int getRunTimeLimit() {
        return this.runTimeLimit;
    }

    public void setRunTimeLimit(int limit) {
        this.runTimeLimit = limit;
    }

    public Date getStartTime() {
        return new Date(this.startTime);
    }

    public void setStartTime(long time) {
        this.startTime = time;
    }

    public Date getEndTime() {
        return new Date(this.endTime);
    }

    public void setEndTime(long time) {
        this.endTime = time;
    }

    public boolean isFilterOnTimePeriod() {
        return this.startTime > 1L && this.endTime > 1L;
    }

    public int getDaysOfTheWeek() {
        return this.daysOfTheWeek;
    }

    public void setDaysOfTheWeek(int days) {
        this.daysOfTheWeek = days;
    }

    public boolean isFilterOnDaysOfTheWeek() {
        return this.daysOfTheWeek != 0;
    }

    public boolean isFilterOnDay(int dayMask) {
        return (this.daysOfTheWeek & dayMask) == dayMask;
    }

    public void setReportUsage(int numberOfReports) {
        this.reportUsage = numberOfReports;
    }

    public int getReportUsage() {
        return this.reportUsage;
    }

    public boolean isFilterOnReportUsage() {
        return this.reportUsage > 0 && this.reportUsage < Integer.MAX_VALUE;
    }

    public List<String> getReportNames() {
        return this.reportNames;
    }

    public void addReportName(String name) {
        this.reportNames.add(name);
    }

    public List<String> getPackageNames() {
        return this.packageNames;
    }

    public void addPackageName(String name) {
        this.packageNames.add(name);
    }

    public List<String> getUserNames() {
        return this.userNames;
    }

    public void addUserName(String name) {
        this.userNames.add(name);
    }

    public int getMaxNumberOfInMemoryAggregates() {
        return this.maxNumberOfInMemoryAggregates;
    }

    public void setMaxNumberOfInMemoryAggregates(int count) {
        this.maxNumberOfInMemoryAggregates = count = Math.max(count, 1);
    }

    public int getMaxNumberOfInDatabaseAggregates() {
        return this.maxNumberOfInDatabaseAggregates;
    }

    public void setMaxNumberOfInDatabaseAggregates(int count) {
        this.maxNumberOfInDatabaseAggregates = count = Math.max(count, 1);
    }

    public int getMaxWorkloadQueriesToConsider() {
        return this.maxWorkloadQueriesToConsider;
    }

    public void setMaxWorkloadQueriesToConsider(int count) {
        this.maxWorkloadQueriesToConsider = count = Math.max(count, 1);
    }

    public boolean getIncludeAllAdditiveMeasures() {
        return this.includeAllAdditiveMeasures;
    }

    public void setIncludeAllAdditiveMeasures(boolean flag) {
        this.includeAllAdditiveMeasures = flag;
    }

    public boolean isEnableTestFeatures() {
        return this.enableTestFeatures;
    }

    public void setEnableTestFeatures(boolean flag) {
        this.enableTestFeatures = flag;
    }

    public boolean isExcludeNonAdditiveMeasures() {
        return this.isExcludeNonAdditiveMeasures;
    }

    public void setExcludeNonAdditiveMeasures(boolean excludeNonAdditiveMeasures) {
        this.isExcludeNonAdditiveMeasures = excludeNonAdditiveMeasures;
    }

    public boolean isInMemoryAggregatesMustMatchInDatabaseAggregates() {
        return this.inMemoryAggregatesMustMatchInDatabaseAggregates;
    }

    public void setInMemoryAggregatesMustMatchInDatabaseAggregates(boolean flag) {
        this.inMemoryAggregatesMustMatchInDatabaseAggregates = flag;
    }

    public long getMaxNumberOfInMemoryAggregateCells() {
        return this.maxNumberOfInMemoryAggregateCells;
    }

    public void setMaxNumberOfInMemoryAggregateCells(long theMaxNumberOfInMemoryAggregateCells) {
        this.maxNumberOfInMemoryAggregateCells = theMaxNumberOfInMemoryAggregateCells;
    }
}

