/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.ICalculation;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQueryItem;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeConfiguration;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Advisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorMemberSample;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUnitTestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetricsFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeRegion;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadSummary;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.AggregateType;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.ExistingInDatabaseAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.LastAggregateLoadStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class AggregateAdvisor {
    private ROLAPBaseCube cube = null;
    private ROLAPMetaCube metaCube = null;
    private AdvisorUnitTestParameters unitTestParameters = new AdvisorUnitTestParameters();
    private WorkloadSummary workloadSummary = null;
    private AdvisorMetrics metrics = new AdvisorMetrics();
    private Advisor advisor = null;
    private AdvisorRequestParameters requestParameters = null;
    private LastAggregateLoadStrategy lastAggregateLoadStrategy;
    private AdvisorMemberSample advisorMemberSample = new AdvisorMemberSample();
    private SliceCombination entireCubeRegion = new SliceCombination();
    private SliceCombination optimizeCubeRegion = new SliceCombination();
    private static final int SEED = 0;
    private Random generator = new Random(0L);
    private Random generatorForExperimentalSlices = new Random(0L);
    private int progressValue = 0;
    private ROLAPMetaMeasure measureForGeneratedQueries = null;
    private ROLAPMetaHierarchy samplingHierarchy = null;
    private ROLAPMetaLevel samplingLevel = null;
    private int samplingHierarchyIndex = -1;
    private double[] interLevelExpansionRatio;
    private static final int NUM_SLICES_TO_TEST_SAMPLING_ON = 3;
    private CubeCardinalityMetrics cubeCardinalityMetrics = null;
    private List<ExistingInDatabaseAggregate> existingInDatabaseAggregates = new ArrayList<ExistingInDatabaseAggregate>();
    private List<ROLAPMetaMeasure> supportedMeasures = new ArrayList<ROLAPMetaMeasure>();
    private List<ROLAPMetaMeasure> additiveMeasures = new ArrayList<ROLAPMetaMeasure>();
    private List<Aggregate> sliceUsageAggregates = new ArrayList<Aggregate>();
    private List<Aggregate> rejectedAggregateSet = new ArrayList<Aggregate>();
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");
    private static final long IN_DATABASE_AGGREGATE_AVG_BYTES_PER_MEASURE = 10L;
    private static final long IN_DATABASE_AGGREGATE_AVG_OVERHEAD_PER_ROW = 50L;
    public static final long HUGE_CARDINALITY = 1000000000000000L;
    public static final long ERROR_GETTING_CARDINALITY = 10000000000000000L;
    public static final int SMALLEST_DATABASE_AGGREGATE_RATIO = 10000;
    private static final long SMALL_AGGREGATE_CARDINALITY = 10000L;
    protected static final int PROGRESS_VALUE_SLICE_CARDINALITY = 10;
    public static final int FACT_RATIO = 5;
    private static final int SMALL_FACT_CARDINALITY = 1000;
    private static final String DATE_STRING_UPPER = "DATE";
    private static final String TIME_STRING_UPPER = "TIME";
    private static final String DAY_LEVEL_IDENTIFIER = "time_days";
    private static final String COMMASPACE_STR = ", ";
    public static final String NRT_CUBE_INCLUDE_NON_ADDITIVE_MEASURES_JVM_PARAM = "includeNonAdditiveMeasuresForNRTCube";
    private static final String YES_STRING = "yes";
    private static final String NO_STRING = "no";

    public AggregateAdvisor(ROLAPBaseCube aCube, ROLAPMetaCube aMetaCube, Advisor anAdvisor, AdvisorRequestParameters theRequestParameters, AdvisorUnitTestParameters theUnitTestParameters) {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Aggregate Advisor constructor - begin"));
        this.cube = aCube;
        this.metaCube = aMetaCube;
        this.advisor = anAdvisor;
        this.requestParameters = theRequestParameters;
        if (theUnitTestParameters != null) {
            this.unitTestParameters = theUnitTestParameters;
        }
        this.metrics = new AdvisorMetrics();
        try {
            this.cubeCardinalityMetrics = CubeCardinalityMetricsFileUtility.readAdvisorMetrics(this.metaCube);
            this.cubeCardinalityMetrics.setFactCardinalityWhenAdvisorLastRan(this.cubeCardinalityMetrics.getFactCardinality());
            this.cubeCardinalityMetrics.setFactCardinality(0L);
            INFO_LOGGER.log("Read cube cardinality metrics file successfully");
        }
        catch (Exception e) {
            this.cubeCardinalityMetrics = new CubeCardinalityMetrics(this.metaCube);
            INFO_LOGGER.log("Failed to read cube cardinality metrics file");
        }
        this.initializeMeasures();
        this.measureForGeneratedQueries = this.selectMeasureForQueries();
        Aggregate aggregate = new Aggregate(this.metaCube);
        this.entireCubeRegion.copy(aggregate.getSliceId());
        this.optimizeCubeRegion.copy(aggregate.getSliceId());
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Aggregate Advisor constructor - end"));
    }

    public AdvisorRequestParameters getRequestParameters() {
        return this.requestParameters;
    }

    public AdvisorUnitTestParameters getUnitTestParameters() {
        return this.unitTestParameters;
    }

    public QuerySummaryInfoLog getQuerySummaryInfoLog() {
        return this.advisor.getQuerySummaryInfoLog();
    }

    public LastAggregateLoadStrategy getLastAggregateLoadStrategy() {
        return this.lastAggregateLoadStrategy;
    }

    public void setLastAggregateLoadStrategy(LastAggregateLoadStrategy theLastAggregateLoadStrategy) {
        this.lastAggregateLoadStrategy = theLastAggregateLoadStrategy;
    }

    public CubeCardinalityMetrics getCubeCardinalityMetrics() {
        return this.cubeCardinalityMetrics;
    }

    public AdvisorMetrics getMetrics() {
        return this.metrics;
    }

    public void setWorkloadSummary(WorkloadSummary theWorkloadSummary) {
        this.workloadSummary = theWorkloadSummary;
    }

    public WorkloadSummary getWorkloadSummary() {
        return this.workloadSummary;
    }

    public SliceCombination getOptimizationRegion() {
        return this.optimizeCubeRegion;
    }

    public boolean isCubeAutonomic() {
        return this.cube.getConfigAutoAggrOptimizationEnum() == ROLAPCubeConfiguration.AutoAggrOptimization.On || this.unitTestParameters.getAutonomic();
    }

    public int getProgessValue() {
        return this.progressValue;
    }

    public void setProgressValue(int theProgressValue) {
        this.progressValue = theProgressValue;
    }

    public ROLAPMetaMeasure selectMeasureForQueries() {
        ROLAPMetaMeasure queryMeasure = null;
        for (ROLAPMetaMeasure measure : this.metaCube.getMeasures()) {
            if (!this.isMeasureSupported(measure)) continue;
            if (this.isMeasureAdditive(measure)) {
                return measure;
            }
            queryMeasure = measure;
        }
        return queryMeasure;
    }

    public void determineFactRowCount() {
        INFO_LOGGER.log("Obtain fact row count.");
        HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
        stopWatch.start();
        long factRowCountCurrent = AdvisorUtils.getFactCardinality(this.advisor, this.metaCube, this.measureForGeneratedQueries);
        this.cubeCardinalityMetrics.setFactCardinality(factRowCountCurrent);
        long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
        this.metrics.logEvent("getFactCardinality", elapsedTime);
        long factRowCountPrior = this.cubeCardinalityMetrics.getFactCardinalityWhenAdvisorLastRan();
        long factRowCountDelta = factRowCountCurrent - factRowCountPrior;
        String msg = String.format("Fact cardinality: prior = %,d rows, current = %,d rows, delta = %,d, time = %.3f seconds. \n", factRowCountPrior, factRowCountCurrent, factRowCountDelta, (double)elapsedTime / 1000.0);
        INFO_LOGGER.log(msg);
        this.adjustSliceCardinalityMetricsBasedOnFactChange();
    }

    public void adjustSliceCardinalityMetricsBasedOnFactChange() {
        int oldSliceCardinalityCount = this.cubeCardinalityMetrics.getSliceCardinalityCount();
        this.cubeCardinalityMetrics.trimSliceCardinalitiesBasedOnFactSizeChange();
        int newSliceCardinalityCount = this.cubeCardinalityMetrics.getSliceCardinalityCount();
        int deltaSliceCardinalityCount = oldSliceCardinalityCount - newSliceCardinalityCount;
        if (deltaSliceCardinalityCount > 0) {
            INFO_LOGGER.log(String.format("Reduced slice cardinality cache from %,d to %,d entries", oldSliceCardinalityCount, newSliceCardinalityCount));
        }
    }

    public long getFactRowCount() {
        return this.cubeCardinalityMetrics.getFactCardinality();
    }

    public long getSliceCardinality(Aggregate aggregate, String caller) throws OperationCanceledException {
        long rows = 0L;
        SliceCombination sliceId = aggregate.getSliceId();
        if (this.cubeCardinalityMetrics.isSliceCardinalityKnown(sliceId)) {
            return this.cubeCardinalityMetrics.getSliceCardinality(sliceId);
        }
        if (this.isSamplingEnabled()) {
            rows = this.getEstimatedSliceCardinality(aggregate, caller);
            this.cubeCardinalityMetrics.setEstimatedSliceCardinality(sliceId, rows);
            rows = this.cubeCardinalityMetrics.getSliceCardinality(sliceId);
        } else {
            rows = this.getActualSliceCardinality(aggregate, caller);
            this.cubeCardinalityMetrics.setActualSliceCardinality(sliceId, rows);
        }
        return rows;
    }

    public long getActualSliceCardinality(Aggregate aggregate, String caller) throws OperationCanceledException {
        long rows = 0L;
        HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
        stopWatch.start();
        try {
            rows = AdvisorUtils.getSliceCardinality(this.advisor, this.metaCube, aggregate.getLevels(), this.measureForGeneratedQueries, null);
            long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
            this.metrics.logEvent("getSliceCardinality", elapsedTime);
            INFO_LOGGER.log(String.format("Get actual slice cardinality: %,d rows; %.3f seconds; caller=%s; id=%s; depth=%d; name=%s ", rows, (double)elapsedTime / 1000.0, caller, aggregate.getSliceId().valueToString(), aggregate.getSliceId().getNumberOfTurns(), aggregate.getName()));
        }
        catch (XQERuntimeException ex) {
            long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
            this.metrics.logEvent("getSliceCardinality", elapsedTime);
            INFO_LOGGER.log(String.format("Get actual slice cardinality - failed: ? rows; %.3f seconds; caller=%s; id=%s; depth=%d; name=%s ", (double)elapsedTime / 1000.0, caller, aggregate.getSliceId().valueToString(), aggregate.getSliceId().getNumberOfTurns(), aggregate.getName()));
            throw ex;
        }
        return rows;
    }

    public long getEstimatedSliceCardinality(Aggregate aggregate, String caller) throws OperationCanceledException {
        long rows = 0L;
        HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
        stopWatch.start();
        try {
            rows = this.getEstimatedSliceCardinality(aggregate);
            long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
            this.metrics.logEvent("getSliceCardinality", elapsedTime);
            INFO_LOGGER.log(String.format("Get estimated slice cardinality (call, rows, time, caller, dimId, hierId, depth, name):;%d; %,d; %.3f; %s; %s; %s; %d; %s;", this.metrics.getEventCount("getSliceCardinality"), rows, (double)elapsedTime / 1000.0, caller, AdvisorTrace.formatDimensionSliceIdAsString(aggregate), aggregate.getSliceId().valueToString(), aggregate.getSliceId().getNumberOfTurns(), aggregate.getName()));
        }
        catch (XQERuntimeException ex) {
            long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
            this.metrics.logEvent("getSliceCardinality", elapsedTime);
            INFO_LOGGER.log(String.format("Get estimated slice cardinality - failed (call, rows, time, caller, dimId, hierId, depth, name):;%d; ?; %.3f; %s; %s; %s; %d; %s;", this.metrics.getEventCount("getSliceCardinality"), (double)elapsedTime / 1000.0, caller, AdvisorTrace.formatDimensionSliceIdAsString(aggregate), aggregate.getSliceId().valueToString(), aggregate.getSliceId().getNumberOfTurns(), aggregate.getName()));
            throw ex;
        }
        return rows;
    }

    private long getEstimatedSliceCardinality(Aggregate aggregate) {
        long maxRows;
        long rows = 0L;
        String selectedSamplingHierarchyLevelName = aggregate.getLevelName(this.samplingHierarchy.getDimensionName(), this.samplingHierarchy.getName());
        List<String> filters = selectedSamplingHierarchyLevelName.equals(this.samplingLevel.getName()) ? this.advisorMemberSample.getSingleMemberSamplingFilterStrings() : this.advisorMemberSample.getMultipleMemberSamplingFilterStrings();
        long sampledRows = AdvisorUtils.getSliceCardinality(this.advisor, this.metaCube, aggregate.getLevels(), this.measureForGeneratedQueries, filters);
        double samplingRate = 0.0;
        samplingRate = selectedSamplingHierarchyLevelName.equals(this.samplingLevel.getName()) ? this.advisorMemberSample.getSingleMemberSamplingRate() : this.advisorMemberSample.getMultipleMemberSamplingRate();
        rows = (long)((double)sampledRows / samplingRate);
        if (rows > (maxRows = this.getMaxSliceCardinality(aggregate))) {
            rows = maxRows;
        }
        return rows;
    }

    public long getEstimatedSliceCardinalityUsingLogarithmicApproach(Aggregate aggregate) {
        SliceCombination sliceId = aggregate.getSliceId();
        sliceId.last();
        Aggregate bottomSliceAggregate = Aggregate.createAggregateForSliceId(this.metaCube, sliceId);
        bottomSliceAggregate.setAggregateAdvisor(this);
        bottomSliceAggregate.addMeasures(this.selectMeasuresBasedOnModel());
        double maxLogarithmicCardinality = this.getLogarithmicCardinality(bottomSliceAggregate);
        double currLogarithmicCardinality = this.getLogarithmicCardinality(aggregate);
        double ratio = currLogarithmicCardinality / maxLogarithmicCardinality;
        int power = 4;
        ratio = Math.pow(ratio, 4.0);
        long rows = (long)(ratio * (double)this.getFactRowCount());
        return rows;
    }

    public double getLogarithmicCardinality(Aggregate aggregate) {
        double logarithmicCardinality = 0.0;
        int hierarchyIndex = -1;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                String levelName = aggregate.getLevelName(++hierarchyIndex);
                if (hierarchy.isRecursive() || levelName.equals("[All]")) continue;
                long levelCardinality = this.cubeCardinalityMetrics.getLevelCardinality(dimension.getName(), hierarchy.getName(), levelName);
                logarithmicCardinality += Math.log10(levelCardinality);
            }
        }
        return logarithmicCardinality;
    }

    public void setupSampling() {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Setup sampling - begin"));
        HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
        stopWatch.start();
        this.selectSamplingLevel();
        if (this.samplingLevel != null) {
            INFO_LOGGER.log(String.format("Sample on dimension %s, hierarchy %s, level %s", this.samplingLevel.getParent().getName(), this.samplingHierarchy.getName(), this.samplingLevel.getName()));
            this.advisorMemberSample.setSamplingLevel(this.metaCube, this.measureForGeneratedQueries, this.samplingHierarchy, this.samplingLevel, this.requestParameters.isEnableTestFeatures());
            this.traceSamplingHierarchyLevelCardinalities();
            String format = "\n\nSampling filters:\nSingle   member sampling: %s\nMultiple member sampling: %s\n\nSampling rates:\nSingle   member sampling: %.6f\nMultiple member sampling: %.6f\n";
            String msg = String.format(format, this.advisorMemberSample.getSingleMemberSamplingFilterStrings(), this.advisorMemberSample.getMultipleMemberSamplingFilterStrings(), this.advisorMemberSample.getSingleMemberSamplingRate(), this.advisorMemberSample.getMultipleMemberSamplingRate());
            INFO_LOGGER.log(msg);
            Aggregate aggregate = new Aggregate(this.metaCube);
            aggregate.setLevel(this.samplingHierarchy.getDimensionName(), this.samplingHierarchy.getName(), this.samplingLevel.getName());
            long sampledRows = AdvisorUtils.getSliceCardinality(this.advisor, this.metaCube, aggregate.getLevels(), this.measureForGeneratedQueries, this.advisorMemberSample.getSingleMemberSamplingFilterStrings());
            INFO_LOGGER.log(String.format("Single member sampled row count = %d", sampledRows));
            sampledRows = AdvisorUtils.getSliceCardinality(this.advisor, this.metaCube, aggregate.getLevels(), this.measureForGeneratedQueries, this.advisorMemberSample.getMultipleMemberSamplingFilterStrings());
            INFO_LOGGER.log(String.format("Multiple member sampled row count = %d", sampledRows));
        } else {
            INFO_LOGGER.log("No sampling level was selected");
        }
        long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
        this.metrics.logEvent("SetupSampling", elapsedTime);
        INFO_LOGGER.log(String.format("Setup sampling took %.3f seconds.", (double)elapsedTime / 1000.0));
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Setup sampling - end"));
    }

    private boolean isSamplingEnabled() {
        return this.advisorMemberSample.getSingleMemberSamplingRate() != 0.0;
    }

    private void traceSamplingHierarchyLevelCardinalities() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nLevel cardinalities based on dimension and actual fact data\n");
        List<Integer> levelActualCardinality = this.advisorMemberSample.getActualLevelCardinalties();
        int levelIndex = -1;
        for (ROLAPMetaLevel level : this.samplingHierarchy.getLevels()) {
            long levelCardInDimension = this.cubeCardinalityMetrics.getLevelCardinality(this.samplingHierarchy.getDimensionName(), this.samplingHierarchy.getName(), level.getName());
            sb.append(String.format("%-25s  %,15d  %,15d \n", level.getName(), levelCardInDimension, levelActualCardinality.get(++levelIndex)));
        }
        INFO_LOGGER.log(sb.toString());
    }

    protected void determineExtrapolationBetweenLevels() {
        INFO_LOGGER.log("Setup sampling - determine extrapolation between levels - begin");
        ROLAPMetaLevel[] levels = this.samplingHierarchy.getLevels();
        this.interLevelExpansionRatio = new double[levels.length + 1];
        long[][] levelSampleCardinality = new long[levels.length + 1][3];
        long[] levelCardinality = new long[levels.length + 1];
        StringBuilder sb = new StringBuilder();
        sb.append("\nLevel cardinalities based on dimension\n");
        levelCardinality[0] = 1L;
        int levelIndex = 0;
        for (ROLAPMetaLevel level : this.samplingHierarchy.getLevels()) {
            long card;
            levelCardinality[++levelIndex] = card = this.cubeCardinalityMetrics.getLevelCardinality(this.samplingHierarchy.getDimensionName(), this.samplingHierarchy.getName(), level.getName());
            sb.append(String.format("%s level cardinality is %d\n", level.getName(), card));
        }
        INFO_LOGGER.log(sb.toString());
        sb = new StringBuilder();
        sb.append("\nLevel cardinalities based on actual fact data\n");
        List<Integer> levelActualCardinality = this.advisorMemberSample.getActualLevelCardinalties();
        levelIndex = 0;
        sb.append(String.format("[All] level actual cardinality is %d\n", levelActualCardinality.get(levelIndex)));
        for (ROLAPMetaLevel level : this.samplingHierarchy.getLevels()) {
            sb.append(String.format("%s level real cardinality is %d\n", level.getName(), levelActualCardinality.get(++levelIndex)));
        }
        INFO_LOGGER.log(sb.toString());
        List<Aggregate> aggregates = this.generateSlicesToExperimentWith();
        int aggregateIndex = -1;
        for (Aggregate aggregate : aggregates) {
            ++aggregateIndex;
            for (levelIndex = levels.length / 2; levelIndex < levels.length; ++levelIndex) {
                long count;
                ROLAPMetaLevel level = levels[levelIndex];
                List<String> filter = this.advisorMemberSample.getSamplingFilterStrings(level);
                levelSampleCardinality[levelIndex + 1][aggregateIndex] = count = AdvisorUtils.getSliceCardinality(this.advisor, this.metaCube, aggregate.getLevels(), this.measureForGeneratedQueries, filter);
            }
        }
        for (aggregateIndex = 0; aggregateIndex < 3; ++aggregateIndex) {
            sb = new StringBuilder();
            sb.append(String.format("Slice %s \n", aggregates.get(aggregateIndex).getName()));
            sb.append("Cardinality of filtered slice sampling at various time levels:\n");
            sb.append(String.format("[All] level : %d \n", levelSampleCardinality[0][aggregateIndex]));
            for (levelIndex = 0; levelIndex < levels.length; ++levelIndex) {
                sb.append(String.format("%s level : %d \n", levels[levelIndex].getName(), levelSampleCardinality[levelIndex + 1][aggregateIndex]));
            }
            INFO_LOGGER.log(sb.toString());
        }
        for (levelIndex = 0; levelIndex <= levels.length; ++levelIndex) {
            double averageExpansionRatio;
            if (levelIndex == levels.length) {
                this.interLevelExpansionRatio[levelIndex] = 1.0;
                continue;
            }
            if (levelSampleCardinality[levelIndex][0] <= 0L) continue;
            double totalExpansionRatio = 0.0;
            for (int sliceIndex = 0; sliceIndex < 3; ++sliceIndex) {
                double expansionRatioForOneSlice = 1.0 * (double)levelSampleCardinality[levelIndex][sliceIndex] / (double)levelSampleCardinality[levels.length][sliceIndex];
                totalExpansionRatio += expansionRatioForOneSlice;
            }
            this.interLevelExpansionRatio[levelIndex] = averageExpansionRatio = totalExpansionRatio / 3.0;
        }
        for (levelIndex = levels.length - 1; levelIndex >= 0; --levelIndex) {
            if (this.interLevelExpansionRatio[levelIndex] != 0.0) continue;
            double cardRatio = 1.0 * (double)levelCardinality[levelIndex + 1] / (double)levelCardinality[levelIndex];
            this.interLevelExpansionRatio[levelIndex] = this.interLevelExpansionRatio[levelIndex + 1] * cardRatio;
        }
        sb = new StringBuilder();
        sb.append("Inter-level expansion ratios:\n");
        sb.append(String.format("[All] level : %.2f \n", this.interLevelExpansionRatio[0]));
        for (levelIndex = 0; levelIndex < levels.length; ++levelIndex) {
            sb.append(String.format("%s level : %.2f \n", levels[levelIndex].getName(), this.interLevelExpansionRatio[levelIndex + 1]));
        }
        INFO_LOGGER.log(sb.toString());
        INFO_LOGGER.log("Setup sampling - determine extrapolation between levels - end");
    }

    private List<Aggregate> generateSlicesToExperimentWith() {
        ArrayList<Aggregate> aggregates = new ArrayList<Aggregate>();
        Aggregate aggregate = new Aggregate(this.metaCube);
        SliceCombination cubeId = aggregate.getSliceId();
        for (int count = 1; count <= 3; ++count) {
            SliceCombination sliceId = new SliceCombination();
            sliceId.copy(cubeId);
            sliceId.random(sliceId.getMaxNumberOfTurns() / 2, this.generatorForExperimentalSlices);
            sliceId.setValue(this.samplingHierarchyIndex, 1);
            aggregate = Aggregate.createAggregateForSliceId(this.metaCube, sliceId);
            aggregates.add(aggregate);
        }
        return aggregates;
    }

    public void determineLevelCardinalities() {
        INFO_LOGGER.log("Obtain level cardinalities");
        int position = -1;
        boolean modelHasEmptyLevels = false;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                ++position;
                if (hierarchy.isRecursive()) continue;
                for (ROLAPMetaLevel level : hierarchy.getLevels()) {
                    INFO_LOGGER.log("Get cardinality of level " + level.getName());
                    HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
                    stopWatch.start();
                    long card = AdvisorUtils.getLevelCardinality(this.advisor, this.metaCube, hierarchy, level);
                    long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
                    this.metrics.logEvent("getLevelCardinality", elapsedTime);
                    this.cubeCardinalityMetrics.setLevelCardinality(dimension.getName(), hierarchy.getName(), level.getName(), card);
                    if (card != 0L) continue;
                    INFO_LOGGER.log(String.format("Level %s cardinality is 0", level.getName()));
                    this.advisor.addMessage(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorLevelHasNoMembers, level.getName(), dimension.getName())));
                    modelHasEmptyLevels = true;
                    this.optimizeCubeRegion.setMaximum(position, this.optimizeCubeRegion.getMinimum(position));
                }
            }
        }
        INFO_LOGGER.log(String.format("Optimize region %s of cube %s", this.optimizeCubeRegion.rangeToString(), this.entireCubeRegion.rangeToString()));
        if (modelHasEmptyLevels) {
            this.advisor.addMessage(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCubeHasLevelsWithoutRows, this.metaCube.getName())));
        }
    }

    public void assignAggregates(List<Aggregate> candidateAggregates, List<Aggregate> inMemoryAggregates, List<Aggregate> inDatabaseAggregates) {
        INFO_LOGGER.log("Assign aggregates - began.");
        ArrayList<Aggregate> acceptableAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> rejectedAggregates = new ArrayList<Aggregate>();
        this.determineAggregatesCardinalityAcceptability(candidateAggregates, acceptableAggregates, rejectedAggregates);
        if (!rejectedAggregates.isEmpty()) {
            INFO_LOGGER.log("\n\nCandidate aggregates eliminated because their cardinality is too large compared to fact table:\n" + AdvisorTrace.formatAggregates(rejectedAggregates));
        }
        if (this.requestParameters.getInMemoryAggregatesLimit() > 0L && this.requestParameters.getInDatabaseAggregatesLimit() > 0L) {
            this.assignAggregatesAsInMemoryAndInDatabase(acceptableAggregates, inMemoryAggregates, inDatabaseAggregates);
        } else if (this.requestParameters.getInMemoryAggregatesLimit() > 0L) {
            this.assignAggregatesAsInMemory(acceptableAggregates, inMemoryAggregates);
        } else if (this.requestParameters.getInDatabaseAggregatesLimit() > 0L) {
            this.assignAggregatesAsInDatabase(acceptableAggregates, inDatabaseAggregates);
        } else {
            INFO_LOGGER.log("No aggregates recommended because no space was provided for in-memory and in-database aggregates.");
        }
        INFO_LOGGER.log("Assign aggregates - ended.");
    }

    public void determineAggregatesCardinalityAcceptability(List<Aggregate> candidateAggregates, List<Aggregate> acceptableAggregates, List<Aggregate> rejectedAggregates) {
        if (candidateAggregates.isEmpty()) {
            return;
        }
        if (this.cubeCardinalityMetrics.getFactCardinality() <= 0L) {
            throw new IllegalStateException("Fact row count must be known at this point");
        }
        acceptableAggregates.clear();
        rejectedAggregates.clear();
        for (Aggregate aggregate : candidateAggregates) {
            if (aggregate.getRecommendedBy() == AggregateRecommendedByEnum.USER) {
                acceptableAggregates.add(aggregate);
                continue;
            }
            if (this.isAggregateSmallRelativetoFact(aggregate)) {
                acceptableAggregates.add(aggregate);
                continue;
            }
            rejectedAggregates.add(aggregate);
        }
    }

    public boolean isAggregateSmallRelativetoFact(Aggregate aggregate) {
        long factRowCount = this.cubeCardinalityMetrics.getFactCardinality();
        return aggregate.getCardinality() <= factRowCount / 5L || factRowCount <= 1000L;
    }

    private void assignAggregatesAsInMemory(List<Aggregate> candidateAggregates, List<Aggregate> inMemoryAggregates) {
        ArrayList<Aggregate> candidateAggregatesToAssign = new ArrayList<Aggregate>(candidateAggregates);
        AggregateAdvisor.removeDuplicates(candidateAggregatesToAssign);
        ArrayList<Aggregate> validAggregatesForInMemory = new ArrayList<Aggregate>();
        for (Aggregate aggregate : candidateAggregatesToAssign) {
            if (!this.validateAggregateForInMemory(aggregate)) continue;
            validAggregatesForInMemory.add(aggregate);
        }
        long inMemorySpaceUsed = 0L;
        ArrayList<Aggregate> userAggregates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : validAggregatesForInMemory) {
            if (aggregate.getRecommendedBy() != AggregateRecommendedByEnum.USER) continue;
            long inMemorySpaceForCandidate = this.estimateInMemoryAggregateSize(aggregate);
            aggregate.setEstimatedSize(inMemorySpaceForCandidate);
            inMemorySpaceUsed += inMemorySpaceForCandidate;
            aggregate.setType(AggregateType.IN_MEMORY);
            userAggregates.add(aggregate);
        }
        inMemoryAggregates.addAll(userAggregates);
        validAggregatesForInMemory.removeAll(userAggregates);
        ArrayList<Aggregate> smallAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> bigAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> lastAggregates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : validAggregatesForInMemory) {
            if (smallAggregates.size() + bigAggregates.size() >= this.requestParameters.getMaxNumberOfInMemoryAggregates()) {
                lastAggregates.add(aggregate);
                continue;
            }
            if (this.estimateInMemoryAggregateSize(aggregate) <= this.requestParameters.getInMemoryAggregatesLimit() / (long)this.requestParameters.getMaxNumberOfInMemoryAggregates()) {
                smallAggregates.add(aggregate);
                continue;
            }
            bigAggregates.add(aggregate);
        }
        ArrayList<Aggregate> orderedAggregates = new ArrayList<Aggregate>();
        orderedAggregates.addAll(smallAggregates);
        orderedAggregates.addAll(bigAggregates);
        orderedAggregates.addAll(lastAggregates);
        for (Aggregate aggregate : orderedAggregates) {
            long inMemorySpaceForCandidate = this.estimateInMemoryAggregateSize(aggregate);
            if (inMemoryAggregates.size() >= this.requestParameters.getMaxNumberOfInMemoryAggregates()) {
                INFO_LOGGER.log(String.format("Aggregate %s rejected because in-memory aggregates count limit reached.", aggregate.getName()));
                continue;
            }
            if (inMemorySpaceUsed + inMemorySpaceForCandidate > this.requestParameters.getInMemoryAggregatesLimit()) {
                INFO_LOGGER.log(String.format("Aggregate %s rejected because in-memory aggregates space limit reached.", aggregate.getName()));
                continue;
            }
            aggregate.setEstimatedSize(inMemorySpaceForCandidate);
            inMemorySpaceUsed += inMemorySpaceForCandidate;
            aggregate.setType(AggregateType.IN_MEMORY);
            inMemoryAggregates.add(aggregate);
        }
    }

    private void assignAggregatesAsInDatabase(List<Aggregate> candidateAggregates, List<Aggregate> inDatabaseAggregates) {
        ArrayList<Aggregate> candidateAggregatesToAssign = new ArrayList<Aggregate>(candidateAggregates);
        AggregateAdvisor.removeDuplicates(candidateAggregatesToAssign);
        long inDatabaseSpaceUsed = 0L;
        for (Aggregate aggregate : candidateAggregatesToAssign) {
            long inDatabaseSpaceForCandidate = this.estimateInDatabaseAggregateSize(aggregate);
            if (inDatabaseAggregates.size() >= this.requestParameters.getMaxNumberOfInDatabaseAggregates()) {
                INFO_LOGGER.log(String.format("Aggregate %s rejected because in-database aggregates count limit reached.", aggregate.getName()));
                continue;
            }
            if (aggregate.getCardinality() < this.cubeCardinalityMetrics.getFactCardinality() / 10000L) {
                INFO_LOGGER.log(String.format("Aggregate %s rejected because in-database aggregates must have more rows.", aggregate.getName()));
                continue;
            }
            if (inDatabaseSpaceUsed + inDatabaseSpaceForCandidate > this.requestParameters.getInDatabaseAggregatesLimit()) {
                INFO_LOGGER.log(String.format("Aggregate %s rejected because in-database aggregates space limit reached.", aggregate.getName()));
                continue;
            }
            aggregate.setEstimatedSize(inDatabaseSpaceForCandidate);
            inDatabaseSpaceUsed += inDatabaseSpaceForCandidate;
            aggregate.setType(AggregateType.IN_DATABASE);
            inDatabaseAggregates.add(aggregate);
        }
    }

    private void assignAggregatesAsInMemoryAndInDatabase(List<Aggregate> candidateAggregates, List<Aggregate> inMemoryAggregates, List<Aggregate> inDatabaseAggregates) {
        ArrayList<Aggregate> deepModelBasedCandidates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> inMemoryCandidates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : candidateAggregates) {
            if (aggregate.getRecommendedBy() == AggregateRecommendedByEnum.MODEL && aggregate.isDeepSlice()) {
                deepModelBasedCandidates.add(aggregate);
                continue;
            }
            inMemoryCandidates.add(aggregate);
        }
        this.assignAggregatesAsInMemory(inMemoryCandidates, inMemoryAggregates);
        ArrayList<Aggregate> rejectedAsInMemoryButConsiderForInDatabaseAggregates = new ArrayList<Aggregate>();
        for (Aggregate inMemoryCandidate : inMemoryCandidates) {
            if (inMemoryAggregates.contains(inMemoryCandidate) || !inMemoryCandidate.getRecommendedBy().equals((Object)AggregateRecommendedByEnum.WORKLOAD) && !inMemoryCandidate.getRecommendedBy().equals((Object)AggregateRecommendedByEnum.HYBRID)) continue;
            rejectedAsInMemoryButConsiderForInDatabaseAggregates.add(inMemoryCandidate);
        }
        ArrayList<Aggregate> arrayList = new ArrayList<Aggregate>();
        arrayList.addAll(deepModelBasedCandidates);
        arrayList.addAll(rejectedAsInMemoryButConsiderForInDatabaseAggregates);
        this.assignAggregatesAsInDatabase(arrayList, inDatabaseAggregates);
    }

    private static void removeDuplicates(List<Aggregate> candidateAggregates) {
        ArrayList<Aggregate> removedAggregates = new ArrayList<Aggregate>(candidateAggregates);
        AggregateUtils.removeAggregatesWithIdenticalLevels(candidateAggregates);
        removedAggregates.removeAll(candidateAggregates);
        if (!removedAggregates.isEmpty()) {
            INFO_LOGGER.log(String.format("\nCandidate aggregates removed because they are duplicates:\n%s", AdvisorTrace.formatAggregates(removedAggregates)));
        }
    }

    public boolean validateAggregateForInMemory(Aggregate aggregate) {
        boolean valid;
        if (aggregate.getRecommendedBy() != AggregateRecommendedByEnum.USER) {
            long maxNumberOfInMemoryAggregateCells = this.requestParameters.getMaxNumberOfInMemoryAggregateCells();
            long numberOfInMemoryAggregateCells = aggregate.getNumberOfCells();
            if (numberOfInMemoryAggregateCells > maxNumberOfInMemoryAggregateCells) {
                INFO_LOGGER.log(aggregate.getName() + " rejected because it has " + numberOfInMemoryAggregateCells + " cells which exceeds limit of " + maxNumberOfInMemoryAggregateCells + " cells");
                return false;
            }
        }
        if (!(valid = AggregateUtilities.validateDimensionalSize(this.cubeCardinalityMetrics.getLevelMemberCounts(aggregate, true)))) {
            INFO_LOGGER.log(aggregate.getName() + " rejected because it exceeds maximum dimensional size");
        }
        return valid;
    }

    public long estimateInMemoryAggregateSize(Aggregate aggregate) {
        List<ROLAPMetaMeasure> measures = aggregate.getMeasures();
        boolean measuresHaveSameFormatIds = AggregateUtilities.measuresHaveSameFormatIds(measures);
        int[] levelSizes = this.cubeCardinalityMetrics.getLevelMemberCounts(aggregate, true);
        int[] hierarchyDimensionCardinalities = this.cubeCardinalityMetrics.getHierarchyDimensionMemberCounts(aggregate);
        long totalSpace = AggregateUtilities.estimateAggregateSize(aggregate.getName(), levelSizes, hierarchyDimensionCardinalities, aggregate.getNumberOfCells(), measuresHaveSameFormatIds);
        return totalSpace;
    }

    public long estimateInDatabaseAggregateSize(Aggregate aggregate) {
        long rowWidth = (long)aggregate.getMeasures().size() * 10L + 50L;
        long space = aggregate.getCardinality() * rowWidth;
        return space;
    }

    public long getMaxSliceCardinality(Aggregate aggregate) {
        int[] levelSizes;
        double cardinality = 1.0;
        for (int levelSize : levelSizes = this.cubeCardinalityMetrics.getLevelMemberCounts(aggregate)) {
            if (!((cardinality *= (double)levelSize) > 1.0E15)) continue;
            cardinality = 1.0E15;
            break;
        }
        return (long)cardinality;
    }

    public ROLAPMetaDimension determineTimeDimension() {
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            if (!dimension.isTimeDimension()) continue;
            return dimension;
        }
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            if (!dimension.getName().equalsIgnoreCase(DATE_STRING_UPPER)) continue;
            return dimension;
        }
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            if (!dimension.getName().equalsIgnoreCase(TIME_STRING_UPPER)) continue;
            return dimension;
        }
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            if (!dimension.getName().toUpperCase().startsWith(DATE_STRING_UPPER)) continue;
            return dimension;
        }
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            if (!dimension.getName().toUpperCase().startsWith(TIME_STRING_UPPER)) continue;
            return dimension;
        }
        return null;
    }

    private List<ROLAPMetaDimension> getTimeDimensions() {
        ArrayList<ROLAPMetaDimension> timeDimensions = new ArrayList<ROLAPMetaDimension>();
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            if (!dimension.isTimeDimension()) continue;
            timeDimensions.add(dimension);
        }
        if (timeDimensions.isEmpty()) {
            for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
                if (dimension.getName().equalsIgnoreCase(DATE_STRING_UPPER) || dimension.getName().equalsIgnoreCase(TIME_STRING_UPPER)) {
                    timeDimensions.add(dimension);
                }
                if (!dimension.getName().toUpperCase().startsWith(DATE_STRING_UPPER) && !dimension.getName().toUpperCase().startsWith(TIME_STRING_UPPER)) continue;
                timeDimensions.add(dimension);
            }
        }
        return timeDimensions;
    }

    public void selectSamplingLevel() {
        List<ROLAPMetaDimension> timeDimensions = this.getTimeDimensions();
        if (timeDimensions.isEmpty()) {
            INFO_LOGGER.log("Could not locate a time dimension.  Sampling will not be used.");
            return;
        }
        for (ROLAPMetaDimension timeDimension : timeDimensions) {
            this.searchForDayLevelByTypeName(timeDimension);
            if (null == this.samplingLevel) continue;
            break;
        }
        if (null == this.samplingLevel) {
            ROLAPMetaHierarchy hierarchyWithMostLevels = null;
            int currentHighestLevelCount = 0;
            for (ROLAPMetaDimension timeDimension : timeDimensions) {
                for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(timeDimension)) {
                    if (hierarchy.getLevels().length <= currentHighestLevelCount) continue;
                    currentHighestLevelCount = hierarchy.getLevels().length;
                    hierarchyWithMostLevels = hierarchy;
                }
            }
            ROLAPMetaLevel[] hierarchyLevels = hierarchyWithMostLevels.getLevels();
            this.samplingHierarchy = hierarchyWithMostLevels;
            this.samplingLevel = hierarchyLevels[hierarchyLevels.length - 1];
        }
        if (this.samplingHierarchy != null) {
            this.samplingHierarchyIndex = AdvisorUtils.getHierarchyIndex(this.metaCube, this.samplingHierarchy.getDimensionName(), this.samplingHierarchy.getName());
            this.cubeCardinalityMetrics.setSamplingHierarchyIndex(this.samplingHierarchyIndex);
        }
    }

    private void searchForDayLevelByTypeName(ROLAPMetaDimension timeDimension) {
        for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(timeDimension)) {
            for (ROLAPMetaLevel level : hierarchy.getLevels()) {
                if (0 != level.getType().compareTo(DAY_LEVEL_IDENTIFIER)) continue;
                this.samplingHierarchy = hierarchy;
                this.samplingLevel = level;
                return;
            }
        }
    }

    public List<ROLAPMetaMeasure> selectMeasuresBasedOnModel() {
        ArrayList<ROLAPMetaMeasure> measures = new ArrayList<ROLAPMetaMeasure>();
        for (ROLAPMetaMeasure measure : this.metaCube.getMeasures()) {
            if (!this.isMeasureSupported(measure) || !this.isMeasureAdditive(measure) || !measure.isVisible()) continue;
            measures.add(measure);
        }
        return measures;
    }

    private void initializeMeasures() {
        List<String> measureNames;
        INFO_LOGGER.log(this.formatMeasureProperties());
        ArrayList<ROLAPMetaMeasure> unsupportedMeasures = new ArrayList<ROLAPMetaMeasure>();
        ArrayList<ROLAPMetaMeasure> excludedBecauseNRTMeasures = new ArrayList<ROLAPMetaMeasure>();
        String includeNonAdditiveMeasuresForNRTCubeStr = null;
        if (this.metaCube.isNearRealTimeCube() && (includeNonAdditiveMeasuresForNRTCubeStr = System.getProperty(NRT_CUBE_INCLUDE_NON_ADDITIVE_MEASURES_JVM_PARAM)) != null) {
            INFO_LOGGER.log(String.format("JVM argument %s is set so non-additive measures found in the workload will be included in aggregates", NRT_CUBE_INCLUDE_NON_ADDITIVE_MEASURES_JVM_PARAM));
        }
        for (ROLAPMetaMeasure measure : this.metaCube.getMeasures()) {
            if (this.isMeasureOptimizable(measure)) {
                if (this.isAggregateTypeAdditive(this.getAggregateType(measure))) {
                    this.supportedMeasures.add(measure);
                    this.additiveMeasures.add(measure);
                    continue;
                }
                if (!this.metaCube.isNearRealTimeCube()) {
                    this.supportedMeasures.add(measure);
                    continue;
                }
                if (includeNonAdditiveMeasuresForNRTCubeStr != null) {
                    this.supportedMeasures.add(measure);
                    continue;
                }
                excludedBecauseNRTMeasures.add(measure);
                continue;
            }
            unsupportedMeasures.add(measure);
        }
        if (!unsupportedMeasures.isEmpty() && this.advisor != null) {
            measureNames = AdvisorUtils.getMeasureNames(unsupportedMeasures);
            String measureNamesAsString = AdvisorTrace.formatStringsAsString(measureNames, COMMASPACE_STR);
            this.advisor.addMessage(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorMeasuresNotOptimized, measureNamesAsString)));
        }
        if (!excludedBecauseNRTMeasures.isEmpty() && this.advisor != null) {
            measureNames = AdvisorUtils.getMeasureNames(excludedBecauseNRTMeasures);
            String measureNamesAsString = AdvisorTrace.formatStringsAsString(measureNames, COMMASPACE_STR);
            this.advisor.addMessage(Advisor.buildNotification(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorMeasuresNotOptimizedForNRT, measureNamesAsString)));
        }
        StringBuilder sb = new StringBuilder();
        sb.append('\n');
        sb.append("\nSupported measures (measures that may be optimized by the advisor):\n");
        sb.append(AdvisorTrace.formatStringsAsList(AdvisorUtils.getMeasureNames(this.supportedMeasures)));
        sb.append("\nUnsupported measures (measures that will not be optimized by the advisor):\n");
        sb.append(AdvisorTrace.formatStringsAsList(AdvisorUtils.getMeasureNames(unsupportedMeasures)));
        sb.append("\nNon-additive measures excluded because cube is NRT:\n");
        sb.append(AdvisorTrace.formatStringsAsList(AdvisorUtils.getMeasureNames(excludedBecauseNRTMeasures)));
        INFO_LOGGER.log(sb.toString());
    }

    private String formatMeasureProperties() {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nMeasure properties:\n\n");
        String fmt = "%-12s  %-12s  %-10s  %-15s  %-15s  %s\n";
        sb.append(String.format(fmt, "Optimize?", "Calculated?", "Visible?", "Additive?", "Aggregate type", "Name"));
        for (ROLAPMetaMeasure measure : this.metaCube.getMeasures()) {
            String optimizeStatus = "";
            optimizeStatus = this.isMeasureOptimizable(measure) ? YES_STRING : NO_STRING;
            String calculatedStatus = "";
            calculatedStatus = measure.isCalculated() ? YES_STRING : NO_STRING;
            String visibilityStatus = "";
            visibilityStatus = measure.isVisible() ? YES_STRING : NO_STRING;
            String additiveStatus = "";
            additiveStatus = measure.isCalculated() ? "" : (AdvisorUtils.isMeasureSemiAggregate(measure) ? "semi-aggregate" : (this.isAggregateTypeAdditive(this.getAggregateType(measure)) ? "additive" : "non-additive"));
            String aggregationFunction = "";
            if (!measure.getAggregationFunction().equals("calculated") && measure.getQueryItem() != null) {
                aggregationFunction = this.getAggregateType(measure).toString();
            }
            String measureInfo = String.format(fmt, optimizeStatus, calculatedStatus, visibilityStatus, additiveStatus, aggregationFunction, measure.getName());
            sb.append(measureInfo);
        }
        return sb.toString();
    }

    private boolean isMeasureOptimizable(ROLAPMetaMeasure measure) {
        boolean optimizable = false;
        if (!measure.isCalculated() && !AdvisorUtils.isMeasureSemiAggregate(measure) && this.isAggregateTypeSupported(this.getAggregateType(measure))) {
            optimizable = true;
        }
        return optimizable;
    }

    public AggregateTypeEnum getAggregateType(ROLAPMetaMeasure measure) {
        return this.getAggregateTypeFromBind(measure);
    }

    private AggregateTypeEnum getAggregateTypeFromBind(ROLAPMetaMeasure measure) {
        MetadataConnection metadataConnection = this.cube.getConnection();
        IMetadata metadata = metadataConnection.bindMetadataReference(measure.getQueryItem());
        if (metadata != null) {
            if (metadata.getObjectType() == MetadataType.CALCULATION) {
                ICalculation calculation = (ICalculation)metadata;
                return AggregateTypeEnum.valueOfModelString(calculation.getRegularAggregate());
            }
            if (metadata.getObjectType() == MetadataType.QUERY_ITEM) {
                IQueryItem queryItem = (IQueryItem)metadata;
                return AggregateTypeEnum.valueOfModelString(queryItem.getRegularAggregate());
            }
        }
        return AggregateTypeEnum.UNSUPPORTED;
    }

    public boolean isMeasureSupported(ROLAPMetaMeasure measure) {
        return this.supportedMeasures.contains(measure);
    }

    public List<ROLAPMetaMeasure> getSupportedMeasures() {
        return this.supportedMeasures;
    }

    private boolean isAggregateTypeSupported(AggregateTypeEnum type) {
        switch (type) {
            case COUNT: 
            case SUM: 
            case MIN: 
            case MAX: {
                return true;
            }
            case AVG: 
            case COUNT_DISTINCT: {
                return true;
            }
            case CALCULATED: {
                return true;
            }
            case STDDEV: 
            case MEDIAN: 
            case VAR: {
                return false;
            }
            case UNKNOWN: {
                return false;
            }
        }
        return false;
    }

    public boolean isMeasureAdditive(ROLAPMetaMeasure measure) {
        return this.additiveMeasures.contains(measure);
    }

    public List<ROLAPMetaMeasure> getAdditiveMeasures() {
        return new ArrayList<ROLAPMetaMeasure>(this.additiveMeasures);
    }

    private boolean isAggregateTypeAdditive(AggregateTypeEnum type) {
        switch (type) {
            case COUNT: 
            case SUM: 
            case MIN: 
            case MAX: {
                return true;
            }
            case AVG: 
            case COUNT_DISTINCT: 
            case STDDEV: 
            case MEDIAN: 
            case VAR: {
                return false;
            }
            case CALCULATED: {
                return false;
            }
            case UNKNOWN: {
                return false;
            }
        }
        return false;
    }

    public void initializeExistingInDatabaseAggregates() {
        INFO_LOGGER.log("Initialize the existing in-database aggregates.");
        ROLAPMetaAggregateCube[] metaAggregateCubes = this.metaCube.getAggregateCubes();
        INFO_LOGGER.log(String.format("There are %d existing in-database aggregates", metaAggregateCubes.length));
        for (ROLAPMetaAggregateCube metaAggregateCube : metaAggregateCubes) {
            ExistingInDatabaseAggregate existingInDatabaseAggregate = new ExistingInDatabaseAggregate(this.metaCube, metaAggregateCube);
            this.existingInDatabaseAggregates.add(existingInDatabaseAggregate);
            INFO_LOGGER.log(existingInDatabaseAggregate.toTraceString());
        }
    }

    public List<ExistingInDatabaseAggregate> getExistingInDatabaseAggregates() {
        return this.existingInDatabaseAggregates;
    }

    public void saveRecommendations(List<Aggregate> aggregates) {
        this.advisor.saveRecommendations(aggregates);
    }

    public long getInMemoryAggregatesLimit() {
        return this.requestParameters.getInMemoryAggregatesLimit();
    }

    public boolean isIncludeWorkloadInfo() {
        return this.requestParameters.getIncludeWorkloadInfo();
    }

    public Aggregate randomAggregateInRegion(CubeRegion region) {
        Aggregate aggregate = new Aggregate(this.metaCube);
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                List<String> levels = region.getLevels(dimension.getName(), hierarchy.getName());
                if (levels.size() == 0) {
                    String msg = String.format("Dimension %s hierarchy %s has no levels so can't generate slice.", dimension.getName(), hierarchy.getName());
                    throw new IllegalArgumentException(msg);
                }
                int randomLevelIndex = this.random(0, levels.size() - 1);
                String levelName = levels.get(randomLevelIndex);
                aggregate.setLevel(dimension.getName(), hierarchy.getName(), levelName);
            }
        }
        return aggregate;
    }

    private int random(int min, int max) {
        int num = 0;
        num = this.generator.nextInt(max - min + 1) + min;
        return num;
    }

    public void improveCardinalityEstimates(List<Aggregate> aggregates, String caller) {
        INFO_LOGGER.log("Get estimated slice cardinality for large candidate aggregates - begin.");
        for (Aggregate aggregate : aggregates) {
            this.improveCardinalityEstimate(aggregate, caller);
        }
        INFO_LOGGER.log("Get estimated slice cardinality for large candidate aggregates - end.");
    }

    public void improveCardinalityEstimate(Aggregate aggregate, String caller) {
        if (aggregate.getCardinality() > 10000L) {
            try {
                long cardinality = this.getSliceCardinality(aggregate, caller);
                aggregate.setCardinality(cardinality);
                this.setProgressValue(this.getProgessValue() + 10);
            }
            catch (OperationCanceledException canceled) {
                INFO_LOGGER.log("Get slice cardinality failed due to operation canceled exception.");
                throw canceled;
            }
            catch (Exception ex) {
                aggregate.setCardinality(10000000000000000L);
                String fmt = "Get slice cardinality failed for aggregate %s.  Continue processing.  Exception: %s";
                INFO_LOGGER.log(String.format(fmt, aggregate.getName(), ex.getMessage()));
            }
        } else {
            INFO_LOGGER.log("Get slice cardinality not done since max cardinality is small - " + aggregate.getName());
        }
    }

    public void setSliceUsageAggregates(List<Aggregate> theSliceUsageAggregates) {
        this.sliceUsageAggregates.clear();
        this.sliceUsageAggregates.addAll(theSliceUsageAggregates);
    }

    public List<Aggregate> getSliceUsageAggregates() {
        return this.sliceUsageAggregates;
    }

    public void addRejectedAggregates(List<Aggregate> theRejectedAggregates) {
        this.rejectedAggregateSet.addAll(theRejectedAggregates);
    }

    public List<Aggregate> getRejectedAggregates() {
        return this.rejectedAggregateSet;
    }

    public Aggregate determineAggregateThatWillBeMatched(Aggregate aggregate, List<Aggregate> aggregates) {
        Aggregate bestMatchingAggregate = null;
        List<Aggregate> matchingAggregates = AggregateUtils.getMatchingAggregates(aggregate, aggregates);
        double bestLogarithmicCardinality = Double.MAX_VALUE;
        for (Aggregate matchingAggregate : matchingAggregates) {
            double currLogarithmicCardinality = this.getLogarithmicCardinality(matchingAggregate);
            if (!(currLogarithmicCardinality < bestLogarithmicCardinality)) continue;
            bestLogarithmicCardinality = currLogarithmicCardinality;
            bestMatchingAggregate = matchingAggregate;
        }
        return bestMatchingAggregate;
    }
}

