/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class AggregateSQLInfo {
    private String sql;
    private Map<String, String> columnSetInfo;
    private HashMap<String, ArrayList<String[]>> columnInfoHashDetail = new HashMap();
    private Map<String, Map<String, Map<String, String>>> dimensionNameHierarchyNameMetaNameColumnNameMap;
    private Map<String, String> cubeAttributeobjectNameToColumnNameMap;
    private static final String SPACE_STR = " ";
    private static final String PADDINGSPACE_STR = "    ";
    private static final String DASHES_STR = "---------------";
    private static final String NEW_LINE = "\n";

    public AggregateSQLInfo(String aSql, Map<String, String> colSetInfo, Map<String, Map<String, Map<String, String>>> theDimensionNameHierarchyNameMetaNameColumnNameMap, Map<String, String> thecubeAttributeobjectNameToColumnNameMap) {
        this.sql = aSql;
        this.columnSetInfo = colSetInfo;
        this.dimensionNameHierarchyNameMetaNameColumnNameMap = theDimensionNameHierarchyNameMetaNameColumnNameMap;
        this.cubeAttributeobjectNameToColumnNameMap = thecubeAttributeobjectNameToColumnNameMap;
    }

    public String getSQL() {
        return this.sql;
    }

    public Map<String, String> getColumnSetInfo() {
        return this.columnSetInfo;
    }

    public String getColumnName(String dimensionName, String hierarchyName, String metaName) {
        Map<String, String> metaNameColumnNameMap;
        String columnName = null;
        Map<String, Map<String, String>> hierarchyNameMetaNameColumnNameMap = this.dimensionNameHierarchyNameMetaNameColumnNameMap.get(dimensionName);
        if (hierarchyNameMetaNameColumnNameMap != null && (metaNameColumnNameMap = hierarchyNameMetaNameColumnNameMap.get(hierarchyName)) != null) {
            columnName = metaNameColumnNameMap.get(metaName);
        }
        return columnName;
    }

    public String getColumnNameFromAttributeName(String uniqueAttributeName) {
        return this.cubeAttributeobjectNameToColumnNameMap.get(uniqueAttributeName);
    }

    public String getColumnDataType(String columnName) {
        return this.columnSetInfo.get(columnName);
    }

    public String dumpColumnSetInfo(String prefix, boolean includeHeader, HashMap<String, ArrayList<String[]>> theColumnInfoHashDetail) {
        StringBuilder sb = new StringBuilder();
        this.columnInfoHashDetail = theColumnInfoHashDetail;
        int maxLength = 0;
        Set<Map.Entry<String, String>> set = this.columnSetInfo.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (entry.getKey().length() <= maxLength) continue;
            maxLength = entry.getKey().length();
        }
        if (includeHeader && DASHES_STR.length() > maxLength) {
            maxLength = DASHES_STR.length();
        }
        String columnHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_Column, XQEMessages.getCurrProductLocale());
        String dataTypeHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_DataType, XQEMessages.getCurrProductLocale());
        String columnTypeHeader = XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextAggregate_CubeModelRelationship, XQEMessages.getCurrProductLocale());
        if (includeHeader) {
            int i;
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(columnHeader);
            for (i = columnHeader.length(); i < maxLength; ++i) {
                sb.append(SPACE_STR);
            }
            sb.append(PADDINGSPACE_STR);
            sb.append(dataTypeHeader);
            for (i = dataTypeHeader.length(); i < maxLength; ++i) {
                sb.append(SPACE_STR);
            }
            sb.append(PADDINGSPACE_STR);
            sb.append(PADDINGSPACE_STR);
            sb.append(columnTypeHeader);
            sb.append(NEW_LINE);
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(DASHES_STR);
            for (i = DASHES_STR.length(); i < maxLength; ++i) {
                sb.append(SPACE_STR);
            }
            sb.append(PADDINGSPACE_STR);
            sb.append(DASHES_STR);
            sb.append(PADDINGSPACE_STR);
            sb.append(PADDINGSPACE_STR);
            sb.append(DASHES_STR);
            sb.append(DASHES_STR);
            sb.append(NEW_LINE);
        }
        for (Map.Entry<String, String> entry : set) {
            int i;
            if (prefix != null) {
                sb.append(prefix);
            }
            sb.append(entry.getKey());
            for (i = entry.getKey().length(); i < maxLength; ++i) {
                sb.append(SPACE_STR);
            }
            sb.append(PADDINGSPACE_STR);
            sb.append(entry.getValue());
            for (i = entry.getValue().length(); i < maxLength; ++i) {
                sb.append(SPACE_STR);
            }
            sb.append(PADDINGSPACE_STR);
            sb.append(PADDINGSPACE_STR);
            if (this.columnInfoHashDetail.containsKey(entry.getKey())) {
                ArrayList<String[]> value = this.columnInfoHashDetail.get(entry.getKey());
                String[] type = value.get(0);
                String[] val = value.get(1);
                if (type[0].equals("Level Key")) {
                    sb.append(PADDINGSPACE_STR);
                } else if (type[0].equals("Measure")) {
                    String measureName = val[0];
                    sb.append(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextMeasureRelationship, XQEMessages.getCurrProductLocale(), measureName));
                } else {
                    String dimName = val[0];
                    String hierName = val[1];
                    String levelName = val[2];
                    sb.append(XQEMessages.getMessage(XQEMessageKeys.RLU_AdvisorInDBTextDimHierLevelRelationship, XQEMessages.getCurrProductLocale(), dimName, hierName, levelName));
                }
            }
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }
}

