/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetricsReader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetricsWriter;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.stream.XMLStreamReader;

public class CubeCardinalityMetricsFileUtility {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CubeCardinalityMetrics readAdvisorMetrics(ROLAPMetaCube metaCube) throws Exception {
        CubeCardinalityMetrics cubeCardinalityMetrics = null;
        String advisorMetricsFileName = CubeCardinalityMetricsFileUtility.getLogFileName(metaCube.getName());
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(advisorMetricsFileName);
            XMLStreamReader xmlStreamReader = StaxUtil.createXMLStreamReader(fileInputStream);
            CubeCardinalityMetricsReader cubeCardinalityMetricsReader = new CubeCardinalityMetricsReader(xmlStreamReader, metaCube);
            cubeCardinalityMetrics = cubeCardinalityMetricsReader.parseCubeCardinalityMetrics();
        }
        catch (FileNotFoundException e) {
            cubeCardinalityMetrics = new CubeCardinalityMetrics(metaCube);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return cubeCardinalityMetrics;
    }

    public static void writeAdvisorMetrics(ROLAPMetaCube metaCube, CubeCardinalityMetrics cubeCardinalityMetrics) throws FileNotFoundException {
        String xml = CubeCardinalityMetricsWriter.generateXML(cubeCardinalityMetrics);
        String advisorMetricsFileName = CubeCardinalityMetricsFileUtility.getLogFileName(metaCube.getName());
        File file = new File(advisorMetricsFileName);
        File directory = file.getParentFile();
        directory.mkdirs();
        PrintWriter writer = new PrintWriter(advisorMetricsFileName);
        writer.println(xml);
        writer.close();
    }

    public static String getLogFileName(String cubeName) {
        StringBuilder sb = new StringBuilder();
        sb.append(XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getXqeLogsDirectory());
        sb.append(File.separatorChar);
        sb.append("ROLAPCubes");
        sb.append(File.separatorChar);
        sb.append(cubeName);
        sb.append(File.separatorChar);
        sb.append("advisor");
        sb.append(File.separatorChar);
        sb.append("logs");
        sb.append(File.separatorChar);
        sb.append("metrics");
        sb.append(File.separatorChar);
        sb.append("advisor_metrics.xml");
        String fileName = sb.toString();
        File file = new File(fileName);
        try {
            fileName = file.getCanonicalPath();
        }
        catch (IOException ex) {
            fileName = file.getPath();
        }
        return fileName;
    }
}

