/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.util.xml.XMLWriter;
import java.io.StringWriter;
import java.util.List;

public class CubeCardinalityMetricsWriter {
    public static String generateXML(CubeCardinalityMetrics cubeCardinalityMetrics) {
        StringWriter stringWriter = new StringWriter();
        XMLWriter xmlWriter = new XMLWriter();
        xmlWriter.addStream(stringWriter);
        xmlWriter.setIndentString("  ");
        xmlWriter.writeHeader("1.0", "UTF-8");
        xmlWriter.beginElement("advisorMetrics", -1);
        xmlWriter.attribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        xmlWriter.attribute("xsi:noNamespaceSchemaLocation", "AdvisorMetrics.xsd");
        CubeCardinalityMetricsWriter.writeCubeCardinalityMetrics(xmlWriter, cubeCardinalityMetrics);
        xmlWriter.endElement();
        return stringWriter.toString();
    }

    private static void writeCubeCardinalityMetrics(XMLWriter xmlWriter, CubeCardinalityMetrics cubeCardinalityMetrics) {
        xmlWriter.beginElement("fact", -1);
        xmlWriter.attribute("cardinality", cubeCardinalityMetrics.getFactCardinality());
        xmlWriter.endElement();
        List<SliceCombination> sliceIds = cubeCardinalityMetrics.getSliceCardinalityIds();
        xmlWriter.beginElement("slices", -1);
        for (SliceCombination sliceId : sliceIds) {
            xmlWriter.beginElement("slice", -1);
            xmlWriter.attribute("sliceId", sliceId.valueToString());
            SliceCardinalityMetrics sliceCardinalityMetrics = cubeCardinalityMetrics.getSliceCardinalityMetrics(sliceId);
            xmlWriter.attribute("actualCardinality", sliceCardinalityMetrics.getActualCardinality());
            xmlWriter.attribute("estimatedCardinality", sliceCardinalityMetrics.getEstimatedCardinality());
            xmlWriter.attribute("factCardinality", sliceCardinalityMetrics.getFactCardinality());
            CubeCardinalityMetricsWriter.writeLevels(xmlWriter, sliceId, cubeCardinalityMetrics.getMetaCube());
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    public static void writeLevels(XMLWriter xmlWriter, SliceCombination sliceId, ROLAPMetaCube metaCube) {
        Aggregate aggregate = Aggregate.createAggregateForSliceId(metaCube, sliceId);
        xmlWriter.beginElement("levels", -1);
        int hierarchyIndex = -1;
        List<ROLAPMetaLevel> levels = aggregate.getLevels();
        for (ROLAPMetaDimension dimension : metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : metaCube.getHierarchies(dimension)) {
                ROLAPMetaLevel level;
                if ((level = levels.get(++hierarchyIndex)) == null) continue;
                xmlWriter.beginElement("level", -1);
                xmlWriter.attribute("name", level.getName());
                xmlWriter.attribute("hierarchy", hierarchy.getName());
                xmlWriter.attribute("dimension", dimension.getName());
                xmlWriter.endElement();
            }
        }
        xmlWriter.endElement();
    }
}

