/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class QueryMatchingAnalysis {
    private ROLAPMetaCube metaCube;
    private AggregateAdvisor aggregateAdvisor;
    private long spaceLimit;
    private QuerySummaryInfoLog querySummaryInfoLog;
    private List<Aggregate> aggregates = new ArrayList<Aggregate>();
    private List<Aggregate> queries = new ArrayList<Aggregate>();
    private List<Aggregate> unmatchedQueries = new ArrayList<Aggregate>();
    private long numberOfQueriesRun;
    private long numberOfQueriesMatched;
    private double numberOfWeightedQueriesRun;
    private double numberOfWeightedQueriesMatched;
    private HashMap<String, RatedAggregate> ratedAggregates = new HashMap();
    static final Comparator<RatedAggregate> DESCENDING_WEIGHTED_HIT_ORDER = new Comparator<RatedAggregate>(){

        @Override
        public int compare(RatedAggregate agg1, RatedAggregate agg2) {
            if (agg1.getWeightedHits() < agg2.getWeightedHits()) {
                return 1;
            }
            if (agg1.getWeightedHits() > agg2.getWeightedHits()) {
                return -1;
            }
            return 0;
        }
    };

    public QueryMatchingAnalysis(ROLAPMetaCube theMetaCube, AggregateAdvisor theAggregateAdvisor) {
        this.metaCube = theMetaCube;
        this.aggregateAdvisor = theAggregateAdvisor;
        this.spaceLimit = this.aggregateAdvisor.getInMemoryAggregatesLimit();
    }

    public void setQuerySummary(QuerySummaryInfoLog theQuerySummaryInfoLog) {
        this.querySummaryInfoLog = theQuerySummaryInfoLog;
        this.generateQueriesFromSummary();
        this.analyzeQueryToAggregateMatching();
    }

    private void generateQueriesFromSummary() {
        this.queries.clear();
        List<QuerySummaryInfo> querySummaryInfos = this.querySummaryInfoLog.getQuerySummaryInfos();
        for (QuerySummaryInfo querySummaryInfo : querySummaryInfos) {
            Aggregate query = this.generateQueryAggregateFromQuerySummaryInfo(querySummaryInfo);
            if (query == null) continue;
            query.setHitCount(querySummaryInfo.getExecutionCount());
            query.setWeightedHitCount(querySummaryInfo.getWeightedExecutionCount());
            this.queries.add(query);
        }
    }

    public void setAggregates(List<Aggregate> theAggregates) {
        this.aggregates.clear();
        this.aggregates.addAll(theAggregates);
        this.ratedAggregates.clear();
        for (Aggregate aggregate : this.aggregates) {
            RatedAggregate ratedAggregate = new RatedAggregate(aggregate);
            this.ratedAggregates.put(this.generateSliceKey(aggregate.getSliceId()), ratedAggregate);
        }
        this.analyzeQueryToAggregateMatching();
    }

    private void analyzeQueryToAggregateMatching() {
        this.unmatchedQueries.clear();
        this.numberOfQueriesRun = 0L;
        this.numberOfQueriesMatched = 0L;
        this.numberOfWeightedQueriesRun = 0.0;
        this.numberOfWeightedQueriesMatched = 0.0;
        for (Aggregate query : this.queries) {
            this.numberOfQueriesRun += (long)query.getHitCount();
            this.numberOfWeightedQueriesRun += query.getWeightedHitCount();
            Aggregate matchedAggregate = AggregateUtils.getInMemoryAggregateEngineWillUseForQuery(query, this.aggregates);
            if (matchedAggregate != null) {
                this.numberOfQueriesMatched += (long)query.getHitCount();
                this.numberOfWeightedQueriesMatched += query.getWeightedHitCount();
                String key = this.generateSliceKey(matchedAggregate.getSliceId());
                RatedAggregate ratedAggregate = this.ratedAggregates.get(key);
                ratedAggregate.incrementHits(query.getHitCount());
                ratedAggregate.incrementWeightedHits(query.getWeightedHitCount());
                continue;
            }
            this.unmatchedQueries.add(query);
        }
    }

    public double getRating() {
        return this.getPercentOfWeightedQueriesMatched();
    }

    public double getPercentOfQueriesMatched() {
        return AdvisorUtils.getPercentage(this.numberOfQueriesMatched, this.numberOfQueriesRun);
    }

    public double getPercentOfWeightedQueriesMatched() {
        return AdvisorUtils.getPercentage(this.numberOfWeightedQueriesMatched, this.numberOfWeightedQueriesRun);
    }

    public double getPercentSpaceUsed() {
        return AdvisorUtils.getPercentage(this.getAggregatesSize(), this.spaceLimit);
    }

    private long getAggregatesSize() {
        return AggregateUtils.getAggregatesSize(this.aggregates);
    }

    public List<Aggregate> getQueries() {
        return this.queries;
    }

    public List<Aggregate> getUnmatchedQueries() {
        return this.unmatchedQueries;
    }

    public Aggregate getLowestRatedNonUserAggregate() {
        Aggregate worstAggregate = null;
        double worstRating = 0.0;
        for (RatedAggregate ratedAggregate : this.ratedAggregates.values()) {
            Aggregate aggregate = ratedAggregate.getAggregate();
            if (aggregate.getRecommendedBy() == AggregateRecommendedByEnum.USER) continue;
            double currentRating = this.getRating(ratedAggregate);
            if (worstAggregate != null && !(currentRating < worstRating)) continue;
            worstRating = currentRating;
            worstAggregate = aggregate;
        }
        return worstAggregate;
    }

    private double getRating(RatedAggregate ratedAggregate) {
        return AdvisorUtils.getPercentage(ratedAggregate.getWeightedHits(), this.numberOfWeightedQueriesRun);
    }

    private double getRatingAsNonRatio(double pctMatchedQueriesHittingThisAggregate, double pctProvidedSpaceUsedByAggregate) {
        return pctMatchedQueriesHittingThisAggregate - pctProvidedSpaceUsedByAggregate;
    }

    private double getRatingAsRatio(double pctMatchedQueriesHittingThisAggregate, double pctProvidedSpaceUsedByAggregate) {
        double rating = 0.0;
        if (pctProvidedSpaceUsedByAggregate > 0.0) {
            rating = pctMatchedQueriesHittingThisAggregate / pctProvidedSpaceUsedByAggregate;
        }
        return rating;
    }

    private Aggregate generateQueryAggregateFromQuerySummaryInfo(QuerySummaryInfo querySummaryInfo) {
        Aggregate aggregate = new Aggregate(this.metaCube);
        for (String measureName : querySummaryInfo.getMeasureNames()) {
            ROLAPMetaMeasure measure = AdvisorUtils.getMetaMeasure(this.metaCube, measureName);
            if (!this.aggregateAdvisor.isMeasureSupported(measure)) continue;
            aggregate.addMeasure(measure);
        }
        if (aggregate.getMeasures().isEmpty()) {
            return null;
        }
        List<String> levelNames = querySummaryInfo.getLevelNames();
        int hierarchyIndex = -1;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                String levelName;
                if ((levelName = levelNames.get(++hierarchyIndex)) == null) continue;
                aggregate.setLevel(dimension.getName(), hierarchy.getName(), levelName);
            }
        }
        aggregate.setName(aggregate.generateDescriptiveName());
        return aggregate;
    }

    private String generateSliceKey(SliceCombination sliceId) {
        return sliceId.valueToString();
    }

    public String formatQueryToAggregateMatchingSummary() {
        String fmt = "Aggregate summary:  %d aggregates.  %.2f pct of weighted queries match (%,.0f of %,.0f).  %.2f pct of queries match (%,d of %,d).  %.2f pct of space used (%,d of %,d).";
        return String.format(fmt, this.ratedAggregates.size(), this.getPercentOfWeightedQueriesMatched(), this.numberOfWeightedQueriesMatched, this.numberOfWeightedQueriesRun, this.getPercentOfQueriesMatched(), this.numberOfQueriesMatched, this.numberOfQueriesRun, this.getPercentSpaceUsed(), this.getAggregatesSize(), this.spaceLimit);
    }

    public String formatQueryToAggregateMatching() {
        StringBuilder sb = new StringBuilder();
        sb.append(AdvisorTrace.heading("Query to aggregate matching"));
        sb.append(this.formatQueryToAggregateMatchingSummary() + '\n' + '\n');
        for (Aggregate query : this.queries) {
            Aggregate matchedAggregate = AggregateUtils.getInMemoryAggregateEngineWillUseForQuery(query, this.aggregates);
            if (matchedAggregate != null) {
                sb.append(String.format("Query [%s] matches aggregate [%s] which has %,d cells%n", query.getName(), matchedAggregate.getName(), matchedAggregate.getNumberOfCells()));
                continue;
            }
            sb.append(String.format("Query [%s] does not match an aggregate%n", query.getName()));
        }
        return sb.toString();
    }

    public String formatAggregateUsage() {
        StringBuilder sb = new StringBuilder();
        sb.append(AdvisorTrace.heading("Aggregates sorted by query matching benefit"));
        sb.append(this.formatQueryToAggregateMatchingSummary() + '\n' + '\n');
        ArrayList<RatedAggregate> sortedRatedAggregates = new ArrayList<RatedAggregate>();
        sortedRatedAggregates.addAll(this.ratedAggregates.values());
        Collections.sort(sortedRatedAggregates, DESCENDING_WEIGHTED_HIT_ORDER);
        sb.append(String.format("%12s %12s %6s %6s %6s %15s %15s %6s %6s %6s %s %s %n", "WHits", "Hits", "WHits%", "Qry %", "Hit %", "Cardinality", "Size", "Size %", "Q%-S%", "Q%/S%", "Slice Id", "Name"));
        for (RatedAggregate ratedAggregate : sortedRatedAggregates) {
            Aggregate aggregate = ratedAggregate.getAggregate();
            long aggregateHitCount = ratedAggregate.getHits();
            double aggregateWeightedHitCount = ratedAggregate.getWeightedHits();
            double pctWeightedQueriesHittingThisAggregate = AdvisorUtils.getPercentage(aggregateWeightedHitCount, this.numberOfWeightedQueriesRun);
            double pctQueriesHittingThisAggregate = AdvisorUtils.getPercentage(aggregateHitCount, this.numberOfQueriesRun);
            double pctMatchedQueriesHittingThisAggregate = AdvisorUtils.getPercentage(aggregateHitCount, this.numberOfQueriesMatched);
            double pctAggregateSizeOfProvidedSpace = AdvisorUtils.getPercentage(aggregate.getEstimatedSize(), this.spaceLimit);
            double ratingAsNonRatio = this.getRatingAsNonRatio(pctQueriesHittingThisAggregate, pctAggregateSizeOfProvidedSpace);
            double ratingAsRatio = this.getRatingAsRatio(pctQueriesHittingThisAggregate, pctAggregateSizeOfProvidedSpace);
            sb.append(String.format("%,12.2f %,12d %6.2f %6.2f %6.2f %,15d %,15d %6.2f %6.2f %6.2f %s %s %n", aggregateWeightedHitCount, aggregateHitCount, pctWeightedQueriesHittingThisAggregate, pctQueriesHittingThisAggregate, pctMatchedQueriesHittingThisAggregate, aggregate.getCardinality(), aggregate.getEstimatedSize(), pctAggregateSizeOfProvidedSpace, ratingAsNonRatio, ratingAsRatio, aggregate.getSliceId().valueToString(), aggregate.getName()));
        }
        return sb.toString();
    }

    private class RatedAggregate {
        private Aggregate aggregate;
        private long hits;
        private double weightedHits;

        RatedAggregate(Aggregate theAggregate) {
            this.aggregate = theAggregate;
        }

        public Aggregate getAggregate() {
            return this.aggregate;
        }

        public long getHits() {
            return this.hits;
        }

        public void incrementHits(long theHits) {
            this.hits += theHits;
        }

        public double getWeightedHits() {
            return this.weightedHits;
        }

        public void incrementWeightedHits(double theWeightedHits) {
            this.weightedHits += theWeightedHits;
        }
    }
}

