/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogReportParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogStatisticsElementData;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class WorkloadParser {
    private static final String LOG_MSG_WORKLOAD_PARSING_INFO = "Parsing the workload log file %s";
    private static final String LOG_MSG_WORKLOAD_LOG_FILE_MISSING = "Could not find the workload log file %s";
    private static final String NULL_STRING = "null";
    private static final int MINUTES_AND_SECONDS = 60;
    private File workloadLogfile = null;
    private XMLStreamReader reader = null;
    private FileInputStream fileInputStream = null;
    private List<WorkloadReportTraceData> reportWorkloadCollection = new ArrayList<WorkloadReportTraceData>();
    private boolean testingMode = false;
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");
    private static String testLogFolderName;

    public void addWorkloadTraceData(WorkloadReportTraceData workloadReportTraceData) {
        this.reportWorkloadCollection.add(workloadReportTraceData);
    }

    public void setTestMode(String logFolderName) {
        this.testingMode = true;
        testLogFolderName = logFolderName;
    }

    public boolean initializeParsing(String cubeName) {
        INFO_LOGGER.log("WorkloadParser Initialize parsing for cube " + cubeName);
        StringBuilder workloadLogPathname = new StringBuilder();
        if (this.testingMode) {
            workloadLogPathname.append(testLogFolderName);
        } else {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            workloadLogPathname.append(configuration.getXqeLogsDirectory());
            workloadLogPathname.append(File.separatorChar);
        }
        workloadLogPathname.append(ROLAPCube.getRelativeWorkloadLogFolder(cubeName));
        File folderExistanceCheck = new File(workloadLogPathname.toString());
        try {
            if (!folderExistanceCheck.exists()) {
                INFO_LOGGER.log(String.format("WorkloadParser Initialize parsing failed because the workload log folder %s does not exist.", workloadLogPathname));
                return false;
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
        String workloadTraceLogFileName = workloadLogPathname.append(File.separatorChar).append("workload_log.xml").toString();
        this.workloadLogfile = new File(workloadTraceLogFileName);
        try {
            if (!this.workloadLogfile.exists()) {
                INFO_LOGGER.log(String.format("WorkloadParser Initialize parsing failed because the workload log file %s does not exist.", workloadLogPathname));
                return false;
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(e);
        }
        INFO_LOGGER.log("WorkloadParser Initialize parsing succeeded.  Full log file name is " + workloadLogPathname);
        return true;
    }

    private void parseWorkloadData() {
        block17: {
            this.reportWorkloadCollection.clear();
            try {
                if (null != this.workloadLogfile) {
                    this.fileInputStream = new FileInputStream(this.workloadLogfile);
                }
                if (null != this.fileInputStream) {
                    this.reader = StaxUtil.createXMLStreamReader(this.fileInputStream);
                }
                if (null == this.reader || !StaxUtil.moveToElement(this.reader)) break block17;
                INFO_LOGGER.log("WorkloadParser Parsing workload log, performing initial validation check on file " + this.workloadLogfile.getPath());
                this.reader.require(1, "http://www.ibm.com/olap/rolap/advisor", "aggregateWorkloads");
                String element = null;
                ParseData parseData = new ParseData();
                WorkloadLogReportParser reportParser = new WorkloadLogReportParser();
                reportParser.setReader(this.reader);
                try {
                    INFO_LOGGER.log("WorkloadParser About to parse workload log file " + this.workloadLogfile.getPath());
                    int event = this.reader.next();
                    while (event != 8) {
                        if ((event == 1 || event == 2) && "report".equals(element = this.reader.getLocalName()) && !reportParser.parse(this, event == 1, parseData)) {
                            break;
                        }
                        event = this.reader.next();
                    }
                }
                catch (XMLStreamException ex) {
                    INFO_LOGGER.log("WorkloadParser Parsing ended normally in WorkloadParser " + this.workloadLogfile.getPath());
                }
            }
            catch (FileNotFoundException ex) {
                ROLAPLog.logError("ROLAPAggregateAdvisor", String.format(LOG_MSG_WORKLOAD_LOG_FILE_MISSING, this.workloadLogfile.getPath()), ex);
                throw new XQERuntimeException(XQEMessageKeys.ROL_MissingWorkloadLogFile, (Throwable)ex, this.workloadLogfile.getPath());
            }
            catch (XMLStreamException ex) {
                ROLAPLog.logError("ROLAPAggregateAdvisor", String.format("Parsing the workload log file %s failed.", this.workloadLogfile.getPath()), ex);
                throw new XQERuntimeException(XQEMessageKeys.ROL_StreamErrorInitializingWorkloadLogParsing, (Throwable)ex, this.workloadLogfile.getPath());
            }
            finally {
                if (null != this.fileInputStream) {
                    try {
                        this.fileInputStream.close();
                        this.fileInputStream = null;
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public List<WorkloadAggregateTraceData> getWorkloads(AdvisorRequestParameters requestParameters) {
        this.parseWorkloadData();
        INFO_LOGGER.log(String.format("Retrieving workloads.  There are %d reports extracted from log file %s.  Each report can contain multiple workloads", this.reportWorkloadCollection.size(), this.getWorkloadLogFileNameForTrace()));
        HashMap<String, CountedReport> reportCounts = new HashMap<String, CountedReport>();
        boolean filteringUsingNames = false;
        HashSet<String> packageNamesFilter = new HashSet<String>();
        HashSet<String> reportNamesFilter = new HashSet<String>();
        HashSet<String> userNamesFilter = new HashSet<String>();
        if (this.isFilteredOnNames(requestParameters)) {
            filteringUsingNames = true;
            packageNamesFilter = new HashSet();
            reportNamesFilter = new HashSet();
            userNamesFilter = new HashSet();
            packageNamesFilter.addAll(requestParameters.getPackageNames());
            this.fixNullsInNamesFilter(packageNamesFilter);
            reportNamesFilter.addAll(requestParameters.getReportNames());
            this.fixNullsInNamesFilter(reportNamesFilter);
            userNamesFilter.addAll(requestParameters.getUserNames());
            this.fixNullsInNamesFilter(userNamesFilter);
        }
        if (requestParameters.isFilterOnReportUsage()) {
            for (WorkloadReportTraceData reportData : this.reportWorkloadCollection) {
                if (reportCounts.containsKey(reportData.reportName)) {
                    ((CountedReport)reportCounts.get(reportData.reportName)).reportCount++;
                    continue;
                }
                CountedReport countedReport = new CountedReport(reportData.reportName);
                reportCounts.put(reportData.reportName, countedReport);
            }
            ArrayList sortedReports = new ArrayList();
            sortedReports.addAll(reportCounts.values());
            Collections.sort(sortedReports);
            int sizeOfSortedReports = sortedReports.size();
            for (int ii = 0; ii < requestParameters.getReportUsage() && ii < sizeOfSortedReports; ++ii) {
                if (reportNamesFilter.contains(((CountedReport)sortedReports.get(ii)).reportName)) continue;
                reportNamesFilter.add(((CountedReport)sortedReports.get(ii)).reportName);
            }
        }
        ArrayList<WorkloadAggregateTraceData> workloadAggregates = new ArrayList<WorkloadAggregateTraceData>(this.reportWorkloadCollection.size());
        Date requestParametersStartDate = requestParameters.getStartTime();
        Date requestParametersEndDate = requestParameters.getEndTime();
        boolean filteringOnTimePeriod = requestParameters.isFilterOnTimePeriod();
        boolean filteringOnDayOfWeek = requestParameters.isFilterOnDaysOfTheWeek();
        RequestParameterTimes requestParameterTimes = null;
        if (filteringOnTimePeriod && filteringOnDayOfWeek) {
            requestParameterTimes = new RequestParameterTimes(requestParameters);
        }
        Date reportDataDate = null;
        boolean rejectedByFiltering = false;
        for (WorkloadReportTraceData reportData : this.reportWorkloadCollection) {
            rejectedByFiltering = false;
            if (filteringOnDayOfWeek || filteringOnTimePeriod) {
                reportDataDate = reportData.getDateTime();
            }
            if (filteringOnDayOfWeek) {
                if (!this.isAllowedDayOfWeek(requestParameters, reportDataDate)) {
                    rejectedByFiltering = true;
                } else if (filteringOnTimePeriod && !this.isAllowedTimeOfDay(requestParameterTimes, reportDataDate)) {
                    rejectedByFiltering = true;
                }
            } else if (filteringOnTimePeriod && (requestParametersStartDate.after(reportDataDate) || requestParametersEndDate.before(reportDataDate))) {
                rejectedByFiltering = true;
            }
            if (!(rejectedByFiltering || !filteringUsingNames || reportNamesFilter.contains(reportData.reportName) || userNamesFilter.contains(reportData.userName) || packageNamesFilter.contains(reportData.packageName))) {
                rejectedByFiltering = true;
            }
            if (rejectedByFiltering) continue;
            workloadAggregates.addAll(reportData.getAggregateWorkloadTraces());
        }
        INFO_LOGGER.log(String.format("WorkloadParser.getWorkloads %d workloads match filtering criteria.  Note that each report can contain multiple workloads.", workloadAggregates.size()));
        return workloadAggregates;
    }

    private void fixNullsInNamesFilter(HashSet<String> namesFilter) {
        if (namesFilter.contains(NULL_STRING)) {
            namesFilter.remove(NULL_STRING);
            namesFilter.add("");
        }
    }

    private boolean isFilteredOnNames(AdvisorRequestParameters requestParameters) {
        return !requestParameters.getPackageNames().isEmpty() || !requestParameters.getUserNames().isEmpty() || !requestParameters.getReportNames().isEmpty() || requestParameters.isFilterOnReportUsage();
    }

    private boolean isAllowedDayOfWeek(AdvisorRequestParameters requestParameters, Date reportDataDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(reportDataDate);
        int dayOfWeek = calendar.get(7);
        int dayOfWeekBitFlag = 0;
        switch (dayOfWeek) {
            case 1: {
                dayOfWeekBitFlag = 64;
                break;
            }
            case 2: {
                dayOfWeekBitFlag = 1;
                break;
            }
            case 3: {
                dayOfWeekBitFlag = 2;
                break;
            }
            case 4: {
                dayOfWeekBitFlag = 4;
                break;
            }
            case 5: {
                dayOfWeekBitFlag = 8;
                break;
            }
            case 6: {
                dayOfWeekBitFlag = 16;
                break;
            }
            case 7: {
                dayOfWeekBitFlag = 32;
                break;
            }
        }
        return requestParameters.isFilterOnDay(dayOfWeekBitFlag);
    }

    private boolean isAllowedTimeOfDay(RequestParameterTimes requestParameterTimes, Date requestDate) {
        boolean isAllowed = false;
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(requestDate);
        int secondsFromMidnight = calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13);
        if (requestParameterTimes.startSecondFromMidnight <= secondsFromMidnight && secondsFromMidnight <= requestParameterTimes.endSecondsFromMidnight) {
            isAllowed = true;
        }
        return isAllowed;
    }

    public List<WorkloadReportTraceData> getReportTraces() {
        this.parseWorkloadData();
        return this.reportWorkloadCollection;
    }

    public String getWorkloadLogPath() {
        String fileName = null;
        if (null != this.workloadLogfile) {
            fileName = this.workloadLogfile.getPath();
        }
        return fileName;
    }

    public String getWorkloadLogFileNameForTrace() {
        String fileName = null;
        fileName = null != this.workloadLogfile ? this.workloadLogfile.getPath() : "unknown";
        return fileName;
    }

    public void tearDown() {
        if (this.reportWorkloadCollection != null && !this.reportWorkloadCollection.isEmpty()) {
            for (WorkloadReportTraceData data : this.reportWorkloadCollection) {
                data.tearDown();
            }
            this.reportWorkloadCollection.clear();
        }
    }

    private class RequestParameterTimes {
        private int startSecondFromMidnight = 0;
        private int endSecondsFromMidnight = 0;
        private Calendar calendar = Calendar.getInstance();

        RequestParameterTimes(AdvisorRequestParameters requestParameters) {
            this.startSecondFromMidnight = this.convertToSecondsFromMidnight(requestParameters.getStartTime());
            this.endSecondsFromMidnight = this.convertToSecondsFromMidnight(requestParameters.getEndTime());
        }

        int convertToSecondsFromMidnight(Date timeToConvert) {
            this.calendar.setTime(timeToConvert);
            return this.calendar.get(11) * 60 * 60 + this.calendar.get(12) * 60 + this.calendar.get(13);
        }
    }

    private class CountedReport
    implements Comparable<CountedReport> {
        private String reportName = new String();
        private int reportCount = 0;

        CountedReport(String reportNameIn) {
            this.reportName = reportNameIn;
            this.reportCount = 1;
        }

        @Override
        public int compareTo(CountedReport incomingCountedReport) {
            int returnValue = 0;
            int incomingCount = incomingCountedReport.reportCount;
            if (this.reportCount > incomingCount) {
                returnValue = -1;
            } else if (this.reportCount < incomingCount) {
                returnValue = 1;
            }
            return returnValue;
        }
    }

    public class ParseData {
        private WorkloadReportTraceData workloadReportTraceData = null;
        private WorkloadAggregateTraceData aggregateWorkloadData = null;
        private HierarchyTraceData hierarchyData = null;

        public WorkloadReportTraceData getReportWorkloadData() {
            return this.workloadReportTraceData;
        }

        public void createNewReportTraceTraceData() {
            this.workloadReportTraceData = new WorkloadReportTraceData();
        }

        public void createNewAggregateWorkloadTraceData() {
            this.aggregateWorkloadData = new WorkloadAggregateTraceData();
        }

        public void finishAggregateWorkload() {
            if (null != this.workloadReportTraceData) {
                this.workloadReportTraceData.finishAggregateWorkload(this.aggregateWorkloadData);
            }
        }

        public HierarchyTraceData createNewHierarchyTraceData() {
            this.hierarchyData = new HierarchyTraceData();
            return this.hierarchyData;
        }

        public HierarchyTraceData getHierarchyTraceData() {
            return this.hierarchyData;
        }

        public void addHierarchy() {
            if (null != this.aggregateWorkloadData) {
                this.aggregateWorkloadData.addHierarchy(this.hierarchyData);
            }
        }

        public WorkloadLogStatisticsElementData getStatisticsTraceData() {
            if (this.aggregateWorkloadData == null) {
                return null;
            }
            return this.aggregateWorkloadData.getStatisticsData();
        }

        public void addMeasure(String measure) {
            if (null != this.aggregateWorkloadData) {
                this.aggregateWorkloadData.addMeasure(measure);
            }
        }
    }

    public class WorkloadReportTraceData {
        private List<WorkloadAggregateTraceData> workloadAggregateTraces = new ArrayList<WorkloadAggregateTraceData>();
        private String requestID;
        private String subRequestID;
        private String packageName;
        private String serverGroupName;
        private String dispatcherName;
        private String userName;
        private String reportName;
        private Date dateTime;
        private long reportExecutionTime;

        public void setRequestID(String requestIDIn) {
            this.requestID = requestIDIn;
        }

        public String getRequestID() {
            return this.requestID;
        }

        public void setSubRequestID(String subRequestIDIn) {
            this.subRequestID = subRequestIDIn;
        }

        public String getSubRequestID() {
            return this.subRequestID;
        }

        public void setPackageName(String packageNameIn) {
            this.packageName = packageNameIn;
        }

        public String getPackageName() {
            return this.packageName;
        }

        public void setServerGroup(String serverGroupNameIn) {
            this.serverGroupName = serverGroupNameIn;
        }

        public String getServerGroup() {
            return this.serverGroupName;
        }

        public void setDispatcher(String dispatcherNameIn) {
            this.dispatcherName = dispatcherNameIn;
        }

        public String getDispatcher() {
            return this.dispatcherName;
        }

        public void setUserName(String userNameIn) {
            this.userName = userNameIn;
        }

        public String getUserName() {
            return this.userName;
        }

        public void setReportName(String reportNameIn) {
            this.reportName = reportNameIn;
        }

        public String getReportName() {
            return this.reportName;
        }

        public void setDateTime(Date dateTimeIn) {
            this.dateTime = dateTimeIn;
        }

        public Date getDateTime() {
            return this.dateTime;
        }

        public void setReportExecutionTime(long reportExecutionTimeIn) {
            this.reportExecutionTime = reportExecutionTimeIn;
        }

        public long getReportExecutionTime() {
            return this.reportExecutionTime;
        }

        private void finishAggregateWorkload(WorkloadAggregateTraceData aggregateWorkloadTraceData) {
            this.workloadAggregateTraces.add(aggregateWorkloadTraceData);
        }

        private List<WorkloadAggregateTraceData> getAggregateWorkloadTraces() {
            return this.workloadAggregateTraces;
        }

        public void tearDown() {
            if (this.workloadAggregateTraces != null && !this.workloadAggregateTraces.isEmpty()) {
                for (WorkloadAggregateTraceData data : this.workloadAggregateTraces) {
                    data.tearDown();
                }
                this.workloadAggregateTraces.clear();
            }
        }
    }

    public class WorkloadAggregateTraceData {
        private List<HierarchyTraceData> hierarchyCollection = new ArrayList<HierarchyTraceData>();
        private List<String> measuresCollection = new ArrayList<String>();
        private WorkloadLogStatisticsElementData statisticsData = new WorkloadLogStatisticsElementData();

        public void addHierarchy(HierarchyTraceData hierarchyData) {
            this.hierarchyCollection.add(hierarchyData);
        }

        public List<HierarchyTraceData> getHierarchies() {
            return this.hierarchyCollection;
        }

        public boolean hasHierarchies() {
            return !this.hierarchyCollection.isEmpty();
        }

        public WorkloadLogStatisticsElementData getStatisticsData() {
            return this.statisticsData;
        }

        public void addMeasure(String measure) {
            this.measuresCollection.add(measure);
        }

        public List<String> getMeasures() {
            return this.measuresCollection;
        }

        public void tearDown() {
            if (this.hierarchyCollection != null && !this.hierarchyCollection.isEmpty()) {
                this.hierarchyCollection.clear();
            }
            if (this.measuresCollection != null && !this.measuresCollection.isEmpty()) {
                this.measuresCollection.clear();
            }
        }
    }

    public class HierarchyTraceData {
        private String dimensionName = null;
        private String hierarchyName = null;
        private String levelName = null;

        public void setDimensionName(String dimensionNameIn) {
            this.dimensionName = dimensionNameIn;
        }

        public String getDimensionName() {
            return this.dimensionName;
        }

        public void setHierarchyName(String hierarchyNameIn) {
            this.hierarchyName = hierarchyNameIn;
        }

        public String getHierarchyName() {
            return this.hierarchyName;
        }

        public void setLevelName(String levelNameIn) {
            this.levelName = levelNameIn;
        }

        public String getLevelName() {
            return this.levelName;
        }
    }
}

