/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.LogConstants;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;

public class LogUtility {
    public static String getWorkloadLogFileName(String cubeName) {
        return LogUtility.getWorkloadLogFileName(cubeName, false);
    }

    public static String getWorkloadLogFileName(String cubeName, boolean createDir) {
        StringBuilder sb;
        File workloadFolder = LogUtility.getWorkloadFolder(cubeName, createDir);
        try {
            sb = new StringBuilder(workloadFolder.getCanonicalPath());
        }
        catch (IOException e) {
            sb = new StringBuilder(workloadFolder.getPath());
        }
        sb.append(File.separatorChar).append("workload_log.xml");
        return sb.toString();
    }

    public static File getWorkloadFolder(String cubeName, boolean createDir) {
        StringBuilder sb = new StringBuilder();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        sb.append(configuration.getXqeLogsDirectory());
        sb.append(ROLAPCube.getRelativeWorkloadLogFolder(cubeName));
        File folder = new File(sb.toString());
        if (!folder.exists() && createDir) {
            folder.mkdirs();
        }
        return folder;
    }

    public static SimpleDateFormat generateReportDateTimeFormat() {
        return new SimpleDateFormat(String.format(LogConstants.REPORT_DATE_TIME_FORMAT_STRING, new Object[0]));
    }
}

