/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryReader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryWriter;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class QuerySummaryFileUtility {
    public static QuerySummaryInfoLog readQuerySummaryFile(ROLAPMetaCube metaCube) throws Exception {
        return QuerySummaryFileUtility.readQuerySummaryFile(metaCube, "query_summary.xml");
    }

    public static QuerySummaryInfoLog readQuerySummaryFileProvidedByTest(ROLAPMetaCube metaCube) throws Exception {
        return QuerySummaryFileUtility.readQuerySummaryFile(metaCube, "query_summary_test.xml");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QuerySummaryInfoLog readQuerySummaryFile(ROLAPMetaCube metaCube, String fileName) throws XMLStreamException {
        QuerySummaryInfoLog querySummaryInfoLog = null;
        String querySummaryFileName = QuerySummaryFileUtility.getQuerySummaryPathName(metaCube.getName()) + File.separatorChar + fileName;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(querySummaryFileName);
            XMLStreamReader xmlStreamReader = StaxUtil.createXMLStreamReader(fileInputStream);
            QuerySummaryReader querySummaryReader = new QuerySummaryReader(xmlStreamReader, metaCube);
            querySummaryInfoLog = querySummaryReader.parseQuerySummary();
        }
        catch (FileNotFoundException e) {
            querySummaryInfoLog = new QuerySummaryInfoLog(new ArrayList<QuerySummaryInfo>());
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return querySummaryInfoLog;
    }

    public static void writeQuerySummaryFile(ROLAPMetaCube metaCube, QuerySummaryInfoLog querySummaryInfoLog) throws FileNotFoundException {
        String xml = QuerySummaryWriter.generateXML(querySummaryInfoLog, metaCube);
        String querySummaryFileName = QuerySummaryFileUtility.getQuerySummaryPathName(metaCube.getName()) + File.separatorChar + "query_summary.xml";
        File file = new File(querySummaryFileName);
        File directory = file.getParentFile();
        directory.mkdirs();
        PrintWriter writer = new PrintWriter(querySummaryFileName);
        writer.println(xml);
        writer.close();
    }

    private static String getQuerySummaryPathName(String cubeName) {
        StringBuilder querySummaryPathName = new StringBuilder();
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        querySummaryPathName.append(configuration.getXqeLogsDirectory());
        querySummaryPathName.append(File.separatorChar);
        querySummaryPathName.append(ROLAPCube.getRelativeWorkloadLogFolder(cubeName));
        return querySummaryPathName.toString();
    }

    public static String getQuerySummaryFileName(String cubeName) {
        return QuerySummaryFileUtility.getQuerySummaryPathName(cubeName) + File.separatorChar + "query_summary.xml";
    }
}

