/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadLogger;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.JVMArguments;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ConfigurationValues;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuerySummaryInfoLogger
extends WorkloadLogger {
    private static final int WRITE_QUERY_SUMMARY_INFO_INTERVAL = JVMArguments.getAutonomicLoggingWriteQuerySummaryInfoInterval();
    private static final String WEIGHTED_EXECUTION_COUNTS_REDUCTION_RATE_KEY = "AdvisorWeightedExecutionCountsReductionRate";
    private static final int DEFAULT_WEIGHTED_EXECUTION_COUNTS_REDUCTION_RATE = 95;
    public static final String WEIGHTED_EXECUTION_COUNTS_UPDATE_DATE_JVM_PARAM = "weightedExecutionCountsUpdateDate";
    public static final String MAX_QUERY_SUMMARY_INFOS = "AdvisorMaxQuerySummaryInfo";
    private static final int DEFAULT_MAX_QUERY_SUMMARY_INFOS = 1000;
    public static final String TRIM_QUERY_SUMMARY_INFO_PCT = "AdvisorTrimQuerySummaryInfoPct";
    private static final int DEFAULT_TRIM_QUERY_SUMMARY_INFO_PCT = 5;
    private static final String PCH_LEVEL_NAME_PREFIX = "Level ";
    private static Comparator<Map.Entry<String, QuerySummaryInfo>> mapEntryComparator = new Comparator<Map.Entry<String, QuerySummaryInfo>>(){

        @Override
        public int compare(Map.Entry<String, QuerySummaryInfo> o1, Map.Entry<String, QuerySummaryInfo> o2) {
            return QuerySummaryInfo.getAscendingTimeComparator().compare(o1.getValue(), o2.getValue());
        }
    };
    private Map<String, QuerySummaryInfo> queryKeyToQuerySummaryInfoMap = new HashMap<String, QuerySummaryInfo>();
    private ROLAPMetaCube metaCube;
    private int numberOfQueriesLoggedSinceLastWrite;
    private String weightedExecutionCountsUpdateDate = "";
    private final int maxQuerySummaryInfos = ConfigurationValues.getZeroOrPositiveInt("AdvisorMaxQuerySummaryInfo", 1000);

    public QuerySummaryInfoLogger(ROLAPCube cube) {
        super(cube);
    }

    @Override
    public boolean isLoggingEnabledForCube() {
        return true;
    }

    @Override
    public synchronized void startLogging() {
        this.metaCube = this.mCube.getModelCube();
        this.readQuerySummaryInfoLogFromDisk();
        this.initialized = true;
    }

    @Override
    public synchronized void stopLogging() {
        this.initialized = false;
        this.writeQuerySummaryInfoLogToDisk();
        this.numberOfQueriesLoggedSinceLastWrite = 0;
        this.queryKeyToQuerySummaryInfoMap.clear();
    }

    @Override
    public synchronized void clearLogs() {
    }

    public synchronized QuerySummaryInfoLog getQuerySummaryInfoLog() {
        ArrayList<QuerySummaryInfo> querySummaryInfos = new ArrayList<QuerySummaryInfo>(this.queryKeyToQuerySummaryInfoMap.values());
        QuerySummaryInfoLog querySummaryInfoLog = new QuerySummaryInfoLog(querySummaryInfos);
        querySummaryInfoLog.setWeightedExecutionCountsUpdateDate(this.weightedExecutionCountsUpdateDate);
        return querySummaryInfoLog;
    }

    @Override
    public synchronized void logWorkloadInfo(WorkloadInfo workloadInfo) {
        if (this.isWorkloadInfoFromAggregateLoad(workloadInfo)) {
            return;
        }
        if (this.isDateChangedSinceWeightedExecutionCountsUpdated()) {
            this.reduceWeightedExecutionCounts();
        }
        long now = System.currentTimeMillis();
        Collection<WorkloadInfo.WorkloadEntry> workloadEntries = workloadInfo.getWorkloadEntries();
        for (WorkloadInfo.WorkloadEntry workloadEntry : workloadEntries) {
            List<String> levelNames = this.getLevelNames(workloadEntry);
            if (levelNames == null) continue;
            String queryKey = this.createQueryKey(levelNames);
            QuerySummaryInfo querySummaryInfo = this.queryKeyToQuerySummaryInfoMap.get(queryKey);
            if (querySummaryInfo == null) {
                querySummaryInfo = new QuerySummaryInfo(levelNames);
                this.queryKeyToQuerySummaryInfoMap.put(queryKey, querySummaryInfo);
            }
            querySummaryInfo.incrementExecutionCount();
            long executionTime = workloadEntry.getExecutionTime();
            querySummaryInfo.incrementExecutionTime(executionTime);
            querySummaryInfo.setLastUsedTime(now);
            List<String> measureNames = workloadEntry.getMeasures();
            for (String measureName : measureNames) {
                querySummaryInfo.incrementMeasureHitCount(measureName);
            }
            if (this.queryKeyToQuerySummaryInfoMap.size() > this.maxQuerySummaryInfos) {
                this.trimQuerySummaryInfoMap();
            }
            ++this.numberOfQueriesLoggedSinceLastWrite;
            if (this.numberOfQueriesLoggedSinceLastWrite < WRITE_QUERY_SUMMARY_INFO_INTERVAL) continue;
            this.writeQuerySummaryInfoLogToDisk();
            this.numberOfQueriesLoggedSinceLastWrite = 0;
        }
    }

    private void trimQuerySummaryInfoMap() {
        double querySummaryTrimPct = ConfigurationValues.getPercentFromInt(TRIM_QUERY_SUMMARY_INFO_PCT, 5);
        int numItemsDesired = this.maxQuerySummaryInfos - (int)((double)this.maxQuerySummaryInfos * querySummaryTrimPct);
        int numItemsToTrim = this.queryKeyToQuerySummaryInfoMap.size() - numItemsDesired;
        ArrayList<Map.Entry<String, QuerySummaryInfo>> mapEntryList = new ArrayList<Map.Entry<String, QuerySummaryInfo>>(this.queryKeyToQuerySummaryInfoMap.entrySet());
        Collections.sort(mapEntryList, mapEntryComparator);
        for (int i = 0; i < numItemsToTrim; ++i) {
            this.queryKeyToQuerySummaryInfoMap.remove(((Map.Entry)mapEntryList.get(i)).getKey());
        }
    }

    private boolean isDateChangedSinceWeightedExecutionCountsUpdated() {
        String currentDateIsoFormat = System.getProperty(WEIGHTED_EXECUTION_COUNTS_UPDATE_DATE_JVM_PARAM);
        if (currentDateIsoFormat == null) {
            SimpleDateFormat isoDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date currentDate = new Date();
            currentDateIsoFormat = isoDateFormat.format(currentDate);
        }
        boolean isDateChanged = false;
        if (!currentDateIsoFormat.equals(this.weightedExecutionCountsUpdateDate)) {
            isDateChanged = true;
            this.weightedExecutionCountsUpdateDate = currentDateIsoFormat;
        }
        return isDateChanged;
    }

    private void reduceWeightedExecutionCounts() {
        double reductionPct = ConfigurationValues.getPercentFromInt(WEIGHTED_EXECUTION_COUNTS_REDUCTION_RATE_KEY, 95);
        for (Map.Entry<String, QuerySummaryInfo> entry : this.queryKeyToQuerySummaryInfoMap.entrySet()) {
            QuerySummaryInfo querySummaryInfo = entry.getValue();
            double updatedWeightedExecutionCount = reductionPct * querySummaryInfo.getWeightedExecutionCount();
            querySummaryInfo.setWeightedExecutionCount(updatedWeightedExecutionCount);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<String> getLevelNames(WorkloadInfo.WorkloadEntry workloadEntry) {
        ROLAPMetaDimension[] metaDimensions;
        ArrayList<String> levelNames = new ArrayList<String>();
        for (ROLAPMetaDimension metaDimension : metaDimensions = this.metaCube.getDimensions()) {
            ROLAPMetaHierarchy[] metaHierarchies;
            String dimensionName = metaDimension.getName();
            for (ROLAPMetaHierarchy metaHierarchy : metaHierarchies = this.metaCube.getHierarchies(metaDimension)) {
                String hierarchyName = metaHierarchy.getName();
                String levelName = workloadEntry.getLevelName(dimensionName, hierarchyName);
                if (metaHierarchy.isRecursive()) {
                    if (metaHierarchy.hasAllLevel()) {
                        if (levelName != null && levelName.startsWith(PCH_LEVEL_NAME_PREFIX)) return null;
                        levelName = null;
                    } else {
                        if (levelName != null && !"Level 1".equals(levelName)) return null;
                        levelName = "[Root]";
                    }
                }
                levelNames.add(levelName);
            }
        }
        return levelNames;
    }

    private String createQueryKey(List<String> levelNames) {
        ROLAPMetaDimension[] metaDimensions;
        StringBuilder sb = new StringBuilder();
        int hierarchyIndex = 0;
        for (ROLAPMetaDimension metaDimension : metaDimensions = this.metaCube.getDimensions()) {
            ROLAPMetaHierarchy[] metaHierarchies;
            for (ROLAPMetaHierarchy metaHierarchy : metaHierarchies = this.metaCube.getHierarchies(metaDimension)) {
                String levelName = levelNames.get(hierarchyIndex);
                int levelDepth = 0;
                if (levelName != null) {
                    levelDepth = AdvisorUtils.getLevelDepth(metaHierarchy, levelName);
                }
                if (hierarchyIndex > 0) {
                    sb.append(",");
                }
                sb.append(levelDepth);
                ++hierarchyIndex;
            }
        }
        return sb.toString();
    }

    private void writeQuerySummaryInfoLogToDisk() {
        if (this.numberOfQueriesLoggedSinceLastWrite == 0) {
            return;
        }
        try {
            this.logger.log("Writing summary information about queries to disk");
            QuerySummaryInfoLog querySummaryInfoLog = this.getQuerySummaryInfoLog();
            QuerySummaryFileUtility.writeQuerySummaryFile(this.metaCube, querySummaryInfoLog);
            this.logger.log(String.format("Wrote summary information about %,d queries to disk", querySummaryInfoLog.getQuerySummaryInfos().size()));
        }
        catch (Exception ex) {
            this.logger.log(LogLevel.WARN, "The summary information about queries could not be written to disk.", (Throwable)ex);
        }
    }

    private void readQuerySummaryInfoLogFromDisk() {
        try {
            this.logger.log("Reading summary information about queries from disk");
            QuerySummaryInfoLog querySummaryInfoLog = QuerySummaryFileUtility.readQuerySummaryFile(this.metaCube);
            this.weightedExecutionCountsUpdateDate = querySummaryInfoLog.getWeightedExecutionCountsUpdateDate();
            List<QuerySummaryInfo> querySummaryInfos = querySummaryInfoLog.getQuerySummaryInfos();
            this.logger.log(String.format("Read summary information about %,d queries from disk", querySummaryInfos.size()));
            for (QuerySummaryInfo querySummaryInfo : querySummaryInfos) {
                List<String> levelNames = querySummaryInfo.getLevelNames();
                String queryKey = this.createQueryKey(levelNames);
                this.queryKeyToQuerySummaryInfoMap.put(queryKey, querySummaryInfo);
            }
            this.logger.log(String.format("Loaded summary information about %,d queries into memory", this.queryKeyToQuerySummaryInfoMap.size()));
        }
        catch (Exception ex) {
            this.logger.log(LogLevel.WARN, "The summary information about queries could not be read from disk.", (Throwable)ex);
        }
    }
}

