/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogElementParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLoggerTypes;
import com.cognos.xqe.trace.XQELogger;
import javax.xml.stream.XMLStreamException;

public class WorkloadLogHierarchyParser
extends WorkloadLogElementParser {
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");
    private static final String LEVEL_STRING = "level";

    @Override
    protected void initialize() {
        this.registerType(LEVEL_STRING, WorkloadLoggerTypes.ElementEnum.hierarchyLevelElement);
        this.registerType("hierarchy", WorkloadLoggerTypes.ElementEnum.hierarchyElement);
    }

    @Override
    public boolean parse(WorkloadParser workloadParser, boolean start, WorkloadParser.ParseData parseData) {
        if (start) {
            WorkloadParser.HierarchyTraceData hierarchyData = parseData.createNewHierarchyTraceData();
            String elementName = null;
            try {
                hierarchyData.setHierarchyName(this.mReader.getAttributeValue("", "name"));
                hierarchyData.setDimensionName(this.mReader.getAttributeValue("", "dimension"));
                block5: while (this.locateNextStartOrEndElement() && this.isStartElement()) {
                    elementName = this.getElementName();
                    switch (this.getType(elementName)) {
                        case hierarchyLevelElement: {
                            parseData.getHierarchyTraceData().setLevelName(this.mReader.getAttributeValue("", "name"));
                            parseData.addHierarchy();
                            continue block5;
                        }
                    }
                }
            }
            catch (XMLStreamException ex) {
                INFO_LOGGER.log(String.format("WorkloadLogHierarchyParser encountered invalid hierarchy element while parsing %s", workloadParser.getWorkloadLogFileNameForTrace()));
                throw new XQERuntimeException(XQEMessageKeys.ROL_ErrorParsingWorkloadLogFile, (Throwable)ex, elementName, (Object)workloadParser.getWorkloadLogPath());
            }
        }
        return this.isMoreDataAvailable();
    }
}

