/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogElementParser;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLogStatisticsElementData;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadLoggerTypes;
import com.cognos.xqe.trace.XQELogger;
import javax.xml.stream.XMLStreamException;

public class WorkloadLogStatisticsElementParser
extends WorkloadLogElementParser {
    private static final XQELogger INFO_LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor");

    @Override
    public void initialize() {
        this.registerType("numberOfRows", WorkloadLoggerTypes.ElementEnum.statisticsNumberOfRows);
        this.registerType("cacheHit", WorkloadLoggerTypes.ElementEnum.statisticsCacheHit);
        this.registerType("accessType", WorkloadLoggerTypes.ElementEnum.statisticsAccess);
        this.registerType("executionTime", WorkloadLoggerTypes.ElementEnum.statisticsQueryExecutionTime);
        this.registerType("aggregateName", WorkloadLoggerTypes.ElementEnum.statisticsAggregateName);
        this.registerType("statistics", WorkloadLoggerTypes.ElementEnum.statisticsElement);
    }

    @Override
    public boolean parse(WorkloadParser workloadParser, boolean start, WorkloadParser.ParseData parseData) throws XQERuntimeException, XMLStreamException {
        WorkloadLogStatisticsElementData statsTracedata;
        if (start && null != (statsTracedata = parseData.getStatisticsTraceData())) {
            String elementName = null;
            WorkloadLoggerTypes.ElementEnum type = WorkloadLoggerTypes.ElementEnum.unknownElement;
            try {
                block9: while (this.locateNextStartOrEndElement()) {
                    elementName = this.getElementName();
                    type = this.getType(elementName);
                    if (this.isStartElement()) {
                        switch (type) {
                            case statisticsNumberOfRows: {
                                statsTracedata.setNumberOfRows(new Long(this.getElementValue()));
                                continue block9;
                            }
                            case statisticsCacheHit: {
                                statsTracedata.setCacheHit(new Boolean(this.getElementValue()));
                                continue block9;
                            }
                            case statisticsAccess: {
                                statsTracedata.setAccessType(new Integer(this.getElementValue()));
                                continue block9;
                            }
                            case statisticsQueryExecutionTime: {
                                statsTracedata.setExecutionTime(new Long(this.getElementValue()));
                                continue block9;
                            }
                            case statisticsAggregateName: {
                                statsTracedata.setAggregateName(this.getElementValue());
                                continue block9;
                            }
                        }
                        continue;
                    }
                    if (WorkloadLoggerTypes.ElementEnum.statisticsElement != type) continue;
                    break;
                }
            }
            catch (XMLStreamException ex) {
                INFO_LOGGER.log(String.format("WorkloadLogStatisticsElementParser encountered an invalid statitics element while parsing %s", workloadParser.getWorkloadLogFileNameForTrace()));
                throw new XQERuntimeException(XQEMessageKeys.ROL_ErrorParsingWorkloadLogFile, (Throwable)ex, (Object)elementName, (Object)workloadParser.getWorkloadLogPath());
            }
        }
        return this.isMoreDataAvailable();
    }
}

