/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class WorkloadSummarizedMeasuresCollection {
    private Map<String, MeasureSummaryData> mCountedMeasuresMap = new HashMap<String, MeasureSummaryData>();

    public void recordHit(String measureName) {
        if (this.mCountedMeasuresMap.containsKey(measureName)) {
            this.mCountedMeasuresMap.get(measureName).incrementHitCount();
        } else {
            this.mCountedMeasuresMap.put(measureName, new MeasureSummaryData(measureName));
        }
    }

    public void recordHits(List<String> measureNames) {
        for (String measureName : measureNames) {
            this.recordHit(measureName);
        }
    }

    public void recordHits(String measureName, int numberOfHits) {
        if (this.mCountedMeasuresMap.containsKey(measureName)) {
            this.mCountedMeasuresMap.get(measureName).incrementHitCount(numberOfHits);
        } else {
            this.mCountedMeasuresMap.put(measureName, new MeasureSummaryData(measureName, numberOfHits));
        }
    }

    public int getCollectionSizeForTrace() {
        return this.mCountedMeasuresMap.size();
    }

    public HashMap<String, MeasureSummaryData> getCollection() {
        HashMap<String, MeasureSummaryData> copyToReturn = new HashMap<String, MeasureSummaryData>();
        Iterator<Map.Entry<String, MeasureSummaryData>> iterator = this.mCountedMeasuresMap.entrySet().iterator();
        Map.Entry<String, MeasureSummaryData> anEntry = null;
        String key = null;
        MeasureSummaryData clonedValue = null;
        while (iterator.hasNext()) {
            anEntry = iterator.next();
            key = anEntry.getKey();
            clonedValue = new MeasureSummaryData(anEntry.getValue());
            copyToReturn.put(key, clonedValue);
        }
        return copyToReturn;
    }

    public WorkloadSummarizedMeasuresCollection makeClone() {
        WorkloadSummarizedMeasuresCollection clonedObject = new WorkloadSummarizedMeasuresCollection();
        clonedObject.mCountedMeasuresMap = this.getCollection();
        return clonedObject;
    }

    public class MeasureSummaryData {
        private String mMeasureName = null;
        private int mNumberOfHits = 0;

        public MeasureSummaryData(String measureName) {
            this.mNumberOfHits = 1;
            this.mMeasureName = measureName;
        }

        public MeasureSummaryData(String measureName, int numberOfHits) {
            this.mNumberOfHits = numberOfHits;
            this.mMeasureName = measureName;
        }

        public MeasureSummaryData(MeasureSummaryData countedData) {
            this.mMeasureName = countedData.mMeasureName;
            this.mNumberOfHits = countedData.mNumberOfHits;
        }

        public void incrementHitCount() {
            ++this.mNumberOfHits;
        }

        public void incrementHitCount(int incrementAmount) {
            this.mNumberOfHits += incrementAmount;
        }

        public int getHitCount() {
            return this.mNumberOfHits;
        }

        public String getMeasureName() {
            return this.mMeasureName;
        }
    }
}

