/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCommandResult;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.io.File;
import java.util.List;

public class AdvisorRetrieveSubsequentRecommendationsResult
extends AdvisorCommandResult {
    private static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor", LogLevel.TRACE);
    private static final long TOTAL_FILE_SIZE_LIMIT = 0xA00000L;
    private List<File> recommendationFiles;
    private int fromIndex;
    private int toIndex;

    public AdvisorRetrieveSubsequentRecommendationsResult(List<File> theRecommendationFiles) {
        this.recommendationFiles = theRecommendationFiles;
    }

    public void determineRecommendationFilesToReturn() {
        int index;
        LOGGER.log("Determining the recommendation files to return");
        int fileCount = this.recommendationFiles.size();
        LOGGER.log(String.format("Current state of the recommendation files: fromIndex = %,d, toIndex = %,d, diff = %,d, fileCount = %,d", this.fromIndex, this.toIndex, this.toIndex - this.fromIndex, fileCount));
        this.fromIndex = this.toIndex;
        long totalFileSize = 0L;
        for (index = this.fromIndex; index < fileCount; ++index) {
            File file = this.recommendationFiles.get(index);
            long fileSize = file.length();
            if (index != this.fromIndex && totalFileSize + fileSize > 0xA00000L) break;
            LOGGER.log(String.format("Including the recommendation file at index %,d with size %,d bytes and name %s", index, fileSize, file.getAbsoluteFile()));
            totalFileSize += fileSize;
        }
        this.toIndex = index;
        LOGGER.log(String.format("New state of the recommendation files: fromIndex = %,d, toIndex = %,d, diff = %,d, fileCount = %,d", this.fromIndex, this.toIndex, this.toIndex - this.fromIndex, fileCount));
        if (this.toIndex < fileCount) {
            this.setState(AggregateAdvisorState.EXECUTING);
        } else {
            this.setState(AggregateAdvisorState.SUCCEEDED);
            this.addMessage(new XQERuntimeException(XQEMessageKeys.ROL_AdvisorCommandSucceeded, "retrieveSubsequentAggregateAdvisorRecommendations"));
        }
        LOGGER.log(String.format("State of the command that retrieves recommendation files: %s", this.getState().toString()));
    }

    public List<File> getRecommendationFilesToReturn() {
        return this.recommendationFiles.subList(this.fromIndex, this.toIndex);
    }
}

