/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Advisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCancelReason;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.XQELogger;
import java.util.concurrent.Callable;

public class AdvisorRunTimeLimitEnforcerTask
implements Callable<Object> {
    private static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor.Management");
    private static final long SLEEP_TIME = 30000L;
    private Advisor advisor;
    private String sessionID;
    private long runTimeLimit;
    private HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();

    public AdvisorRunTimeLimitEnforcerTask(Advisor theAdvisor, String theSessionID, long theRunTimeLimit) {
        this.advisor = theAdvisor;
        this.sessionID = theSessionID;
        this.runTimeLimit = theRunTimeLimit;
        this.stopWatch.start();
    }

    @Override
    public Object call() throws Exception {
        TraceContext traceContext = TraceContext.enter();
        traceContext.addAttribute("rolapCube", this.advisor.getCubeName());
        try {
            LOGGER.log(String.format("The %s started.", this));
            this.enforceRunTimeLimit();
            LOGGER.log(String.format("The %s stopped.", this));
            Object var2_2 = null;
            return var2_2;
        }
        finally {
            traceContext.exit();
        }
    }

    private void enforceRunTimeLimit() {
        AggregateAdvisorState state = this.advisor.getState();
        while (!state.isDone()) {
            long runTime = this.getRunTime();
            if (runTime >= this.runTimeLimit) {
                if (state.isOptimizing()) {
                    LOGGER.log(String.format("The advisor exceeded the run time limit of %d minute(s), and it has a set of recommendations.  It will be stopped.", this.runTimeLimit));
                    this.advisor.stop(this.sessionID, AdvisorCancelReason.RUN_TIME_LIMIT_REACHED);
                    this.advisor.setState(AggregateAdvisorState.COMPLETED);
                    break;
                }
                LOGGER.log(LogLevel.TRACE, String.format("The advisor exceeded the run time limit of %d minute(s), but it does not have a set of recommendations.  It will be allowed to continue to run until it has a set of recommendations.", this.runTimeLimit));
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException ex) {
                LOGGER.log(String.format("The %s was interrupted.", this));
                break;
            }
            state = this.advisor.getState();
        }
    }

    private long getRunTime() {
        return this.stopWatch.getElapsedTimeInMinutes();
    }

    public String toString() {
        return "task that enforces the run time limit of the advisor";
    }
}

