/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AutonomicAggregateOptimizeCubeTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AutonomicAggregateServerTask;
import com.cognos.xqe.trace.LogLevel;

public class AutonomicAggregateOptimizeServerTask
extends AutonomicAggregateServerTask {
    @Override
    public void handleCubeStart(ROLAPBaseCube cube) {
        if (!cube.isAutonomicAggregateOptimizationEnabled()) {
            LOGGER.log(LogLevel.TRACE, "Skipping the autonomic optimization of the aggregates of the cube because autonomic optimization is not enabled");
            return;
        }
        if (cube.getConfigMaxAggregateCacheSize() == 0) {
            LOGGER.log(LogLevel.WARN, "Skipping the autonomic optimization of the aggregates of the cube because the maximum aggregate cache size is 0");
            return;
        }
        AutonomicAggregateOptimizeCubeTask cubeTask = new AutonomicAggregateOptimizeCubeTask(cube);
        this.cubeToCubeTaskMap.put(cube, cubeTask);
        LOGGER.log(String.format("Added the %s to the %s", cubeTask, this));
    }

    public String toString() {
        return "autonomic server task that optimizes the aggregates of autonomic cubes on the server";
    }
}

