/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.recommendation;

import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorPropertyName;
import com.cognos.xqe.bibus.rolap.aggregateAdvisor.AggregateAdvisorState;
import com.cognos.xqe.bibushandler.ROLAPAdvisorCommandResponseUtility;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.management.AdvisorCommandResult;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.FileHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.XMLWriter;

public class RecommendationFileUtility {
    private static final String NEWLINE = "\n";
    private static final String CHARSET_UTF_8 = "UTF-8";
    private static final String ATTRIBUTE_NAME_VERSION = "version";
    private static final String ATTRIBUTE_VALUE_VERSION = "1.0";
    private static final String RECOMMENDATION_FILE_NAME_PREFIX = "recommendation_";
    private static final String RECOMMENDATION_FILE_NAME_EXTENSION = ".xml";
    private static final XQELogger LOGGER = ROLAPLog.getLogger("ROLAPAggregateAdvisor.Management");
    private static String cubeParentDirectoryName;
    private static long lastRecommendationID;

    public static synchronized String generateRecommendationID() {
        long recommendationID = System.currentTimeMillis();
        while (recommendationID == lastRecommendationID) {
            recommendationID = System.currentTimeMillis();
        }
        lastRecommendationID = recommendationID;
        return String.valueOf(recommendationID);
    }

    private static String getCubeParentDirectoryName() {
        if (cubeParentDirectoryName == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE).getXqeLogsDirectory());
            sb.append(File.separatorChar);
            sb.append("ROLAPCubes");
            cubeParentDirectoryName = sb.toString();
        }
        return cubeParentDirectoryName;
    }

    private static String getCubeChildDirectoryName(boolean isAutonomicRecommendation) {
        StringBuilder sb = new StringBuilder();
        sb.append("advisor");
        sb.append(File.separatorChar);
        if (isAutonomicRecommendation) {
            sb.append("_");
        }
        sb.append("recommendations");
        return sb.toString();
    }

    public static String getRecommendationFileName(String cubeName, String recommendationID) {
        return RecommendationFileUtility.getRecommendationFileName(cubeName, recommendationID, false);
    }

    private static String getRecommendationFileName(String cubeName, String recommendationID, boolean isAutonomicRecommendation) {
        StringBuilder sb = new StringBuilder();
        sb.append(RecommendationFileUtility.getCubeParentDirectoryName());
        sb.append(File.separatorChar);
        sb.append(cubeName);
        sb.append(File.separatorChar);
        sb.append(RecommendationFileUtility.getCubeChildDirectoryName(isAutonomicRecommendation));
        sb.append(File.separatorChar);
        sb.append(RECOMMENDATION_FILE_NAME_PREFIX);
        sb.append(recommendationID);
        sb.append(RECOMMENDATION_FILE_NAME_EXTENSION);
        String recommendationFileName = sb.toString();
        File recommendationFile = new File(recommendationFileName);
        try {
            recommendationFileName = recommendationFile.getCanonicalPath();
        }
        catch (IOException ex) {
            recommendationFileName = recommendationFile.getPath();
        }
        return recommendationFileName;
    }

    public static void storeRecommendation(String cubeName, String recommendationID, boolean isAutonomicRecommendation, AdvisorCommandResult commandResult) throws IOException {
        Document recommendationDocument = DocumentHelper.createDocument();
        Element recommendationRootElement = RecommendationFileUtility.addRootElement(recommendationDocument);
        ROLAPAdvisorCommandResponseUtility.addResult(recommendationRootElement, commandResult, false);
        RecommendationFileUtility.writeRecommendation(cubeName, recommendationID, isAutonomicRecommendation, recommendationDocument);
    }

    public static void storeRecommendation(String cubeName, String recommendationID, AggregateAdvisorState state, List<String> messages, Map<String, String> options, Properties properties, Element recommendationsElement) throws IOException {
        Document recommendationDocument = DocumentHelper.createDocument();
        Element recommendationRootElement = RecommendationFileUtility.addRootElement(recommendationDocument);
        ROLAPAdvisorCommandResponseUtility.addStateElement(recommendationRootElement, state);
        ROLAPAdvisorCommandResponseUtility.addMessagesElement(recommendationRootElement, messages);
        ROLAPAdvisorCommandResponseUtility.addOptionsElement(recommendationRootElement, options);
        ROLAPAdvisorCommandResponseUtility.addPropertiesElement(recommendationRootElement, properties);
        recommendationRootElement.add(recommendationsElement);
        RecommendationFileUtility.writeRecommendation(cubeName, recommendationID, false, recommendationDocument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRecommendation(String cubeName, String recommendationID, boolean isAutonomicRecommendation, Document recommendationDocument) throws IOException {
        String recommendationFileName = RecommendationFileUtility.getRecommendationFileName(cubeName, recommendationID, isAutonomicRecommendation);
        FileHandler.createOutputFolders(recommendationFileName);
        Writer recommendationFileWriter = null;
        XMLWriter recommendationFileXMLWriter = null;
        try {
            recommendationFileWriter = FileHandler.createFileWriter(recommendationFileName);
            recommendationFileXMLWriter = new XMLWriter(recommendationFileWriter);
            recommendationFileXMLWriter.write(recommendationDocument);
        }
        finally {
            if (recommendationFileXMLWriter != null) {
                recommendationFileXMLWriter.close();
            }
            if (recommendationFileWriter != null) {
                recommendationFileWriter.close();
            }
        }
    }

    private static Element addRootElement(Document document) {
        Element rootElement = document.addElement("advisorRecommendation");
        rootElement.addAttribute(ATTRIBUTE_NAME_VERSION, ATTRIBUTE_VALUE_VERSION);
        return rootElement;
    }

    public static void updateRecommendationName(String cubeName, String recommendationID, String recommendationName) throws Exception {
        String recommendationFileName = RecommendationFileUtility.getRecommendationFileName(cubeName, recommendationID);
        File recommendationFile = new File(recommendationFileName);
        if (!recommendationFile.exists()) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_RecommendationFileDoesNotExist, recommendationFileName);
        }
        String recommendationFileContents = RecommendationFileUtility.getFileContents(recommendationFile);
        Document recommendationDocument = DocumentHelper.parseText((String)recommendationFileContents);
        Element recommendationRootElement = recommendationDocument.getRootElement();
        Element propertiesElement = recommendationRootElement.element("properties");
        List propertyElements = propertiesElement.elements();
        for (Element propertyElement : propertyElements) {
            Element nameElement = propertyElement.element("name");
            String propertyName = nameElement.getText();
            if (!AggregateAdvisorPropertyName.RECOMMENDATION_NAME.toString().equals(propertyName)) continue;
            Element valueElement = propertyElement.element("value");
            valueElement.setText(recommendationName);
            break;
        }
        RecommendationFileUtility.writeRecommendation(cubeName, recommendationID, false, recommendationDocument);
    }

    public static void deleteAutonomicRecommendationFiles(String cubeName) {
        File[] recommendationFiles;
        StringBuilder sb = new StringBuilder();
        sb.append(RecommendationFileUtility.getCubeParentDirectoryName());
        sb.append(File.separatorChar);
        sb.append(cubeName);
        sb.append(File.separatorChar);
        sb.append(RecommendationFileUtility.getCubeChildDirectoryName(true));
        String recommendationsDirectoryName = sb.toString();
        File recommendationsDirectory = new File(recommendationsDirectoryName);
        if (recommendationsDirectory.exists() && (recommendationFiles = recommendationsDirectory.listFiles()) != null) {
            LOGGER.log(String.format("Deleting the autonomic recommendation files for the cube %s (total = %d)", cubeName, recommendationFiles.length));
            for (File recommendationFile : recommendationFiles) {
                String recommendationFileName = recommendationFile.getPath();
                LOGGER.log(LogLevel.TRACE, String.format("Deleting the autonomic recommendation file %s", recommendationFileName));
                boolean deleted = recommendationFile.delete();
                if (deleted) {
                    LOGGER.log(LogLevel.TRACE, String.format("Deleting the autonomic recommendation file %s succeeded.", recommendationFileName));
                    continue;
                }
                LOGGER.log(LogLevel.TRACE, String.format("Deleting the autonomic recommendation file %s failed.", recommendationFileName));
            }
        }
    }

    public static boolean deleteRecommendationFile(String cubeName, String recommendationID) {
        String recommendationFileName = RecommendationFileUtility.getRecommendationFileName(cubeName, recommendationID);
        File recommendationFile = new File(recommendationFileName);
        return recommendationFile.delete();
    }

    public static List<File> getRecommendationFiles(List<String> recommendationIDsToExclude) {
        File[] cubeDirectories;
        ArrayList<File> recommendationFiles = new ArrayList<File>();
        File cubeParentDirectory = new File(RecommendationFileUtility.getCubeParentDirectoryName());
        if (cubeParentDirectory.exists() && (cubeDirectories = cubeParentDirectory.listFiles()) != null) {
            String manualRecommendationsDirectoryName = RecommendationFileUtility.getCubeChildDirectoryName(false);
            String autonomicRecommendationsDirectoryName = RecommendationFileUtility.getCubeChildDirectoryName(true);
            List<String> recommendationFileNamesToExclude = RecommendationFileUtility.getRecommendationFileNames(recommendationIDsToExclude);
            RecommendationFileNameFilter recommendationFileNameFilter = new RecommendationFileNameFilter(recommendationFileNamesToExclude);
            for (File cubeDirectory : cubeDirectories) {
                if (!cubeDirectory.isDirectory()) continue;
                List<File> manualRecommendationFiles = RecommendationFileUtility.getRecommendationFiles(cubeDirectory, manualRecommendationsDirectoryName, recommendationFileNameFilter);
                recommendationFiles.addAll(manualRecommendationFiles);
                List<File> autonomicRecommendationFiles = RecommendationFileUtility.getRecommendationFiles(cubeDirectory, autonomicRecommendationsDirectoryName, recommendationFileNameFilter);
                recommendationFiles.addAll(autonomicRecommendationFiles);
            }
        }
        return recommendationFiles;
    }

    private static List<File> getRecommendationFiles(File cubeDirectory, String recommendationsDirectoryName, RecommendationFileNameFilter recommendationFileNameFilter) {
        File[] cubeRecommendationFiles;
        ArrayList<File> recommendationFiles = new ArrayList<File>();
        File recommendationsDirectory = new File(cubeDirectory, recommendationsDirectoryName);
        if (recommendationsDirectory.exists() && (cubeRecommendationFiles = recommendationsDirectory.listFiles(recommendationFileNameFilter)) != null) {
            for (File cubeRecommendationFile : cubeRecommendationFiles) {
                recommendationFiles.add(cubeRecommendationFile);
            }
        }
        return recommendationFiles;
    }

    private static List<String> getRecommendationFileNames(List<String> recommendationIDs) {
        ArrayList<String> recommendationFileNames = new ArrayList<String>();
        for (String recommendationID : recommendationIDs) {
            String recommendationFileName = String.format("%s%s%s", RECOMMENDATION_FILE_NAME_PREFIX, recommendationID, RECOMMENDATION_FILE_NAME_EXTENSION);
            recommendationFileNames.add(recommendationFileName);
        }
        return recommendationFileNames;
    }

    public static List<Element> getRecommendationFileElements(File recommendationFile) throws Exception {
        ArrayList<Element> elementsToReturn = new ArrayList<Element>();
        String recommendationFileContents = RecommendationFileUtility.getFileContents(recommendationFile);
        Document recommendationDocument = DocumentHelper.parseText((String)recommendationFileContents);
        Element recommendationRootElement = recommendationDocument.getRootElement();
        String versionValue = recommendationRootElement.attributeValue(ATTRIBUTE_NAME_VERSION);
        if (ATTRIBUTE_VALUE_VERSION.equals(versionValue)) {
            List recommendationRootChildElements = recommendationRootElement.elements();
            for (Element recommendationRootChildElement : recommendationRootChildElements) {
                Node node = recommendationRootChildElement.detach();
                if (!(node instanceof Element)) continue;
                elementsToReturn.add((Element)node);
            }
        }
        return elementsToReturn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getFileContents(File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        try {
            String line;
            fileInputStream = new FileInputStream(file);
            inputStreamReader = new InputStreamReader((InputStream)fileInputStream, CHARSET_UTF_8);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line).append(NEWLINE);
            }
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStreamReader != null) {
                inputStreamReader.close();
            }
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return sb.toString();
    }

    private static class RecommendationFileNameFilter
    implements FilenameFilter {
        private List<String> recommendationFileNamesToExclude;

        RecommendationFileNameFilter(List<String> theRecommendationFileNamesToExclude) {
            this.recommendationFileNamesToExclude = theRecommendationFileNamesToExclude;
        }

        @Override
        public boolean accept(File directory, String fileName) {
            return fileName.startsWith(RecommendationFileUtility.RECOMMENDATION_FILE_NAME_PREFIX) && fileName.endsWith(RecommendationFileUtility.RECOMMENDATION_FILE_NAME_EXTENSION) && !this.recommendationFileNamesToExclude.contains(fileName);
        }
    }
}

