/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorRequestParameters;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.CubeCardinalityMetrics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.QueryMatchingAnalysis;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryFileUtility;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.QuerySummaryInfoLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.ExistingInDatabaseAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.AggregateRecommendationStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.LastAggregateLoadStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ConfigurationValues;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class AutonomicStrategy
extends AggregateRecommendationStrategy {
    private QueryMatchingAnalysis queryMatchingAnalysis;
    private List<Aggregate> existingDatabaseAggregates = new ArrayList<Aggregate>();
    private CubeCardinalityMetrics cubeCardinalityMetrics;
    private AdvisorRequestParameters advisorRequestParameters = this.aggregateAdvisor.getRequestParameters();
    public static final String USE_QUERY_SUMMARY_PROVIDED_BY_TEST_JVM_PARAM = "useQuerySummaryProvidedByTest";
    private static final int DELETE_AGGREGATE_PCT_SPACE_THRESHOLD = 85;
    private static final int ADD_AGGREGATE_PCT_SPACE_THRESHOLD = 90;
    private static final int MAX_PCT_SPACE_PER_AGGREGATE = 20;
    private static final int REPLACE_AGGREGATES_RATING_PCT_THRESHOLD = 10;
    private static final int IN_MEMORY_AGGREGATE_TO_FACT_CARDINALITY_PCT_THRESHOLD = 5;
    private static final int MAX_GET_SLICE_CARDINALITY_CALLS_WHEN_RECOMMENDING_INITIAL_AGGREGATES = 25;
    private static final int MAX_GET_SLICE_CARDINALITY_CALLS_WHEN_ADJUSTING_AGGREGATES = 10;
    private static final int MAX_NUMBER_OF_INITIAL_AGGREGATES = 10;

    public AutonomicStrategy(ROLAPMetaCube theMetaCube, AggregateAdvisor theAggregateAdvisor) {
        super(theMetaCube, theAggregateAdvisor);
        this.queryMatchingAnalysis = new QueryMatchingAnalysis(this.metaCube, this.aggregateAdvisor);
    }

    @Override
    public void recommendAggregates(List<Aggregate> candidateAggregates) {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend aggregates based on the autonomic workload - begin"));
        HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
        stopWatch.start();
        boolean recommendInitialSetOfAggregates = this.setup(candidateAggregates);
        if (recommendInitialSetOfAggregates) {
            this.recommendInitialSetOfAggregates(candidateAggregates);
        } else {
            this.recommendDeltaSetOfAggregates(candidateAggregates);
        }
        this.aggregateAdvisor.saveRecommendations(candidateAggregates);
        INFO_LOGGER.log(AdvisorTrace.heading("Autonomic - output aggregates") + AdvisorTrace.formatAggregates(candidateAggregates));
        INFO_LOGGER.log(this.queryMatchingAnalysis.formatQueryToAggregateMatching());
        long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("AutonomicStrategy", elapsedTime);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend aggregates based on the autonomic workload - end"));
    }

    private boolean setup(List<Aggregate> candidateAggregates) {
        this.determineExistingDatabaseAggregatesToLeverage();
        ArrayList<Aggregate> userDefinedAggregates = new ArrayList<Aggregate>(candidateAggregates);
        LastAggregateLoadStrategy lastAggregateLoadStrategy = this.aggregateAdvisor.getLastAggregateLoadStrategy();
        List<Aggregate> loadedAggregates = lastAggregateLoadStrategy.getLoadedAggregates();
        List<Aggregate> currentCandidateAggregates = this.getCurrentCandidateAggregates(userDefinedAggregates, loadedAggregates);
        candidateAggregates.clear();
        candidateAggregates.addAll(currentCandidateAggregates);
        this.cubeCardinalityMetrics = this.aggregateAdvisor.getCubeCardinalityMetrics();
        INFO_LOGGER.log(AdvisorTrace.formatSliceCardinalities(this.cubeCardinalityMetrics));
        QuerySummaryInfoLog querySummaryInfoLog = this.getQuerySummaryInfoLog();
        this.queryMatchingAnalysis.setQuerySummary(querySummaryInfoLog);
        return loadedAggregates.isEmpty();
    }

    private List<Aggregate> getCurrentCandidateAggregates(List<Aggregate> userDefinedAggregates, List<Aggregate> loadedAggregates) {
        ArrayList<Aggregate> userDefinedAggregatesThatAreLoaded = new ArrayList<Aggregate>();
        ArrayList<Aggregate> userDefinedAggregatesThatAreNotLoaded = new ArrayList<Aggregate>();
        ArrayList<Aggregate> loadedAggregatesThatAreUserDefined = new ArrayList<Aggregate>();
        ArrayList<Aggregate> loadedAggregatesThatAreNotUserDefined = new ArrayList<Aggregate>();
        block0: for (Aggregate userDefinedAggregate : userDefinedAggregates) {
            for (Aggregate loadedAggregate : loadedAggregates) {
                if (!userDefinedAggregate.getName().equals(loadedAggregate.getName())) continue;
                userDefinedAggregate.setCardinality(loadedAggregate.getCardinality());
                long inMemorySpaceForCandidate = this.aggregateAdvisor.estimateInMemoryAggregateSize(userDefinedAggregate);
                userDefinedAggregate.setEstimatedSize(inMemorySpaceForCandidate);
                userDefinedAggregatesThatAreLoaded.add(userDefinedAggregate);
                loadedAggregatesThatAreUserDefined.add(loadedAggregate);
                continue block0;
            }
        }
        userDefinedAggregatesThatAreNotLoaded.addAll(userDefinedAggregates);
        userDefinedAggregatesThatAreNotLoaded.removeAll(userDefinedAggregatesThatAreLoaded);
        loadedAggregatesThatAreNotUserDefined.addAll(loadedAggregates);
        loadedAggregatesThatAreNotUserDefined.removeAll(loadedAggregatesThatAreUserDefined);
        if (this.advisorRequestParameters.isInMemoryAggregatesMustMatchInDatabaseAggregates()) {
            List<Aggregate> coveredAggregates = AggregateUtils.getInMemoryAggregatesCoveredByInDatabaseAggregates(loadedAggregatesThatAreNotUserDefined, this.existingDatabaseAggregates);
            ArrayList<Aggregate> uncoveredAggregates = new ArrayList<Aggregate>(loadedAggregatesThatAreNotUserDefined);
            uncoveredAggregates.removeAll(coveredAggregates);
            INFO_LOGGER.log(AdvisorTrace.heading("Loaded aggregates removed because they aren't covered by database aggregates") + AdvisorTrace.formatAggregates(uncoveredAggregates));
            loadedAggregatesThatAreNotUserDefined.retainAll(coveredAggregates);
        }
        ArrayList<Aggregate> candidateAggregates = new ArrayList<Aggregate>();
        candidateAggregates.addAll(userDefinedAggregatesThatAreLoaded);
        candidateAggregates.addAll(userDefinedAggregatesThatAreNotLoaded);
        candidateAggregates.addAll(loadedAggregatesThatAreNotUserDefined);
        INFO_LOGGER.log(AdvisorTrace.heading("Autonomic - input aggregates") + "\nUser defined aggregates (not loaded):\n" + AdvisorTrace.formatAggregates(userDefinedAggregatesThatAreNotLoaded) + "\nUser defined aggregates (loaded):\n" + AdvisorTrace.formatAggregates(userDefinedAggregatesThatAreLoaded) + "\nLoaded aggregates (user defined):\n" + AdvisorTrace.formatAggregates(loadedAggregatesThatAreUserDefined) + "\nLoaded aggregates (not user defined):\n" + AdvisorTrace.formatAggregates(loadedAggregatesThatAreNotUserDefined) + "\nCurrent aggregates (all user defined + loaded non-user defined):\n" + AdvisorTrace.formatAggregates(candidateAggregates));
        return candidateAggregates;
    }

    private void recommendInitialSetOfAggregates(List<Aggregate> candidateAggregates) {
        INFO_LOGGER.log("Recommend initial aggregates - begin");
        INFO_LOGGER.log("\n\nQueries:\n" + AdvisorTrace.formatQueries(this.queryMatchingAnalysis.getQueries()));
        int maxSliceCardinalityCalls = ConfigurationValues.getZeroOrPositiveInt("qsAdvisorMaxGetSliceCardinalityCallsWhenReccommendingInitialAggregates", 25);
        ArrayList<Aggregate> currentAggregates = new ArrayList();
        boolean optimize = true;
        int numGetSliceCardinalityCalls = 0;
        while (optimize) {
            if (numGetSliceCardinalityCalls < maxSliceCardinalityCalls) {
                ++numGetSliceCardinalityCalls;
                List<Aggregate> unmatchedQueries = this.queryMatchingAnalysis.getUnmatchedQueries();
                INFO_LOGGER.log(LogLevel.TRACE, "\n\nUnmatched queries:\n" + AdvisorTrace.formatAggregates(unmatchedQueries));
                List<Aggregate> queriesWithUnknownCardinalities = this.getQueriesWhoseCardinalityIsNotKnown(unmatchedQueries);
                INFO_LOGGER.log(LogLevel.TRACE, "\n\nUnknown cardinalities:\n" + AdvisorTrace.formatAggregates(queriesWithUnknownCardinalities));
                Aggregate queryToGetSliceCardinalityOf = this.getBestQueryToGetCardinalityFor(queriesWithUnknownCardinalities);
                if (queryToGetSliceCardinalityOf != null) {
                    this.getQueryCardinality(queryToGetSliceCardinalityOf);
                    if (this.aggregateAdvisor.isAggregateSmallRelativetoFact(queryToGetSliceCardinalityOf)) {
                        currentAggregates = this.selectBestAggregates();
                        this.queryMatchingAnalysis.setAggregates(currentAggregates);
                        INFO_LOGGER.log(AdvisorTrace.heading("Get slice cardinality calls = " + numGetSliceCardinalityCalls) + this.queryMatchingAnalysis.formatAggregateUsage());
                        continue;
                    }
                    INFO_LOGGER.log("Slice ignored since it is estimated to be too large");
                    continue;
                }
                INFO_LOGGER.log("No slice to get the cardinality of");
                continue;
            }
            optimize = false;
        }
        candidateAggregates.addAll(currentAggregates);
        INFO_LOGGER.log("Recommend initial aggregates - end");
    }

    private void recommendDeltaSetOfAggregates(List<Aggregate> candidateAggregates) {
        double replaceAggregatesRatingThreshold;
        double bestReplaceAggregateRating;
        INFO_LOGGER.log("Recommend delta aggregates - begin");
        ArrayList<Aggregate> originalAggregates = new ArrayList<Aggregate>(candidateAggregates);
        ArrayList<Aggregate> currentAggregates = new ArrayList<Aggregate>(originalAggregates);
        this.queryMatchingAnalysis.setAggregates(originalAggregates);
        INFO_LOGGER.log(this.queryMatchingAnalysis.formatAggregateUsage());
        double originalAggregatesRating = this.queryMatchingAnalysis.getRating();
        List<Aggregate> unmatchedQueries = this.queryMatchingAnalysis.getUnmatchedQueries();
        INFO_LOGGER.log("\n\nQueries not covered by aggregates:\n" + AdvisorTrace.formatQueries(unmatchedQueries));
        List<Aggregate> queriesWithUnknownCardinalities = this.getQueriesWhoseCardinalityIsNotKnown(unmatchedQueries);
        this.checkQueryCardinalities(queriesWithUnknownCardinalities);
        this.getMoreQueryCardinalities(queriesWithUnknownCardinalities);
        queriesWithUnknownCardinalities = this.getQueriesWhoseCardinalityIsNotKnown(unmatchedQueries);
        List<Aggregate> queriesWithKnownCardinalities = this.getQueriesWhoseCardinalityIsKnown(unmatchedQueries);
        ArrayList<Aggregate> acceptableAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> rejectedAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> tooLargeRelativeToDbAggs = new ArrayList<Aggregate>();
        this.aggregateAdvisor.determineAggregatesCardinalityAcceptability(queriesWithKnownCardinalities, acceptableAggregates, rejectedAggregates);
        this.determineAcceptableInMemoryAggregatesGivenInDatabaseAggregates(acceptableAggregates, acceptableAggregates, tooLargeRelativeToDbAggs);
        INFO_LOGGER.log(AdvisorTrace.heading("Queries not covered by aggregates") + "\nCardinality is unknown:\n" + AdvisorTrace.formatAggregates(queriesWithUnknownCardinalities) + "\nCardinality is acceptable:\n" + AdvisorTrace.formatAggregates(acceptableAggregates) + "\nCardinality is too high relative to fact:\n" + AdvisorTrace.formatAggregates(rejectedAggregates) + "\nCardinality is too high relative to in-database aggregates:\n" + AdvisorTrace.formatAggregates(tooLargeRelativeToDbAggs));
        List<Aggregate> aggregatesAfterAdd = this.adjustAggregatesByAdding(currentAggregates, acceptableAggregates);
        this.queryMatchingAnalysis.setAggregates(aggregatesAfterAdd);
        double aggregatesAfterAddRating = this.queryMatchingAnalysis.getRating();
        List<Aggregate> aggregatesAfterDeleteAndAdd = this.adjustAggregatesByDeletingAndAdding(currentAggregates, acceptableAggregates);
        this.queryMatchingAnalysis.setAggregates(aggregatesAfterDeleteAndAdd);
        double aggregatesAfterDeleteAndAddRating = this.queryMatchingAnalysis.getRating();
        List<Aggregate> aggregatesAfterDeleteBigAggAndAdd = this.adjustAggregatesByDeletingLargeAggregate(currentAggregates, acceptableAggregates);
        this.queryMatchingAnalysis.setAggregates(aggregatesAfterDeleteBigAggAndAdd);
        double aggregatesAfterDeleteBigAggAndAddRating = this.queryMatchingAnalysis.getRating();
        INFO_LOGGER.log(String.format("Aggregate ratings: original=%.2f   add=%.2f   delete+add=%.2f   delete big=%.2f", originalAggregatesRating, aggregatesAfterAddRating, aggregatesAfterDeleteAndAddRating, aggregatesAfterDeleteBigAggAndAddRating));
        ArrayList<Aggregate> aggregatesAfterReplace = new ArrayList<Aggregate>();
        if (aggregatesAfterDeleteAndAddRating > aggregatesAfterDeleteBigAggAndAddRating) {
            bestReplaceAggregateRating = aggregatesAfterDeleteAndAddRating;
            aggregatesAfterReplace.addAll(aggregatesAfterDeleteAndAdd);
        } else {
            bestReplaceAggregateRating = aggregatesAfterDeleteBigAggAndAddRating;
            aggregatesAfterReplace.addAll(aggregatesAfterDeleteBigAggAndAdd);
        }
        double bestRating = originalAggregatesRating;
        candidateAggregates.clear();
        candidateAggregates.addAll(originalAggregates);
        if (aggregatesAfterAddRating > bestRating) {
            bestRating = aggregatesAfterAddRating;
            candidateAggregates.clear();
            candidateAggregates.addAll(aggregatesAfterAdd);
        }
        if (bestReplaceAggregateRating > bestRating + (replaceAggregatesRatingThreshold = (double)ConfigurationValues.getZeroOrPositiveInt("qsAdvisorReplaceAggregatesRatingPctThreshold", 10) / 100.0)) {
            candidateAggregates.clear();
            candidateAggregates.addAll(aggregatesAfterReplace);
        }
        INFO_LOGGER.log("\n\nFinal aggregates:\n" + AdvisorTrace.formatAggregates(candidateAggregates));
        this.queryMatchingAnalysis.setAggregates(candidateAggregates);
        INFO_LOGGER.log(this.queryMatchingAnalysis.formatAggregateUsage());
        INFO_LOGGER.log("Recommend delta aggregates - end");
    }

    private List<Aggregate> adjustAggregatesByAdding(List<Aggregate> inputAggregates, List<Aggregate> acceptableAggregates) {
        ArrayList<Aggregate> outputAggregates = new ArrayList<Aggregate>();
        outputAggregates.addAll(inputAggregates);
        if (outputAggregates.size() < this.advisorRequestParameters.getMaxNumberOfInMemoryAggregates()) {
            INFO_LOGGER.log("Adjust aggregates: Aggregate count limit not reached.  Add an aggregate.");
            Aggregate bestAggregateToAdd = this.getBestAggregateToAdd(outputAggregates, acceptableAggregates);
            if (bestAggregateToAdd != null) {
                outputAggregates.add(bestAggregateToAdd);
            }
        }
        return outputAggregates;
    }

    private List<Aggregate> adjustAggregatesByDeletingAndAdding(List<Aggregate> inputAggregates, List<Aggregate> acceptableAggregates) {
        List<Aggregate> outputAggregates = new ArrayList<Aggregate>();
        outputAggregates.addAll(inputAggregates);
        if (outputAggregates.size() >= this.advisorRequestParameters.getMaxNumberOfInMemoryAggregates()) {
            INFO_LOGGER.log("Adjust aggregates: Aggregate count limit reached.  Replace lowest rated aggregate with better one.");
            this.queryMatchingAnalysis.setAggregates(inputAggregates);
            Aggregate bestAggregateToDelete = this.queryMatchingAnalysis.getLowestRatedNonUserAggregate();
            if (bestAggregateToDelete != null) {
                outputAggregates.remove(bestAggregateToDelete);
                outputAggregates = this.adjustAggregatesByAdding(outputAggregates, acceptableAggregates);
            }
        }
        return outputAggregates;
    }

    private List<Aggregate> adjustAggregatesByDeletingLargeAggregate(List<Aggregate> inputAggregates, List<Aggregate> acceptableAggregates) {
        List<Aggregate> outputAggregates = new ArrayList<Aggregate>();
        outputAggregates.addAll(inputAggregates);
        int deleteAggregatePctSpaceThreshold = (int)(ConfigurationValues.getPercentFromInt("qsAdvisorDeleteAggregatePctSpaceThreshold", 85) * 100.0);
        if (this.queryMatchingAnalysis.getPercentSpaceUsed() > (double)deleteAggregatePctSpaceThreshold) {
            INFO_LOGGER.log("Adjust aggregates: Nearing space threshold.  Replace a large aggregate with smaller ones.");
            Aggregate bestAggregateToDelete = this.getBestAggregateToDeleteToSaveSpace(outputAggregates);
            if (bestAggregateToDelete != null) {
                outputAggregates.remove(bestAggregateToDelete);
                outputAggregates = this.adjustAggregatesByAdding(outputAggregates, acceptableAggregates);
            }
        }
        return outputAggregates;
    }

    private List<Aggregate> selectBestAggregates() {
        Aggregate bestAggregateToAdd;
        List<Aggregate> queries = this.queryMatchingAnalysis.getQueries();
        List<Aggregate> queriesWithKnownCardinalities = this.getQueriesWhoseCardinalityIsKnown(queries);
        ArrayList<Aggregate> acceptableAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> rejectedAggregates = new ArrayList<Aggregate>();
        this.aggregateAdvisor.determineAggregatesCardinalityAcceptability(queriesWithKnownCardinalities, acceptableAggregates, rejectedAggregates);
        INFO_LOGGER.log("\n\nRejected because cardinality too close to fact:\n" + AdvisorTrace.formatAggregates(rejectedAggregates));
        this.determineAcceptableInMemoryAggregatesGivenInDatabaseAggregates(acceptableAggregates, acceptableAggregates, rejectedAggregates);
        INFO_LOGGER.log("\n\nRejected because cardinality too close to in-database aggregates:\n" + AdvisorTrace.formatAggregates(rejectedAggregates));
        ArrayList<Aggregate> currentAggregates = new ArrayList<Aggregate>();
        int numInitialAggregates = ConfigurationValues.getZeroOrPositiveInt("qsAdvisorMaxNumberOfInitialAggregates", 10);
        for (int count = 1; count <= numInitialAggregates && (bestAggregateToAdd = this.getBestAggregateToAdd(currentAggregates, acceptableAggregates)) != null; ++count) {
            currentAggregates.add(bestAggregateToAdd);
            acceptableAggregates.remove(bestAggregateToAdd);
        }
        return currentAggregates;
    }

    public void determineAcceptableInMemoryAggregatesGivenInDatabaseAggregates(List<Aggregate> candidateAggregates, List<Aggregate> acceptableAggregates, List<Aggregate> rejectedAggregates) {
        ArrayList<Aggregate> candidateAggregatesCopy = new ArrayList<Aggregate>(candidateAggregates);
        acceptableAggregates.clear();
        rejectedAggregates.clear();
        for (Aggregate aggregate : candidateAggregatesCopy) {
            if (!this.advisorRequestParameters.isInMemoryAggregatesMustMatchInDatabaseAggregates()) {
                acceptableAggregates.add(aggregate);
                continue;
            }
            if (this.isSmallRelativeToDatabaseAggregates(aggregate)) {
                acceptableAggregates.add(aggregate);
                continue;
            }
            rejectedAggregates.add(aggregate);
        }
    }

    private boolean isSmallRelativeToDatabaseAggregates(Aggregate aggregate) {
        double maxAggregateToFactCardinalityRatio = ConfigurationValues.getPercentFromInt("qsAdvisorInMemoryAggregateToFactCardinalityPctThreshold", 5);
        double aggregateToFactCardinalityRatio = 1.0 * (double)aggregate.getCardinality() / (double)this.cubeCardinalityMetrics.getFactCardinality();
        return aggregateToFactCardinalityRatio <= maxAggregateToFactCardinalityRatio;
    }

    private Aggregate getBestAggregateToAdd(List<Aggregate> currentAggregates, List<Aggregate> candidateAggregates) {
        Aggregate bestAggregateToAdd = null;
        int maxPctSpacePerAggregate = (int)(ConfigurationValues.getPercentFromInt("qsAdvisorMaxPctSpacePerAggregate", 20) * 100.0);
        int addAggregatePctSpaceThreshold = (int)(ConfigurationValues.getPercentFromInt("qsAdvisorAddAggregatePctSpaceThreshold", 90) * 100.0);
        this.queryMatchingAnalysis.setAggregates(currentAggregates);
        double origPercentOfWeightedQueriesMatched = this.queryMatchingAnalysis.getPercentOfWeightedQueriesMatched();
        double origPercentOfQueriesMatched = this.queryMatchingAnalysis.getPercentOfQueriesMatched();
        double origPercentOfSpaceUsed = this.queryMatchingAnalysis.getPercentSpaceUsed();
        double origRating = this.queryMatchingAnalysis.getRating();
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nGet best aggregate to add\n");
        sb.append(String.format("%10s %10s %10s %10s %10s %10s %10s %-10s %s %n", "WgtQry", "Qry  ", "Space", "WgtQryChg", "QryChg", "SpaceChg", "Rating", "Status", "Name"));
        sb.append(String.format("%10.2f %10.2f %10.2f %10s %10s %10s %10.2f %-10s %s  %n", origPercentOfWeightedQueriesMatched, origPercentOfQueriesMatched, origPercentOfSpaceUsed, "", "", "", origRating, "", "Current aggregates = " + currentAggregates.size()));
        double bestRating = origRating;
        for (Aggregate aggregate : candidateAggregates) {
            String status;
            ArrayList<Aggregate> aggregatesToAnalyze = new ArrayList<Aggregate>(currentAggregates);
            aggregatesToAnalyze.add(aggregate);
            this.queryMatchingAnalysis.setAggregates(aggregatesToAnalyze);
            double deltaPercentOfWeightedQuerieMatched = this.queryMatchingAnalysis.getPercentOfWeightedQueriesMatched() - origPercentOfWeightedQueriesMatched;
            double deltaPercentOfQueriesMatched = this.queryMatchingAnalysis.getPercentOfQueriesMatched() - origPercentOfQueriesMatched;
            double deltaPercentSpaceUsed = this.queryMatchingAnalysis.getPercentSpaceUsed() - origPercentOfSpaceUsed;
            double currRating = this.queryMatchingAnalysis.getRating();
            double pctSpaceForThisAggregate = AdvisorUtils.getPercentage(aggregate.getEstimatedSize(), this.aggregateAdvisor.getInMemoryAggregatesLimit());
            if (pctSpaceForThisAggregate > (double)maxPctSpacePerAggregate) {
                status = "agg max";
            } else if (this.queryMatchingAnalysis.getPercentSpaceUsed() > (double)addAggregatePctSpaceThreshold) {
                status = "space max";
            } else if (currRating > bestRating) {
                bestRating = currRating;
                bestAggregateToAdd = aggregate;
                status = "best";
            } else {
                status = "";
            }
            sb.append(String.format("%10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %10.2f %-10s %s  %n", this.queryMatchingAnalysis.getPercentOfWeightedQueriesMatched(), this.queryMatchingAnalysis.getPercentOfQueriesMatched(), this.queryMatchingAnalysis.getPercentSpaceUsed(), deltaPercentOfWeightedQuerieMatched, deltaPercentOfQueriesMatched, deltaPercentSpaceUsed, currRating, status, aggregate.getName()));
        }
        INFO_LOGGER.log(sb.toString());
        return bestAggregateToAdd;
    }

    private Aggregate getBestAggregateToDeleteToSaveSpace(List<Aggregate> currentAggregates) {
        Aggregate bestAggregateToDelete = null;
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nGet best aggregate to delete\n");
        this.queryMatchingAnalysis.setAggregates(currentAggregates);
        double currRating = this.queryMatchingAnalysis.getPercentOfWeightedQueriesMatched() - this.queryMatchingAnalysis.getPercentSpaceUsed();
        sb.append(String.format("Weighted queries match pct = %.2f  Space used pct = %.2f  Rating = %.2f %n", this.queryMatchingAnalysis.getPercentOfWeightedQueriesMatched(), this.queryMatchingAnalysis.getPercentSpaceUsed(), currRating));
        double bestRating = currRating;
        for (Aggregate aggregate : currentAggregates) {
            ArrayList<Aggregate> aggregatesToAnalyze = new ArrayList<Aggregate>(currentAggregates);
            aggregatesToAnalyze.remove(aggregate);
            this.queryMatchingAnalysis.setAggregates(aggregatesToAnalyze);
            currRating = this.queryMatchingAnalysis.getPercentOfWeightedQueriesMatched() - this.queryMatchingAnalysis.getPercentSpaceUsed();
            sb.append(String.format("Weighted queries match pct = %.2f  Space used pct = %.2f  Rating = %.2f  ", this.queryMatchingAnalysis.getPercentOfWeightedQueriesMatched(), this.queryMatchingAnalysis.getPercentSpaceUsed(), currRating));
            if (aggregate.getRecommendedBy() == AggregateRecommendedByEnum.USER) {
                sb.append(" user  ");
            } else if (currRating > bestRating) {
                bestRating = currRating;
                bestAggregateToDelete = aggregate;
                sb.append(" best  ");
            } else {
                sb.append("       ");
            }
            sb.append(aggregate.getName());
            sb.append('\n');
        }
        INFO_LOGGER.log(sb.toString());
        return bestAggregateToDelete;
    }

    private List<Aggregate> getQueriesWhoseCardinalityIsKnown(List<Aggregate> queries) {
        ArrayList<Aggregate> queriesWhoseCardinalityIsKnown = new ArrayList<Aggregate>();
        for (Aggregate query : queries) {
            SliceCombination sliceId = query.getSliceId();
            if (!this.cubeCardinalityMetrics.isSliceCardinalityKnown(sliceId)) continue;
            query.setAggregateAdvisor(this.aggregateAdvisor);
            query.setRecommendedBy(AggregateRecommendedByEnum.AUTONOMIC);
            long cardinality = this.cubeCardinalityMetrics.getSliceCardinality(sliceId);
            query.setCardinality(cardinality);
            long inMemorySpaceForCandidate = this.aggregateAdvisor.estimateInMemoryAggregateSize(query);
            query.setEstimatedSize(inMemorySpaceForCandidate);
            queriesWhoseCardinalityIsKnown.add(query);
        }
        return queriesWhoseCardinalityIsKnown;
    }

    private List<Aggregate> getQueriesWhoseCardinalityIsNotKnown(List<Aggregate> queries) {
        List<Aggregate> queriesWhoseCardinalityIsKnown = this.getQueriesWhoseCardinalityIsKnown(queries);
        ArrayList<Aggregate> queriesWhoseCardinalityIsNotKnown = new ArrayList<Aggregate>();
        queriesWhoseCardinalityIsNotKnown.addAll(queries);
        queriesWhoseCardinalityIsNotKnown.removeAll(queriesWhoseCardinalityIsKnown);
        return queriesWhoseCardinalityIsNotKnown;
    }

    private void checkQueryCardinalities(List<Aggregate> queries) {
        StringBuilder sb = new StringBuilder();
        sb.append(AdvisorTrace.heading("Check query cardinalities"));
        for (Aggregate query : queries) {
            SliceCombination sliceId = query.getSliceId();
            sb.append(String.format("%nslice id = %s%n", sliceId.valueToString()));
            List<SliceCombination> aboveSliceIds = this.cubeCardinalityMetrics.getSliceCardinalityIdsAbove(sliceId);
            for (SliceCombination aboveSliceId : aboveSliceIds) {
                sb.append(String.format("higher slice: id = %s, cardinality = %,d %n", aboveSliceId.valueToString(), this.cubeCardinalityMetrics.getSliceCardinality(aboveSliceId)));
            }
            List<SliceCombination> belowSliceIds = this.cubeCardinalityMetrics.getSliceCardinalityIdsBelow(sliceId);
            for (SliceCombination belowSliceId : belowSliceIds) {
                sb.append(String.format("lower slice: id = %s, cardinality = %,d %n", belowSliceId.valueToString(), this.cubeCardinalityMetrics.getSliceCardinality(belowSliceId)));
            }
        }
        INFO_LOGGER.log(LogLevel.TRACE, sb.toString());
    }

    private void getMoreQueryCardinalities(List<Aggregate> queries) {
        ArrayList<Aggregate> candidateQueries = new ArrayList<Aggregate>(queries);
        int maxSliceCardinalityCalls = ConfigurationValues.getZeroOrPositiveInt("qsAdvisorMaxGetSliceCardinalityCallsWhenAdjustingAggregates", 10);
        for (int i = 1; i <= maxSliceCardinalityCalls; ++i) {
            Aggregate queryToGetSliceCardinalityOf = this.getBestQueryToGetCardinalityFor(candidateQueries);
            if (queryToGetSliceCardinalityOf == null) continue;
            this.getQueryCardinality(queryToGetSliceCardinalityOf);
            candidateQueries.remove(queryToGetSliceCardinalityOf);
        }
    }

    private void getQueryCardinality(Aggregate query) {
        long maxCardinality = this.aggregateAdvisor.getMaxSliceCardinality(query);
        query.setCardinality(maxCardinality);
        this.aggregateAdvisor.improveCardinalityEstimate(query, "AutonomicStrategy");
        if (query.getCardinality() == maxCardinality) {
            this.cubeCardinalityMetrics.setEstimatedSliceCardinality(query.getSliceId(), maxCardinality);
        }
        long estimatedSize = this.aggregateAdvisor.estimateInMemoryAggregateSize(query);
        query.setEstimatedSize(estimatedSize);
    }

    private Aggregate getBestQueryToGetCardinalityFor(List<Aggregate> queries) {
        Aggregate bestQuery = null;
        double bestWeightedHitCount = 0.0;
        for (Aggregate query : queries) {
            if (!(query.getWeightedHitCount() > bestWeightedHitCount)) continue;
            bestQuery = query;
            bestWeightedHitCount = query.getWeightedHitCount();
        }
        return bestQuery;
    }

    private QuerySummaryInfoLog getQuerySummaryInfoLog() {
        QuerySummaryInfoLog querySummaryInfoLog = null;
        if (System.getProperty(USE_QUERY_SUMMARY_PROVIDED_BY_TEST_JVM_PARAM) == null) {
            querySummaryInfoLog = this.aggregateAdvisor.getQuerySummaryInfoLog();
        } else {
            INFO_LOGGER.log(AdvisorTrace.majorHeading("Use query summary provided by test file"));
            try {
                querySummaryInfoLog = QuerySummaryFileUtility.readQuerySummaryFileProvidedByTest(this.metaCube);
            }
            catch (Exception ex) {
                INFO_LOGGER.log("Error reading query summary file");
            }
        }
        if (querySummaryInfoLog != null) {
            boolean shouldPrune;
            INFO_LOGGER.log(AdvisorTrace.heading("Query summary collection - original") + AdvisorTrace.formatQuerySummary(querySummaryInfoLog));
            boolean bl = shouldPrune = this.advisorRequestParameters.isInMemoryAggregatesMustMatchInDatabaseAggregates() && !this.advisorRequestParameters.isInDatabaseAggregatesRequested();
            if (shouldPrune) {
                QuerySummaryInfoLog newQuerySummaryInfoLog = this.pruneQuerySummaryToMatchInDatabaseAggregates(querySummaryInfoLog);
                INFO_LOGGER.log(AdvisorTrace.heading("Query summary collection - pruned") + AdvisorTrace.formatQuerySummary(newQuerySummaryInfoLog));
                querySummaryInfoLog = newQuerySummaryInfoLog;
            }
        }
        return querySummaryInfoLog;
    }

    private QuerySummaryInfoLog pruneQuerySummaryToMatchInDatabaseAggregates(QuerySummaryInfoLog oldQuerySummaryInfoLog) {
        List<QuerySummaryInfo> oldQuerySummaryInfos = oldQuerySummaryInfoLog.getQuerySummaryInfos();
        ArrayList<QuerySummaryInfo> newQuerySummaryInfos = new ArrayList<QuerySummaryInfo>();
        for (QuerySummaryInfo oldQuerySummaryInfo : oldQuerySummaryInfos) {
            try {
                QuerySummaryInfo newQuerySummaryInfo = this.pruneQuerySummaryToMatchInDatabaseAggregates(oldQuerySummaryInfo, this.existingDatabaseAggregates);
                if (newQuerySummaryInfo == null) continue;
                newQuerySummaryInfos.add(newQuerySummaryInfo);
            }
            catch (Exception ex) {
                INFO_LOGGER.log("Error processing query summary info");
            }
        }
        return new QuerySummaryInfoLog(newQuerySummaryInfos);
    }

    public QuerySummaryInfo pruneQuerySummaryToMatchInDatabaseAggregates(QuerySummaryInfo oldQuerySummaryInfo, List<Aggregate> databaseAggregates) {
        QuerySummaryInfo newQuerySummaryInfo = null;
        HashSet<String> measuresInDatabaseAggregatesAtSameSlice = new HashSet<String>();
        HashSet<String> measuresInDatabaseAggregatesAtDeeperSlice = new HashSet<String>();
        SliceCombination querySummaryInfoSliceId = this.generateSliceIdFromQuerySummaryInfo(oldQuerySummaryInfo);
        for (Aggregate databaseAggregate : databaseAggregates) {
            SliceCombination databaseAggregateSliceId = databaseAggregate.getSliceId();
            List<String> measures = AdvisorUtils.getMeasureNames(databaseAggregate.getMeasures());
            if (databaseAggregateSliceId.isEqual(querySummaryInfoSliceId)) {
                measuresInDatabaseAggregatesAtSameSlice.addAll(measures);
                continue;
            }
            if (!databaseAggregateSliceId.isCovered(querySummaryInfoSliceId)) continue;
            measuresInDatabaseAggregatesAtDeeperSlice.addAll(measures);
        }
        HashSet<String> measuresInDatabaseAggregatesAtSameOrDeeperSlice = new HashSet<String>();
        measuresInDatabaseAggregatesAtSameOrDeeperSlice.addAll(measuresInDatabaseAggregatesAtSameSlice);
        measuresInDatabaseAggregatesAtSameOrDeeperSlice.addAll(measuresInDatabaseAggregatesAtDeeperSlice);
        List<String> cubeAdditiveMeasures = AdvisorUtils.getMeasureNames(this.aggregateAdvisor.getAdditiveMeasures());
        List<String> oldQueryMeasures = oldQuerySummaryInfo.getMeasureNames();
        HashSet<String> newQueryMeasures = new HashSet<String>(oldQueryMeasures);
        newQueryMeasures.retainAll(cubeAdditiveMeasures);
        newQueryMeasures.retainAll(measuresInDatabaseAggregatesAtSameOrDeeperSlice);
        HashSet<String> newQueryMeasuresCoveredByDatabaseAggregatesAtDeeperSliceOnly = new HashSet<String>(newQueryMeasures);
        newQueryMeasuresCoveredByDatabaseAggregatesAtDeeperSliceOnly.removeAll(measuresInDatabaseAggregatesAtSameSlice);
        if (!newQueryMeasuresCoveredByDatabaseAggregatesAtDeeperSliceOnly.isEmpty()) {
            newQuerySummaryInfo = new QuerySummaryInfo(oldQuerySummaryInfo.getLevelNames());
            newQuerySummaryInfo.setExecutionCount(oldQuerySummaryInfo.getExecutionCount());
            newQuerySummaryInfo.setWeightedExecutionCount(oldQuerySummaryInfo.getWeightedExecutionCount());
            newQuerySummaryInfo.incrementExecutionTime(oldQuerySummaryInfo.getExecutionTime());
            for (String measureName : newQueryMeasures) {
                newQuerySummaryInfo.setMeasureHitCount(measureName, oldQuerySummaryInfo.getMeasureHitCount(measureName));
            }
        }
        return newQuerySummaryInfo;
    }

    private SliceCombination generateSliceIdFromQuerySummaryInfo(QuerySummaryInfo querySummaryInfo) {
        Aggregate aggregate = new Aggregate(this.metaCube);
        for (String measureName : querySummaryInfo.getMeasureNames()) {
            aggregate.addMeasure(AdvisorUtils.getMetaMeasure(this.metaCube, measureName));
        }
        List<String> levelNames = querySummaryInfo.getLevelNames();
        int hierarchyIndex = -1;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                String levelName;
                if ((levelName = levelNames.get(++hierarchyIndex)) == null) continue;
                aggregate.setLevel(dimension.getName(), hierarchy.getName(), levelName);
            }
        }
        return aggregate.getSliceId();
    }

    private void determineExistingDatabaseAggregatesToLeverage() {
        for (ExistingInDatabaseAggregate existingAggregate : this.aggregateAdvisor.getExistingInDatabaseAggregates()) {
            if (existingAggregate.hasFiltering()) continue;
            Aggregate aggregate = this.createAggregateFromExistingAggregate(existingAggregate);
            this.existingDatabaseAggregates.add(aggregate);
        }
        if (!this.aggregateAdvisor.getUnitTestParameters().getExistingDatabaseAggregates().isEmpty()) {
            this.existingDatabaseAggregates.clear();
            this.existingDatabaseAggregates.addAll(this.aggregateAdvisor.getUnitTestParameters().getExistingDatabaseAggregates());
        }
        for (Aggregate existingDatabaseAggregate : this.existingDatabaseAggregates) {
            existingDatabaseAggregate.setRecommendedBy(AggregateRecommendedByEnum.EXISTING);
            existingDatabaseAggregate.setAggregateAdvisor(this.aggregateAdvisor);
        }
        INFO_LOGGER.log(AdvisorTrace.heading("Existing database aggregates that will be considered") + AdvisorTrace.formatAggregates(this.existingDatabaseAggregates));
    }

    private Aggregate createAggregateFromExistingAggregate(ExistingInDatabaseAggregate existingAggregate) {
        SliceCombination sliceId = new SliceCombination();
        sliceId.copy(this.aggregateAdvisor.getOptimizationRegion());
        sliceId.first();
        Aggregate aggregate = Aggregate.createAggregateForSliceId(this.metaCube, sliceId);
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                String levelName = existingAggregate.getLevelName(dimension.getName(), hierarchy.getName());
                if (levelName == null) continue;
                aggregate.setLevel(dimension.getName(), hierarchy.getName(), levelName);
            }
        }
        aggregate.addMeasures(existingAggregate.getMeasureNames());
        aggregate.setName(existingAggregate.getName());
        return aggregate;
    }
}

