/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.SliceCombination;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.metadata.ExistingInDatabaseAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.AggregateRecommendationStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class ModelBasedLowerSlicesStrategy
extends AggregateRecommendationStrategy {
    private List<Aggregate> existingDatabaseAggregates = new ArrayList<Aggregate>();
    private List<Aggregate> candidateAggregatesFromOtherStrategies = new ArrayList<Aggregate>();
    private List<Aggregate> tooLargeAggregates = new ArrayList<Aggregate>();
    private List<Aggregate> candidateDeepAggregates = new ArrayList<Aggregate>();
    private List<Aggregate> stackedAggregates = new ArrayList<Aggregate>();
    private ROLAPMetaDimension timeDimension;
    private static final int SEED = 0;
    private Random generator = new Random(0L);
    private static final int NUM_AGGREGATES_TO_CONSIDER_IN_DIMENSIONS_REGION = 500;
    private static final int NUM_AGGREGATES_TO_CONSIDER_IN_HIERARCHIES_REGION = 1000;
    private static final double DRILL_PCT_THRESHOLD = 0.6;
    private static final double CONVERT_TO_PERCENTAGE = 100.0;
    public static final double THOUSAND = 1000.0;
    private static final int MAX_DIMENSION_SLICES_FOR_COMPUTING_MODEL_COVERAGE = 1024;
    private static final int NUM_RANDOM_SLICES_FOR_COMPUTING_MODEL_COVERAGE = 1000;
    private List<SliceCombination> dimensionSlicesForModelCoverage = new ArrayList<SliceCombination>();
    private List<SliceCombination> hierarchySlicesForModelCoverage = new ArrayList<SliceCombination>(1000);
    private int numSlicesRejectedForBeingTooShallow = 0;
    private int numSlicesRejectedForBeingTooLarge = 0;
    private int numSlicesRejectedForBeingAboveExistingSlice = 0;
    private int numAcceptableAggregate = 0;
    private int numGetSliceCardinalityCalls = 0;
    private HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
    private Aggregate cube = new Aggregate(this.metaCube);
    private SliceCombination cubeId = this.cube.getSliceId();
    private String phase = "";
    private static final double RATING_DELTA_THRESHOLD = 12.0;
    private static final int MAX_STACKED_AGGREGATES = 4;
    private static final int FACT_ROW_COUNT_TO_LOWER_AGGREGATE_DIVISOR = 15;
    private static final int LOWER_AGGREGATE_TO_UPPER_AGGREGATE_DIVISOR = 100;
    private static final int LOWER_AGGREGATE_TO_STACKED_AGGREGATE_DIVISOR = 10;

    public ModelBasedLowerSlicesStrategy(ROLAPMetaCube theMetaCube, AggregateAdvisor theAggregateAdvisor) {
        super(theMetaCube, theAggregateAdvisor);
    }

    @Override
    public void recommendAggregates(List<Aggregate> aggregates) {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - begin"));
        this.stopWatch.start();
        this.setup();
        this.candidateAggregatesFromOtherStrategies = aggregates;
        this.timeDimension = this.aggregateAdvisor.determineTimeDimension();
        if (this.timeDimension == null) {
            INFO_LOGGER.log("No deep aggregates were selected because no time dimension was found");
            return;
        }
        ArrayList<Aggregate> deepAggregates = new ArrayList<Aggregate>();
        this.selectDeepAggregates(deepAggregates);
        INFO_LOGGER.log("\n\nCandidates - low level slices:\n" + AdvisorTrace.formatAggregates(deepAggregates));
        aggregates.addAll(this.stackedAggregates);
        aggregates.addAll(deepAggregates);
        if (this.aggregateAdvisor.getRequestParameters().getInDatabaseAggregatesLimit() == 0L || this.aggregateAdvisor.getRequestParameters().getInMemoryAggregatesLimit() == 0L) {
            ModelBasedLowerSlicesStrategy.eliminateDuplicateAggregates(aggregates);
        }
        long elapsedTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("ModelBasedLowerSlicesStrategy", elapsedTime);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - end"));
    }

    private void setup() {
        this.determineExistingDatabaseAggregatesToLeverage();
        this.setupForModelCoverageMetric();
        double initialDimensionSliceCoverage = this.estimateModelCoverage(this.dimensionSlicesForModelCoverage, this.candidateDeepAggregates);
        double initialHierarchySliceCoverage = this.estimateModelCoverage(this.hierarchySlicesForModelCoverage, this.candidateDeepAggregates);
        this.aggregateAdvisor.getMetrics().setDimensionSliceCoverage(initialDimensionSliceCoverage);
        this.aggregateAdvisor.getMetrics().setCoverage(initialHierarchySliceCoverage);
        INFO_LOGGER.log(String.format("Model coverage (using existing database aggregates only): dimension slice coverage = %.1f, hierarchy slice coverage = %.1f", initialDimensionSliceCoverage, initialHierarchySliceCoverage));
        this.initializeRejectedAggregates();
    }

    private void selectDeepAggregates(List<Aggregate> deepAggregates) {
        INFO_LOGGER.log("Select deep aggregates - consider candidates with many drills - begin");
        if (this.aggregateAdvisor.getRequestParameters().getUseWorkloadOnly() || this.aggregateAdvisor.getRequestParameters().getUserDefinedAggregatesOnly()) {
            INFO_LOGGER.log("User requested limited analysis or recommendations.  Do not consider dimension hierarchy slices.");
            this.considerUncoveredAdditiveAggregates();
        } else {
            this.considerDimensionSlices();
            this.considerUncoveredAdditiveAggregates();
            this.considerHierarchySlices();
            this.generalizeCandidateAggregates();
        }
        this.selectBestAggregates();
        this.recommendStackedAggregates();
        deepAggregates.addAll(this.candidateDeepAggregates);
        INFO_LOGGER.log(String.format("count = %d, too shallow = %d, too large = %d, above existing = %d, acceptable = %d, get slice card calls = %d, too large agg collection = %d", 1500, this.numSlicesRejectedForBeingTooShallow, this.numSlicesRejectedForBeingTooLarge, this.numSlicesRejectedForBeingAboveExistingSlice, this.numAcceptableAggregate, this.numGetSliceCardinalityCalls, this.tooLargeAggregates.size()));
        INFO_LOGGER.log(String.format("Model coverage (final) = dimension slice coverage = %.1f, hierarchy slice coverage = %.1f", this.estimateModelCoverage(this.dimensionSlicesForModelCoverage, this.candidateDeepAggregates), this.estimateModelCoverage(this.hierarchySlicesForModelCoverage, this.candidateDeepAggregates)));
        INFO_LOGGER.log("Select deep aggregates - consider candidates with many drills - end");
    }

    private void considerUncoveredAdditiveAggregates() {
        if (this.aggregateAdvisor.getRequestParameters().getInDatabaseAggregatesLimit() == 0L) {
            INFO_LOGGER.log("Do not consider uncovered additive aggregates because the in-database aggregates limit is 0.");
            return;
        }
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - Consider uncovered additive aggregates - begin"));
        long startTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.phase = "considerUncoveredAdditiveAggregates";
        List<Aggregate> uncoveredAdditiveAggregates = ModelBasedLowerSlicesStrategy.getUncoveredAdditiveAggregates(this.candidateAggregatesFromOtherStrategies, this.candidateDeepAggregates);
        SliceCombination regionId = this.defineHierarchiesRegion();
        this.consolidateAggregates(uncoveredAdditiveAggregates, null);
        INFO_LOGGER.log("Select deep aggregates - generate deep candidates at same slice as uncovered aggregates - begin");
        for (Aggregate aggregate : uncoveredAdditiveAggregates) {
            this.considerSlice(aggregate.getSliceId());
        }
        INFO_LOGGER.log("\n\nCandidate aggregates - deep slices - consider uncovered additive aggregates - exact slices:\n" + AdvisorTrace.formatAggregates(this.candidateDeepAggregates));
        INFO_LOGGER.log("Select deep aggregates - generate deep candidates at same slice as uncovered aggregates - end");
        if (!this.aggregateAdvisor.getRequestParameters().getUseWorkloadOnly() && !this.aggregateAdvisor.getRequestParameters().getUserDefinedAggregatesOnly()) {
            INFO_LOGGER.log("Select deep aggregates - make deeper in time dimension - begin");
            for (Aggregate aggregate : uncoveredAdditiveAggregates) {
                SliceCombination sliceId = new SliceCombination();
                sliceId.copy(aggregate.getSliceId());
                for (int pos = 0; pos < sliceId.getNumPositions(); ++pos) {
                    if (sliceId.getValue(pos) >= regionId.getMinimum(pos)) continue;
                    sliceId.setValue(pos, regionId.getMinimum(pos));
                }
                this.considerSlice(sliceId);
            }
            INFO_LOGGER.log("\n\nCandidate aggregates - deep slices - consider uncovered additive aggregates - deeper in time:\n" + AdvisorTrace.formatAggregates(this.candidateDeepAggregates));
            INFO_LOGGER.log("Select deep aggregates - make deeper in time dimension - end");
        }
        this.generalizeCandidateAggregates();
        INFO_LOGGER.log("\n\nCandidate aggregates - deep slices - consider uncovered additive aggregates - generalized:\n" + AdvisorTrace.formatAggregates(this.candidateDeepAggregates));
        long endTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("considerUncoveredAdditiveAggregates", endTime - startTime);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - Consider uncovered additive aggregates - end"));
    }

    private void consolidateAggregates(List<Aggregate> aggregates, Aggregate lowerAggregate) {
        ArrayList<Aggregate> originalAggregates = new ArrayList<Aggregate>();
        originalAggregates.addAll(aggregates);
        INFO_LOGGER.log("\n\nConsolidate aggregates:\n" + AdvisorTrace.formatAggregates(originalAggregates));
        ArrayList<Aggregate> consolidatedAggregates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            this.mergeAggregate(aggregate, consolidatedAggregates, lowerAggregate);
        }
        aggregates.clear();
        aggregates.addAll(consolidatedAggregates);
        INFO_LOGGER.log(AdvisorTrace.heading("Consolidated aggregates") + "\nOriginal aggregates:\n" + AdvisorTrace.formatAggregates(originalAggregates) + "\nConsolidated aggregates:\n" + AdvisorTrace.formatAggregates(aggregates));
    }

    private void mergeAggregate(Aggregate aggregateToMerge, List<Aggregate> aggregates, Aggregate lowerAggregate) {
        Collections.sort(aggregates, AggregateUtils.AGGREGATE_ASCENDING_CARDINALITY_ORDER);
        ArrayList<Aggregate> consolidatedAggregates = new ArrayList<Aggregate>();
        boolean merged = false;
        for (Aggregate aggregate : aggregates) {
            Aggregate mergedAggregate = this.merge(aggregateToMerge, aggregate, lowerAggregate);
            if (mergedAggregate == null) continue;
            INFO_LOGGER.log(String.format("Merged aggregates [%s] and [%s] to [%s]", aggregateToMerge.getName(), aggregate.getName(), mergedAggregate.getName()));
            consolidatedAggregates.addAll(aggregates);
            consolidatedAggregates.remove(aggregate);
            consolidatedAggregates.add(mergedAggregate);
            merged = true;
            break;
        }
        if (!merged) {
            INFO_LOGGER.log(String.format("Unable to merge aggregate [%s]", aggregateToMerge.getName()));
            if (lowerAggregate != null) {
                INFO_LOGGER.log(String.format("Create a stacked aggregate corresponding to the upper aggregate [%s]", aggregateToMerge.getName()));
                Aggregate stackedAggregate = this.createAggregateForSliceId(aggregateToMerge.getSliceId());
                stackedAggregate.setCardinality(aggregateToMerge.getCardinality());
                aggregateToMerge = stackedAggregate;
            }
            consolidatedAggregates.addAll(aggregates);
            consolidatedAggregates.add(aggregateToMerge);
        }
        aggregates.clear();
        aggregates.addAll(consolidatedAggregates);
    }

    private Aggregate merge(Aggregate aggregate1, Aggregate aggregate2, Aggregate lowerAggregate) {
        Aggregate mergedAggregate = null;
        SliceCombination sliceId = new SliceCombination();
        sliceId.copy(aggregate1.getSliceId());
        sliceId.union(aggregate2.getSliceId());
        mergedAggregate = this.createAggregateForSliceId(sliceId);
        long rows = this.aggregateAdvisor.getSliceCardinality(mergedAggregate, this.phase);
        mergedAggregate.setCardinality(rows);
        if (lowerAggregate == null) {
            if (this.aggregateAdvisor.isAggregateSmallRelativetoFact(mergedAggregate)) {
                return mergedAggregate;
            }
            INFO_LOGGER.log(LogLevel.TRACE, String.format("The merged aggregate [%s] is large compared to the fact ( %,d / %,d = %,.1f ).", mergedAggregate.getName(), this.aggregateAdvisor.getFactRowCount(), mergedAggregate.getCardinality(), 1.0 * (double)this.aggregateAdvisor.getFactRowCount() / (double)mergedAggregate.getCardinality()));
            return null;
        }
        if (ModelBasedLowerSlicesStrategy.isStackedAggregateSmallRelativeToLowerAggregate(mergedAggregate, lowerAggregate)) {
            return mergedAggregate;
        }
        INFO_LOGGER.log(LogLevel.TRACE, String.format("The merged aggregate [%s] is large compared to the lower aggregate [%s] ( %,d / %,d = %,.1f ).", mergedAggregate.getName(), lowerAggregate.getName(), lowerAggregate.getCardinality(), mergedAggregate.getCardinality(), 1.0 * (double)lowerAggregate.getCardinality() / (double)mergedAggregate.getCardinality()));
        return null;
    }

    private static List<Aggregate> getUncoveredAdditiveAggregates(List<Aggregate> candidateAggregates, List<Aggregate> deepAggregates) {
        ArrayList<Aggregate> uncoveredAdditiveAggregates = new ArrayList<Aggregate>();
        List<Aggregate> additiveAggregates = AggregateUtils.getAdditiveAggregates(candidateAggregates);
        for (Aggregate aggregate : additiveAggregates) {
            if (Aggregate.isAggregateCovered(aggregate, deepAggregates)) continue;
            uncoveredAdditiveAggregates.add(aggregate);
        }
        return uncoveredAdditiveAggregates;
    }

    private void generalizeCandidateAggregates() {
        INFO_LOGGER.log("Select deep aggregates - generalize candidate aggregates - begin");
        long startTime = this.stopWatch.getElapsedTimeInMilliseconds();
        int count = 10;
        for (int i = 1; i <= 10; ++i) {
            this.considerSimilarAggregates(this.candidateDeepAggregates);
        }
        INFO_LOGGER.log("\n\nCandidate aggregates - deep slices - generalize slices:\n" + AdvisorTrace.formatAggregates(this.candidateDeepAggregates));
        long endTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("generalizeCandidateAggregates", endTime - startTime);
        INFO_LOGGER.log("Select deep aggregates - generalize candidate aggregates - end");
    }

    private void considerSimilarAggregates(List<Aggregate> originalAggregates) {
        ArrayList<SliceCombination> newCandidates = new ArrayList<SliceCombination>();
        for (Aggregate originalAggregate1 : originalAggregates) {
            for (Aggregate originalAggregate2 : originalAggregates) {
                if (originalAggregate1.getName().equals(originalAggregate2.getName())) continue;
                SliceCombination sliceId = new SliceCombination();
                sliceId.copy(originalAggregate1.getSliceId());
                sliceId.union(originalAggregate2.getSliceId());
                newCandidates.add(sliceId);
            }
        }
        for (SliceCombination sliceId : newCandidates) {
            this.considerSlice(sliceId);
        }
    }

    private void selectBestAggregates() {
        StringBuilder sb = new StringBuilder();
        ArrayList<Aggregate> currentAggregates = new ArrayList<Aggregate>();
        currentAggregates.addAll(this.candidateDeepAggregates);
        ArrayList<Aggregate> bestAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> removedDeepAggregates = new ArrayList<Aggregate>();
        sb.append(AdvisorTrace.heading("Select the best deep aggregates"));
        sb.append("\nCurrent deep aggregates:\n" + AdvisorTrace.formatAggregates(currentAggregates));
        sb.append("\nModel and slice coverage as aggregates are added:\n");
        sb.append("Rating  Count   Dim    Hier  Aggregate name\n");
        double lastRating = 0.0;
        while (!currentAggregates.isEmpty()) {
            Aggregate currBestAggregate = this.selectAggregateToMaximizeCoverage(bestAggregates, currentAggregates);
            ArrayList<Aggregate> testAggregates = new ArrayList<Aggregate>();
            testAggregates.addAll(bestAggregates);
            testAggregates.add(currBestAggregate);
            double currRating = this.coverageRating(testAggregates);
            double deltaRating = currRating - lastRating;
            boolean includeAggregate = true;
            if (deltaRating < 12.0) {
                ArrayList<Aggregate> deltaAggregates = new ArrayList<Aggregate>();
                deltaAggregates.addAll(AggregateUtils.getCoveredAggregates(this.candidateAggregatesFromOtherStrategies, testAggregates));
                deltaAggregates.removeAll(AggregateUtils.getCoveredAggregates(this.candidateAggregatesFromOtherStrategies, bestAggregates));
                boolean allAggregatesBasedOnModel = true;
                for (Aggregate deltaAggregate : deltaAggregates) {
                    if (deltaAggregate.getRecommendedBy() == AggregateRecommendedByEnum.MODEL) continue;
                    allAggregatesBasedOnModel = false;
                    break;
                }
                if (allAggregatesBasedOnModel) {
                    includeAggregate = false;
                }
            }
            currentAggregates.remove(currBestAggregate);
            if (includeAggregate) {
                lastRating = currRating;
                bestAggregates.add(currBestAggregate);
                int numSlicesCovered = this.numberOfSlicesCovered(this.candidateAggregatesFromOtherStrategies, bestAggregates);
                double dimensionSliceCoverage = this.estimateModelCoverage(this.dimensionSlicesForModelCoverage, bestAggregates);
                double hierarchySliceCoverage = this.estimateModelCoverage(this.hierarchySlicesForModelCoverage, bestAggregates);
                sb.append(String.format(" %5.1f  %5d  %5.1f  %5.1f  %s \n", currRating, numSlicesCovered, dimensionSliceCoverage, hierarchySliceCoverage, currBestAggregate.getName()));
                continue;
            }
            removedDeepAggregates.add(currBestAggregate);
        }
        ArrayList<Aggregate> noLongerCoveredAggregates = new ArrayList<Aggregate>();
        noLongerCoveredAggregates.addAll(AggregateUtils.getCoveredAggregates(this.candidateAggregatesFromOtherStrategies, this.candidateDeepAggregates));
        noLongerCoveredAggregates.removeAll(AggregateUtils.getCoveredAggregates(this.candidateAggregatesFromOtherStrategies, bestAggregates));
        this.candidateAggregatesFromOtherStrategies.removeAll(noLongerCoveredAggregates);
        this.candidateDeepAggregates.clear();
        this.candidateDeepAggregates.addAll(bestAggregates);
        sb.append("\nDeep aggregates eliminated because they provide insufficient benefit:\n" + AdvisorTrace.formatAggregates(removedDeepAggregates));
        sb.append("\nUpper aggregates eliminated because the deep aggregates covering them were eliminated:\n" + AdvisorTrace.formatAggregates(noLongerCoveredAggregates));
        sb.append("\nDeep aggregates retained because they provide good benefit (sorted in descending benefit order):\n" + AdvisorTrace.formatAggregates(bestAggregates));
        INFO_LOGGER.log(sb.toString());
    }

    private Aggregate selectAggregateToMaximizeCoverage(List<Aggregate> currentAggregates, List<Aggregate> candidateAggregates) {
        double bestRating = this.coverageRating(currentAggregates);
        Aggregate bestCandidate = null;
        for (Aggregate aggregate : candidateAggregates) {
            ArrayList<Aggregate> testAggregates = new ArrayList<Aggregate>();
            testAggregates.addAll(currentAggregates);
            testAggregates.add(aggregate);
            double newRating = this.coverageRating(testAggregates);
            if (!(newRating >= bestRating)) continue;
            bestCandidate = aggregate;
            bestRating = newRating;
        }
        return bestCandidate;
    }

    private double coverageRating(List<Aggregate> aggregates) {
        int numSlicesCovered = this.numberOfSlicesCovered(this.candidateAggregatesFromOtherStrategies, aggregates);
        double pctUpperSlicesCovered = 100.0 * (double)numSlicesCovered / (double)this.candidateAggregatesFromOtherStrategies.size();
        double dimensionSliceCoverage = this.estimateModelCoverage(this.dimensionSlicesForModelCoverage, aggregates);
        double hierarchySliceCoverage = this.estimateModelCoverage(this.hierarchySlicesForModelCoverage, aggregates);
        double rating = pctUpperSlicesCovered + dimensionSliceCoverage + hierarchySliceCoverage;
        return rating;
    }

    private int numberOfSlicesCovered(List<Aggregate> upperAggregates, List<Aggregate> lowerAggregates) {
        int count = 0;
        block0: for (Aggregate upperAggregate : upperAggregates) {
            for (Aggregate lowerAggregate : lowerAggregates) {
                if (!lowerAggregate.isCovered(upperAggregate)) continue;
                ++count;
                continue block0;
            }
        }
        return count;
    }

    protected void considerSpecialSlices() {
        INFO_LOGGER.log("Select deep aggregates - consider special slices - begin");
        long startTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.phase = "considerDimensionSlices";
        this.generateBottomSlice();
        this.generateSliceAtVariousTimeHierarchyLevels();
        INFO_LOGGER.log("\n\nCandidate aggregates - deep slices - special slices:\n" + AdvisorTrace.formatAggregates(this.candidateDeepAggregates));
        long endTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("considerDimensionSlices", endTime - startTime);
        INFO_LOGGER.log("Select deep aggregates - consider special slices - end");
    }

    private void generateBottomSlice() {
        SliceCombination sliceId = new SliceCombination();
        sliceId.copy(this.cubeId);
        sliceId.last();
        this.considerSliceIncludingDepth(sliceId);
    }

    private void generateSliceAtVariousTimeHierarchyLevels() {
        if (this.timeDimension == null) {
            return;
        }
        SliceCombination sliceId = new SliceCombination();
        sliceId.copy(this.cubeId);
        sliceId.last();
        ROLAPMetaHierarchy timeHierarchy = this.metaCube.getHierarchies(this.timeDimension)[0];
        for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(this.timeDimension)) {
            int hierarchyIndex = AdvisorUtils.getHierarchyIndex(this.metaCube, this.timeDimension.getName(), hierarchy.getName());
            sliceId.setValue(hierarchyIndex, sliceId.getMinimum(hierarchyIndex));
        }
        int primaryHierarchyIndex = AdvisorUtils.getHierarchyIndex(this.metaCube, this.timeDimension.getName(), timeHierarchy.getName());
        for (int levelIndex = sliceId.getMaximum(primaryHierarchyIndex); levelIndex >= sliceId.getMinimum(primaryHierarchyIndex); --levelIndex) {
            sliceId.setValue(primaryHierarchyIndex, levelIndex);
            this.considerSliceIncludingDepth(sliceId);
        }
    }

    private void considerDimensionSlices() {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - Consider dimension slices - begin"));
        long startTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.phase = "considerDimensionSlices";
        SliceCombination regionId = new SliceCombination();
        regionId.copy(this.aggregateAdvisor.getOptimizationRegion());
        SliceCombination sliceId = new SliceCombination();
        sliceId.copy(this.cubeId);
        SliceCombination dimensionsShape = this.cube.getDimensionSliceId();
        INFO_LOGGER.log(String.format("Cube: dimension shape %s, hierarchy shape %s, depth=%d", dimensionsShape.rangeToString(), this.cubeId.rangeToString(), this.cubeId.getMaxNumberOfTurns()));
        SliceCombination dimensionsRegion = new SliceCombination();
        dimensionsRegion.copy(dimensionsShape);
        int dimIndex = -1;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            ++dimIndex;
            for (int hierIndex = 1; hierIndex <= this.metaCube.getHierarchies(dimension).length; ++hierIndex) {
                if (!dimension.getName().equals(this.timeDimension.getName())) continue;
                dimensionsRegion.setMinimum(dimIndex, dimensionsRegion.getMaximum(dimIndex));
            }
        }
        INFO_LOGGER.log(String.format("Region by dimensions: %s, depth=%d, slices=%.0f", dimensionsRegion.rangeToString(), dimensionsRegion.getMaxNumberOfTurns(), dimensionsRegion.getNumberOfCombinations()));
        for (int i = 1; i <= 500; ++i) {
            dimensionsRegion.random(this.generator);
            this.convertDimensionSliceToHierarchySlice(dimensionsRegion, regionId, sliceId);
            this.considerSliceIncludingDepth(sliceId);
        }
        INFO_LOGGER.log("\n\nCandidate aggregates - deep slices - dimension slices:\n" + AdvisorTrace.formatAggregates(this.candidateDeepAggregates));
        long endTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("considerDimensionSlices", endTime - startTime);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - Consider dimension slices - end"));
    }

    private void convertDimensionSliceToHierarchySlice(SliceCombination dimensionsRegion, SliceCombination regionId, SliceCombination sliceId) {
        int dimIndex = -1;
        int pos = -1;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            ++dimIndex;
            for (int hierIndex = 1; hierIndex <= this.metaCube.getHierarchies(dimension).length; ++hierIndex) {
                ++pos;
                if (dimensionsRegion.getValue(dimIndex) == 0) {
                    sliceId.setValue(pos, regionId.getMinimum(pos));
                    continue;
                }
                sliceId.setValue(pos, regionId.getMaximum(pos));
            }
        }
    }

    private void considerHierarchySlices() {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - Consider hierarchy slices - begin"));
        long startTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.phase = "considerHierarchySlices";
        SliceCombination sliceId = new SliceCombination();
        sliceId.copy(this.cubeId);
        SliceCombination regionId = this.defineHierarchiesRegion();
        for (int i = 1; i <= 1000; ++i) {
            if (i <= 500) continue;
            regionId.random(this.generator);
            for (int pos = 0; pos < regionId.getNumPositions(); ++pos) {
                sliceId.setValue(pos, regionId.getValue(pos));
            }
            this.considerSliceIncludingDepth(sliceId);
        }
        long endTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("considerHierarchySlices", endTime - startTime);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - Consider hierarchy slices - end"));
    }

    private void recommendStackedAggregates() {
        Aggregate lowerAggregate;
        List<Aggregate> matchedUpperAggregates;
        if (this.aggregateAdvisor.getRequestParameters().getInDatabaseAggregatesLimit() == 0L) {
            INFO_LOGGER.log("Do not recommend stacked aggregates because the in-database aggregates limit is 0.");
            return;
        }
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - Select stacked aggregates - begin"));
        long startTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.phase = "recommendStackedAggregates";
        long factRowCount = this.aggregateAdvisor.getFactRowCount();
        INFO_LOGGER.log(AdvisorTrace.heading("Current aggregates") + "\nUpper aggregates:\n" + AdvisorTrace.formatAggregates(this.candidateAggregatesFromOtherStrategies) + "\nLower aggregates:\n" + AdvisorTrace.formatAggregates(this.candidateDeepAggregates));
        INFO_LOGGER.log("\nShow all upper aggregates and where they are derived from:\n" + AdvisorTrace.formatAggregateCoverageAnalysis(this.candidateAggregatesFromOtherStrategies, this.candidateDeepAggregates, this.aggregateAdvisor));
        ArrayList<Aggregate> lowerAggregates = new ArrayList<Aggregate>(this.candidateDeepAggregates);
        this.traceLowerAggregateSizeInfo(lowerAggregates);
        List<Aggregate> upperAggregates = this.getUpperAggregatesFromWhichToGenerateStackedAggregates(this.candidateAggregatesFromOtherStrategies, lowerAggregates);
        INFO_LOGGER.log("\nUpper aggregates selected for the generation of stacked aggregates:\n" + AdvisorTrace.formatAggregates(upperAggregates));
        INFO_LOGGER.log("\nShow upper aggregates most likely to benefit from stacked aggregates and where they are derived from:\n" + AdvisorTrace.formatAggregateCoverageAnalysis(upperAggregates, lowerAggregates, this.aggregateAdvisor));
        Map<Aggregate, List<Aggregate>> lowerAggregateToMatchedUpperAggregatesMap = this.getLowerAggregateToMatchedUpperAggregatesMap(lowerAggregates, upperAggregates);
        Collections.sort(lowerAggregates, new LowerAggregateComparatorByDescendingMatchedUpperAggregateCount(lowerAggregateToMatchedUpperAggregatesMap));
        ModelBasedLowerSlicesStrategy.traceLowerAggregateToMatchedUpperAggregates(lowerAggregates, lowerAggregateToMatchedUpperAggregatesMap);
        Iterator iterator = lowerAggregates.iterator();
        while (iterator.hasNext() && !(matchedUpperAggregates = lowerAggregateToMatchedUpperAggregatesMap.get(lowerAggregate = (Aggregate)iterator.next())).isEmpty()) {
            INFO_LOGGER.log(String.format("Merge the selected upper aggregates that would be matched with the lower aggregate %s", lowerAggregate.getName()));
            this.consolidateAggregates(matchedUpperAggregates, lowerAggregate);
            for (Aggregate matchedUpperAggregate : matchedUpperAggregates) {
                if (this.stackedAggregates.size() >= 4) break;
                String matchedUpperAggregateName = matchedUpperAggregate.getName();
                long matchedUpperAggregateCardinality = matchedUpperAggregate.getCardinality();
                if (this.isStackedAggregateLargeRelativeToFact(matchedUpperAggregate)) {
                    INFO_LOGGER.log(String.format("Accept the stacked aggregate [%s] because it is large compared to the fact ( %,d / %,d = %,.1f )", matchedUpperAggregateName, factRowCount, matchedUpperAggregateCardinality, 1.0 * (double)factRowCount / (double)matchedUpperAggregateCardinality));
                    this.stackedAggregates.add(matchedUpperAggregate);
                    continue;
                }
                INFO_LOGGER.log(String.format("Reject the stacked aggregate [%s] because it is small compared to the fact ( %,d / %,d = %,.1f )", matchedUpperAggregateName, factRowCount, matchedUpperAggregateCardinality, 1.0 * (double)factRowCount / (double)matchedUpperAggregateCardinality));
            }
            if (this.stackedAggregates.size() < 4) continue;
            break;
        }
        INFO_LOGGER.log("\nStacked slices:\n" + AdvisorTrace.formatAggregates(this.stackedAggregates));
        ArrayList<Aggregate> lowerAndStackedAggregates = new ArrayList<Aggregate>(lowerAggregates);
        lowerAndStackedAggregates.addAll(this.stackedAggregates);
        INFO_LOGGER.log("\nShow upper aggregates most likely to benefit from stacked aggregates and where they are derived from now that stacked aggregates have been defined:\n" + AdvisorTrace.formatAggregateCoverageAnalysis(upperAggregates, lowerAndStackedAggregates, this.aggregateAdvisor));
        long endTime = this.stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("recommendStackedAggregates", endTime - startTime);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Select deep aggregates - Select stacked aggregates - end"));
    }

    private List<Aggregate> getUpperAggregatesFromWhichToGenerateStackedAggregates(List<Aggregate> upperAggregates, List<Aggregate> lowerAggregates) {
        ArrayList<Aggregate> aggregatesToReturn = new ArrayList<Aggregate>();
        List<Aggregate> additiveUpperAggregates = AggregateUtils.getAdditiveAggregates(upperAggregates);
        for (Aggregate additiveUpperAggregate : additiveUpperAggregates) {
            Aggregate lowerAggregate;
            if (!Aggregate.isAggregateCovered(additiveUpperAggregate, lowerAggregates) || !ModelBasedLowerSlicesStrategy.isUpperAggregateSmallRelativeToLowerAggregate(additiveUpperAggregate, lowerAggregate = this.aggregateAdvisor.determineAggregateThatWillBeMatched(additiveUpperAggregate, lowerAggregates)) || !this.isLowerAggregateLargeRelativeToFact(lowerAggregate)) continue;
            aggregatesToReturn.add(additiveUpperAggregate);
        }
        return aggregatesToReturn;
    }

    private boolean isLowerAggregateLargeRelativeToFact(Aggregate lowerAggregate) {
        long factRowCount;
        long lowerAggregateCardinalityThreshold;
        long lowerAggregateCardinality = lowerAggregate.getCardinality();
        return lowerAggregateCardinality >= (lowerAggregateCardinalityThreshold = (factRowCount = this.aggregateAdvisor.getFactRowCount()) / 15L);
    }

    private static boolean isUpperAggregateSmallRelativeToLowerAggregate(Aggregate upperAggregate, Aggregate lowerAggregate) {
        long lowerAggregateCardinality;
        long upperAggregateCardinalityThreshold;
        long upperAggregateCardinality = upperAggregate.getCardinality();
        return upperAggregateCardinality <= (upperAggregateCardinalityThreshold = (lowerAggregateCardinality = lowerAggregate.getCardinality()) / 100L);
    }

    private static boolean isStackedAggregateSmallRelativeToLowerAggregate(Aggregate stackedAggregate, Aggregate lowerAggregate) {
        long lowerAggregateCardinality;
        long stackedAggregateCardinalityThreshold;
        long stackedAggregateCardinality = stackedAggregate.getCardinality();
        return stackedAggregateCardinality <= (stackedAggregateCardinalityThreshold = (lowerAggregateCardinality = lowerAggregate.getCardinality()) / 10L);
    }

    private boolean isStackedAggregateLargeRelativeToFact(Aggregate stackedAggregate) {
        long factRowCount;
        long stackedAggregateCardinalityThreshold;
        long stackedAggregateCardinality = stackedAggregate.getCardinality();
        return stackedAggregateCardinality >= (stackedAggregateCardinalityThreshold = (factRowCount = this.aggregateAdvisor.getFactRowCount()) / 10000L);
    }

    private Map<Aggregate, List<Aggregate>> getLowerAggregateToMatchedUpperAggregatesMap(List<Aggregate> lowerAggregates, List<Aggregate> upperAggregates) {
        HashMap<Aggregate, List<Aggregate>> lowerAggregateToMatchedUpperAggregatesMap = new HashMap<Aggregate, List<Aggregate>>();
        for (Aggregate lowerAggregate : lowerAggregates) {
            List<Aggregate> matchedUpperAggregates = this.getMatchedUpperAggregates(lowerAggregate, upperAggregates, lowerAggregates);
            lowerAggregateToMatchedUpperAggregatesMap.put(lowerAggregate, matchedUpperAggregates);
        }
        return lowerAggregateToMatchedUpperAggregatesMap;
    }

    private List<Aggregate> getMatchedUpperAggregates(Aggregate lowerAggregate, List<Aggregate> upperAggregates, List<Aggregate> lowerAggregates) {
        ArrayList<Aggregate> matchedUpperAggregates = new ArrayList<Aggregate>();
        for (Aggregate upperAggregate : upperAggregates) {
            Aggregate matchedLowerAggregate = this.aggregateAdvisor.determineAggregateThatWillBeMatched(upperAggregate, lowerAggregates);
            if (lowerAggregate != matchedLowerAggregate) continue;
            matchedUpperAggregates.add(upperAggregate);
        }
        return matchedUpperAggregates;
    }

    private void traceLowerAggregateSizeInfo(List<Aggregate> lowerAggregates) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nLower aggregate size info:\n");
        sb.append(String.format("%15s %15s %10s %s\n", "Cardinality", "Fact row count", "Ratio", "Aggregate name"));
        long factRowCount = this.aggregateAdvisor.getFactRowCount();
        for (Aggregate lowerAggregate : lowerAggregates) {
            long cardinality = lowerAggregate.getCardinality();
            double ratio = 1.0 * (double)factRowCount / (double)cardinality;
            sb.append(String.format("%,15d %,15d %,10.1f %s\n", cardinality, factRowCount, ratio, lowerAggregate.getName()));
        }
        INFO_LOGGER.log(sb.toString());
    }

    private static void traceLowerAggregateToMatchedUpperAggregates(List<Aggregate> lowerAggregates, Map<Aggregate, List<Aggregate>> lowerAggregateToMatchedUpperAggregatesMap) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nLower aggregates with the selected upper aggregates that would be matched with the lower aggregates:\n\n");
        for (Aggregate lowerAggregate : lowerAggregates) {
            sb.append(lowerAggregate.getName());
            sb.append("\n");
            List<Aggregate> matchedUpperAggregates = lowerAggregateToMatchedUpperAggregatesMap.get(lowerAggregate);
            for (Aggregate matchedUpperAggregate : matchedUpperAggregates) {
                sb.append(String.format("   %s\n", matchedUpperAggregate.getName()));
            }
            sb.append(String.format("Total: %,d\n\n", matchedUpperAggregates.size()));
        }
        INFO_LOGGER.log(sb.toString());
    }

    private SliceCombination defineHierarchiesRegion() {
        SliceCombination regionId = new SliceCombination();
        regionId.copy(this.aggregateAdvisor.getOptimizationRegion());
        int pos = -1;
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (int hierIndex = 1; hierIndex <= this.metaCube.getHierarchies(dimension).length; ++hierIndex) {
                ++pos;
                if (!dimension.getName().equals(this.timeDimension.getName())) continue;
                regionId.setMinimum(pos, regionId.getMaximum(pos));
            }
        }
        INFO_LOGGER.log(String.format("Region by hierarchies: %s, depth=%d, slices=%.0f", regionId.rangeToString(), regionId.getMaxNumberOfTurns(), regionId.getNumberOfCombinations()));
        return regionId;
    }

    private void considerSliceIncludingDepth(SliceCombination sliceId) {
        if ((double)sliceId.getNumberOfTurns() < 0.6 * (double)sliceId.getMaxNumberOfTurns()) {
            ++this.numSlicesRejectedForBeingTooShallow;
            return;
        }
        this.considerSlice(sliceId);
    }

    private void considerSlice(SliceCombination sliceId) {
        Aggregate aggregate = this.createAggregateForSliceId(sliceId);
        if (this.isAboveExistingDatabaseAggregate(aggregate)) {
            ++this.numSlicesRejectedForBeingAboveExistingSlice;
            return;
        }
        if (this.isBelowCandidateRejectedForBeingTooLarge(aggregate)) {
            ++this.numSlicesRejectedForBeingTooLarge;
            return;
        }
        if (this.isAboveAnAcceptableCandidate(aggregate)) {
            ++this.numSlicesRejectedForBeingAboveExistingSlice;
            return;
        }
        ++this.numGetSliceCardinalityCalls;
        this.getCardinality(aggregate);
        if (this.aggregateAdvisor.isAggregateSmallRelativetoFact(aggregate)) {
            INFO_LOGGER.log(String.format("Deep aggregate %s is kept since it is small compared to the fact table", aggregate.getName()));
            this.addAcceptableCandidate(aggregate);
            ++this.numAcceptableAggregate;
            double dimensionSliceCoverage = this.estimateModelCoverage(this.dimensionSlicesForModelCoverage, this.candidateDeepAggregates);
            double hierarchySliceCoverage = this.estimateModelCoverage(this.hierarchySlicesForModelCoverage, this.candidateDeepAggregates);
            this.aggregateAdvisor.getMetrics().setDimensionSliceCoverage(dimensionSliceCoverage);
            this.aggregateAdvisor.getMetrics().setCoverage(hierarchySliceCoverage);
            String str = String.format("Candidate deep aggregates updated (time, phase, count, DimSliceCoverage, HierSliceCoverage): %.1f; %s; %d; %.3f; %.3f", (double)this.stopWatch.getElapsedTimeInMilliseconds() / 1000.0, this.phase, this.candidateDeepAggregates.size(), dimensionSliceCoverage, hierarchySliceCoverage);
            INFO_LOGGER.log(str);
            ArrayList<Aggregate> aggregatesToSave = new ArrayList<Aggregate>();
            aggregatesToSave.addAll(this.candidateAggregatesFromOtherStrategies);
            aggregatesToSave.addAll(this.candidateDeepAggregates);
            if (this.aggregateAdvisor.getRequestParameters().getInDatabaseAggregatesLimit() == 0L || this.aggregateAdvisor.getRequestParameters().getInMemoryAggregatesLimit() == 0L) {
                ModelBasedLowerSlicesStrategy.eliminateDuplicateAggregates(aggregatesToSave);
            }
            this.aggregateAdvisor.saveRecommendations(aggregatesToSave);
            this.aggregateAdvisor.setProgressValue(this.aggregateAdvisor.getProgessValue() + 10);
        } else {
            INFO_LOGGER.log(String.format("Deep aggregate rejected because it is too large compared to the fact table.\nAggregate: %s %s [%s]", AdvisorTrace.formatDimensionSliceIdAsString(aggregate), aggregate.getSliceId().valueToString(), aggregate.getName()));
            this.addTooLargeAggregate(aggregate);
            ++this.numSlicesRejectedForBeingTooLarge;
        }
    }

    private boolean isAboveExistingDatabaseAggregate(Aggregate anAggregate) {
        for (Aggregate existingAggregate : this.existingDatabaseAggregates) {
            if (!existingAggregate.getSliceId().isCovered(anAggregate.getSliceId())) continue;
            return true;
        }
        return false;
    }

    private boolean isBelowCandidateRejectedForBeingTooLarge(Aggregate anAggregate) {
        for (Aggregate aggregate : this.tooLargeAggregates) {
            if (!anAggregate.getSliceId().isCovered(aggregate.getSliceId())) continue;
            return true;
        }
        return false;
    }

    private boolean isAboveAnAcceptableCandidate(Aggregate anAggregate) {
        for (Aggregate aggregate : this.candidateDeepAggregates) {
            if (!aggregate.getSliceId().isCovered(anAggregate.getSliceId())) continue;
            return true;
        }
        return false;
    }

    private void addTooLargeAggregate(Aggregate anAggregate) {
        List<Aggregate> aggregatesBelow = this.getAggregatesBelowSpecifiedAggregate(this.tooLargeAggregates, anAggregate);
        this.tooLargeAggregates.removeAll(aggregatesBelow);
        this.tooLargeAggregates.add(anAggregate);
    }

    private void addAcceptableCandidate(Aggregate anAggregate) {
        List<Aggregate> aggregatesAbove = this.getAggregatesAboveSpecifiedAggregate(this.candidateDeepAggregates, anAggregate);
        this.candidateDeepAggregates.removeAll(aggregatesAbove);
        this.candidateDeepAggregates.add(anAggregate);
    }

    private List<Aggregate> getAggregatesAboveSpecifiedAggregate(List<Aggregate> aggregates, Aggregate anAggregate) {
        ArrayList<Aggregate> aggregatesAbove = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            if (!anAggregate.getSliceId().isCovered(aggregate.getSliceId())) continue;
            aggregatesAbove.add(aggregate);
        }
        return aggregatesAbove;
    }

    private List<Aggregate> getAggregatesBelowSpecifiedAggregate(List<Aggregate> aggregates, Aggregate anAggregate) {
        ArrayList<Aggregate> aggregatesBelow = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            if (!aggregate.getSliceId().isCovered(anAggregate.getSliceId())) continue;
            aggregatesBelow.add(aggregate);
        }
        return aggregatesBelow;
    }

    private void determineExistingDatabaseAggregatesToLeverage() {
        SliceCombination topSliceId = new SliceCombination();
        topSliceId.copy(this.cubeId);
        topSliceId.first();
        Aggregate topSliceAggregate = this.createAggregateForSliceId(topSliceId);
        StringBuilder sb = new StringBuilder();
        sb.append("Existing database aggregates - need cube's entire set of additive measures and no slicer:\n");
        for (ExistingInDatabaseAggregate existingAggregate : this.aggregateAdvisor.getExistingInDatabaseAggregates()) {
            if (existingAggregate.covers(topSliceAggregate)) {
                sb.append(String.format("Consider           %s\n", existingAggregate.getName()));
                Aggregate aggregate = this.createAggregateFromExistingAggregate(existingAggregate);
                this.existingDatabaseAggregates.add(aggregate);
                continue;
            }
            sb.append(String.format("Don't consider     %s\n", existingAggregate.getName()));
        }
        INFO_LOGGER.log(sb.toString());
        if (!this.aggregateAdvisor.getUnitTestParameters().getExistingDatabaseAggregates().isEmpty()) {
            this.existingDatabaseAggregates.clear();
            this.existingDatabaseAggregates.addAll(this.aggregateAdvisor.getUnitTestParameters().getExistingDatabaseAggregates());
        }
        INFO_LOGGER.log("\n\nExisting database aggregates that will be considered:\n" + AdvisorTrace.formatAggregates(this.existingDatabaseAggregates));
    }

    private Aggregate createAggregateFromExistingAggregate(ExistingInDatabaseAggregate existingAggregate) {
        SliceCombination sliceId = new SliceCombination();
        sliceId.copy(this.cubeId);
        sliceId.first();
        Aggregate aggregate = this.createAggregateForSliceId(sliceId);
        for (ROLAPMetaDimension dimension : this.metaCube.getDimensions()) {
            for (ROLAPMetaHierarchy hierarchy : this.metaCube.getHierarchies(dimension)) {
                String levelName = existingAggregate.getLevelName(dimension.getName(), hierarchy.getName());
                if (levelName == null) continue;
                aggregate.setLevel(dimension.getName(), hierarchy.getName(), levelName);
            }
        }
        aggregate.setRecommendedBy(AggregateRecommendedByEnum.EXISTING);
        aggregate.setName(aggregate.generateDescriptiveName());
        return aggregate;
    }

    private void getCardinality(Aggregate aggregate) {
        try {
            long cardinality = this.aggregateAdvisor.getSliceCardinality(aggregate, this.phase);
            aggregate.setMaxCardinality(cardinality);
            aggregate.setCardinality(cardinality);
            this.aggregateAdvisor.setProgressValue(this.aggregateAdvisor.getProgessValue() + 10);
        }
        catch (OperationCanceledException canceled) {
            throw canceled;
        }
        catch (Exception ex) {
            aggregate.setCardinality(10000000000000000L);
            String fmt = "Get slice cardinality failed for aggregate %s.  Continue processing.  Exception: %s";
            INFO_LOGGER.log(String.format(fmt, aggregate.getName(), ex.getMessage()));
        }
    }

    private Aggregate createAggregateForSliceId(SliceCombination sliceId) {
        Aggregate aggregate = Aggregate.createAggregateForSliceId(this.metaCube, sliceId);
        this.setAggregateSettings(aggregate);
        aggregate.setName(aggregate.generateDescriptiveName());
        return aggregate;
    }

    private void setAggregateSettings(Aggregate aggregate) {
        aggregate.setAggregateAdvisor(this.aggregateAdvisor);
        aggregate.setRecommendedBy(AggregateRecommendedByEnum.MODEL);
        aggregate.setDeepSlice(true);
        aggregate.addMeasures(this.aggregateAdvisor.selectMeasuresBasedOnModel());
    }

    private void setupForModelCoverageMetric() {
        INFO_LOGGER.log("Setup for model coverage metrics");
        this.setupForDimensionSliceCoverageMetric();
        this.setupForHierarchySliceCoverageMetric();
    }

    private void setupForDimensionSliceCoverageMetric() {
        INFO_LOGGER.log("Setup for dimension slice coverage metric");
        Aggregate aggregate = new Aggregate(this.metaCube);
        SliceCombination dimSliceRegionId = aggregate.getDimensionSliceId();
        ArrayList<SliceCombination> dimSlices = new ArrayList<SliceCombination>();
        if (dimSliceRegionId.getNumberOfCombinations() <= 1024.0) {
            dimSliceRegionId.first();
            while (!dimSliceRegionId.isEof()) {
                SliceCombination dimSliceId = new SliceCombination();
                dimSliceId.copy(dimSliceRegionId);
                dimSlices.add(dimSliceId);
                dimSliceRegionId.next();
            }
        } else {
            for (int i = 1; i <= 1000; ++i) {
                dimSliceRegionId.random(this.generator);
                SliceCombination dimSliceId = new SliceCombination();
                dimSliceId.copy(dimSliceRegionId);
                dimSlices.add(dimSliceId);
            }
        }
        SliceCombination hierSliceRegionId = this.aggregateAdvisor.getOptimizationRegion();
        for (SliceCombination dimSliceId : dimSlices) {
            SliceCombination sliceId = new SliceCombination();
            sliceId.copy(hierSliceRegionId);
            this.convertDimensionSliceToHierarchySlice(dimSliceId, hierSliceRegionId, sliceId);
            this.dimensionSlicesForModelCoverage.add(sliceId);
        }
    }

    private void setupForHierarchySliceCoverageMetric() {
        INFO_LOGGER.log(String.format("Setup for hierarchy slice coverage metric - generate %d random slices within region %s of cube %s", 1000, this.aggregateAdvisor.getOptimizationRegion().rangeToString(), this.cubeId.rangeToString()));
        for (int i = 1; i <= 1000; ++i) {
            SliceCombination sliceId = new SliceCombination();
            sliceId.copy(this.aggregateAdvisor.getOptimizationRegion());
            sliceId.random(this.generator);
            this.hierarchySlicesForModelCoverage.add(sliceId);
        }
    }

    private double estimateModelCoverage(List<SliceCombination> slices, List<Aggregate> aggregates) {
        int numSlicesCovered = 0;
        for (SliceCombination sliceId : slices) {
            if (!ModelBasedLowerSlicesStrategy.isSliceCovered(sliceId, aggregates) && !ModelBasedLowerSlicesStrategy.isSliceCovered(sliceId, this.existingDatabaseAggregates)) continue;
            ++numSlicesCovered;
        }
        double coverage = 100.0 * (double)numSlicesCovered / (double)slices.size();
        return coverage;
    }

    private static boolean isSliceCovered(SliceCombination aSliceId, List<Aggregate> aggregates) {
        for (Aggregate aggregate : aggregates) {
            if (!aggregate.getSliceId().isCovered(aSliceId)) continue;
            return true;
        }
        return false;
    }

    private static void eliminateDuplicateAggregates(List<Aggregate> aggregates) {
        ArrayList<Aggregate> uniqueAggregates = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            boolean aggregateAlreadyExists = false;
            for (Aggregate uniqueAggregate : uniqueAggregates) {
                if (!aggregate.isCovered(uniqueAggregate) || !uniqueAggregate.isCovered(aggregate)) continue;
                aggregateAlreadyExists = true;
                break;
            }
            if (aggregateAlreadyExists) continue;
            uniqueAggregates.add(aggregate);
        }
        aggregates.clear();
        aggregates.addAll(uniqueAggregates);
    }

    private void initializeRejectedAggregates() {
        List<Aggregate> rejectedAggregates = this.aggregateAdvisor.getRejectedAggregates();
        for (Aggregate aggregate : rejectedAggregates) {
            this.considerSlice(aggregate.getSliceId());
        }
    }

    private static class LowerAggregateComparatorByDescendingMatchedUpperAggregateCount
    implements Comparator<Aggregate> {
        private Map<Aggregate, List<Aggregate>> lowerAggregateToMatchedUpperAggregatesMap;

        LowerAggregateComparatorByDescendingMatchedUpperAggregateCount(Map<Aggregate, List<Aggregate>> theLowerAggregateToMatchedUpperAggregatesMap) {
            this.lowerAggregateToMatchedUpperAggregatesMap = theLowerAggregateToMatchedUpperAggregatesMap;
        }

        @Override
        public int compare(Aggregate lowerAggregate1, Aggregate lowerAggregate2) {
            int matchedUpperAggregateCount2;
            int matchedUpperAggregateCount1 = this.lowerAggregateToMatchedUpperAggregatesMap.get(lowerAggregate1).size();
            if (matchedUpperAggregateCount1 < (matchedUpperAggregateCount2 = this.lowerAggregateToMatchedUpperAggregatesMap.get(lowerAggregate2).size())) {
                return 1;
            }
            if (matchedUpperAggregateCount1 > matchedUpperAggregateCount2) {
                return -1;
            }
            return 0;
        }
    }
}

