/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.AggregateRecommendationStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import java.util.ArrayList;
import java.util.List;

public class UserDefinedAggregatesStrategy
extends AggregateRecommendationStrategy {
    public UserDefinedAggregatesStrategy(ROLAPMetaCube theMetaCube, AggregateAdvisor theAggregateAdvisor) {
        super(theMetaCube, theAggregateAdvisor);
    }

    @Override
    public void recommendAggregates(List<Aggregate> candidateAggregates) {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend aggregates based on user defined aggregates - begin"));
        ArrayList<Aggregate> userDefinedAggregates = new ArrayList<Aggregate>();
        List<Aggregate> userDefinedAggregatesFromUnitTest = this.aggregateAdvisor.getUnitTestParameters().getUserDefinedAggregates();
        List<Aggregate> userDefinedAggregatesFromModel = this.getUserDefinedAggregatesFromModel();
        if (!userDefinedAggregatesFromUnitTest.isEmpty()) {
            userDefinedAggregates.addAll(userDefinedAggregatesFromUnitTest);
        } else {
            userDefinedAggregates.addAll(userDefinedAggregatesFromModel);
        }
        for (Aggregate userDefinedAggregate : userDefinedAggregates) {
            userDefinedAggregate.setRecommendedBy(AggregateRecommendedByEnum.USER);
            long cardinality = this.aggregateAdvisor.getMaxSliceCardinality(userDefinedAggregate);
            userDefinedAggregate.setCardinality(cardinality);
        }
        INFO_LOGGER.log("\n\nUser defined in-memory aggregates - row count estimated using maximum cardinality:\n" + AdvisorTrace.formatAggregates(userDefinedAggregates));
        this.aggregateAdvisor.improveCardinalityEstimates(userDefinedAggregates, "UserDefinedAggregatesStrategy");
        INFO_LOGGER.log("\n\nUser defined in-memory aggregates - row count estimated using sampling for larger aggregates:\n" + AdvisorTrace.formatAggregates(userDefinedAggregates));
        for (Aggregate userDefinedAggregate : userDefinedAggregates) {
            long aggregateSize = this.aggregateAdvisor.estimateInMemoryAggregateSize(userDefinedAggregate);
            userDefinedAggregate.setEstimatedSize(aggregateSize);
        }
        candidateAggregates.addAll(userDefinedAggregates);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend aggregates based on user defined aggregates - end"));
    }

    List<Aggregate> getUserDefinedAggregatesFromModel() {
        ROLAPMetaAggregateCube[] metaAggregateCubes;
        ArrayList<Aggregate> userDefinedAggregatesFromModel = new ArrayList<Aggregate>();
        for (ROLAPMetaAggregateCube metaAggregateCube : metaAggregateCubes = this.metaCube.getUserDefinedInMemoryAggregates()) {
            ROLAPMetaAggregateDimensionRef[] dimensionRefs;
            ROLAPMetaAggregateMeasureRef[] measureRefs;
            Aggregate aggregate = new Aggregate(this.metaCube);
            aggregate.setAggregateAdvisor(this.aggregateAdvisor);
            for (ROLAPMetaAggregateMeasureRef measureRef : measureRefs = metaAggregateCube.getAggregateMeasureRefs()) {
                String measureName = measureRef.getName();
                ROLAPMetaMeasure measure = AdvisorUtils.getMetaMeasure(this.metaCube, measureName);
                if (measure != null) {
                    aggregate.addMeasure(measure);
                    continue;
                }
                INFO_LOGGER.log(String.format("Aggregate '%s' measure '%s' does not exist", metaAggregateCube.getName(), measureName));
            }
            for (ROLAPMetaAggregateDimensionRef dimRef : dimensionRefs = metaAggregateCube.getAggregateDimensionRefs()) {
                ROLAPMetaAggregateHierarchyRef[] hierarchyRefs;
                String dimName = dimRef.getName();
                for (ROLAPMetaAggregateHierarchyRef hierarchyRef : hierarchyRefs = dimRef.getAggregateHierarchyRefs()) {
                    String hierName = hierarchyRef.getName();
                    String levelName = hierarchyRef.getLowestAggregateLevelRef().getName();
                    aggregate.setLevel(dimName, hierName, levelName);
                }
            }
            aggregate.setName(metaAggregateCube.getName());
            userDefinedAggregatesFromModel.add(aggregate);
        }
        return userDefinedAggregatesFromModel;
    }
}

