/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AdvisorTrace;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.Aggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateAdvisor;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateRecommendedByEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.AggregateUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.HighPrecisionStopWatch;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.WorkloadSummary;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.WorkloadSummarizedMeasuresCollection;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.AggregateRecommendationStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.strategy.ConsolidateAggregatesStrategy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;

public class WorkloadBasedStrategy
extends AggregateRecommendationStrategy {
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#,##0.000s");
    private static final double THOUSAND = 1000.0;
    private static final double HUNDRED = 100.0;
    private long queryTimeWithoutAggregates = 0L;
    static final Comparator<RatedMeasure> DESCENDING_RATING_ORDER = new Comparator<RatedMeasure>(){

        @Override
        public int compare(RatedMeasure c1, RatedMeasure c2) {
            if (c1.getRating() > c2.getRating()) {
                return -1;
            }
            if (c1.getRating() < c2.getRating()) {
                return 1;
            }
            return 0;
        }
    };
    static final Comparator<Aggregate> DESCENDING_PRIORITY_ORDER = new Comparator<Aggregate>(){

        @Override
        public int compare(Aggregate c1, Aggregate c2) {
            if (c1.getWorkloadHitCount() < c2.getWorkloadHitCount()) {
                return 1;
            }
            if (c1.getWorkloadHitCount() > c2.getWorkloadHitCount()) {
                return -1;
            }
            if (c1.getWorkloadQueryExecutionTime() < c2.getWorkloadQueryExecutionTime()) {
                return 1;
            }
            if (c1.getWorkloadQueryExecutionTime() > c2.getWorkloadQueryExecutionTime()) {
                return -1;
            }
            return 0;
        }
    };

    public WorkloadBasedStrategy(ROLAPMetaCube theMetaCube, AggregateAdvisor theAggregateAdvisor) {
        super(theMetaCube, theAggregateAdvisor);
    }

    @Override
    public void recommendAggregates(List<Aggregate> candidateAggregates) {
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend aggregates based on the workload - begin"));
        HighPrecisionStopWatch stopWatch = new HighPrecisionStopWatch();
        stopWatch.start();
        List<Aggregate> sliceUsageCollection = this.getLogicalQueriesToOptimize();
        for (Aggregate sliceUsage : sliceUsageCollection) {
            Aggregate candidateAggregate = this.createCandidateAggregateForSlice(sliceUsage);
            if (!candidateAggregate.getMeasures().isEmpty()) {
                candidateAggregates.add(candidateAggregate);
                continue;
            }
            INFO_LOGGER.log(String.format("Aggregate %s has been excluded because it has no measures.", candidateAggregate.getName()));
        }
        ArrayList<Aggregate> acceptableAggregates = new ArrayList<Aggregate>();
        ArrayList<Aggregate> rejectedAggregates = new ArrayList<Aggregate>();
        this.aggregateAdvisor.determineAggregatesCardinalityAcceptability(candidateAggregates, acceptableAggregates, rejectedAggregates);
        INFO_LOGGER.log("\n\nCandidate aggregates - row count estimated using maximum cardinality:\n" + AdvisorTrace.formatAggregates(acceptableAggregates) + "\nAggregates rejected because cardinality too high:\n" + AdvisorTrace.formatAggregates(rejectedAggregates));
        ConsolidateAggregatesStrategy consolidateStrategy = new ConsolidateAggregatesStrategy(this.metaCube, this.aggregateAdvisor);
        consolidateStrategy.recommendAggregates(candidateAggregates);
        this.aggregateAdvisor.determineAggregatesCardinalityAcceptability(candidateAggregates, acceptableAggregates, rejectedAggregates);
        INFO_LOGGER.log("\n\nCandidate aggregates - row count estimated using maximum cardinality (consolidated):\n" + AdvisorTrace.formatAggregates(acceptableAggregates) + "\nAggregates rejected because cardinality too high: \n" + AdvisorTrace.formatAggregates(rejectedAggregates));
        this.aggregateAdvisor.saveRecommendations(candidateAggregates);
        this.aggregateAdvisor.setProgressValue(this.aggregateAdvisor.getProgessValue() + 100);
        this.aggregateAdvisor.improveCardinalityEstimates(candidateAggregates, "WorkloadBasedStrategy");
        consolidateStrategy.recommendAggregates(candidateAggregates);
        this.aggregateAdvisor.determineAggregatesCardinalityAcceptability(candidateAggregates, acceptableAggregates, rejectedAggregates);
        INFO_LOGGER.log("\n\nCandidate aggregates - row count estimated using sampling for larger aggregates:\n" + AdvisorTrace.formatAggregates(acceptableAggregates) + "\nAggregates rejected because cardinality too high:  \n" + AdvisorTrace.formatAggregates(rejectedAggregates));
        candidateAggregates.retainAll(acceptableAggregates);
        this.aggregateAdvisor.addRejectedAggregates(rejectedAggregates);
        WorkloadBasedStrategy.mergeAggregatesWithIdenticalLevels(candidateAggregates);
        this.aggregateAdvisor.saveRecommendations(candidateAggregates);
        this.aggregateAdvisor.setProgressValue(this.aggregateAdvisor.getProgessValue() + 100);
        List<Aggregate> queriedSlices = this.aggregateAdvisor.getSliceUsageAggregates();
        this.traceAggregateCoverage(queriedSlices, candidateAggregates);
        INFO_LOGGER.log(AdvisorTrace.formatQueryCoverage(queriedSlices, candidateAggregates));
        long elapsedTime = stopWatch.getElapsedTimeInMilliseconds();
        this.aggregateAdvisor.getMetrics().logEvent("WorkloadBasedStrategy", elapsedTime);
        INFO_LOGGER.log(AdvisorTrace.majorHeading("Recommend aggregates based on the workload - end"));
    }

    private static void mergeAggregatesWithIdenticalLevels(List<Aggregate> aggregates) {
        int beginCount = aggregates.size();
        ArrayList<Aggregate> replacementAggregates = new ArrayList<Aggregate>();
        while (!aggregates.isEmpty()) {
            Aggregate aggregate = aggregates.get(0);
            List<Aggregate> aggregatesWithSameLevels = AggregateUtils.getAggregatesWithSameLevels(aggregate, aggregates);
            List<Aggregate> userAggregates = AggregateUtils.getAggregatesRecommendedBy(aggregatesWithSameLevels, AggregateRecommendedByEnum.USER);
            if (aggregatesWithSameLevels.size() > 1 && userAggregates.size() > 0) {
                Aggregate userAggregate = userAggregates.get(0);
                String userAggregateName = userAggregate.getName();
                Aggregate mergedAggregate = userAggregate;
                for (Aggregate aggregateWithSameLevels : aggregatesWithSameLevels) {
                    mergedAggregate = new Aggregate(mergedAggregate, aggregateWithSameLevels);
                }
                mergedAggregate.setRecommendedBy(AggregateRecommendedByEnum.USER);
                mergedAggregate.setName(userAggregateName);
                replacementAggregates.add(mergedAggregate);
            } else {
                replacementAggregates.add(aggregate);
            }
            aggregates.removeAll(aggregatesWithSameLevels);
        }
        aggregates.addAll(replacementAggregates);
        int endCount = aggregates.size();
        INFO_LOGGER.log(String.format("Merged aggregates with identical levels.  Reduced from %d to %d aggregates.", beginCount, endCount));
    }

    private List<Aggregate> getLogicalQueriesToOptimize() {
        WorkloadSummary workloadSummary = this.aggregateAdvisor.getWorkloadSummary();
        List<Aggregate> sliceUsageCollection = workloadSummary.getCandidateCollection(this.metaCube);
        for (Aggregate candidateAggregate : sliceUsageCollection) {
            candidateAggregate.setName(candidateAggregate.generateDescriptiveName());
            candidateAggregate.setAggregateAdvisor(this.aggregateAdvisor);
        }
        this.traceWorkload(workloadSummary);
        sliceUsageCollection = this.selectSlicesWithinOptimizationRegion(sliceUsageCollection);
        ArrayList<Aggregate> emptyAggregateSet = new ArrayList<Aggregate>();
        this.queryTimeWithoutAggregates = AggregateUtils.estimateQueryTime(sliceUsageCollection, emptyAggregateSet);
        Collections.sort(sliceUsageCollection, DESCENDING_PRIORITY_ORDER);
        INFO_LOGGER.log("\n\nWorkload - slices referenced by queries - sorted by priority of optimizing:\n" + AdvisorTrace.sliceUsageToTraceString(sliceUsageCollection));
        List<Aggregate> sliceUsageAggregates = this.getSliceUsageAggregates(sliceUsageCollection);
        this.aggregateAdvisor.setSliceUsageAggregates(sliceUsageAggregates);
        List<Aggregate> prunedSliceUsageCollection = this.selectQueriesToOptimize(sliceUsageCollection);
        return prunedSliceUsageCollection;
    }

    private List<Aggregate> selectSlicesWithinOptimizationRegion(List<Aggregate> aggregates) {
        ArrayList<Aggregate> aggregatesInRegion = new ArrayList<Aggregate>();
        for (Aggregate aggregate : aggregates) {
            if (!this.aggregateAdvisor.getOptimizationRegion().isSliceWithinRegion(aggregate.getSliceId())) continue;
            aggregatesInRegion.add(aggregate);
        }
        return aggregatesInRegion;
    }

    private Aggregate createCandidateAggregateForSlice(Aggregate query) {
        ROLAPMetaDimension[] dimensions;
        Aggregate candidateAggregate = new Aggregate(this.metaCube);
        candidateAggregate.setAggregateAdvisor(this.aggregateAdvisor);
        candidateAggregate.setRecommendedBy(AggregateRecommendedByEnum.WORKLOAD);
        List<ROLAPMetaMeasure> measures = this.determineMeasures(query);
        candidateAggregate.addMeasures(measures);
        for (ROLAPMetaDimension dimension : dimensions = this.metaCube.getDimensions()) {
            ROLAPMetaHierarchy[] hierarchies;
            String dimensionName = dimension.getName();
            for (ROLAPMetaHierarchy hierarchy : hierarchies = this.metaCube.getHierarchies(dimension)) {
                String hierarchyName = hierarchy.getName();
                String levelName = query.getLevelName(dimensionName, hierarchyName);
                candidateAggregate.setLevel(dimensionName, hierarchyName, levelName);
            }
        }
        candidateAggregate.setName(candidateAggregate.generateDescriptiveName());
        long cardinality = this.aggregateAdvisor.getMaxSliceCardinality(candidateAggregate);
        candidateAggregate.setMaxCardinality(cardinality);
        candidateAggregate.setCardinality(cardinality);
        return candidateAggregate;
    }

    private List<ROLAPMetaMeasure> determineMeasures(Aggregate query) {
        List<ROLAPMetaMeasure> measures = new ArrayList<ROLAPMetaMeasure>();
        HashMap<String, WorkloadSummarizedMeasuresCollection.MeasureSummaryData> measureUsageCollection = query.getWorkloadMeasureSummaryData();
        for (ROLAPMetaMeasure measure : this.metaCube.getMeasures()) {
            if (!this.aggregateAdvisor.isMeasureSupported(measure)) continue;
            boolean measureUsed = false;
            WorkloadSummarizedMeasuresCollection.MeasureSummaryData measureUsage = measureUsageCollection.get(measure.getName());
            if (measureUsage != null && measureUsage.getHitCount() > 0) {
                measureUsed = true;
            }
            boolean includeMeasure = false;
            if (measureUsed) {
                includeMeasure = true;
            }
            if (this.aggregateAdvisor.getRequestParameters().getIncludeAllAdditiveMeasures() && measure.isVisible() && this.aggregateAdvisor.isMeasureAdditive(measure)) {
                includeMeasure = true;
            }
            if (this.aggregateAdvisor.getRequestParameters().isExcludeNonAdditiveMeasures() && !this.aggregateAdvisor.isMeasureAdditive(measure)) {
                includeMeasure = false;
            }
            if (!includeMeasure) continue;
            measures.add(measure);
        }
        measures = this.orderMeasuresToImprovePerformance(measures, query);
        return measures;
    }

    private List<ROLAPMetaMeasure> orderMeasuresToImprovePerformance(List<ROLAPMetaMeasure> measures, Aggregate query) {
        ArrayList<RatedMeasure> ratedMeasures = new ArrayList<RatedMeasure>();
        HashMap<String, WorkloadSummarizedMeasuresCollection.MeasureSummaryData> measureUsageCollection = query.getWorkloadMeasureSummaryData();
        for (ROLAPMetaMeasure measure : measures) {
            int hitCount = 0;
            WorkloadSummarizedMeasuresCollection.MeasureSummaryData measureUsage = measureUsageCollection.get(measure.getName());
            if (measureUsage != null) {
                hitCount = measureUsage.getHitCount();
            }
            RatedMeasure ratedMeasure = new RatedMeasure(measure);
            ratedMeasure.setRating(hitCount);
            ratedMeasures.add(ratedMeasure);
        }
        Collections.sort(ratedMeasures, DESCENDING_RATING_ORDER);
        ArrayList<ROLAPMetaMeasure> orderedMeasures = new ArrayList<ROLAPMetaMeasure>();
        for (RatedMeasure ratedMeasure : ratedMeasures) {
            orderedMeasures.add(ratedMeasure.getMeasure());
        }
        return orderedMeasures;
    }

    private List<Aggregate> selectQueriesToOptimize(List<Aggregate> sliceUsageCollection) {
        ArrayList<Aggregate> queriesToOptimize = new ArrayList<Aggregate>();
        for (Aggregate slice : sliceUsageCollection) {
            queriesToOptimize.add(slice);
            if (queriesToOptimize.size() < this.aggregateAdvisor.getRequestParameters().getMaxWorkloadQueriesToConsider()) continue;
            break;
        }
        INFO_LOGGER.log(String.format("Selected %d of %d queries to optimize.", queriesToOptimize.size(), sliceUsageCollection.size()));
        return queriesToOptimize;
    }

    private List<Aggregate> getSliceUsageAggregates(List<Aggregate> sliceUsageCollection) {
        ArrayList<Aggregate> sliceUsageAggregates = new ArrayList<Aggregate>();
        for (Aggregate querySlice : sliceUsageCollection) {
            Aggregate sliceUsageAggregate = querySlice.copy();
            HashMap<String, WorkloadSummarizedMeasuresCollection.MeasureSummaryData> measureUsageCollection = querySlice.getWorkloadMeasureSummaryData();
            for (ROLAPMetaMeasure measure : this.metaCube.getMeasures()) {
                WorkloadSummarizedMeasuresCollection.MeasureSummaryData measureUsage;
                if (!this.aggregateAdvisor.isMeasureSupported(measure) || (measureUsage = measureUsageCollection.get(measure.getName())) == null || measureUsage.getHitCount() <= 0) continue;
                sliceUsageAggregate.addMeasure(measure);
            }
            sliceUsageAggregates.add(sliceUsageAggregate);
        }
        return sliceUsageAggregates;
    }

    private void traceWorkload(WorkloadSummary workloadSummary) {
        INFO_LOGGER.log(this.formatWorkloadMeasureSummary(workloadSummary));
        List<Aggregate> sliceUsageCollection = workloadSummary.getCandidateCollection(this.metaCube);
        INFO_LOGGER.log(this.formatQuerySummary(sliceUsageCollection));
    }

    private String formatWorkloadMeasureSummary(WorkloadSummary workloadSummary) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nMeasure usage summary:\n");
        HashMap<String, WorkloadSummarizedMeasuresCollection.MeasureSummaryData> measureUsageCollection = workloadSummary.getMeasureSummaryData();
        for (ROLAPMetaMeasure measure : this.metaCube.getMeasures()) {
            WorkloadSummarizedMeasuresCollection.MeasureSummaryData measureUsage = measureUsageCollection.get(measure.getName());
            int count = 0;
            if (measureUsage != null) {
                count = measureUsage.getHitCount();
            }
            sb.append(String.format("%,15d %s  \n", count, measure.getName()));
        }
        return sb.toString();
    }

    private String formatQuerySummary(List<Aggregate> sliceUsageCollection) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\nQuery summary:\n\n");
        sb.append(String.format("%,d unique slices were queried.\n", sliceUsageCollection.size()));
        sb.append("For each slice the count of how often it was queried and how often each measure was used is shown.\n");
        for (Aggregate slice : sliceUsageCollection) {
            sb.append('\n');
            sb.append(slice.generateDescriptiveName() + '\n');
            sb.append(String.format("%,15d %s    \n", slice.getWorkloadHitCount(), "# of times slice was queried"));
            HashMap<String, WorkloadSummarizedMeasuresCollection.MeasureSummaryData> measureUsageCollection = slice.getWorkloadMeasureSummaryData();
            for (ROLAPMetaMeasure measure : this.metaCube.getMeasures()) {
                int count;
                WorkloadSummarizedMeasuresCollection.MeasureSummaryData measureUsage = measureUsageCollection.get(measure.getName());
                if (measureUsage == null || (count = measureUsage.getHitCount()) <= 0) continue;
                sb.append(String.format("%,15d %s   \n", count, measure.getName()));
            }
        }
        return sb.toString();
    }

    private void traceAggregateCoverage(List<Aggregate> sliceUsageCollection, List<Aggregate> aggregates) {
        long queryTimeNotCoveredByAggregates = AggregateUtils.estimateQueryTime(sliceUsageCollection, aggregates);
        long queryTimeCoveredByAggregates = this.queryTimeWithoutAggregates - queryTimeNotCoveredByAggregates;
        double queryTimeCoveredByAggregatesPct = 100.0 * (double)queryTimeCoveredByAggregates / (double)this.queryTimeWithoutAggregates;
        INFO_LOGGER.log(String.format("%d aggregates cover %.1f percent of the workload query time \n", aggregates.size(), queryTimeCoveredByAggregatesPct));
        StringBuilder sb = new StringBuilder();
        sb.append("\nAggregate coverage (potential number of logical query slices and number of queries): \n");
        sb.append(String.format("%15s  %10s  %10s  %s  \n", "Time", "Slices", "Queries", "Aggregate slice name"));
        for (Aggregate aggregate : aggregates) {
            long totalSlicesCovered = 0L;
            long totalQueryCount = 0L;
            long totalExecutionTime = 0L;
            for (Aggregate querySlice : sliceUsageCollection) {
                boolean covered = aggregate.isCovered(querySlice);
                if (!covered) continue;
                ++totalSlicesCovered;
                totalQueryCount += (long)querySlice.getWorkloadHitCount();
                totalExecutionTime += querySlice.getWorkloadQueryExecutionTime();
            }
            sb.append(String.format("%15s  %,10d  %,10d  %s  \n", TIME_FORMAT.format((double)totalExecutionTime / 1000.0), totalSlicesCovered, totalQueryCount, aggregate.getName()));
        }
        INFO_LOGGER.log(sb.toString());
    }

    private class RatedMeasure {
        private ROLAPMetaMeasure measure;
        private long rating;

        RatedMeasure(ROLAPMetaMeasure aMeasure) {
            this.measure = aMeasure;
        }

        public ROLAPMetaMeasure getMeasure() {
            return this.measure;
        }

        public long getRating() {
            return this.rating;
        }

        public void setRating(long aRating) {
            this.rating = aRating;
        }
    }
}

