/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.IROLAPCacheFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.util.IReleasable;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ROLAPCacheManager<T extends ROLAPCacheBase>
implements IReleasable {
    private IROLAPCacheFactory<T> mCacheFactory;
    private final ConcurrentLinkedQueue<T> mCacheRevisions = new ConcurrentLinkedQueue();
    private T mCurrentRevision = null;
    private ROLAPCacheBase mParent;

    public ROLAPCacheManager(IROLAPCacheFactory<T> cacheFactory) {
        this.mCacheFactory = cacheFactory;
    }

    public ROLAPCacheManager(IROLAPCacheFactory<T> cacheFactory, ROLAPCacheBase parent) {
        this(cacheFactory);
        this.mParent = parent;
    }

    public T getCurrentRevision() {
        return this.mCurrentRevision;
    }

    public T newRevision() {
        return this.mCacheFactory.create(this.mParent);
    }

    public boolean createAllowed() {
        return this.mCacheFactory.createAllowed();
    }

    public void setNewRevision(T newRev) {
        T oldRev = this.mCurrentRevision;
        this.mCurrentRevision = newRev;
        if (oldRev != null) {
            if (((ROLAPCacheBase)oldRev).getReservationCount() == 0 && ((ROLAPCacheBase)oldRev).getSoftReservationCount() == 0) {
                oldRev.release();
            } else {
                this.mCacheRevisions.add(oldRev);
            }
        }
    }

    public T reserve(T suggestedRevision) {
        if (this.mCurrentRevision == suggestedRevision) {
            ((ROLAPCacheBase)this.mCurrentRevision).reserve();
            return this.mCurrentRevision;
        }
        for (ROLAPCacheBase rev : this.mCacheRevisions) {
            if (rev != suggestedRevision) continue;
            rev.reserve();
            return (T)rev;
        }
        ((ROLAPCacheBase)this.mCurrentRevision).reserve();
        return this.mCurrentRevision;
    }

    public void unreserve(T cache) {
        if (this.mCurrentRevision != cache && !this.mCacheRevisions.contains(cache)) {
            throw new IllegalArgumentException("The cache was not registered with the manager.");
        }
        if (((ROLAPCacheBase)cache).unreserve() == 0 && this.mCurrentRevision != cache && ((ROLAPCacheBase)cache).getSoftReservationCount() == 0) {
            this.mCacheRevisions.remove(cache);
            cache.release();
        }
    }

    @Override
    public void release() {
        if (this.mCurrentRevision != null) {
            this.mCurrentRevision.release();
            this.mCurrentRevision = null;
        }
        for (ROLAPCacheBase cache : this.mCacheRevisions) {
            cache.release();
        }
        this.mCacheRevisions.clear();
    }

    public List<T> getCacheRevisions() {
        LinkedList<Object> list = new LinkedList<Object>();
        if (this.mCurrentRevision != null) {
            list.add(this.mCurrentRevision);
        }
        for (ROLAPCacheBase cache : this.mCacheRevisions) {
            list.add(cache);
        }
        return list;
    }

    public int getCacheNo() {
        int count = 0;
        if (this.mCurrentRevision != null) {
            ++count;
        }
        for (ROLAPCacheBase cache : this.mCacheRevisions) {
            if (cache.getReservationCount() <= 0) continue;
            ++count;
        }
        return count;
    }

    public boolean compress() {
        for (ROLAPCacheBase cache : this.mCacheRevisions) {
            if (cache.getReservationCount() != 0) continue;
            this.mCacheRevisions.remove(cache);
            cache.release();
            return true;
        }
        return false;
    }

    public void maintain() {
        for (ROLAPCacheBase cache : this.mCacheRevisions) {
            if (cache.getReservationCount() != 0 || cache.getSoftReservationCount() != 0) continue;
            this.mCacheRevisions.remove(cache);
            cache.release();
        }
    }
}

