/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPMemberCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSecurityCache;
import com.cognos.xqe.util.IReleasable;
import java.lang.ref.WeakReference;

public class ROLAPCubeSoftReservation
implements IReleasable {
    WeakReference<ROLAPDataCache> mDataCache;
    WeakReference<ROLAPMemberCache> mMemberCache;
    WeakReference<ROLAPSecurityCache> mSecurityCache;

    public ROLAPCubeSoftReservation(ROLAPCubeReservation res) {
        if (res.getDataCache() != null) {
            this.mDataCache = new WeakReference<ROLAPDataCache>(res.getDataCache());
            res.getDataCache().incSoftRefCount();
        }
        if (res.getMemberCache() != null) {
            this.mMemberCache = new WeakReference<ROLAPMemberCache>(res.getMemberCache());
            res.getMemberCache().incSoftRefCount();
        }
        if (res.getSecurityCache() != null) {
            this.mSecurityCache = new WeakReference<ROLAPSecurityCache>(res.getSecurityCache());
            res.getSecurityCache().incSoftRefCount();
        }
    }

    public void updateROLAPCubeSoftReservation(ROLAPCubeReservation res) {
        if (res.getDataCache() != null && res.getDataCache() != this.getDataCache()) {
            this.mDataCache = new WeakReference<ROLAPDataCache>(res.getDataCache());
            res.getDataCache().incSoftRefCount();
        }
        if (res.getMemberCache() != null && res.getMemberCache() != this.getMemberCache()) {
            this.mMemberCache = new WeakReference<ROLAPMemberCache>(res.getMemberCache());
            res.getMemberCache().incSoftRefCount();
        }
        if (res.getSecurityCache() != null && res.getSecurityCache() != this.getSecurityCache()) {
            this.mSecurityCache = new WeakReference<ROLAPSecurityCache>(res.getSecurityCache());
            res.getSecurityCache().incSoftRefCount();
        }
    }

    public ROLAPDataCache getDataCache() {
        if (this.mDataCache == null) {
            return null;
        }
        return (ROLAPDataCache)this.mDataCache.get();
    }

    public ROLAPMemberCache getMemberCache() {
        if (this.mMemberCache == null) {
            return null;
        }
        return (ROLAPMemberCache)this.mMemberCache.get();
    }

    public ROLAPSecurityCache getSecurityCache() {
        if (this.mSecurityCache == null) {
            return null;
        }
        return (ROLAPSecurityCache)this.mSecurityCache.get();
    }

    @Override
    public void release() {
        if (this.mDataCache != null) {
            ROLAPDataCache dataCache = (ROLAPDataCache)this.mDataCache.get();
            if (dataCache != null) {
                dataCache.decSoftRefCount();
            }
            this.mDataCache.clear();
            this.mDataCache = null;
        }
        if (this.mMemberCache != null) {
            ROLAPMemberCache memberCache = (ROLAPMemberCache)this.mMemberCache.get();
            if (memberCache != null) {
                memberCache.decSoftRefCount();
            }
            this.mMemberCache.clear();
            this.mMemberCache = null;
        }
        if (this.mSecurityCache != null) {
            ROLAPSecurityCache securityCache = (ROLAPSecurityCache)this.mSecurityCache.get();
            if (securityCache != null) {
                securityCache.decSoftRefCount();
            }
            this.mSecurityCache.clear();
            this.mSecurityCache = null;
        }
    }

    public boolean matches(ROLAPCubeReservation res) {
        return this.getMemberCache() == res.getMemberCache() && this.getDataCache() == res.getDataCache() && this.getSecurityCache() == res.getSecurityCache();
    }
}

