/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.CacheEngineFactory;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.INamedSet;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPNamedSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchyMemberLoader;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeAction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCacheFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSecurityCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSecurityCacheFactory;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeModel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPModelValidationException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.ROLAPMemoryWalker;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.trace.TraceLogManager;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.FileUtil;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.SequencedHashMap;

public class ROLAPMemberCache
extends ROLAPCacheBase {
    private static final long ONE_THOUSAND_TWENTY_FOUR = 1024L;
    public static final String[] INTERNAL_DIMENSION_NAMES = new String[]{"XQE_VD1", "XQE_VD2"};
    private ROLAPCacheEngine mMetadataStorage = null;
    protected ROLAPCacheManager<ROLAPDataCache> mDataCacheManager;
    protected OrderedMap<IDimension> mDimensions = new OrderedMap();
    private String mCacheFolderName = null;
    protected ROLAPCacheManager<ROLAPSecurityCache> mSecurityCacheManager;
    protected SequencedHashMap mUniqueNameToCalculatedMember;
    protected SequencedHashMap mUniqueNameToNamedSet;
    private final ConcurrentHashMap<IHierarchy, Set<String>> hierarchyInvalidCalculatedMembersMap = new ConcurrentHashMap();

    public ROLAPMemberCache(ROLAPCube cube) {
        super(cube);
        this.mDataCacheManager = new ROLAPCacheManager<ROLAPDataCache>(new ROLAPDataCacheFactory(cube), this);
        this.mSecurityCacheManager = new ROLAPCacheManager<ROLAPSecurityCache>(new ROLAPSecurityCacheFactory(cube), this);
        this.mUniqueNameToCalculatedMember = new SequencedHashMap();
        this.mUniqueNameToNamedSet = new SequencedHashMap();
        ROLAPLog.log("ROLAPCubes.Management", String.format("Member cache %d was created.", this.getID()));
    }

    protected void initializeCacheImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(ROLAPCubeAction cubeAction, SecurityManagerInterface currentSecurityManager) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        ROLAPCube cube = this.getCube();
        ROLAPContext context = ROLAPContext.get(execEnv);
        ROLAPCubeReservation reservation = new ROLAPCubeReservation(cube, this, null, null);
        context.addReservation(reservation, execEnv);
        ArrayList<ROLAPCubeReservation> missingRes = new ArrayList<ROLAPCubeReservation>();
        context.reserveMissingLeaves(cube, missingRes);
        boolean needToRemoveCurrentCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
        try {
            long loadStartTime = System.nanoTime();
            this.establishMetadataConnection(execEnv, cube);
            this.initializeCacheConfiguration();
            this.initializeCacheImpl();
            ROLAPDataCache dataCache = this.getDataCacheManager().newRevision();
            reservation.setDataCache(dataCache);
            dataCache.initialize();
            this.getDataCacheManager().setNewRevision(dataCache);
            ROLAPSecurityCache securityCache = this.getSecurityCacheManager().newRevision();
            reservation.setSecurityCache(securityCache);
            securityCache.initialize(cubeAction, currentSecurityManager);
            this.getSecurityCacheManager().setNewRevision(securityCache);
            ROLAPLog.log("ROLAPCubes", "Total number of members in cache: " + this.getCachedMemberCount() + ". ");
            cube.getMetrics().recordMetadataLoadTime(TimeUnit.MILLISECONDS.convert(System.nanoTime() - loadStartTime, TimeUnit.NANOSECONDS));
        }
        finally {
            context.unreserveMissingLeaves(missingRes);
            context.removeReservation(reservation);
            ROLAPContext.removeCurrentCubeName(needToRemoveCurrentCubeName);
        }
    }

    private void processDefaultMeasure(ROLAPHierarchy hierarchy) {
        ROLAPMetaCube metaCube = this.getCube().getModelCube();
        String defaultMeasureName = metaCube.getDefaultMeasureName();
        IMember defaultMeasure = null;
        if (defaultMeasureName != null) {
            String errorMessage;
            defaultMeasure = this.getCube().findROLAPMember(defaultMeasureName);
            if (defaultMeasure == null) {
                errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_UnableToAssignDefaultMember, XQEMessages.getCurrProductLocale(), defaultMeasureName, hierarchy.getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL));
            } else if (!((ROLAPMeasure)defaultMeasure).isVisible()) {
                errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_UnableToAssignInvisibleDefaultMeasure, XQEMessages.getCurrProductLocale(), defaultMeasureName, this.getCube().getName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL));
                defaultMeasure = null;
            }
        }
        if (defaultMeasure == null) {
            List<IMember> measures = hierarchy.getLevel(0).getMembers();
            Iterator<IMember> measuresIterator = measures.iterator();
            while (defaultMeasure == null && measuresIterator.hasNext()) {
                ROLAPMeasure measure = (ROLAPMeasure)measuresIterator.next();
                if (!measure.isVisible()) continue;
                defaultMeasure = measure;
            }
        }
        if (defaultMeasure == null) {
            throw new ROLAPModelValidationException(XQEMessageKeys.ROL_NoVisibleMeasuresInCube, this.getCube().getName());
        }
        hierarchy.setDefaultMember(defaultMeasure);
    }

    private void processDefaultMember(ROLAPHierarchy hierarchy) throws Exception {
        if (hierarchy.isMeasure()) {
            this.processDefaultMeasure(hierarchy);
            return;
        }
        String defaultMemberName = null;
        ROLAPMetaHierarchy metaHierarchy = hierarchy.getMetaHierarchy();
        defaultMemberName = metaHierarchy.getDefaultMemberName();
        if (defaultMemberName != null) {
            IMember defaultMember = this.getCube().findROLAPMember(defaultMemberName);
            hierarchy.setDefaultMember(defaultMember);
            if (defaultMember == null) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_UnableToAssignDefaultMember, XQEMessages.getCurrProductLocale(), defaultMemberName, hierarchy.getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL));
            }
        }
    }

    protected void loadBaseCubeHierarchies(ROLAPCubeReservation reservation) {
        if (this.getDimensionCount() == 0) {
            return;
        }
        ROLAPMemoryWalker.ROLAPMemoryWalkerState state = ROLAPMemoryWalker.initMemoryWalker(reservation.getCube());
        LinkedList<Callable<Void>> hierLoadTasks = new LinkedList<Callable<Void>>();
        for (IDimension dimension : this.mDimensions) {
            if (dimension.getType() == DimensionTypeEnum.INTERNAL) continue;
            this.createHierarchyLoadTasks(hierLoadTasks, dimension, reservation);
        }
        ExecutorService execService = ROLAPCubeManager.getInstance().createHierarchyLoadExecutorService(hierLoadTasks.size(), this.getCube().getConfigMaxHierarchyLoadThreads());
        try {
            List<Future<Void>> futures = null;
            try {
                futures = execService.invokeAll(hierLoadTasks);
            }
            catch (InterruptedException ex) {
                throw new OperationCanceledException();
            }
            RuntimeException hierarchyLoadException = null;
            for (Future<Void> f : futures) {
                try {
                    f.get();
                }
                catch (InterruptedException ex) {
                    if (hierarchyLoadException != null) continue;
                    hierarchyLoadException = new OperationCanceledException();
                }
                catch (CancellationException ex) {
                    if (hierarchyLoadException != null) continue;
                    hierarchyLoadException = new OperationCanceledException();
                }
                catch (ExecutionException ex) {
                    if (hierarchyLoadException != null) continue;
                    Throwable cause = ex.getCause();
                    cause.printStackTrace(XQEDebugLog.err);
                    hierarchyLoadException = XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, cause);
                }
                catch (OperationCanceledException cancelException) {
                    if (hierarchyLoadException != null) continue;
                    hierarchyLoadException = cancelException;
                }
            }
            if (hierarchyLoadException != null) {
                throw hierarchyLoadException;
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
        finally {
            execService.shutdownNow();
        }
        for (IDimension dimension : this.mDimensions) {
            if (dimension instanceof ROLAPDimension) {
                ((ROLAPDimension)dimension).clearStringCache();
            }
            if (dimension.getType() == DimensionTypeEnum.INTERNAL) continue;
            long cardinality = ((ROLAPDimension)dimension).getROLAPCardinality();
            ((Dimension)dimension).setCardinality((int)cardinality);
            List<IHierarchy> hierarchies = dimension.getHierarchies();
            for (IHierarchy h : hierarchies) {
                ROLAPHierarchy hierarchy = (ROLAPHierarchy)h;
                try {
                    this.processDefaultMember(hierarchy);
                }
                catch (Exception e) {
                    throw XQERuntimeException.wrap(e);
                }
            }
        }
        ROLAPMemoryWalker.analyzeSizes(reservation.getCube(), state);
    }

    public ROLAPCacheManager<ROLAPDataCache> getDataCacheManager() {
        this.assertValid();
        return this.mDataCacheManager;
    }

    public ROLAPCacheManager<ROLAPSecurityCache> getSecurityCacheManager() {
        this.assertValid();
        return this.mSecurityCacheManager;
    }

    public int getCachedMemberCount() {
        int memberCount = this.mMetadataStorage.getCachedMemberCount();
        for (IDimension d : this.mDimensions) {
            if (!d.isShareable()) continue;
            memberCount += ((ShareableROLAPDimension)d).getMetadataStorage().getCachedMemberCount();
        }
        return memberCount;
    }

    public IDimension getDimension(String dimName) {
        this.assertValid();
        return this.mDimensions.get(dimName);
    }

    public IDimension getDimension(int index) {
        this.assertValid();
        return this.mDimensions.get(index);
    }

    public List<IDimension> getDimensions() {
        this.assertValid();
        return this.mDimensions.toArrayList();
    }

    public Object[] getDimensionsToArray(Object[] array) {
        this.assertValid();
        return this.mDimensions.toArray(array);
    }

    public int getDimensionIndex(IDimension dim) {
        this.assertValid();
        return this.mDimensions.indexOf(dim);
    }

    public int getDimensionCount() {
        this.assertValid();
        return this.mDimensions.size();
    }

    public void addDimension(IDimension dim) {
        this.assertValid();
        this.mDimensions.put(dim);
    }

    private static String getCubeFolderName(String cube) {
        String cacheDir = ROLAPCubeManager.getInstance().getConfigMemberCacheFolder();
        if (cacheDir == null || cacheDir.length() == 0) {
            return null;
        }
        return cacheDir + File.separator + TraceLogManager.escapeName(cube);
    }

    protected void initializeCacheConfiguration() {
        ROLAPCacheEngine memcache = null;
        if (this.getCube().getConfigIsEnableDynamicMemberCaching()) {
            int maxMembers = this.getCube().getConfigMemberCacheLimit();
            boolean replace = true;
            String cubeFolderName = ROLAPMemberCache.getCubeFolderName(this.getCube().getName());
            if (cubeFolderName == null || cubeFolderName.length() == 0) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CacheDirUnspecifiedException, this.getCube().getName());
            }
            long timestamp = System.currentTimeMillis();
            this.mCacheFolderName = cubeFolderName + File.separator + timestamp;
            File f = new File(this.mCacheFolderName);
            if (!f.exists() && !f.mkdirs()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_CacheDirCreateException, this.mCacheFolderName);
            }
            String fn = "[" + FileUtil.makeJavaIdentifier(this.getCube().getCatalogName()) + "].[" + FileUtil.makeJavaIdentifier(this.getCube().getName()) + "]_" + timestamp + "_cache";
            TraceContext traceContext = TraceContext.enter();
            traceContext.addAttribute("rolapCube", this.getCube().getName());
            try {
                memcache = new ROLAPCacheEngine(CacheEngineFactory.createDynamicCache(maxMembers, fn, this.mCacheFolderName, replace));
                ROLAPLog.log("ROLAPCubes.Loader", String.format("Created dynamic member cache with maximum number of members = %1$s in directory %2$s.", maxMembers, this.mCacheFolderName));
            }
            catch (CacheException e) {
                String folder = this.mCacheFolderName;
                if (e.getFilename() != null && e.getFilename().length() > 0) {
                    File cacheFile = new File(e.getFilename());
                    folder = cacheFile.isDirectory() ? e.getFilename() : cacheFile.getParent();
                }
                throw new XQERuntimeException(XQEMessageKeys.ROL_CacheDirCreateException, (Throwable)e, folder);
            }
            finally {
                traceContext.exit();
            }
        } else {
            memcache = new ROLAPCacheEngine(CacheEngineFactory.createStaticCache());
            TraceContext traceContext = TraceContext.enter();
            traceContext.addAttribute("rolapCube", this.getCube().getName());
            ROLAPLog.log("ROLAPCubes.Loader", "Created static member cache.");
            traceContext.exit();
        }
        this.setMetadataStorage(memcache);
    }

    public ROLAPCacheEngine getMetadataStorage() {
        this.assertValid();
        return this.mMetadataStorage;
    }

    public void setMetadataStorage(ICacheEngine cacheEngine) {
        this.mMetadataStorage = (ROLAPCacheEngine)cacheEngine;
    }

    @Override
    public void release() {
        try {
            if (this.mDimensions != null) {
                this.mDimensions.clear();
                this.mDimensions = null;
            }
            if (this.mUniqueNameToCalculatedMember != null) {
                this.mUniqueNameToCalculatedMember.clear();
                this.mUniqueNameToCalculatedMember = null;
            }
            if (this.mUniqueNameToNamedSet != null) {
                this.mUniqueNameToNamedSet.clear();
                this.mUniqueNameToNamedSet = null;
            }
            if (this.mSecurityCacheManager != null) {
                this.mSecurityCacheManager.release();
                this.mSecurityCacheManager = null;
            }
            if (this.mDataCacheManager != null) {
                this.mDataCacheManager.release();
                this.mDataCacheManager = null;
            }
            if (this.mMetadataStorage != null) {
                try {
                    this.mMetadataStorage.close();
                }
                catch (CacheException cacheException) {
                    // empty catch block
                }
                this.mMetadataStorage = null;
            }
            if (this.mCacheFolderName != null) {
                ROLAPMemberCache.deleteFolder(this.mCacheFolderName);
            }
        }
        finally {
            this.getCube().onMemberCacheReleased(this.getID());
        }
    }

    public static void deleteCacheFolder(String cube) {
        String folder = ROLAPMemberCache.getCubeFolderName(cube);
        if (folder != null) {
            ROLAPMemberCache.deleteFolder(folder);
        }
    }

    private static void deleteFolder(String folder) {
        File[] files;
        File fdir = new File(folder);
        if (!fdir.exists()) {
            return;
        }
        if (!fdir.canWrite()) {
            return;
        }
        for (File file : files = fdir.listFiles()) {
            if (file.isDirectory()) {
                ROLAPMemberCache.deleteFolder(file.getPath());
                continue;
            }
            file.delete();
        }
        fdir.delete();
    }

    protected void establishMetadataConnection(ExecutionEnvironment env, ROLAPCube cube) {
        if (cube.getConnection() != null) {
            return;
        }
        MetadataConnection metadataConnection = null;
        ROLAPMetaCubeModel cubeModel = cube.getSchema().getCommonCubeModel();
        String modelPath = null;
        if (cubeModel instanceof ROLAPMetaCubeModel) {
            modelPath = cubeModel.getMetaCubeModel().getModelPath();
        }
        if (modelPath != null) {
            metadataConnection = MetadataService.getInstance().getConnection("MFW4J", modelPath, env, true);
        }
        if (metadataConnection != null) {
            cube.setConnection(metadataConnection);
        }
    }

    private void createHierarchyLoadTasks(List<Callable<Void>> taskList, IDimension dimension, ROLAPCubeReservation reservation) {
        boolean primeLevels = ROLAPMemberCache.isLevelMemberPrimingEnabled();
        int taskIndex = 1;
        for (IHierarchy hierarchy : dimension.getHierarchies()) {
            Callable<Void> task = new HierarchyLoaderTask(hierarchy, reservation, primeLevels);
            task = ROLAPCallable.decorateServerTask(task, reservation.getCube(), task.getZipiAction(), UniqueNameGenerator.join(reservation.getCube().getUniqueName(), ((HierarchyLoaderTask)task).mHierarchy.getUniqueName()), taskIndex++);
            taskList.add(task);
        }
        if (dimension.isShareable()) {
            ((ShareableROLAPDimension)dimension).initCountDownLatch(reservation.getCube().getName(), dimension.getHierarchyCount());
        }
    }

    public int getDataCacheNo() {
        if (this.mDataCacheManager == null) {
            return 0;
        }
        return this.mDataCacheManager.getCacheNo();
    }

    public int getSecurityCacheNo() {
        if (this.mSecurityCacheManager == null) {
            return 0;
        }
        return this.mSecurityCacheManager.getCacheNo();
    }

    public SequencedHashMap getCalculatedMembers() {
        this.assertValid();
        return new SequencedHashMap((Map)this.mUniqueNameToCalculatedMember);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCalculatedMember(CalculatedMember cm) {
        this.assertValid();
        SequencedHashMap sequencedHashMap = this.mUniqueNameToCalculatedMember;
        synchronized (sequencedHashMap) {
            this.mUniqueNameToCalculatedMember.put((Object)cm.getUniqueName(), (Object)cm);
        }
    }

    public void removeCalculatedMembers(List<ROLAPCalculatedMember> calcsToRemove) {
        this.assertValid();
        if (calcsToRemove == null) {
            return;
        }
        for (ROLAPCalculatedMember m : calcsToRemove) {
            this.mUniqueNameToCalculatedMember.remove((Object)m.getUniqueName());
        }
    }

    public CalculatedMember getCalculatedMember(String memberUniqueName) {
        this.assertValid();
        CalculatedMember result = null;
        Iterator it = this.mUniqueNameToCalculatedMember.keySet().iterator();
        while (it.hasNext()) {
            CalculatedMember calcMem = (CalculatedMember)this.mUniqueNameToCalculatedMember.get(it.next());
            if (!calcMem.getUniqueName().equals(memberUniqueName)) continue;
            result = calcMem;
        }
        return result;
    }

    public ArrayList<CalculatedMember> getCalculations(IDimension d) {
        this.assertValid();
        ArrayList<CalculatedMember> result = new ArrayList<CalculatedMember>();
        Iterator it = this.mUniqueNameToCalculatedMember.keySet().iterator();
        while (it.hasNext()) {
            CalculatedMember calcMem = (CalculatedMember)this.mUniqueNameToCalculatedMember.get(it.next());
            if (calcMem.getDimension() != d) continue;
            result.add(calcMem);
        }
        return result;
    }

    public ArrayList<CalculatedMember> getCalculations(ILevel l) {
        this.assertValid();
        ArrayList<CalculatedMember> result = new ArrayList<CalculatedMember>();
        Iterator it = this.mUniqueNameToCalculatedMember.keySet().iterator();
        while (it.hasNext()) {
            CalculatedMember calcMem = (CalculatedMember)this.mUniqueNameToCalculatedMember.get(it.next());
            if (calcMem.getLevel() != l) continue;
            result.add(calcMem);
        }
        return result;
    }

    public ArrayList<CalculatedMember> getCalculations(IMember parentMember) {
        this.assertValid();
        ArrayList<CalculatedMember> result = new ArrayList<CalculatedMember>();
        Iterator it = this.mUniqueNameToCalculatedMember.keySet().iterator();
        while (it.hasNext()) {
            CalculatedMember calcMem = (CalculatedMember)this.mUniqueNameToCalculatedMember.get(it.next());
            if (calcMem.getParent() != parentMember) continue;
            result.add(calcMem);
        }
        return result;
    }

    public void addInvalidCalculatedMember(IHierarchy hierarchy, String calculatedMemberName) {
        this.assertValid();
        Set<String> invalidCalculatedMembers = this.hierarchyInvalidCalculatedMembersMap.get(hierarchy);
        if (invalidCalculatedMembers == null) {
            invalidCalculatedMembers = new HashSet<String>();
            this.hierarchyInvalidCalculatedMembersMap.put(hierarchy, invalidCalculatedMembers);
        }
        invalidCalculatedMembers.add(calculatedMemberName);
    }

    public Set<String> getInvalidCalculatedMembers(IHierarchy hierarchy) {
        this.assertValid();
        return this.hierarchyInvalidCalculatedMembersMap.get(hierarchy);
    }

    private static boolean isLevelMemberPrimingEnabled() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty("rolap.hierarchyLoader.primeLevelMembers[@enabled]", true);
    }

    public SequencedHashMap getNamedSets() {
        this.assertValid();
        return new SequencedHashMap((Map)this.mUniqueNameToNamedSet);
    }

    public void addNamedSet(INamedSet ns) {
        this.assertValid();
        if (!this.containsNamedSet(ns)) {
            this.mUniqueNameToNamedSet.put((Object)ns.getUniqueName(), (Object)ns);
        }
    }

    public boolean containsNamedSet(INamedSet ns) {
        this.assertValid();
        return this.mUniqueNameToNamedSet.containsKey((Object)ns.getUniqueName());
    }

    public void removeNamedSets(List<IROLAPNamedSet> namedSetsToRemove) {
        this.assertValid();
        if (namedSetsToRemove == null) {
            return;
        }
        for (IROLAPNamedSet namedSet : namedSetsToRemove) {
            this.mUniqueNameToNamedSet.remove((Object)namedSet.getUniqueName());
        }
    }

    private final class HierarchyLoaderTask
    extends ROLAPCallable<Void> {
        private static final String TASK_DESCRIPTION = "Dynamic Cube Hierarchy Load: ";
        private final IHierarchy mHierarchy;
        private final ROLAPCubeReservation parentReservation;
        private final boolean mPrimeLevelMembers;

        HierarchyLoaderTask(IHierarchy hierarchy, ROLAPCubeReservation reservation, boolean primeLevelMembers) {
            super(reservation.getCube());
            this.mHierarchy = hierarchy;
            this.parentReservation = reservation;
            this.mPrimeLevelMembers = primeLevelMembers;
            this.mZipiAction = "DCHierarchyLoad";
        }

        @Override
        public Void callImpl() throws Exception {
            ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            CountDownLatch sharedHierLoadLatch = null;
            try {
                sharedHierLoadLatch = this.getOrWaitSharedHierLoadCountDownLatch();
                this.loadHierarchy(this.mHierarchy, execEnv);
            }
            finally {
                if (sharedHierLoadLatch != null) {
                    sharedHierLoadLatch.countDown();
                }
            }
            return null;
        }

        private CountDownLatch getOrWaitSharedHierLoadCountDownLatch() {
            CountDownLatch latch = null;
            if (this.mHierarchy.getDimension().isShareable()) {
                ShareableROLAPDimension dim = (ShareableROLAPDimension)this.mHierarchy.getDimension();
                latch = dim.getHierarchyLoadCountDownLatch();
                if (!dim.isCubeLoadingHierarchies(this.mCube.getName())) {
                    try {
                        latch.await();
                    }
                    catch (InterruptedException ie) {
                        throw new OperationCanceledException();
                    }
                }
            }
            return latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void loadHierarchy(IHierarchy hierarchy, ExecutionEnvironment execEnv) throws Exception {
            TraceContext traceContext = TraceContext.enter();
            String dimName = hierarchy.getDimension().getName();
            String hierName = hierarchy.getName();
            traceContext.addAttribute("rolapDimension", dimName);
            traceContext.addAttribute("rolapHierarchy", hierName);
            ROLAPCube cube = ROLAPMemberCache.this.getCube();
            boolean registered = false;
            boolean needToRemoveCubeName = false;
            try {
                block15: {
                    needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
                    registered = cube.registerCurrentThread(false);
                    ROLAPLog.log("ROLAPCubes.Loader", "Hierarchy load began.");
                    ROLAPContext context = ROLAPContext.get();
                    context.addReservation(this.parentReservation, execEnv);
                    try {
                        ROLAPCacheEngine memberStorage;
                        ShareableROLAPDimension sharedDim = null;
                        if (hierarchy.getDimension().isShareable()) {
                            sharedDim = (ShareableROLAPDimension)hierarchy.getDimension();
                            memberStorage = sharedDim.getMetadataStorage();
                        } else {
                            memberStorage = this.parentReservation.getMemberCache().getMetadataStorage();
                        }
                        ROLAPHierarchyMemberLoader hierarchyMemberLoader = new ROLAPHierarchyMemberLoader(cube, (ROLAPHierarchy)hierarchy, memberStorage, this.mPrimeLevelMembers);
                        if (sharedDim != null) {
                            ROLAPHierarchy.LoadStatusEnum loadStatus = ((ROLAPHierarchy)hierarchy).getLoadStatus();
                            if (loadStatus == ROLAPHierarchy.LoadStatusEnum.finished_success) {
                                ROLAPMetaHierarchy metaHierarchy = this.getROLAPMetaHierarchy(cube.getModelCube(), hierarchy.getName());
                                hierarchyMemberLoader.resolveAttributeDataTypes((ROLAPHierarchy)hierarchy);
                                hierarchyMemberLoader.loadCalculatedMembers(metaHierarchy);
                                ((ROLAPHierarchy)hierarchy).createRelativeTimeMembers(cube);
                                break block15;
                            } else {
                                if (loadStatus != ROLAPHierarchy.LoadStatusEnum.notYetStarted) {
                                    ROLAPLog.log("ROLAPCubes.Loader", "Previous shared hierarchy load was unsuccessful");
                                    throw new XQERuntimeException(XQEMessageKeys.ROL_UnexpectedException, "Hierarchy '" + this.mHierarchy.getUniqueName() + "' is a shared dimension and was not loaded successfully on an alternate cube.");
                                }
                                hierarchyMemberLoader.execute();
                            }
                            break block15;
                        }
                        hierarchyMemberLoader.execute();
                    }
                    finally {
                        context.removeReservation(this.parentReservation);
                        ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
                    }
                }
                ROLAPLog.log("ROLAPCubes.Loader", "Hierarchy load succeeded.");
                return;
            }
            catch (OutOfMemoryError oome) {
                String maxHeapSize = String.valueOf(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
                throw new XQERuntimeException(XQEMessageKeys.ROL_CannotLoadCubeOOM, (Throwable)oome, (Object)maxHeapSize, (Object)cube.getName());
            }
            catch (Exception e) {
                ROLAPLog.logError("ROLAPCubes.Loader", "Hierarchy load failed", e);
                throw e;
            }
            finally {
                cube.deregisterCurrentThread(false, registered);
                traceContext.exit();
            }
        }

        private ROLAPMetaHierarchy getROLAPMetaHierarchy(ROLAPMetaCube metaCube, String hierarchyName) {
            ROLAPMetaHierarchy[] hierarchies;
            for (ROLAPMetaHierarchy metaHierarchy : hierarchies = metaCube.getHierarchies()) {
                if (!metaHierarchy.getName().equals(hierarchyName)) continue;
                return metaHierarchy;
            }
            return null;
        }

        public String toString() {
            String cubeName = this.mCube.getUniqueName();
            return TASK_DESCRIPTION + UniqueNameGenerator.join(cubeName, this.mHierarchy.getUniqueName());
        }
    }
}

