/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class ROLAPResultSetCacheKey
implements Comparable<ROLAPResultSetCacheKey> {
    private final String mCubeName;
    private final String mSecurityContext;
    private final int mMemberCacheRevision;
    private final int mDataCacheRevision;
    private final String mMDX;
    private final Map<String, String> mMDXParameters;
    private final String localCollationSequenceKey;
    private final int incrementId;
    private int mCachedHashCode = -1;

    public ROLAPResultSetCacheKey(String cubeName, String securityContext, int memberCacheRevision, int dataCacheRevision, String mdx, Map<String, String> mdxParameters, String collationSequenceKey, int theIncrementId) {
        this.mCubeName = cubeName;
        this.mSecurityContext = securityContext;
        this.mMemberCacheRevision = memberCacheRevision;
        this.mDataCacheRevision = dataCacheRevision;
        this.mMDX = mdx;
        this.mMDXParameters = mdxParameters;
        this.localCollationSequenceKey = collationSequenceKey;
        this.incrementId = theIncrementId;
    }

    public String getCubeName() {
        return this.mCubeName;
    }

    public int getMemberCacheRevision() {
        return this.mMemberCacheRevision;
    }

    public int getDataCacheRevision() {
        return this.mDataCacheRevision;
    }

    public String getSecurityContext() {
        return this.mSecurityContext;
    }

    public String getMDX() {
        return this.mMDX;
    }

    public Map<String, String> getMDXParameters() {
        return Collections.unmodifiableMap(this.mMDXParameters);
    }

    public String getLocalCollationSequenceKey() {
        return this.localCollationSequenceKey;
    }

    public int getIncrementId() {
        return this.incrementId;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('[');
        buffer.append("cube=").append(this.mCubeName);
        buffer.append(", securityContext=").append(this.mSecurityContext);
        buffer.append(", memberCacheRev=").append(this.mMemberCacheRevision);
        buffer.append(", dataCacheRev=").append(this.mDataCacheRevision);
        buffer.append(", mdx=").append(this.mMDX);
        buffer.append(", mdxParameters=").append(this.mMDXParameters);
        buffer.append(", localCollationSequenceKey=").append(this.localCollationSequenceKey);
        buffer.append(", incrementId=").append(this.incrementId);
        buffer.append(']');
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ROLAPResultSetCacheKey)) {
            return false;
        }
        ROLAPResultSetCacheKey other = (ROLAPResultSetCacheKey)o;
        return this.incrementId == other.incrementId && this.mCubeName.equals(other.mCubeName) && this.mSecurityContext.equals(other.mSecurityContext) && this.mMemberCacheRevision == other.mMemberCacheRevision && this.mDataCacheRevision == other.mDataCacheRevision && this.mMDX.equals(other.mMDX) && this.mMDXParameters.equals(other.mMDXParameters) && this.localCollationSequenceKey.equals(other.localCollationSequenceKey);
    }

    public int hashCode() {
        if (-1 == this.mCachedHashCode) {
            HashCodeBuilder hcb = new HashCodeBuilder();
            this.mCachedHashCode = hcb.append((Object)this.mCubeName).append((Object)this.mSecurityContext).append(this.mMemberCacheRevision).append(this.mDataCacheRevision).append((Object)this.mMDX).append(this.mMDXParameters).append((Object)this.localCollationSequenceKey).toHashCode();
            if (-1 == this.mCachedHashCode) {
                this.mCachedHashCode = 0;
            }
        }
        return this.mCachedHashCode;
    }

    @Override
    public int compareTo(ROLAPResultSetCacheKey other) {
        CompareToBuilder ctb = new CompareToBuilder();
        ctb.append(this.incrementId, other.incrementId);
        if (ctb.toComparison() != 0) {
            return ctb.toComparison();
        }
        ctb.append((Object)this.mCubeName, (Object)other.mCubeName);
        if (ctb.toComparison() != 0) {
            return ctb.toComparison();
        }
        ctb.append((Object)this.mSecurityContext, (Object)other.mSecurityContext);
        if (ctb.toComparison() != 0) {
            return ctb.toComparison();
        }
        ctb.append(this.mMemberCacheRevision, other.mMemberCacheRevision);
        if (ctb.toComparison() != 0) {
            return ctb.toComparison();
        }
        ctb.append(this.mDataCacheRevision, other.mDataCacheRevision);
        if (ctb.toComparison() != 0) {
            return ctb.toComparison();
        }
        ctb.append((Object)this.mMDX, (Object)other.mMDX);
        if (ctb.toComparison() != 0) {
            return ctb.toComparison();
        }
        ctb.append(this.mMDXParameters, other.mMDXParameters);
        if (ctb.toComparison() != 0) {
            return ctb.toComparison();
        }
        ctb.append((Object)this.localCollationSequenceKey, (Object)other.localCollationSequenceKey);
        return ctb.toComparison();
    }
}

