/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.olap.IMDXParameterValue;
import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.BaseExecutionEnvironment;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.data.cache.IResultSetCacheKeyMaker;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPResultSetCacheKey;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.util.MapCast;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.Flat3Map;

public final class ROLAPResultSetCacheKeyMaker
implements IResultSetCacheKeyMaker {
    @Override
    public Object makeKey(ICube cube, MDXQuery mdxQuery, XDataContext dataContext) {
        SecurityManagerInterface secMan;
        ROLAPContext rolapCtx = ROLAPContext.get((ExecutionEnvironment)dataContext.getEnvironment());
        ROLAPCube rolapCube = ROLAPCubeManager.getInstance().getCube(cube.getName());
        ROLAPCubeReservation reservation = rolapCtx.getReservation(rolapCube);
        String securityKey = "Security not enabled";
        if (reservation == null) {
            throw new IllegalStateException(String.format("Cannot generate a result set cache key, ROLAP cube \"%s\" has not been reserved.", cube.getName()));
        }
        if (reservation.getSecurityCache() != null && (secMan = reservation.getSecurityCache().getSecurityManager()) != null) {
            securityKey = secMan.getAuthorizationKeyForCurrentUser();
        }
        int dataCacheId = 0;
        if (reservation.getDataCache() != null) {
            dataCacheId = reservation.getDataCache().getID();
        }
        Map<String, String> mdxParameters = MapCast.uncheckedCast(new Flat3Map());
        List<IXQEQueryNode> originalMdxParams = mdxQuery.getMDXParameters();
        for (IXQEQueryNode node : originalMdxParams) {
            if (node instanceof IMDXParameterValue) {
                IMDXParameterValue param = (IMDXParameterValue)((Object)node);
                mdxParameters.put(param.getName(), param.getExternalValues().toString());
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected type for MDX parameter: " + node.getClass().toString());
        }
        String localCollationSequenceKey = null;
        IExecutionEnvironment executionEnvironment = dataContext.getEnvironment();
        if (executionEnvironment instanceof BaseExecutionEnvironment) {
            localCollationSequenceKey = ((BaseExecutionEnvironment)executionEnvironment).getLocalCollationSequenceKey();
        }
        int incrementId = MultiRequestContext.getCurrentIncrementId(executionEnvironment, rolapCube);
        return new ROLAPResultSetCacheKey(cube.getName(), securityKey, reservation.getMemberCache().getID(), dataCacheId, mdxQuery.getMDX(), mdxParameters, localCollationSequenceKey, incrementId);
    }
}

