/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.SingletonHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ROLAPSharedDimensionCache {
    public static final boolean DISABLESHAREDDIMENSIONCACHE = System.getProperty("disableSharedDimensionCache") != null;
    public static final String SHAREABLE_DIMENSIONS = "shareableDimensions";
    private static final String WITH_UUID = " with uuid: ";
    private static final String CUBE = "Cube: ";
    private static final int UUID_CACHE_SIZE = 100;
    private ConcurrentHashMap<String, ShareableROLAPDimension> sharedDimensionCache;
    private ConcurrentHashMap<String, ReadWriteLock> uuidCacheForLocks;
    private static SingletonHelper<ROLAPSharedDimensionCache> sharedDimensionCacheSingletonHelper = new SingletonHelper<ROLAPSharedDimensionCache>(){

        @Override
        protected ROLAPSharedDimensionCache newInstance() {
            return new ROLAPSharedDimensionCache();
        }

        @Override
        protected void initializeImpl(ROLAPSharedDimensionCache theInstance) {
            theInstance.initialize();
        }

        @Override
        protected void releaseImpl(ROLAPSharedDimensionCache theInstance) {
            theInstance.release();
        }
    };

    private void log(LogLevel level, String message) {
        XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAP.MemberCache", level).log(message);
    }

    public ShareableROLAPDimension getAndRegisterShareableDimension(ROLAPCube rolapCube, String uuid) {
        ShareableROLAPDimension shareableDimension = this.sharedDimensionCache.get(uuid);
        if (shareableDimension != null) {
            this.log(LogLevel.TRACE, "Found existing sharable dimension: " + shareableDimension.getName() + WITH_UUID + uuid + " in the cache.");
            this.registerSharableDimension(rolapCube, shareableDimension);
            return shareableDimension;
        }
        this.log(LogLevel.TRACE, "No sharable dimension matching uuid: " + uuid + " exists in the cache.");
        return null;
    }

    private void registerSharableDimension(ROLAPCube rolapCube, ShareableROLAPDimension dimension) {
        this.sharedDimensionCache.put(dimension.getUUID(), dimension);
        dimension.addCube(rolapCube);
        this.log(LogLevel.TRACE, CUBE + rolapCube.getName() + " sharing dimension: " + dimension.getName() + WITH_UUID + dimension.getUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSharedDimensions(ROLAPCube rolapCube) {
        Collection<ShareableROLAPDimension> valuesCollection = this.sharedDimensionCache.values();
        Iterator<ShareableROLAPDimension> iterator = valuesCollection.iterator();
        while (iterator.hasNext()) {
            ShareableROLAPDimension dimension = iterator.next();
            ReadWriteLock dimLock = this.uuidCacheForLocks.get(dimension.getUUID());
            if (dimLock == null) continue;
            try {
                dimLock.writeLock().lock();
                if (!dimension.removeCube(rolapCube)) continue;
                this.log(LogLevel.TRACE, CUBE + rolapCube.getName() + " removed from sharing dimension: " + dimension.getName());
                if (dimension.isSharing()) continue;
                dimension.close();
                iterator.remove();
                this.uuidCacheForLocks.remove(dimension.getUUID());
                this.log(LogLevel.TRACE, "Removed sharing dimension: " + dimension.getName() + WITH_UUID + dimension.getUUID() + " from cache.");
            }
            finally {
                dimLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getOrCreateShareableDimension(ROLAPCube cube, String dimName, ROLAPMetaDimension metaDim, ROLAPMetaCube metaCube, String sharedDimUUID, DimensionTypeEnum dimType, ROLAPMetaHierarchy metaDefaultHierarchy) {
        block12: {
            ReentrantReadWriteLock newLock = new ReentrantReadWriteLock();
            newLock.writeLock().lock();
            ReadWriteLock existingLock = this.uuidCacheForLocks.putIfAbsent(sharedDimUUID, newLock);
            try {
                if (existingLock != null) {
                    try {
                        existingLock.readLock().lock();
                        ShareableROLAPDimension rolapDimension = this.getAndRegisterShareableDimension(cube, sharedDimUUID);
                        if (rolapDimension == null) {
                            throw new XQERuntimeException(new RuntimeException("Shareable dimension: " + dimName + WITH_UUID + sharedDimUUID + " was not found in the cache."));
                        }
                        cube.addDimension(rolapDimension);
                        break block12;
                    }
                    finally {
                        existingLock.readLock().unlock();
                    }
                }
                boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName(cube.getName());
                try {
                    ShareableROLAPDimension rolapDimension = new ShareableROLAPDimension(dimName, cube, metaDim, metaDefaultHierarchy, dimType, sharedDimUUID);
                    this.registerSharableDimension(cube, rolapDimension);
                    for (ROLAPMetaHierarchy hier : metaCube.getHierarchies(metaDim)) {
                        ROLAPHierarchy rolapHier = rolapDimension.addHierarchy(hier);
                        if (!hier.getName().equals(metaDefaultHierarchy.getName())) continue;
                        rolapDimension.setDefaultHierarchy(rolapHier);
                    }
                }
                finally {
                    ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
                }
            }
            finally {
                newLock.writeLock().unlock();
            }
        }
    }

    private void initialize() {
        this.sharedDimensionCache = new ConcurrentHashMap();
        this.uuidCacheForLocks = new ConcurrentHashMap(100);
    }

    private void release() {
        for (ShareableROLAPDimension dim : this.sharedDimensionCache.values()) {
            dim.close();
        }
        this.sharedDimensionCache.clear();
        this.sharedDimensionCache = null;
        this.uuidCacheForLocks.clear();
        this.uuidCacheForLocks = null;
    }

    public static ROLAPSharedDimensionCache getInstance() {
        return sharedDimensionCacheSingletonHelper.getInstance();
    }

    public static void releaseInstance() {
        sharedDimensionCacheSingletonHelper.releaseInstance();
    }
}

