/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.log.AggregateLoadManagerTaskInfo;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.advisor.model.ROLAPMetaInMemoryAggregate;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTask;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTaskResult;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateLoadTreeExecution;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.util.ConfigurationValues;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;

public abstract class AbstractAggregateLoadManagerCubeTask {
    protected final ROLAPBaseCube cube;
    protected final AggregateLoadManagerTaskInfo aggregateLoadManagerTaskInfo = new AggregateLoadManagerTaskInfo();

    public AbstractAggregateLoadManagerCubeTask(ROLAPBaseCube theCube) {
        this.cube = theCube;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAggregates() {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setCMRequestExecutor(this.cube.getAccountManager());
        envHelper.setInternalUse(true);
        envHelper.setUpEnvironment(true);
        ExecutionEnvironment execEnv = envHelper.getExecutionEnvironment();
        try {
            ROLAPCubeReservation reservation = this.cube.reserve(execEnv, null);
            try {
                this.loadAggregates(reservation);
            }
            finally {
                this.cube.unreserve(reservation);
            }
        }
        finally {
            envHelper.tearDownEnvironment();
        }
    }

    protected abstract void loadAggregates(ROLAPCubeReservation var1);

    protected List<AggregateLoadTask> createLoadTasks(AggregateCubeletStorage aggregateCache, List<AggregateDefinition> aggregateDefinitions, ROLAPCubeReservation reservation) {
        ArrayList<AggregateLoadTask> loadTasks = new ArrayList<AggregateLoadTask>();
        if (ConfigurationValues.getBoolean("UseStackedAggregates", true)) {
            Collection<AggregateLoadTreeExecution> loadTrees = AggregateLoadTreeExecution.createExecutionTrees(aggregateDefinitions, this.cube, aggregateCache);
            for (AggregateLoadTreeExecution loadTree : loadTrees) {
                AggregateLoadTask loadTask = new AggregateLoadTask(this.cube, aggregateCache, loadTree, reservation);
                loadTasks.add(loadTask);
            }
        } else {
            for (AggregateDefinition aggregateDefinition : aggregateDefinitions) {
                AggregateLoadTask loadTask = new AggregateLoadTask(this.cube, aggregateCache, aggregateDefinition, reservation);
                loadTasks.add(loadTask);
            }
        }
        return loadTasks;
    }

    protected List<Callable<AggregateLoadTaskResult>> decorateLoadTasks(List<AggregateLoadTask> aggregateLoadTasks) {
        ArrayList<Callable<AggregateLoadTaskResult>> decoratedLoadTasks = new ArrayList<Callable<AggregateLoadTaskResult>>();
        int aggrTaskIndex = 1;
        for (Callable callable : aggregateLoadTasks) {
            Callable decoratedLoadTask = ROLAPCallable.decorateServerTask(callable, this.cube, ((ROLAPCallable)callable).getZipiAction(), this.cube.getUniqueName(), aggrTaskIndex++);
            decoratedLoadTasks.add(decoratedLoadTask);
        }
        return decoratedLoadTasks;
    }

    protected void logAggregateLoadManagerTaskInfo(long loadStartTime, long loadEndTime) {
        try {
            ROLAPLog.log("ROLAPCubes.AggregateCache", "Logging the information about the loading of the aggregates for the advisor began.");
            this.aggregateLoadManagerTaskInfo.setLoadStartTime(loadStartTime);
            this.aggregateLoadManagerTaskInfo.setLoadEndTime(loadEndTime);
            ROLAPMetaInMemoryAggregate metaInMemoryAggregate = this.cube.getInMemoryAggregateModel();
            this.aggregateLoadManagerTaskInfo.setAggregateXML(metaInMemoryAggregate.getXMLString());
            this.logAggregateLoadManagerTaskInfo();
            ROLAPLog.log("ROLAPCubes.AggregateCache", "Logging the information about the loading of the aggregates for the advisor succeeded.");
        }
        catch (Exception e) {
            ROLAPLog.logError("ROLAPCubes.AggregateCache", "Logging the information about the loading of the aggregates for the advisor failed.", e);
            throw XQERuntimeException.wrap(e);
        }
    }

    protected abstract void logAggregateLoadManagerTaskInfo() throws Exception;
}

