/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateLevelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

public class ROLAPMetaAggregateCube
extends ROLAPMetaObject {
    private int ordinal = 0;
    private String typeAttribute = null;
    private static final String TYPE_DATABASE_AGGREGATE = "database";
    private static final String TYPE_MEMORY_AGGREGATE = "memory";
    private double lowestLevelsCardinality = 0.0;
    private LinkedHashMap<String, ROLAPMetaAggregateDimensionRef> aggregateDimensionRefs = null;
    private LinkedHashMap<String, ROLAPMetaAggregateMeasureRef> aggregateMeasureRefs = null;

    public boolean isInDatabaseAggregate() {
        return this.getType().equalsIgnoreCase(TYPE_DATABASE_AGGREGATE);
    }

    public boolean isInMemoryAggregate() {
        return this.getType().equalsIgnoreCase(TYPE_MEMORY_AGGREGATE);
    }

    public int getOrdinal() {
        if (!this.getType().equalsIgnoreCase(TYPE_DATABASE_AGGREGATE)) {
            return 1;
        }
        if (this.ordinal == 0) {
            this.ordinal = Integer.parseInt(this.captureAttribute("ordinal"));
        }
        return this.ordinal;
    }

    @Override
    public void captureContents() {
        super.captureContents();
        this.getName();
        this.getOrdinal();
        this.getType();
        this.getAggregateDimensionRefs();
        this.getAggregateMeasureRefs();
        this.clearDOMNode();
    }

    private String getType() {
        if (this.typeAttribute == null) {
            this.typeAttribute = this.captureAttribute("type");
            if (this.typeAttribute == null) {
                this.typeAttribute = TYPE_DATABASE_AGGREGATE;
            }
        }
        return this.typeAttribute;
    }

    public ROLAPMetaAggregateDimensionRef[] getAggregateDimensionRefs() {
        if (this.aggregateDimensionRefs == null) {
            this.aggregateDimensionRefs = new LinkedHashMap();
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaObject obj = this.getChild(i);
                if (!(obj instanceof ROLAPMetaAggregateDimensionRef)) continue;
                ROLAPMetaAggregateDimensionRef aggregateDimensionRef = (ROLAPMetaAggregateDimensionRef)obj;
                this.aggregateDimensionRefs.put(aggregateDimensionRef.getName(), aggregateDimensionRef);
            }
        }
        return this.aggregateDimensionRefs.values().toArray(new ROLAPMetaAggregateDimensionRef[0]);
    }

    public ROLAPMetaAggregateMeasureRef[] getAggregateMeasureRefs() {
        if (this.aggregateMeasureRefs == null) {
            this.aggregateMeasureRefs = new LinkedHashMap();
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaObject obj = this.getChild(i);
                if (!(obj instanceof ROLAPMetaAggregateMeasureRef)) continue;
                ROLAPMetaAggregateMeasureRef aggregateMeasureRef = (ROLAPMetaAggregateMeasureRef)obj;
                this.aggregateMeasureRefs.put(aggregateMeasureRef.getName(), aggregateMeasureRef);
            }
        }
        return this.aggregateMeasureRefs.values().toArray(new ROLAPMetaAggregateMeasureRef[0]);
    }

    public ROLAPMetaAggregateMeasureRef getAggregateMeasure(ROLAPMeasure measure) {
        if (this.aggregateMeasureRefs == null) {
            return null;
        }
        return this.aggregateMeasureRefs.get(measure.getName());
    }

    private ROLAPMetaAggregateDimensionRef getAggregateDimension(IDimension dimension) {
        if (this.aggregateDimensionRefs == null) {
            return null;
        }
        return this.aggregateDimensionRefs.get(dimension.getName());
    }

    public ROLAPMetaAggregateLevelRef getAggregateLevel(ROLAPLevel level) {
        IDimension dim = level.getDimension();
        ROLAPMetaAggregateDimensionRef aggrDim = this.getAggregateDimension(dim);
        if (aggrDim != null) {
            return aggrDim.getAggregatLevel(level);
        }
        return null;
    }

    public ILevel getLowestAggregateLevel(IHierarchy hierarchy) {
        ROLAPMetaAggregateHierarchyRef aggrHier;
        IDimension dim = hierarchy.getDimension();
        ROLAPMetaAggregateDimensionRef aggrDim = this.getAggregateDimension(dim);
        if (aggrDim != null && (aggrHier = aggrDim.getAggregateHierarchy(hierarchy)) != null) {
            String lowestLevelName = aggrHier.getLowestAggregateLevelRef().getName();
            return hierarchy.getLevel(lowestLevelName);
        }
        return null;
    }

    public boolean isLowestAggregateLevel(ROLAPLevel level) {
        IDimension dim = level.getDimension();
        ROLAPMetaAggregateDimensionRef aggrDim = this.getAggregateDimension(dim);
        if (aggrDim != null) {
            return aggrDim.isLowestAggregateLevel(level);
        }
        return false;
    }

    public boolean hasAggregateSlice() {
        for (ROLAPMetaAggregateDimensionRef aggrDim : this.getAggregateDimensionRefs()) {
            if (!aggrDim.hasAggregateSlice()) continue;
            return true;
        }
        return false;
    }

    public double getLowestLevelsCardinality(ROLAPCube runtimeCube) {
        if (this.lowestLevelsCardinality == 0.0) {
            long levelCardinality = 0L;
            for (ROLAPMetaAggregateDimensionRef aggrDimensionRef : this.getAggregateDimensionRefs()) {
                IDimension runtimeDimension = runtimeCube.getDimension(aggrDimensionRef.getName());
                for (ROLAPMetaAggregateHierarchyRef aggrHierarchyRef : aggrDimensionRef.getAggregateHierarchyRefs()) {
                    IHierarchy runtimeHierarchy = runtimeDimension.getHierarchy(aggrHierarchyRef.getName());
                    if (runtimeHierarchy.isParentChild()) {
                        if (aggrHierarchyRef.getAggregateSlice() == null) {
                            levelCardinality = 0L;
                            List<ILevel> levels = runtimeHierarchy.getLevels();
                            for (ILevel level : levels) {
                                levelCardinality += (long)((ROLAPLevel)level).getMemberCount();
                            }
                        } else {
                            HashSet<IMember> slicerMembers = aggrHierarchyRef.getAggregateSliceMemberObjects(runtimeHierarchy);
                            levelCardinality = slicerMembers.size();
                        }
                    } else {
                        ROLAPMetaAggregateLevelRef aggrLowestLevel = aggrHierarchyRef.getLowestAggregateLevelRef();
                        ROLAPLevel runtimeAggrLowestLevel = (ROLAPLevel)runtimeHierarchy.getLevel(aggrLowestLevel.getName());
                        ILevel runtimeSliceLevel = aggrHierarchyRef.getAggregateSliceLevel(runtimeHierarchy);
                        if (runtimeSliceLevel == null) {
                            levelCardinality = runtimeAggrLowestLevel.getMemberCount();
                        } else {
                            HashSet<IMember> slicerMembers = aggrHierarchyRef.getAggregateSliceMemberObjects(runtimeHierarchy);
                            if (runtimeSliceLevel == runtimeAggrLowestLevel) {
                                levelCardinality = slicerMembers.size();
                            } else {
                                levelCardinality = 0L;
                                for (IMember slicerMember : slicerMembers) {
                                    levelCardinality += (long)((IMemberCubics)slicerMember).getDescendants(runtimeAggrLowestLevel).size();
                                }
                            }
                        }
                    }
                    if (levelCardinality == 0L) continue;
                    this.lowestLevelsCardinality += Math.log10(levelCardinality);
                }
            }
        }
        return this.lowestLevelsCardinality;
    }
}

