/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregateCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAttribute;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeFacts;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeModel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDefaultMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaFactTransactionId;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaFacts;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasureRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaNamedSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaNamedSets;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaRuleRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurity;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurityDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurityRules;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaView;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaViews;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPModelValidationException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ROLAPMetaCube
extends ROLAPMetaObject {
    private String type = null;
    private static final int TWELVE = 12;
    private static final int MAX_MEMBER_CACHE_SIZE = 100000;
    private static final String TRUE = "true";
    private long createDate = System.currentTimeMillis();
    private List<ROLAPMetaMeasure> measures = null;
    private List<ROLAPMetaHierarchy> hierarchies = null;
    private List<ROLAPMetaAggregateCube> aggregateCubes = null;
    private List<ROLAPMetaAggregateCube> userDefinedInMemoryAggregates = null;
    private String cubingServicesCompatibility = null;
    private boolean capturedCubingServicesCompatibility = false;
    private boolean removeNonExistentTuples = true;
    private boolean capturedRemoveNonExistentTuples = false;
    private String dbContainsDirtyData = null;
    private boolean capturedDbContainsDirtyData = false;
    private Map<String, ROLAPMetaView> securityViews = null;
    private List<ROLAPMetaNamedSet> namedSets = null;

    public long getCreated() {
        return this.createDate;
    }

    public ROLAPMetaMeasure[] getMeasures() {
        if (this.measures == null) {
            boolean hasVisibleMeasure = false;
            this.measures = new ArrayList<ROLAPMetaMeasure>();
            ROLAPMetaCubeFacts facts = (ROLAPMetaCubeFacts)this.getFirstChildByType(ROLAPMetaCubeFacts.class);
            List<ROLAPMetaObject> metaMeasures = facts.getAllNonFolderMetaMeasureItems();
            for (ROLAPMetaObject obj : metaMeasures) {
                if (obj instanceof ROLAPMetaDefaultMeasureRef) continue;
                if (obj instanceof ROLAPMetaMeasureRef) {
                    ROLAPMetaObject parent = this.getMeasureParent();
                    ROLAPMetaMeasure meas = ((ROLAPMetaMeasureRef)obj).getMeasure(parent);
                    if (meas == null) {
                        throw new ROLAPModelValidationException(XQEMessageKeys.ROL_InvalidMeasureReferenceInCube, obj.getName(), this.getName());
                    }
                    if (!hasVisibleMeasure) {
                        hasVisibleMeasure = meas.isVisible();
                    }
                    this.measures.add(meas);
                    continue;
                }
                if (!(obj instanceof ROLAPMetaMeasure)) continue;
                if (!hasVisibleMeasure) {
                    hasVisibleMeasure = ((ROLAPMetaMeasure)obj).isVisible();
                }
                this.measures.add((ROLAPMetaMeasure)obj);
            }
            if (!hasVisibleMeasure) {
                throw new ROLAPModelValidationException(XQEMessageKeys.ROL_NoVisibleMeasuresInCube, this.getName());
            }
        }
        return this.measures.toArray(new ROLAPMetaMeasure[0]);
    }

    public ROLAPMetaHierarchy[] getHierarchies() {
        if (this.hierarchies == null) {
            this.hierarchies = ROLAPMetaCube.getHierarchies(this);
        }
        return this.hierarchies.toArray(new ROLAPMetaHierarchy[0]);
    }

    public ROLAPMetaAggregateCube[] getAggregateCubes() {
        if (this.aggregateCubes == null) {
            ArrayList<ROLAPMetaAggregateCube> aggCubes = new ArrayList<ROLAPMetaAggregateCube>();
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaAggregateCube aggregateCube;
                ROLAPMetaObject obj = this.getChild(i);
                if (!(obj instanceof ROLAPMetaAggregateCube) || !(aggregateCube = (ROLAPMetaAggregateCube)obj).isInDatabaseAggregate()) continue;
                aggCubes.add(aggregateCube);
            }
            ArrayList<ROLAPMetaAggregateCube> orderedAggregateCubes = new ArrayList<ROLAPMetaAggregateCube>();
            while (aggCubes.size() > 0) {
                ROLAPMetaAggregateCube lowerOrdinalAggrCube = (ROLAPMetaAggregateCube)aggCubes.get(0);
                for (ROLAPMetaAggregateCube aggregateCube : aggCubes) {
                    int ordinal = aggregateCube.getOrdinal();
                    if (ordinal >= lowerOrdinalAggrCube.getOrdinal()) continue;
                    lowerOrdinalAggrCube = aggregateCube;
                }
                aggCubes.remove(lowerOrdinalAggrCube);
                orderedAggregateCubes.add(lowerOrdinalAggrCube);
            }
            this.aggregateCubes = orderedAggregateCubes;
        }
        return this.aggregateCubes.toArray(new ROLAPMetaAggregateCube[0]);
    }

    public ROLAPMetaAggregateCube[] getUserDefinedInMemoryAggregates() {
        if (this.userDefinedInMemoryAggregates == null) {
            this.userDefinedInMemoryAggregates = new ArrayList<ROLAPMetaAggregateCube>();
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaAggregateCube aggregateCube;
                ROLAPMetaObject obj = this.getChild(i);
                if (!(obj instanceof ROLAPMetaAggregateCube) || !(aggregateCube = (ROLAPMetaAggregateCube)obj).isInMemoryAggregate()) continue;
                this.userDefinedInMemoryAggregates.add(aggregateCube);
            }
        }
        return this.userDefinedInMemoryAggregates.toArray(new ROLAPMetaAggregateCube[0]);
    }

    public void removeAggregateCubes(List<ROLAPMetaAggregateCube> invalidCubesToRemove) {
        if (this.aggregateCubes == null) {
            return;
        }
        this.aggregateCubes.removeAll(invalidCubesToRemove);
    }

    public String getDefaultMeasureName() {
        ROLAPMetaCubeFacts facts = (ROLAPMetaCubeFacts)this.getFirstChildByType(ROLAPMetaCubeFacts.class);
        String name = facts.getDefaultMeasureName();
        return name;
    }

    public ROLAPMetaObject getMeasureParent() {
        ROLAPMetaCubeModel cubeModel = (ROLAPMetaCubeModel)this.getParent();
        for (int i = 0; i < cubeModel.getChildCount(); ++i) {
            ROLAPMetaObject child = cubeModel.getChild(i);
            if (!(child instanceof ROLAPMetaFacts)) continue;
            ROLAPMetaFacts facts = (ROLAPMetaFacts)child;
            return facts;
        }
        return null;
    }

    @Override
    public void captureContents() {
        ROLAPMetaObject metaNamedSets;
        super.captureContents();
        this.collectNames();
        this.collectDescriptions();
        this.collectComplete();
        this.getType();
        this.getCubingServicesCompatibility();
        this.getDbContainsDirtyData();
        this.isRemoveNonExistentTuplesEnabled();
        this.clearDOMNode();
        ROLAPMetaObject obj = this.getChild("ROLAPMetaSecurity");
        if (obj != null && obj instanceof ROLAPMetaSecurity) {
            this.securityViews = ((ROLAPMetaSecurity)obj).getSecurityViews();
        }
        if ((metaNamedSets = this.getChild("ROLAPMetaNamedSets")) != null && metaNamedSets instanceof ROLAPMetaNamedSets) {
            this.namedSets = ((ROLAPMetaNamedSets)metaNamedSets).getNamedSets();
        }
    }

    public ROLAPMetaHierarchy getDefaultHierarchy(ROLAPMetaDimension dim) {
        ROLAPMetaCubeDimensionRef foundDimensionRef = null;
        for (ROLAPMetaObject obj : this.getChildren()) {
            if (!(obj instanceof ROLAPMetaCubeDimensionRef)) continue;
            String dimName = dim.getName();
            String dimCatagory = dim.getCategory();
            ROLAPMetaCubeDimensionRef dimRef = (ROLAPMetaCubeDimensionRef)obj;
            if (!dimName.equals(dimRef.getName()) || !dimCatagory.equals(dimRef.getDimensionCategory())) continue;
            foundDimensionRef = dimRef;
            break;
        }
        ROLAPMetaHierarchy defaultHierarchy = null;
        if (foundDimensionRef != null) {
            defaultHierarchy = foundDimensionRef.getDefaultHierarchy();
        }
        return defaultHierarchy;
    }

    public ROLAPMetaDimension[] getDimensions() {
        ArrayList<ROLAPMetaDimension> dimList = new ArrayList<ROLAPMetaDimension>();
        for (ROLAPMetaObject obj : this.getChildren()) {
            if (!(obj instanceof ROLAPMetaCubeDimensionRef)) continue;
            ROLAPMetaCubeDimensionRef dimRef = (ROLAPMetaCubeDimensionRef)obj;
            ROLAPMetaDimension dim = dimRef.getDimension();
            dimList.add(dim);
        }
        return dimList.toArray(new ROLAPMetaDimension[dimList.size()]);
    }

    public ROLAPMetaHierarchy[] getHierarchies(ROLAPMetaDimension dim) {
        ArrayList<ROLAPMetaHierarchy> hier = new ArrayList<ROLAPMetaHierarchy>();
        String dimName = dim.getName();
        String dimCategory = dim.getCategory();
        for (ROLAPMetaObject obj : this.getChildren()) {
            ROLAPMetaCubeDimensionRef dimRef;
            if (!(obj instanceof ROLAPMetaCubeDimensionRef) || !dimName.equals((dimRef = (ROLAPMetaCubeDimensionRef)obj).getName()) || !dimCategory.equals(dimRef.getDimensionCategory())) continue;
            hier.addAll(ROLAPMetaCube.getHierarchies(dimRef));
        }
        return hier.toArray(new ROLAPMetaHierarchy[hier.size()]);
    }

    public boolean isCubingServicesCompatible() {
        String comp = this.getCubingServicesCompatibility();
        return TRUE.equalsIgnoreCase(comp);
    }

    public String getCubingServicesCompatibility() {
        if (!this.capturedCubingServicesCompatibility) {
            this.cubingServicesCompatibility = this.captureAttribute("cubingServicesCompatibility");
            this.capturedCubingServicesCompatibility = true;
        }
        return this.cubingServicesCompatibility;
    }

    public boolean isRemoveNonExistentTuplesEnabled() {
        if (!this.capturedRemoveNonExistentTuples) {
            String removeNonExistentTuplesStr = this.captureAttribute("removeNonExistentTuples");
            this.removeNonExistentTuples = removeNonExistentTuplesStr == null ? true : Boolean.valueOf(removeNonExistentTuplesStr);
            this.capturedRemoveNonExistentTuples = true;
        }
        return this.removeNonExistentTuples;
    }

    public Map<String, ROLAPMetaView> getSecurityViews() {
        return this.securityViews;
    }

    public List<ROLAPMetaNamedSet> getNamedSets() {
        return this.namedSets;
    }

    public boolean isDbContainsDirtyData() {
        String comp = this.getDbContainsDirtyData();
        return TRUE.equalsIgnoreCase(comp);
    }

    public String getDbContainsDirtyData() {
        if (!this.capturedDbContainsDirtyData) {
            this.dbContainsDirtyData = this.captureAttribute("dbContainsDirtyData");
            this.capturedDbContainsDirtyData = true;
        }
        return this.dbContainsDirtyData;
    }

    public String getFactTransactionIDQueryItem() {
        String queryItem = null;
        ROLAPMetaFactTransactionId factTIDElement = (ROLAPMetaFactTransactionId)this.getFirstChildByType(ROLAPMetaFactTransactionId.class);
        if (factTIDElement != null) {
            queryItem = factTIDElement.getQueryItem();
        }
        return queryItem;
    }

    public boolean isNearRealTimeCube() {
        String factTransactionIDQueryItem = this.getFactTransactionIDQueryItem();
        return factTransactionIDQueryItem != null && factTransactionIDQueryItem.length() > 0;
    }

    public static boolean nodesEqual(ROLAPMetaObject left, ROLAPMetaObject right) {
        if (!left.getClass().getName().equals(right.getClass().getName())) {
            return false;
        }
        if (!(left.getName() == right.getName() || left.getName() != null && left.getName().equals(right.getName()))) {
            return false;
        }
        if (left instanceof ROLAPMetaDimension && (((ROLAPMetaDimension)left).getType() != ((ROLAPMetaDimension)right).getType() && ((ROLAPMetaDimension)left).getType() == null || !((ROLAPMetaDimension)left).getType().equals(((ROLAPMetaDimension)right).getType()))) {
            return false;
        }
        if (left instanceof ROLAPMetaAttribute && (((ROLAPMetaAttribute)left).getLocales() != ((ROLAPMetaAttribute)right).getLocales() && ((ROLAPMetaAttribute)left).getLocales() == null || !((ROLAPMetaAttribute)left).getLocales().equals(((ROLAPMetaAttribute)right).getLocales()))) {
            return false;
        }
        if (left instanceof ROLAPMetaLevel && (((ROLAPMetaLevel)left).getType() != ((ROLAPMetaLevel)right).getType() && ((ROLAPMetaLevel)left).getType() == null || !((ROLAPMetaLevel)left).getType().equals(((ROLAPMetaLevel)right).getType()))) {
            return false;
        }
        List<ROLAPMetaObject> childListL = ROLAPMetaCube.sanitizeChildList(left.getChildren());
        List<ROLAPMetaObject> childListR = ROLAPMetaCube.sanitizeChildList(right.getChildren());
        if (childListL.size() != childListR.size()) {
            return false;
        }
        Iterator<ROLAPMetaObject> leftIt = childListL.iterator();
        Iterator<ROLAPMetaObject> rightIt = childListR.iterator();
        while (leftIt.hasNext() && rightIt.hasNext()) {
            if (ROLAPMetaCube.nodesEqual(leftIt.next(), rightIt.next())) continue;
            return false;
        }
        return true;
    }

    private static List<ROLAPMetaObject> sanitizeChildList(List<ROLAPMetaObject> origChildren) {
        ArrayList<ROLAPMetaObject> children = new ArrayList<ROLAPMetaObject>();
        if (origChildren != null) {
            for (ROLAPMetaObject child : origChildren) {
                if (child instanceof ROLAPMetaSecurity || child instanceof ROLAPMetaSecurityRules || child instanceof ROLAPMetaViews || child instanceof ROLAPMetaView || child instanceof ROLAPMetaSecurityDimensionRef || child instanceof ROLAPMetaRuleRef) continue;
                children.add(child);
            }
        }
        return children;
    }

    public String getType() {
        if (this.type == null) {
            this.type = this.captureAttribute("type");
        }
        return this.type;
    }

    public boolean isValidateCube() {
        boolean bIsValidateCube = false;
        if (this.type != null && this.type.equalsIgnoreCase("validate")) {
            bIsValidateCube = true;
        }
        return bIsValidateCube;
    }
}

