/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCubeModel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDefaultHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObjectKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaRule;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaRuleRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurity;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurityDimensionRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurityHierarchyRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaSecurityRules;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaView;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaViews;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaVirtualCubeModels;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPModelValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;
import org.dom4j.Node;

public class ROLAPMetaMdSchema
extends ROLAPMetaObject {
    private static final String DEFAULTLOCALE_ATTR = "defaultLocale";
    private static final String DEFAULTLOCALE = "en-us";
    private List<ROLAPMetaCube> cubes = null;
    private ROLAPMetaVirtualCube[] virtualCubes = null;
    private boolean capturedVirtualCubes = false;
    private Map<ROLAPMetaObjectKey, ROLAPMetaObject> schemaRefsToObjects = null;
    private String defaultLocale;
    private String version = null;

    public ROLAPMetaObject get(ROLAPMetaObjectKey key) {
        ROLAPMetaObject result = null;
        Map<ROLAPMetaObjectKey, ROLAPMetaObject> refsToObjects = this.getSchemaRefsToObjects();
        if (refsToObjects != null) {
            result = refsToObjects.get(key);
        }
        return result;
    }

    public ROLAPMetaCubeModel getCommonCubeModel() {
        ROLAPMetaObjectKey objectKey = ROLAPMetaObject.createMetaObjectKey("Common", ROLAPMetaMdSchema.class, this.getName(), ROLAPMetaCubeModel.class, "Common");
        return (ROLAPMetaCubeModel)this.get(objectKey);
    }

    public ROLAPMetaCube[] getCubes() {
        if (this.cubes == null) {
            this.cubes = new ArrayList<ROLAPMetaCube>();
            int ct = this.getChildCount();
            for (int i = 0; i < ct; ++i) {
                ROLAPMetaObject child = this.getChild(i);
                if (!(child instanceof ROLAPMetaCubeModel)) continue;
                ROLAPMetaCubeModel model = (ROLAPMetaCubeModel)child;
                ROLAPMetaCube[] cubeArray = model.getCubes();
                for (int k = 0; k < cubeArray.length; ++k) {
                    ROLAPMetaCube cube = cubeArray[k];
                    this.cubes.add(cube);
                }
            }
        }
        return this.cubes.toArray(new ROLAPMetaCube[0]);
    }

    public Map<ROLAPMetaObjectKey, ROLAPMetaObject> getSchemaRefsToObjects() {
        return this.schemaRefsToObjects;
    }

    public ROLAPMetaVirtualCube[] getVirtualCubes() {
        if (!this.capturedVirtualCubes) {
            this.virtualCubes = null;
            Element virtualCubeModels = this.captureElement("virtualCubes");
            if (virtualCubeModels != null) {
                ROLAPMetaVirtualCubeModels models = new ROLAPMetaVirtualCubeModels();
                models.setNode((Node)virtualCubeModels);
                this.virtualCubes = models.getVirtualCubes();
            }
            this.capturedVirtualCubes = true;
        }
        return this.virtualCubes;
    }

    public void put(ROLAPMetaObjectKey objKey, ROLAPMetaObject obj) {
        if (this.schemaRefsToObjects == null) {
            this.schemaRefsToObjects = new HashMap<ROLAPMetaObjectKey, ROLAPMetaObject>();
        }
        this.schemaRefsToObjects.put(objKey, obj);
    }

    @Override
    public void captureContents() {
        super.captureContents();
        this.getMdSchemaDefaultLocale();
        this.getVirtualCubes();
        this.clearDOMNode();
    }

    protected String getMdSchemaDefaultLocale() {
        if (this.defaultLocale == null) {
            this.defaultLocale = this.captureAttribute(DEFAULTLOCALE_ATTR);
            if (this.defaultLocale == null) {
                this.defaultLocale = DEFAULTLOCALE;
            }
        }
        return this.defaultLocale;
    }

    public void validateModel() throws Exception {
        ROLAPMetaCube[] modelCubes;
        for (ROLAPMetaCube cube : modelCubes = this.getCubes()) {
            for (ROLAPMetaObject obj : cube.getChildren()) {
                if (obj instanceof ROLAPMetaCubeDimensionRef) {
                    ROLAPMetaMdSchema.validateDefaultHierarchy((ROLAPMetaCubeDimensionRef)obj);
                    ROLAPMetaMdSchema.validateHierarchies((ROLAPMetaCubeDimensionRef)obj);
                    continue;
                }
                if (!(obj instanceof ROLAPMetaSecurity)) continue;
                ROLAPMetaMdSchema.validateSecurity(cube, (ROLAPMetaSecurity)obj);
            }
        }
    }

    private static void validateDefaultHierarchy(ROLAPMetaCubeDimensionRef cubeDimRef) throws Exception {
        ROLAPMetaHierarchy defaultHierarchy = cubeDimRef.getDefaultHierarchy();
        if (defaultHierarchy == null) {
            String defaultHierarchyName = null;
            for (ROLAPMetaObject obj2 : cubeDimRef.getChildren()) {
                if (!(obj2 instanceof ROLAPMetaDefaultHierarchyRef)) continue;
                defaultHierarchyName = obj2.getName();
                break;
            }
            String cubeName = cubeDimRef.getParent().getName();
            if (defaultHierarchyName != null) {
                throw new ROLAPModelValidationException(XQEMessageKeys.ROL_DefaultHierarchyNotInCube, (Object)cubeDimRef.getName(), (Object)cubeName, (Object)defaultHierarchyName);
            }
            throw new ROLAPModelValidationException(XQEMessageKeys.ROL_NoDefaultHierarchyInCube, cubeDimRef.getName(), cubeName);
        }
    }

    private static void validateHierarchies(ROLAPMetaCubeDimensionRef cubeDimRef) throws Exception {
        ROLAPMetaHierarchy[] hierarchies = cubeDimRef.getHierarchies();
        String cubeName = cubeDimRef.getParent().getName();
        for (ROLAPMetaHierarchy hierarchy : hierarchies) {
            if (hierarchy.isRecursive()) {
                if (hierarchies.length > 1) {
                    throw new ROLAPModelValidationException(XQEMessageKeys.ROL_ParentChildHierarchyWithMultipleHierarchies, (Object)hierarchy.getName(), (Object)cubeDimRef.getName(), (Object)cubeName);
                }
                ROLAPMetaLevel[] levels = hierarchy.getLevels();
                if (levels.length != 2) {
                    throw new ROLAPModelValidationException(XQEMessageKeys.ROL_ParentChildHierarchyIncorrectLevels, (Object)hierarchy.getName(), (Object)cubeDimRef.getName(), (Object)cubeName);
                }
                if (levels[0].getLevelKeys().size() > 1 || levels[1].getLevelKeys().size() > 1) {
                    throw new ROLAPModelValidationException(XQEMessageKeys.ROL_ParentChildHierarchyHasCompositeKeys, (Object)hierarchy.getName(), (Object)cubeDimRef.getName(), (Object)cubeName);
                }
            }
            ROLAPMetaMdSchema.validateHierarchySecurityRules(cubeDimRef, hierarchy);
        }
    }

    private static void validateHierarchySecurityRules(ROLAPMetaCubeDimensionRef cubeDimRef, ROLAPMetaHierarchy hierarchy) {
        List<ROLAPMetaRule> ruleList;
        ROLAPMetaSecurityRules metaSecurityRules = hierarchy.getSecurityRules();
        if (metaSecurityRules != null && (ruleList = metaSecurityRules.getRules()) != null) {
            HashSet<String> ruleNames = new HashSet<String>();
            for (ROLAPMetaRule rule : ruleList) {
                if (ruleNames.add(rule.getName())) continue;
                String cubeName = cubeDimRef.getParent().getName();
                throw new ROLAPModelValidationException(XQEMessageKeys.ROL_DuplicateRule, rule.getName(), (Object)hierarchy.getName(), (Object)cubeDimRef.getName(), (Object)cubeName);
            }
        }
    }

    private static void validateSecurity(ROLAPMetaCube cube, ROLAPMetaSecurity security) throws ROLAPModelValidationException {
        ROLAPMetaObject viewsObj = security.getChild("ROLAPMetaViews");
        HashSet<String> viewNames = new HashSet<String>();
        if (viewsObj != null && viewsObj instanceof ROLAPMetaViews) {
            for (ROLAPMetaObject obj1 : viewsObj.getChildren()) {
                if (!(obj1 instanceof ROLAPMetaView)) continue;
                ROLAPMetaView viewObj = (ROLAPMetaView)obj1;
                ROLAPMetaMdSchema.validateSecurityView(cube, viewObj);
                if (viewNames.add(viewObj.getName())) continue;
                throw new ROLAPModelValidationException(XQEMessageKeys.ROL_DuplicateSecurityView, viewObj.getName(), cube.getName());
            }
        }
    }

    private static void validateSecurityView(ROLAPMetaCube cube, ROLAPMetaView viewObj) throws ROLAPModelValidationException {
        if (viewObj.getChildren() == null) {
            return;
        }
        for (ROLAPMetaObject obj : viewObj.getChildren()) {
            if (!(obj instanceof ROLAPMetaSecurityDimensionRef)) continue;
            ROLAPMetaSecurityDimensionRef dimRef = (ROLAPMetaSecurityDimensionRef)obj;
            if (dimRef.getDimension() == null && !dimRef.isMeasures()) {
                throw new ROLAPModelValidationException(XQEMessageKeys.ROL_SecurityReferenceNotFoundInCube, (Object)dimRef.getName(), (Object)viewObj.getName(), (Object)cube.getName());
            }
            if (dimRef.getChildren() == null) {
                throw new ROLAPModelValidationException(XQEMessageKeys.ROL_SecurityReferenceNoRules, dimRef.getName(), viewObj.getName());
            }
            for (ROLAPMetaObject obj2 : dimRef.getChildren()) {
                if (!(obj2 instanceof ROLAPMetaSecurityHierarchyRef)) continue;
                ROLAPMetaSecurityHierarchyRef hierRef = (ROLAPMetaSecurityHierarchyRef)obj2;
                if (hierRef.getHierarchy(dimRef.getName(), dimRef.getDimensionCategory()) == null && !dimRef.isMeasures()) {
                    String name = dimRef.getName() + "." + hierRef.getName();
                    throw new ROLAPModelValidationException(XQEMessageKeys.ROL_SecurityReferenceNotFoundInCube, (Object)name, (Object)viewObj.getName(), (Object)cube.getName());
                }
                for (ROLAPMetaObject obj3 : hierRef.getChildren()) {
                    if (!(obj3 instanceof ROLAPMetaRuleRef)) continue;
                    ROLAPMetaRuleRef ruleRef = (ROLAPMetaRuleRef)obj3;
                    ROLAPMetaRule rule = ruleRef.getRule();
                    if (rule == null) {
                        String name = dimRef.getName() + "." + hierRef.getName() + "." + ruleRef.getName();
                        throw new ROLAPModelValidationException(XQEMessageKeys.ROL_SecurityReferenceNotFoundInCube, (Object)name, (Object)viewObj.getName(), (Object)cube.getName());
                    }
                    if (ROLAPMetaRule.RuleType.deny_self_and_descendants != rule.getType() || rule.getGrantExpression() == null || rule.getGrantExpression().length() <= 0) continue;
                    String hierName = "[" + dimRef.getName() + "].[" + hierRef.getName() + "]";
                    throw new ROLAPModelValidationException(XQEMessageKeys.ROL_AllowExpressionNotAllowedInDenyDescendantsRuleType, rule.getName(), (Object)hierName, (Object)viewObj.getName(), (Object)ROLAPMetaRule.RuleType.deny_self_and_descendants.toString());
                }
            }
        }
    }

    public void setVersion(String pVersion) {
        this.version = pVersion;
    }

    public String getVersion() {
        return this.version;
    }
}

