/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaAggregation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaQueryItem;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.dom4j.Element;

public class ROLAPMetaMeasure
extends ROLAPMetaObject {
    private static final String FORMAT_ATTRIBUTTE_STR = "format";
    private static final String BLANK_FORMAT_STR = "<formatGroup> </formatGroup>";
    private ROLAPMetaAggregation[] aggregations = null;
    private String aggregationFunction = null;
    private String queryItem = null;
    private FormatId formatId = null;
    private Boolean isVisible = null;

    public FormatId getFormatId() {
        return this.formatId;
    }

    public void setInheritedFormatId(List<IMember> measuresList, List<String> identifersInCalcExpressionList) {
        if (this.formatId == null) {
            ArrayList<FormatId> inheritedFormatIdList = new ArrayList<FormatId>();
            for (IMember measure : measuresList) {
                FormatId id;
                if (!(measure instanceof IROLAPMeasure) || !ROLAPMeasure.matchesMeasure((IROLAPMeasure)measure, identifersInCalcExpressionList) || (id = ((IROLAPMeasure)measure).getFormatId()) == null) continue;
                inheritedFormatIdList.add(id);
            }
            if (inheritedFormatIdList.size() == 1) {
                this.formatId = (FormatId)inheritedFormatIdList.get(0);
            } else if (inheritedFormatIdList.size() > 0) {
                FormatId inheirtFormatId;
                this.formatId = inheirtFormatId = FormatService.getInstance().formatResult("Add", inheritedFormatIdList);
            }
        }
    }

    public static FormatId generateFormatId(String formatString) {
        if (formatString != null && formatString.trim().length() > 0 && !BLANK_FORMAT_STR.equals(formatString)) {
            try {
                FormatService formatService = FormatService.getInstance();
                formatString = ROLAPMetaMeasure.disableWhenFormatting(formatString, "whenMissing=\"[^\"]*\"");
                formatString = ROLAPMetaMeasure.disableWhenFormatting(formatString, "whenAnyError=\"[^\"]*\"");
                formatString = ROLAPMetaMeasure.disableWhenFormatting(formatString, "whenDivideZero=\"[^\"]*\"");
                formatString = formatString.replaceAll("&amp;", "&");
                return formatService.registerV5Format(formatString, null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    private static String disableWhenFormatting(String formatString, String pattern) {
        Pattern whenMissingPattern = Pattern.compile(pattern);
        String[] result = whenMissingPattern.split(formatString);
        if (result.length > 1) {
            formatString = result[0];
            for (int index = 1; index < result.length; ++index) {
                formatString = formatString + result[index].trim();
            }
        }
        return formatString;
    }

    public String getAggregationFunction() {
        if (this.aggregationFunction == null) {
            Element aggr = this.captureElement("aggregation");
            if (aggr != null) {
                this.aggregationFunction = aggr.attributeValue("function");
            }
            if (this.aggregationFunction == null) {
                this.aggregationFunction = "";
            }
        }
        return this.aggregationFunction;
    }

    public ROLAPMetaAggregation[] getAggregations() {
        if (this.aggregations == null) {
            Object aggr = null;
            ArrayList<ROLAPMetaAggregation> aggrList = new ArrayList<ROLAPMetaAggregation>();
            ArrayList<ROLAPMetaObject> children = this.getChildren();
            for (Object e : children) {
                if (!(e instanceof ROLAPMetaAggregation)) continue;
                aggrList.add((ROLAPMetaAggregation)e);
            }
            this.aggregations = aggrList.toArray(new ROLAPMetaAggregation[0]);
        }
        return this.aggregations;
    }

    public ROLAPMetaAggregation getBaseAggregation() {
        ROLAPMetaAggregation[] aggrs = this.getAggregations();
        Object aggr = null;
        if (aggrs.length == 0) {
            return null;
        }
        if (aggrs.length == 1) {
            return aggrs[0];
        }
        for (int i = 0; i < aggrs.length; ++i) {
            if (aggrs[i].getDimensions().length != 0) continue;
            return aggrs[i];
        }
        return null;
    }

    public int getNumAggregations() {
        return this.getAggregations().length;
    }

    public boolean isDimensionInAggregation(ROLAPMetaDimension metaDimension, int aggIndex) {
        List<ROLAPMetaDimension> aggDimensions = this.getAggregations()[aggIndex].getDimensionsAsList();
        return aggDimensions.contains(metaDimension);
    }

    public String getQueryItem() {
        if (this.queryItem == null) {
            this.queryItem = ((ROLAPMetaQueryItem)this.getFirstChildByType(ROLAPMetaQueryItem.class)).getRefObject();
        }
        return this.queryItem;
    }

    @Override
    public void captureContents() {
        super.captureContents();
        this.collectNames();
        this.collectDescriptions();
        this.collectComplete();
        this.getAggregationFunction();
        this.collectFormatId();
        this.isVisible();
        this.clearDOMNode();
    }

    private void collectFormatId() {
        this.formatId = ROLAPMetaMeasure.generateFormatId(this.captureAttribute(FORMAT_ATTRIBUTTE_STR));
    }

    public boolean isCalculated() {
        return false;
    }

    public boolean isVisible() {
        if (this.isVisible == null) {
            String visibleAttribute = this.captureAttribute("visible");
            this.isVisible = visibleAttribute == null ? Boolean.valueOf(true) : Boolean.valueOf("true".equalsIgnoreCase(visibleAttribute));
        }
        return this.isVisible;
    }
}

