/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDeny;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaFacts;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaGrant;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPSecurityDimHierarchy;

public class ROLAPMetaRule
extends ROLAPMetaObject {
    private ROLAPSecurityDimHierarchy dimHierarchy = null;
    private String strRuleType = null;
    private String strSecurityType = null;

    public String getGrantExpression() {
        String text = null;
        for (ROLAPMetaObject obj : this.getChildren()) {
            if (!(obj instanceof ROLAPMetaGrant)) continue;
            text = ((ROLAPMetaGrant)obj).getExpression();
            break;
        }
        return text;
    }

    public ROLAPMetaGrant getGrant() {
        for (ROLAPMetaObject obj : this.getChildren()) {
            if (!(obj instanceof ROLAPMetaGrant)) continue;
            return (ROLAPMetaGrant)obj;
        }
        return null;
    }

    public ROLAPMetaDeny getDeny() {
        for (ROLAPMetaObject obj : this.getChildren()) {
            if (!(obj instanceof ROLAPMetaDeny)) continue;
            return (ROLAPMetaDeny)obj;
        }
        return null;
    }

    public String getDenyExpression() {
        String text = null;
        for (ROLAPMetaObject obj : this.getChildren()) {
            if (!(obj instanceof ROLAPMetaDeny)) continue;
            text = ((ROLAPMetaDeny)obj).getExpression();
            break;
        }
        return text;
    }

    public ROLAPSecurityDimHierarchy getDimensionHierarchy() {
        if (this.dimHierarchy == null) {
            ROLAPMetaObject parent = this.getParent();
            while (this.dimHierarchy == null && parent != null) {
                if (parent instanceof ROLAPMetaHierarchy) {
                    this.dimHierarchy = new ROLAPSecurityDimHierarchy((ROLAPMetaHierarchy)parent);
                    continue;
                }
                if (parent instanceof ROLAPMetaDimension) {
                    this.dimHierarchy = new ROLAPSecurityDimHierarchy((ROLAPMetaDimension)parent);
                    continue;
                }
                if (parent instanceof ROLAPMetaFacts) {
                    this.dimHierarchy = new ROLAPSecurityDimHierarchy(this.getMetaCubeModel().getMeasureDimensionName());
                    continue;
                }
                parent = parent.getParent();
            }
        }
        return this.dimHierarchy;
    }

    public RuleType getType() {
        if (this.strRuleType != null && this.strRuleType.length() > 0) {
            return RuleType.valueOf(this.strRuleType);
        }
        return RuleType.none;
    }

    public SecurityType getSecurityType() {
        if (this.strSecurityType != null && this.strSecurityType.length() > 0) {
            return SecurityType.valueOf(this.strSecurityType);
        }
        return SecurityType.none;
    }

    @Override
    public void captureContents() {
        super.captureContents();
        this.strRuleType = this.captureAttribute("type");
        this.strSecurityType = this.captureAttribute("securityType");
    }

    public void setGrantExpression(String text) {
        for (ROLAPMetaObject obj : this.getChildren()) {
            if (!(obj instanceof ROLAPMetaGrant)) continue;
            ((ROLAPMetaGrant)obj).setExpressionText(text);
            break;
        }
    }

    public void setDenyExpression(String text) {
        for (ROLAPMetaObject obj : this.getChildren()) {
            if (!(obj instanceof ROLAPMetaDeny)) continue;
            ((ROLAPMetaDeny)obj).setExpressionText(text);
            break;
        }
    }

    public boolean isSecurityLookupRule() {
        ROLAPMetaDeny denyElem;
        ROLAPMetaGrant grantElem = this.getGrant();
        return grantElem != null ? grantElem.getLookupTableQueryItems() != null : (denyElem = this.getDeny()).getLookupTableQueryItems() != null;
    }

    public static enum SecurityType {
        value,
        member,
        attribute,
        dimension,
        none;

    }

    public static enum RuleType {
        deny_self_and_descendants,
        basic,
        none;

    }

    public static enum Scope {
        self,
        self_and_ascendants,
        self_and_descendants,
        self_and_ascendants_descendants;


        public boolean addDescendants() {
            return self_and_descendants == this || self_and_ascendants_descendants == this;
        }

        public boolean addAscendants() {
            return self_and_ascendants == this || self_and_ascendants_descendants == this;
        }
    }
}

