/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.model;

import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;

public class ROLAPSecurityDimHierarchy {
    private ROLAPMetaHierarchy hierarchy = null;
    private String measureHierarchyName = null;
    private boolean isMeasures = false;
    private boolean isDimension = false;
    private ROLAPMetaDimension dimension;

    public ROLAPSecurityDimHierarchy(ROLAPMetaHierarchy metaHierarchy) {
        this.isMeasures = false;
        this.isDimension = false;
        this.hierarchy = metaHierarchy;
    }

    public ROLAPSecurityDimHierarchy(String theMeasureHierarchyName) {
        this.isMeasures = true;
        this.isDimension = false;
        this.measureHierarchyName = theMeasureHierarchyName;
        this.hierarchy = null;
    }

    public ROLAPSecurityDimHierarchy(ROLAPMetaDimension metaDimension) {
        this.isMeasures = false;
        this.isDimension = true;
        this.hierarchy = null;
        this.dimension = metaDimension;
    }

    private boolean isMeasures() {
        return this.isMeasures;
    }

    public boolean isDimension() {
        return this.isDimension;
    }

    public String getHierarchyName() {
        if (this.isMeasures()) {
            return this.measureHierarchyName;
        }
        return this.hierarchy.getName();
    }

    public ROLAPMetaHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String getDimensionName() {
        if (this.isMeasures()) {
            return this.measureHierarchyName;
        }
        if (this.hierarchy != null) {
            return this.hierarchy.getDimensionName();
        }
        return this.dimension.getName();
    }

    public String getDimensionCategory() {
        if (this.isMeasures()) {
            return "private";
        }
        if (this.hierarchy != null) {
            return this.hierarchy.getDimensionCategory();
        }
        return this.dimension.getCategory();
    }

    public int hashCode() {
        if (this.hierarchy == null) {
            if (this.isMeasures) {
                return this.measureHierarchyName.hashCode();
            }
            return this.dimension.hashCode();
        }
        return this.hierarchy.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ROLAPSecurityDimHierarchy) {
            ROLAPSecurityDimHierarchy other = (ROLAPSecurityDimHierarchy)o;
            if (null == this.hierarchy) {
                if (this.isMeasures) {
                    return null == other.hierarchy;
                }
                return this.dimension.equals(other.dimension);
            }
            return this.hierarchy.equals(other.hierarchy);
        }
        return false;
    }
}

