/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.bibushandler.content.CMModelViewSearchKey;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMModelViewSearchKey;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.MembersIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDeny;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaGrant;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLookupTableQueryItem;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaRule;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaView;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPSecurityDimHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPUserSecurityContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewCombinationHierarchyRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewCombinationRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewHierarchyLookupTableRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewHierarchyRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewRestriction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecurityLookupQuery;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecurityLookupQueryCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.V5ExpressionUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.CompositionBuilder;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.util.UniqueNameParser;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class SecManager
implements IROLAPSecurityManager {
    public static final String ALL_ACCESS_AUTHORIZATION_KEY = "Security not enabled";
    private Set<String> overrideModelViews = null;
    private boolean overrideIsSysAdmin = false;
    private static final String PERIOD = ".";
    private static final String SPACE = " ";
    private static final String QUOTE_CHAR = "\"";
    private static final String DENYING_MEMBERS = "Denying all members of hierarchy ";
    private static final String IN_CUBE = " in cube ";
    private static final String QUOTE_FOR_CUBE = "\" for cube ";
    private static final String IN_SECURITY_VIEW = " in security view ";
    public static final HashSet<IMember> EMPTY_SET = new HashSet();
    public static final HashSet<IProperty> EMPTY_ATTRIBUTES_SET = new HashSet();
    private static final SecViewHierarchyRestriction DENY_ALL_HIERARCHY_RESTRICTION = new SecViewHierarchyRestriction(EMPTY_SET, EMPTY_SET, EMPTY_SET, EMPTY_SET, true, SecViewHierarchyRestriction.GrantType.NONE);
    protected static final String DENY_ALL_VIEW_NAME = "<Deny All>";
    private static boolean globalEnableSecurity = true;
    private final ROLAPBaseCube cube;
    private boolean hasAllAccess = false;
    private Map<String, ROLAPMetaView> securityViewDefinitions = null;
    private Map<String, SecViewRestriction> viewRestrictions = new HashMap<String, SecViewRestriction>();
    private SecViewRestriction denyAllView = null;
    private final ICMModelViewSearchKey securityModelViewSearchKey;
    boolean isAllDenied = false;
    private SecurityLookupQueryCache mLookupQueryCache = new SecurityLookupQueryCache();
    private final ConcurrentHashMap<String, SecViewCombinationRestriction> viewCombinationsToRestrictionMap = new ConcurrentHashMap();
    private boolean isSecurityAudit;

    public SecManager(ROLAPBaseCube rolapBaseCube, Map<String, ROLAPMetaView> securityViews) {
        this.cube = rolapBaseCube;
        this.securityViewDefinitions = securityViews;
        this.securityModelViewSearchKey = new CMModelViewSearchKey(this.cube.getModelSearchPath() + "/modelView", "[permission('read')]");
        int numSecurityViews = 0;
        if (this.securityViewDefinitions != null) {
            numSecurityViews = this.securityViewDefinitions.size();
        }
        ROLAPLog.log("ROLAPCubes.Security", "Building security manager for cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()) + " with " + numSecurityViews + " security view definitions.");
        if (numSecurityViews > 0) {
            this.hasAllAccess = false;
            this.denyAllView = this.buildDenyAllView();
            this.initializeAllViewRestrictions();
            ROLAPLog.log("ROLAPCubes.Security", "Security manager built with " + this.viewRestrictions.size() + " loaded security views in cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()));
        } else {
            this.hasAllAccess = true;
            ROLAPLog.log("ROLAPCubes.Security", "Security manager built with no security views defined, so all members visible in cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()));
        }
    }

    public SecManager(SecManager previousSecManager, boolean recalculateMembers) {
        this.cube = previousSecManager.cube;
        this.securityViewDefinitions = previousSecManager.securityViewDefinitions;
        this.hasAllAccess = previousSecManager.hasAllAccess;
        this.denyAllView = previousSecManager.denyAllView;
        this.securityModelViewSearchKey = previousSecManager.securityModelViewSearchKey;
        ROLAPLog.log("ROLAPCubes.Security", "Rebuilding security manager for cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()) + " with recalculateMembers " + recalculateMembers);
        if (recalculateMembers) {
            this.initializeAllViewRestrictions();
        } else {
            this.viewRestrictions = previousSecManager.viewRestrictions;
            ROLAPLog.log("ROLAPCubes.Security", "Copied over " + this.viewRestrictions.size() + " view restrictions for cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()));
        }
        ROLAPLog.log("ROLAPCubes.Security", "Security manager built from previous security manager for cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()));
    }

    @Override
    public ISet[] applySecurity(ISet[] inputSets, InterpreterContext interpreterContext) {
        if (inputSets == null || inputSets.length == 0 || this.isAllAccess()) {
            return inputSets;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        ISet[] outputSets = new com.cognos.xqe.runtree.olap.mdx.interpreter.Set[inputSets.length];
        for (int i = 0; i < inputSets.length; ++i) {
            com.cognos.xqe.runtree.olap.mdx.interpreter.Set inputSet = (com.cognos.xqe.runtree.olap.mdx.interpreter.Set)inputSets[i];
            outputSets[i] = this.applySecurity(inputSet, viewCombinationRestriction);
        }
        return outputSets;
    }

    private SecViewRestriction buildDenyAllView() {
        SecViewRestriction restriction = new SecViewRestriction(DENY_ALL_VIEW_NAME);
        for (IDimension dimension : this.cube.getDimensions()) {
            for (IHierarchy hierarchy : dimension.getHierarchies()) {
                restriction.addRestriction(hierarchy, DENY_ALL_HIERARCHY_RESTRICTION, SecurityType.member);
            }
        }
        return restriction;
    }

    public com.cognos.xqe.runtree.olap.mdx.interpreter.Set applySecurity(com.cognos.xqe.runtree.olap.mdx.interpreter.Set inputSet, SecViewCombinationRestriction viewCombinationRestriction) {
        if (inputSet == null || inputSet.isEmpty() || this.isAllAccess()) {
            return inputSet;
        }
        boolean[] tupleHierarchyHasSecuredMember = this.buildHierarchyRestrictionArrayFor(inputSet.getTuple(0L), viewCombinationRestriction);
        if (!this.hasRestrictions(tupleHierarchyHasSecuredMember)) {
            return inputSet;
        }
        ArrayList<IMember> slicerMembers = new ArrayList<IMember>();
        com.cognos.xqe.runtree.olap.mdx.interpreter.Set setWithRestHiers = this.getMultiTupleSetWithRestrictedHierarchies(inputSet, slicerMembers);
        ITupleList setWithRestHiersTL = setWithRestHiers.getTupleList();
        if (this.areAllTuplesNotRestricted(this.getUserSecurityContext(), setWithRestHiersTL)) {
            return inputSet;
        }
        TupleListFilter filter = new TupleListFilter(inputSet.size());
        long tupleOrd = 0L;
        HashSet<IMember> securedMemberSet = new HashSet<IMember>();
        MembersIterator mIter = new MembersIterator(setWithRestHiersTL.iterator());
        while (mIter.hasNext()) {
            IMember[] membersFromTheTuple = mIter.next();
            if (!this.isRestricted(membersFromTheTuple, tupleHierarchyHasSecuredMember, viewCombinationRestriction, securedMemberSet)) {
                filter.enable(tupleOrd);
            }
            ++tupleOrd;
        }
        if (inputSet.size() == filter.cardinality()) {
            return inputSet;
        }
        com.cognos.xqe.runtree.olap.mdx.interpreter.Set securedSet = inputSet.getFilteredSet(filter);
        return securedSet;
    }

    public com.cognos.xqe.runtree.olap.mdx.interpreter.Set getMultiTupleSetWithRestrictedHierarchies(com.cognos.xqe.runtree.olap.mdx.interpreter.Set inputSet, List<IMember> slicerMembers) {
        if (!(inputSet instanceof CrossJoinedSet)) {
            return inputSet;
        }
        CrossJoinedSet cjSet = (CrossJoinedSet)inputSet;
        com.cognos.xqe.runtree.olap.mdx.interpreter.Set[] sets = cjSet.getSets();
        ArrayList<com.cognos.xqe.runtree.olap.mdx.interpreter.Set> multiTupleSets = new ArrayList<com.cognos.xqe.runtree.olap.mdx.interpreter.Set>();
        for (com.cognos.xqe.runtree.olap.mdx.interpreter.Set set : sets) {
            if (set.size() == 1L) {
                slicerMembers.addAll(Arrays.asList(set.getTuple(0L).getMembers()));
                continue;
            }
            multiTupleSets.add(set);
        }
        if (slicerMembers.size() == 0) {
            return inputSet;
        }
        Tuple slicerTuple = new Tuple(slicerMembers.toArray(new IMember[slicerMembers.size()]), (ICube)this.cube);
        IHierarchy[] slicerHierarchies = slicerTuple.getHierarchies();
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        Set<IHierarchy> restrictedHierarchies = viewCombinationRestriction.getMemberOrValueRestrictedHierarchies();
        boolean restrictedHiersInSlicer = false;
        for (IHierarchy slicerHierarchy : slicerHierarchies) {
            if (!restrictedHierarchies.contains(slicerHierarchy)) continue;
            restrictedHiersInSlicer = true;
            break;
        }
        com.cognos.xqe.runtree.olap.mdx.interpreter.Set setToCheck = cjSet;
        if (!restrictedHiersInSlicer && multiTupleSets.size() > 0) {
            setToCheck = multiTupleSets.size() == 1 ? (com.cognos.xqe.runtree.olap.mdx.interpreter.Set)multiTupleSets.get(0) : new CrossJoinedSet(multiTupleSets.toArray(new com.cognos.xqe.runtree.olap.mdx.interpreter.Set[multiTupleSets.size()]));
        }
        return setToCheck;
    }

    private boolean hasRestrictions(boolean[] tupleHierarchyHasSecuredMember) {
        boolean isSomeHierarchyRestricted = false;
        for (boolean hierarchyRestricted : tupleHierarchyHasSecuredMember) {
            if (!hierarchyRestricted) continue;
            isSomeHierarchyRestricted = true;
            break;
        }
        return isSomeHierarchyRestricted;
    }

    private boolean[] buildHierarchyRestrictionArrayFor(ITuple tuple, SecViewCombinationRestriction viewCombinationRestriction) {
        boolean[] hierarchyRestricted = new boolean[tuple.size()];
        int memberCount = tuple.size();
        for (int i = 0; i < memberCount; ++i) {
            IMember member = tuple.getMember(i);
            hierarchyRestricted[i] = viewCombinationRestriction.hasRestriction(member.getHierarchy(), SecurityType.member);
        }
        return hierarchyRestricted;
    }

    @Override
    public Level[] applySecurity(Level[] levels) {
        if (levels == null || levels.length == 0 || this.isAllAccess()) {
            return levels;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        ArrayList<Level> outputLevels = new ArrayList<Level>(levels.length);
        for (int i = 0; i < levels.length; ++i) {
            Level level = levels[i];
            if (viewCombinationRestriction.isRestricted(level)) continue;
            outputLevels.add(level);
        }
        if (levels.length == outputLevels.size()) {
            return levels;
        }
        return outputLevels.toArray(new Level[outputLevels.size()]);
    }

    public IMember[] filterSecurityPaddingMembersFromOriginalArray(IMember[] originalMembers) {
        ArrayList<IMember> visibleMembers = new ArrayList<IMember>(originalMembers.length);
        boolean wasModified = false;
        for (int i = 0; i < originalMembers.length; ++i) {
            IMember member = originalMembers[i];
            if (member instanceof ROLAPSecurityPaddingMemberProxy) {
                wasModified = true;
                continue;
            }
            visibleMembers.add(member);
        }
        if (wasModified) {
            return visibleMembers.toArray(new IMember[visibleMembers.size()]);
        }
        return originalMembers;
    }

    @Override
    public IMember[] applySecurity(IMember[] members, IHierarchy hierarchy) {
        if (members == null || members.length == 0 || this.isAllAccess()) {
            IMember[] visibleMembers = this.filterSecurityPaddingMembersFromOriginalArray(members);
            return visibleMembers;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        if (hierarchy != null && !viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.member)) {
            IMember[] visibleMembers = this.filterSecurityPaddingMembersFromOriginalArray(members);
            return visibleMembers;
        }
        ArrayList<IMember> outputMembers = new ArrayList<IMember>(members.length);
        for (int i = 0; i < members.length; ++i) {
            IMember member = members[i];
            if (viewCombinationRestriction.isSecuredMember(member = this.checkAndGetRolapCalculatedMember(member))) continue;
            outputMembers.add(member);
        }
        if (members.length == outputMembers.size()) {
            return members;
        }
        return outputMembers.toArray(new IMember[outputMembers.size()]);
    }

    public IMember[] applySecurity(ROLAPUserSecurityContext secContext, IMember[] members, IHierarchy hierarchy) {
        if (members == null || members.length == 0 || secContext.getIsAllAccess()) {
            IMember[] visibleMembers = this.filterSecurityPaddingMembersFromOriginalArray(members);
            return visibleMembers;
        }
        SecViewCombinationRestriction viewCombinationRestriction = secContext.getViewCombinationRestriction();
        if (hierarchy != null && !viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.member)) {
            IMember[] visibleMembers = this.filterSecurityPaddingMembersFromOriginalArray(members);
            return visibleMembers;
        }
        ArrayList<IMember> outputMembers = new ArrayList<IMember>(members.length);
        for (int i = 0; i < members.length; ++i) {
            IMember member = members[i];
            if (viewCombinationRestriction.isSecuredMember(member = this.checkAndGetRolapCalculatedMember(member))) continue;
            outputMembers.add(member);
        }
        if (members.length == outputMembers.size()) {
            return members;
        }
        return outputMembers.toArray(new IMember[outputMembers.size()]);
    }

    public IMember[] applySecurity(ROLAPUserSecurityContext secContext, ILevel level) {
        if (((Level)level).getMemberCount() == 0 || secContext.getIsAllAccess()) {
            List<IMember> members = level.getMembers();
            return members.toArray(new IMember[members.size()]);
        }
        IHierarchy hierarchy = level.getHierarchy();
        int levelIndex = level.getIndex();
        SecViewCombinationRestriction viewCombinationRestriction = secContext.getViewCombinationRestriction();
        if (hierarchy != null && !viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.member)) {
            List<IMember> levelMembers = level.getMembers();
            return levelMembers.toArray(new IMember[levelMembers.size()]);
        }
        IMember[] members = ((Level)level).getAllMembers();
        IMember[] unsecuredLevelMembers = null;
        MostRecentlyCheckedAncestors mrcgAncestors = new MostRecentlyCheckedAncestors(levelIndex);
        MostRecentlyCheckedAncestors mrcdAncestors = new MostRecentlyCheckedAncestors(levelIndex);
        SecViewCombinationHierarchyRestriction viewCombHierarchyRestriction = viewCombinationRestriction.getRestriction(hierarchy, SecurityType.member);
        Integer unsecMemberCount = viewCombHierarchyRestriction.getUnSecuredMemberCount(level);
        if (unsecMemberCount == null) {
            ArrayList<IMember> outputMembers = new ArrayList<IMember>(members.length);
            for (IMember levelMember : members) {
                if (((IMemberCubics)levelMember).isFillerMember() || ((IMemberCubics)levelMember).isHidden() || viewCombinationRestriction.isSecuredMember(levelMember, viewCombHierarchyRestriction, mrcgAncestors, mrcdAncestors)) continue;
                outputMembers.add(levelMember);
            }
            viewCombHierarchyRestriction.setUnSecuredMemberCount(level, outputMembers.size());
            unsecuredLevelMembers = outputMembers.toArray(new IMember[outputMembers.size()]);
        } else {
            unsecuredLevelMembers = new IMember[unsecMemberCount.intValue()];
            int unsecMemIdx = 0;
            for (IMember levelMember : members) {
                if (((IMemberCubics)levelMember).isFillerMember() || ((IMemberCubics)levelMember).isHidden() || viewCombinationRestriction.isSecuredMember(levelMember, viewCombHierarchyRestriction, mrcgAncestors, mrcdAncestors)) continue;
                unsecuredLevelMembers[unsecMemIdx++] = levelMember;
            }
        }
        return unsecuredLevelMembers;
    }

    public List<IMember> applySecurity(ROLAPUserSecurityContext secContext, List<IMember> members, IHierarchy hierarchy, int levelIndex) {
        if (members == null || members.size() == 0 || secContext.getIsAllAccess()) {
            return members;
        }
        SecViewCombinationRestriction viewCombinationRestriction = secContext.getViewCombinationRestriction();
        if (hierarchy != null && !viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.member)) {
            return members;
        }
        MostRecentlyCheckedAncestors mrcgAncestors = new MostRecentlyCheckedAncestors(levelIndex);
        MostRecentlyCheckedAncestors mrcdAncestors = new MostRecentlyCheckedAncestors(levelIndex);
        SecViewCombinationHierarchyRestriction hierarchyRestriction = viewCombinationRestriction.getRestriction(hierarchy, SecurityType.member);
        ArrayList<IMember> outputMembers = new ArrayList<IMember>(members.size());
        for (IMember levelMember : members) {
            if (viewCombinationRestriction.isSecuredMember(levelMember, hierarchyRestriction, mrcgAncestors, mrcdAncestors)) continue;
            outputMembers.add(levelMember);
        }
        if (members.size() == outputMembers.size()) {
            return members;
        }
        return outputMembers;
    }

    @Override
    public Dimension[] applySecurity(Dimension[] dimensions) {
        if (dimensions == null || dimensions.length == 0 || this.isAllAccess()) {
            return dimensions;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        ArrayList<Dimension> outputDimensions = new ArrayList<Dimension>(dimensions.length);
        for (int i = 0; i < dimensions.length; ++i) {
            Dimension dimension = dimensions[i];
            if (viewCombinationRestriction.isRestricted(dimension)) continue;
            outputDimensions.add(dimension);
        }
        if (dimensions.length == outputDimensions.size()) {
            return dimensions;
        }
        return outputDimensions.toArray(new Dimension[outputDimensions.size()]);
    }

    @Override
    public Hierarchy[] applySecurity(Hierarchy[] hierarchies) {
        if (hierarchies == null || hierarchies.length == 0 || this.isAllAccess()) {
            return hierarchies;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        ArrayList<Hierarchy> outputHierarchies = new ArrayList<Hierarchy>(hierarchies.length);
        for (int i = 0; i < hierarchies.length; ++i) {
            Hierarchy hierarchy = hierarchies[i];
            if (viewCombinationRestriction.isRestricted(hierarchy)) continue;
            outputHierarchies.add(hierarchy);
        }
        if (hierarchies.length == outputHierarchies.size()) {
            return hierarchies;
        }
        return outputHierarchies.toArray(new Hierarchy[outputHierarchies.size()]);
    }

    @Override
    public ISet filterSecureValueMembers(ISet set) {
        if (set == null || set.size() == 0L || this.isAllAccess()) {
            return set;
        }
        boolean selectionWasModified = false;
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        Set<IHierarchy> securedHierarchies = viewCombinationRestriction.getSecuredValueHierarchies();
        if (securedHierarchies != null && securedHierarchies.size() > 0) {
            IHierarchy[] setHierarchies = set.getHierarchies();
            HashSet<IMember>[] selections = ((com.cognos.xqe.runtree.olap.mdx.interpreter.Set)set).selectionsInHierarchies(setHierarchies);
            for (int i = 0; i < setHierarchies.length; ++i) {
                if (!securedHierarchies.contains(setHierarchies[i])) continue;
                HashSet<IMember> hierarchyMembers = selections[i];
                Iterator hierarchyMemberIter = hierarchyMembers.iterator();
                while (hierarchyMemberIter.hasNext()) {
                    IMember member = (IMember)hierarchyMemberIter.next();
                    if (!viewCombinationRestriction.isSecuredValueMember(member = this.checkAndGetRolapCalculatedMember(member))) continue;
                    hierarchyMemberIter.remove();
                    selectionWasModified = true;
                }
                if (!hierarchyMembers.isEmpty()) continue;
                return null;
            }
            if (selectionWasModified) {
                return BlockTupleStorageUtil.createCjsFromMemberSelections(selections);
            }
        }
        return set;
    }

    @Override
    public IMember[] filterSecureValueMembers(IMember[] members) {
        if (members == null || members.length == 0 || this.isAllAccess()) {
            return members;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        ArrayList<IMember> outputMembers = new ArrayList<IMember>(members.length);
        for (int i = 0; i < members.length; ++i) {
            IMember member = members[i];
            if (viewCombinationRestriction.isSecuredValueMember(member = this.checkAndGetRolapCalculatedMember(member))) continue;
            outputMembers.add(member);
        }
        if (members.length == outputMembers.size()) {
            return members;
        }
        return outputMembers.toArray(new IMember[outputMembers.size()]);
    }

    @Override
    public boolean isValueSecured(IMember member) {
        if (member == null || this.isAllAccess()) {
            return false;
        }
        boolean restricted = false;
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        member = this.checkAndGetRolapCalculatedMember(member);
        restricted = viewCombinationRestriction.isSecuredValueMember(member);
        return restricted;
    }

    @Override
    public IMember getDefaultMember(IDimension dimension) throws MetadataException {
        IHierarchy hierarchy = dimension.getDefaultHierarchy();
        return this.getDefaultMember(hierarchy);
    }

    @Override
    public IMember getDefaultMember(IHierarchy hierarchy) throws MetadataException {
        SecViewCombinationRestriction viewCombinationRestriction;
        IMember defaultMember = hierarchy.getDefaultMember();
        if (!this.isAllAccess() && (defaultMember = (viewCombinationRestriction = this.getViewCombinationRestriction()).getDefaultMember(hierarchy)) == null && viewCombinationRestriction.isAllDenied()) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_AllHierarchiesDenied, hierarchy.getName());
        }
        if (defaultMember == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidDefaultMember, hierarchy.getName());
        }
        return defaultMember;
    }

    @Override
    public boolean hasRestrictions(IHierarchy hierarchy) {
        if (this.isAllAccess()) {
            return false;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        return viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.member) || viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.value) || viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.attribute);
    }

    @Override
    public boolean isAllAccess() {
        return this.hasNoRestrictions() || this.isUserSysAdmin();
    }

    @Override
    public boolean hasNoRestrictions() {
        return !globalEnableSecurity || this.hasAllAccess;
    }

    private boolean isRestricted(ITuple tuple, boolean[] hierarchiesRestricted, SecViewCombinationRestriction viewCombinationRestriction) {
        int memberCount = tuple.size();
        for (int i = 0; i < memberCount; ++i) {
            if (!hierarchiesRestricted[i]) continue;
            IMember member = tuple.getMember(i);
            if (!viewCombinationRestriction.isSecuredMember(member = this.checkAndGetRolapCalculatedMember(member))) continue;
            return true;
        }
        return false;
    }

    private boolean isRestricted(IMember[] members, boolean[] hierarchiesRestricted, SecViewCombinationRestriction viewCombinationRestriction, HashSet<IMember> securedMemberSet) {
        int memberCount = members.length;
        for (int i = 0; i < memberCount; ++i) {
            if (!hierarchiesRestricted[i]) continue;
            IMember member = members[i];
            if (securedMemberSet.contains(member)) {
                return true;
            }
            if (!viewCombinationRestriction.isSecuredMember(member = this.checkAndGetRolapCalculatedMember(member))) continue;
            securedMemberSet.add(member);
            return true;
        }
        return false;
    }

    private IMember checkAndGetRolapCalculatedMember(IMember member) {
        String originalV5Name;
        if (member != null && member.isCalculatedMember() && member instanceof CalculatedMember && (originalV5Name = ((CalculatedMember)member).getOriginalV5Name()) != null) {
            member = member.isMeasure() ? this.cube.getMeasure(originalV5Name) : this.cube.getCalculatedMember(UniqueNameGenerator.createProviderMemberUniqueName("RO", UniqueNameGenerator.extractPhysicalPartFromCognosMUN(originalV5Name)));
        }
        return member;
    }

    private void initializeAllViewRestrictions() {
        if (this.securityViewDefinitions == null || this.securityViewDefinitions.size() == 0) {
            return;
        }
        for (ROLAPMetaView metaSecView : this.securityViewDefinitions.values()) {
            this.initializeSecViewRestriction(metaSecView);
        }
    }

    public void initializeSecViewRestriction(ROLAPMetaView metaSecView) {
        HashMap<ROLAPSecurityDimHierarchy, ArrayList<ROLAPMetaRule>> hierToRuleMap = new HashMap<ROLAPSecurityDimHierarchy, ArrayList<ROLAPMetaRule>>();
        for (ROLAPMetaRule metaRule : metaSecView.getRules()) {
            ROLAPSecurityDimHierarchy dimHierarchy = metaRule.getDimensionHierarchy();
            ROLAPMetaHierarchy metaHierarchy = dimHierarchy.getHierarchy();
            if (metaHierarchy != null && metaHierarchy.hasRelativeTimeMembers()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidSecurityOnRelativeTimeHierarchy, metaHierarchy.getName());
            }
            ArrayList<ROLAPMetaRule> rules = (ArrayList<ROLAPMetaRule>)hierToRuleMap.get(dimHierarchy);
            if (rules == null) {
                rules = new ArrayList<ROLAPMetaRule>();
                hierToRuleMap.put(dimHierarchy, rules);
            }
            rules.add(metaRule);
        }
        SecViewRestriction restriction = this.initializeSecViewRestriction(metaSecView, hierToRuleMap);
        if (restriction != null) {
            this.viewRestrictions.put(restriction.getName(), restriction);
            StringBuilder allRuleNames = new StringBuilder();
            List<ROLAPMetaRule> rules = metaSecView.getRules();
            for (ROLAPMetaRule rule : rules) {
                if (allRuleNames.length() != 0) {
                    allRuleNames.append(", ");
                }
                allRuleNames.append("[").append(rule.getName()).append("]");
            }
            ROLAPLog.log("ROLAPCubes.Security", "Added security view \"" + metaSecView.getName() + " with corresponding rules: " + allRuleNames.toString());
        } else {
            ROLAPLog.log("ROLAPCubes.Security", "Skipping security view \"" + metaSecView.getName() + QUOTE_CHAR + IN_CUBE + UniqueNameGenerator.createUniqueName(this.cube.getName()));
        }
    }

    private SecViewRestriction initializeSecViewRestriction(ROLAPMetaView metaSecView, Map<ROLAPSecurityDimHierarchy, ArrayList<ROLAPMetaRule>> hierToRuleMap) {
        String viewName = metaSecView.getName();
        ROLAPLog.log("ROLAPCubes.Security", "Building security view \"" + viewName + QUOTE_FOR_CUBE + UniqueNameGenerator.createUniqueName(this.cube.getName()));
        SecViewRestriction restriction = new SecViewRestriction(viewName);
        for (ArrayList<ROLAPMetaRule> rules : hierToRuleMap.values()) {
            SecViewHierarchyRestriction hierarchyAttributeRestriction;
            SecViewHierarchyLookupTableRestriction hierarchyMemberSecLookupRest;
            ROLAPSecurityDimHierarchy securityDimensionHierarchy = rules.get(0).getDimensionHierarchy();
            IROLAPDimension dimension = this.getRuleDimension(securityDimensionHierarchy);
            if (dimension == null) {
                ROLAPLog.log("ROLAPCubes.Security", "Dimension [" + securityDimensionHierarchy.getDimensionName() + "] missing in running cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()));
                return null;
            }
            if (securityDimensionHierarchy.isDimension()) {
                for (ROLAPMetaRule rule : rules) {
                    ROLAPMetaDeny deny;
                    ROLAPMetaGrant grant = rule.getGrant();
                    if (grant != null) {
                        String expression = grant.getExpression();
                        if (dimension.getV5UniqueName(this.cube.getName()).equalsIgnoreCase(expression)) {
                            restriction.addDimensionGranted(dimension);
                        }
                    }
                    if ((deny = rule.getDeny()) == null) continue;
                    String expression = deny.getExpression();
                    if (!dimension.getV5UniqueName(this.cube.getName()).equalsIgnoreCase(expression)) continue;
                    restriction.addDimensionDenied(dimension);
                }
                continue;
            }
            IROLAPHierarchy hierarchy = this.getRuleHierarchy(dimension, securityDimensionHierarchy);
            if (hierarchy == null) {
                ROLAPLog.log("ROLAPCubes.Security", "Hierarchy [" + securityDimensionHierarchy.getHierarchyName() + "] in dimension [" + securityDimensionHierarchy.getDimensionName() + "] is missing in running cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()));
                return null;
            }
            Map<IMember, List<IMember>> calcMemberMap = this.buildCalcMemberMap(hierarchy);
            HashSet<IMember> grantedSelves = new HashSet<IMember>();
            HashSet<IMember> grantedAncestors = new HashSet<IMember>();
            HashSet<IMember> deniedSelves = new HashSet<IMember>();
            HashSet<IMember> deniedAncestors = new HashSet<IMember>();
            HashSet<IMember> grantedValueSelves = new HashSet<IMember>();
            HashSet<IMember> grantedValueAncestors = new HashSet<IMember>();
            HashSet<IMember> deniedValueSelves = new HashSet<IMember>();
            HashSet<IMember> deniedValueAncestors = new HashSet<IMember>();
            HashSet visibleAncestors = new HashSet();
            HashSet<IProperty> deniedAttributes = new HashSet<IProperty>();
            HashSet<IProperty> grantedAttributes = new HashSet<IProperty>();
            ArrayList<SecurityLookupQuery> grantSecLookupQueries = new ArrayList<SecurityLookupQuery>();
            ArrayList<SecurityLookupQuery> denySecLookupQueries = new ArrayList<SecurityLookupQuery>();
            SecViewHierarchyRestriction.GrantType membersGrantType = SecViewHierarchyRestriction.GrantType.NONE;
            SecViewHierarchyRestriction.GrantType valuesGrantType = SecViewHierarchyRestriction.GrantType.NONE;
            SecViewHierarchyRestriction.GrantType attributesGrantType = SecViewHierarchyRestriction.GrantType.NONE;
            boolean isAllMembersDenied = false;
            boolean isAllValuesDenied = false;
            boolean onlyMemberSecLookupRules = true;
            String expression = null;
            String ruleName = null;
            ROLAPMetaRule rule = null;
            try {
                for (int ruleIdx = 0; ruleIdx < rules.size(); ++ruleIdx) {
                    ROLAPMetaDeny deny;
                    rule = rules.get(ruleIdx);
                    ruleName = rule.getName();
                    ROLAPMetaGrant grant = rule.getGrant();
                    if (grant != null) {
                        if (ROLAPMetaRule.SecurityType.member == rule.getSecurityType() || ROLAPMetaRule.SecurityType.none == rule.getSecurityType()) {
                            if (membersGrantType == SecViewHierarchyRestriction.GrantType.ALL || grant.isAllGranted()) {
                                onlyMemberSecLookupRules = false;
                                membersGrantType = SecViewHierarchyRestriction.GrantType.ALL;
                                grantedSelves.clear();
                                visibleAncestors.clear();
                                grantSecLookupQueries.clear();
                                denySecLookupQueries.clear();
                            } else {
                                membersGrantType = SecViewHierarchyRestriction.GrantType.EXPR;
                                List<ROLAPMetaLookupTableQueryItem> lookupTableQueryItems = grant.getLookupTableQueryItems();
                                if (lookupTableQueryItems != null) {
                                    this.addSecurityLookupQuery((ROLAPHierarchy)hierarchy, grantSecLookupQueries, grant.getLookupTableFilter(), lookupTableQueryItems, grant.getScope());
                                } else {
                                    onlyMemberSecLookupRules = false;
                                    this.addMembers(grantedSelves, grantedAncestors, grant.getExpression(), hierarchy, grant.getScope(), RuleType.grant_member);
                                }
                            }
                        } else if (ROLAPMetaRule.SecurityType.value == rule.getSecurityType()) {
                            onlyMemberSecLookupRules = false;
                            if (valuesGrantType == SecViewHierarchyRestriction.GrantType.ALL || grant.isAllGranted()) {
                                valuesGrantType = SecViewHierarchyRestriction.GrantType.ALL;
                                grantedValueSelves.clear();
                                grantedValueAncestors.clear();
                            } else {
                                valuesGrantType = SecViewHierarchyRestriction.GrantType.EXPR;
                                this.addMembers(grantedValueSelves, grantedValueAncestors, grant.getExpression(), hierarchy, grant.getScope(), RuleType.grant_value);
                            }
                        } else if (ROLAPMetaRule.SecurityType.attribute == rule.getSecurityType()) {
                            attributesGrantType = SecViewHierarchyRestriction.GrantType.EXPR;
                            this.addAttributes(grantedAttributes, grant.getExpression(), hierarchy, grant.getScope(), RuleType.grant_attribute);
                        }
                    }
                    if ((deny = rule.getDeny()) == null) continue;
                    expression = deny.getExpression();
                    ROLAPMetaRule.Scope scope = ROLAPMetaRule.Scope.self;
                    if (ROLAPMetaRule.SecurityType.member == rule.getSecurityType() || ROLAPMetaRule.SecurityType.none == rule.getSecurityType()) {
                        scope = ROLAPMetaRule.Scope.self_and_descendants;
                        List<ROLAPMetaLookupTableQueryItem> lookupTableQueryItems = deny.getLookupTableQueryItems();
                        if (lookupTableQueryItems != null) {
                            this.addSecurityLookupQuery((ROLAPHierarchy)hierarchy, denySecLookupQueries, deny.getLookupTableFilter(), lookupTableQueryItems, scope);
                            continue;
                        }
                        onlyMemberSecLookupRules = false;
                        this.addMembers(deniedSelves, deniedAncestors, expression, hierarchy, scope, RuleType.deny_member);
                        continue;
                    }
                    if (ROLAPMetaRule.SecurityType.attribute == rule.getSecurityType()) {
                        scope = ROLAPMetaRule.Scope.self;
                        this.addAttributes(deniedAttributes, expression, hierarchy, scope, RuleType.deny_attribute);
                        continue;
                    }
                    onlyMemberSecLookupRules = false;
                    if (ROLAPMetaRule.RuleType.basic != rule.getType()) {
                        scope = ROLAPMetaRule.Scope.self_and_descendants;
                    }
                    this.addMembers(deniedValueSelves, deniedValueAncestors, deny.getExpression(), hierarchy, scope, RuleType.deny_value);
                }
                ruleName = null;
            }
            catch (Exception ex) {
                if (rule != null && ruleName != null) {
                    String errorMessage = DENYING_MEMBERS + hierarchy.getUniqueName() + IN_SECURITY_VIEW + UniqueNameGenerator.createUniqueName(viewName) + IN_CUBE + UniqueNameGenerator.createUniqueName(this.cube.getName());
                    errorMessage = rule.isSecurityLookupRule() ? errorMessage + " because of error setting up lookup table rule \"" + ruleName + QUOTE_CHAR + PERIOD + SPACE : errorMessage + " because of error evaluating expression in rule \"" + ruleName + QUOTE_CHAR + ".  Expression text " + expression;
                    ROLAPLog.logError("ROLAPCubes.Security", errorMessage, ex);
                } else {
                    ROLAPLog.logError("ROLAPCubes.Security", DENYING_MEMBERS + hierarchy.getUniqueName() + IN_SECURITY_VIEW + UniqueNameGenerator.createUniqueName(viewName) + IN_CUBE + UniqueNameGenerator.createUniqueName(this.cube.getName()) + ". ", ex);
                }
                XQEDebugLog.err.printStackTrace(ex);
                grantedSelves.clear();
                grantedAncestors.clear();
                deniedSelves.clear();
                deniedAncestors.clear();
                grantedValueSelves.clear();
                grantedValueAncestors.clear();
                deniedValueSelves.clear();
                deniedValueAncestors.clear();
                isAllMembersDenied = true;
                isAllValuesDenied = true;
                this.cube.getMessages().addMessage(XQEMessageKeys.RLU_SecurityViewHierarchyDenied, viewName, hierarchy.getUniqueName());
            }
            if (!(!onlyMemberSecLookupRules || grantSecLookupQueries.isEmpty() && denySecLookupQueries.isEmpty())) {
                SecViewHierarchyLookupTableRestriction hierarchyLookupTablerestriction = new SecViewHierarchyLookupTableRestriction(grantSecLookupQueries, denySecLookupQueries, (ROLAPHierarchy)hierarchy, isAllMembersDenied, membersGrantType);
                restriction.addRestriction(hierarchy, hierarchyLookupTablerestriction);
            } else {
                SecViewHierarchyRestriction hierarchyMembersRestriction = new SecViewHierarchyRestriction(grantedSelves, grantedAncestors, deniedSelves, deniedAncestors, isAllMembersDenied, membersGrantType);
                restriction.addRestriction(hierarchy, hierarchyMembersRestriction, SecurityType.member);
                if (!(grantSecLookupQueries.isEmpty() && denySecLookupQueries.isEmpty() || membersGrantType == SecViewHierarchyRestriction.GrantType.ALL)) {
                    SecViewHierarchyLookupTableRestriction hierarchyLookupTablerestriction = new SecViewHierarchyLookupTableRestriction(grantSecLookupQueries, denySecLookupQueries, (ROLAPHierarchy)hierarchy, isAllMembersDenied, membersGrantType);
                    restriction.addRestriction(hierarchy, hierarchyLookupTablerestriction);
                }
            }
            SecViewHierarchyRestriction hierarchyValuesRestriction = new SecViewHierarchyRestriction(grantedValueSelves, grantedValueAncestors, deniedValueSelves, deniedValueAncestors, isAllValuesDenied, valuesGrantType);
            restriction.addRestriction(hierarchy, hierarchyValuesRestriction, SecurityType.value);
            SecViewHierarchyRestriction hierarchyAttributesRestriction = new SecViewHierarchyRestriction(grantedAttributes, deniedAttributes, isAllMembersDenied, attributesGrantType);
            restriction.addRestriction(hierarchy, hierarchyAttributesRestriction, SecurityType.attribute);
            if (!ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO)) continue;
            String memberRestLogMsg = "";
            String secLookupTableRestLogMsg = "";
            String attributeRestLogMsg = "";
            SecViewHierarchyRestriction hierarchyMembersRestriction = restriction.getRestriction(hierarchy, SecurityType.member);
            if (hierarchyMembersRestriction != null && (grantedSelves.size() > 0 || grantedAncestors.size() > 0 || deniedSelves.size() > 0 || deniedAncestors.size() > 0)) {
                memberRestLogMsg = " that has isMembersAllAccess: " + hierarchyMembersRestriction.isAllAccess() + ", isAllMembersDenied: " + isAllMembersDenied + ", number self granted members: " + grantedSelves.size() + ", number granted ancestors: " + grantedAncestors.size() + ", number self denied members: " + deniedSelves.size() + ", number denied ancestors: " + deniedAncestors.size() + ", membersGrantType: " + (Object)((Object)membersGrantType);
            }
            if ((hierarchyMemberSecLookupRest = restriction.getLookupTableRestriction(hierarchy)) != null && !denySecLookupQueries.isEmpty() || !grantSecLookupQueries.isEmpty()) {
                secLookupTableRestLogMsg = " And security lookup table restriction";
            }
            if ((hierarchyAttributeRestriction = restriction.getRestriction(hierarchy, SecurityType.attribute)) != null && (grantedAttributes.size() > 0 || deniedAttributes.size() > 0)) {
                attributeRestLogMsg = " Secutity attributes restriction, number granted attributes: " + grantedAttributes.size() + ", number denied attributes: " + deniedAttributes.size();
            }
            String logMsg = "Created restriction for hierarchy " + hierarchy.getUniqueName() + IN_SECURITY_VIEW + UniqueNameGenerator.createUniqueName(viewName) + IN_CUBE + UniqueNameGenerator.createUniqueName(this.cube.getName()) + memberRestLogMsg + ", isValuesAllAccess: " + hierarchyValuesRestriction.isAllAccess() + ", isAllValuesDenied: " + isAllValuesDenied + ", number granted Values: " + grantedValueSelves.size() + ", number granted Value Ancestors: " + grantedValueAncestors.size() + ", number denied Values: " + deniedValueAncestors.size() + ", valuesGrantType: " + (Object)((Object)valuesGrantType) + secLookupTableRestLogMsg + attributeRestLogMsg;
            ROLAPLog.log("ROLAPCubes.Security", logMsg);
        }
        if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO) && hierToRuleMap.size() == 0) {
            String logMsg = "Security view " + viewName + IN_CUBE + UniqueNameGenerator.createUniqueName(this.cube.getName()) + " has no rules, so all access.";
            ROLAPLog.log("ROLAPCubes.Security", logMsg);
        }
        return restriction;
    }

    private void addSecurityLookupQuery(ROLAPHierarchy hier, List<SecurityLookupQuery> secLookupQueries, String lookupFilterExp, List<ROLAPMetaLookupTableQueryItem> lookupTableQueryItems, ROLAPMetaRule.Scope scope) {
        SecurityLookupQuery lookupQuery = new SecurityLookupQuery(hier, lookupTableQueryItems, lookupFilterExp, scope);
        secLookupQueries.add(lookupQuery);
    }

    public Map<IMember, List<IMember>> buildCalcMemberMap(IROLAPHierarchy hierarchy) {
        HashMap<IMember, List<IMember>> calcMemberMap = new HashMap<IMember, List<IMember>>();
        for (ROLAPCalculatedMember calcMember : hierarchy.getROLAPCalculatedMembers(this.cube.getName())) {
            IMember parent = calcMember.getParent();
            if (parent == null || parent.isCalculatedMember()) continue;
            ArrayList<ROLAPCalculatedMember> memberList = (ArrayList<ROLAPCalculatedMember>)calcMemberMap.get(parent);
            if (memberList == null) {
                memberList = new ArrayList<ROLAPCalculatedMember>();
                calcMemberMap.put(parent, memberList);
            }
            memberList.add(calcMember);
        }
        return calcMemberMap;
    }

    private IROLAPDimension getRuleDimension(ROLAPSecurityDimHierarchy securityDimensionHierarchy) {
        IROLAPDimension dimension = (IROLAPDimension)this.cube.getDimension(securityDimensionHierarchy.getDimensionName());
        if (dimension == null || dimension.isMeasuresDimension() || dimension.getType() == DimensionTypeEnum.INTERNAL) {
            return dimension;
        }
        if (dimension.getMetaDimension().getCategory().equals(securityDimensionHierarchy.getDimensionCategory())) {
            return dimension;
        }
        return null;
    }

    private IROLAPHierarchy getRuleHierarchy(IROLAPDimension dimension, ROLAPSecurityDimHierarchy securityDimensionHierarchy) {
        ROLAPHierarchy hierarchy = null;
        List<IHierarchy> hierarchies = dimension.getHierarchies();
        Iterator<IHierarchy> it = hierarchies.iterator();
        while (it.hasNext() && hierarchy == null) {
            ROLAPHierarchy h = (ROLAPHierarchy)it.next();
            ROLAPMetaHierarchy metaHier = h.getMetaHierarchy();
            if (metaHier == null && h.getName().equals(securityDimensionHierarchy.getHierarchyName())) {
                hierarchy = h;
                continue;
            }
            if (!metaHier.getName().equals(securityDimensionHierarchy.getHierarchyName())) continue;
            hierarchy = h;
        }
        return hierarchy;
    }

    public void addMembers(HashSet<IMember> selves, HashSet<IMember> ancestors, String expression, IROLAPHierarchy hierarchy, ROLAPMetaRule.Scope scope, RuleType ruleType) throws Exception {
        HashSet<IMember> hierarchyMembers;
        if (expression == null || expression.length() == 0) {
            return;
        }
        ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Security", "Started fetching members from cube [" + this.cube.getName() + "] for expression: \"" + expression + QUOTE_CHAR);
        try {
            hierarchyMembers = V5ExpressionUtils.executeAndFetchMembers(hierarchy, this.cube, expression);
            ROLAPLog.log("ROLAPCubes.Security", "Expression returned " + hierarchyMembers.size() + " members.");
        }
        catch (XQERuntimeException e) {
            ROLAPLog.logError("ROLAPCubes.Security", "Expression evaluation had an error", e);
            throw e;
        }
        finally {
            ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Security", "Finished fetching members.");
        }
        for (IMember member : hierarchyMembers) {
            if (member.getHierarchy().equals(hierarchy)) continue;
            throw new XQERuntimeException(XQEMessageKeys.ROL_MembersForWrongHierarchyInSecurityExpression, hierarchy.getName(), (Object)member.getUniqueName(), (Object)member.getHierarchy().getName(), (Object)expression);
        }
        if (ruleType == RuleType.deny_member) {
            for (IMember member : hierarchyMembers) {
                ancestors.add(member);
            }
        } else {
            for (IMember member : hierarchyMembers) {
                if (scope.addDescendants()) {
                    ancestors.add(member);
                } else {
                    selves.add(member);
                }
                if (!scope.addAscendants()) continue;
                SecManager.addAscendantsTo(selves, member.getParent());
            }
        }
    }

    private void addAttributes(HashSet<IProperty> attributesSet, String expression, IROLAPHierarchy hierarchy, ROLAPMetaRule.Scope scope, RuleType ruleType) throws Exception {
        if (expression == null || expression.length() == 0) {
            return;
        }
        HashSet<IProperty> workingAttributesSet = null;
        workingAttributesSet = ruleType == RuleType.deny_attribute ? attributesSet : new HashSet();
        String propertyName = UniqueNameParser.parseLastIdentifier(expression);
        List<ILevel> rolapLevels = hierarchy.getLevels();
        block0: for (ILevel level : rolapLevels) {
            List<IProperty> propertyList = level.getMemberProperties();
            for (IProperty property : propertyList) {
                if (propertyName == null || !propertyName.equals(property.getName())) continue;
                workingAttributesSet.add(property);
                continue block0;
            }
        }
        if (ruleType != RuleType.deny_attribute) {
            attributesSet.addAll(workingAttributesSet);
        }
    }

    private void addDescendantsTo(HashSet<IMember> hashSet, List<IMember> members, Map<IMember, List<IMember>> calcMemberMap) {
        if (members != null) {
            for (IMember member : members) {
                boolean memberNotInSet = hashSet.add(member);
                if (!memberNotInSet) continue;
                this.addDescendantsTo(hashSet, member.getChildren(), calcMemberMap);
                if (calcMemberMap.size() <= 0 || member.isCalculatedMember()) continue;
                this.addDescendantsTo(hashSet, calcMemberMap.get(member), calcMemberMap);
            }
        }
    }

    public static void addAscendantsTo(HashSet<IMember> hashSet, IMember member) {
        boolean memberNotInSet;
        if (member != null && (memberNotInSet = hashSet.add(member))) {
            SecManager.addAscendantsTo(hashSet, member.getParent());
        }
    }

    @Override
    public boolean isUserSysAdmin() {
        ROLAPUserSecurityContext userSecurityContext = this.getUserSecurityContext();
        return userSecurityContext.isSystemAdministrator();
    }

    public SecViewCombinationRestriction getViewCombinationRestriction() {
        List<SecViewRestriction> restrictions = null;
        ROLAPUserSecurityContext userSecurityContext = this.getUserSecurityContext();
        if (userSecurityContext.getIsAllAccess()) {
            return null;
        }
        String viewsForUserAsCacheKey = userSecurityContext.getSecViewCombinationKey();
        SecViewCombinationRestriction viewCombinationRestriction = this.viewCombinationsToRestrictionMap.get(viewsForUserAsCacheKey);
        if (viewCombinationRestriction == null) {
            SecViewCombinationRestriction restrictionFromMap;
            if (SecManager.isLogging()) {
                ROLAPLog.log("ROLAPCubes.Security", "Creating new view combination \"" + viewsForUserAsCacheKey + "\" for current user in cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()));
            }
            String logMsg = "New view combination \"" + viewsForUserAsCacheKey + "\" in cube " + UniqueNameGenerator.createUniqueName(this.cube.getName());
            if (restrictions == null) {
                Set<String> viewsForUser = this.getSecurityViewNamesForUserInContext();
                restrictions = this.getViewRestrictionsInSortedOrder(viewsForUser);
            }
            if ((restrictionFromMap = this.viewCombinationsToRestrictionMap.putIfAbsent(viewsForUserAsCacheKey, viewCombinationRestriction = new SecViewCombinationRestriction(viewsForUserAsCacheKey, restrictions, this.cube))) != null) {
                viewCombinationRestriction = restrictionFromMap;
            }
            if (SecManager.isLogging()) {
                if (restrictions.size() == 1 && restrictions.get(0) == this.denyAllView) {
                    ROLAPLog.log("ROLAPCubes.Security", logMsg + " has all hierarchies marked as denied.");
                } else {
                    List<String> deniedHierarchies = this.findAllDeniedHierachies(viewCombinationRestriction);
                    if (deniedHierarchies.size() == 0) {
                        ROLAPLog.log("ROLAPCubes.Security", logMsg + " has all hierarchies at least partially available.");
                    } else {
                        ROLAPLog.log("ROLAPCubes.Security", logMsg + " has the following hierarchies marked as all denied: " + deniedHierarchies);
                    }
                }
            }
            if (ROLAPLog.isOn("ROLAPCubes.SecurityAudit", LogLevel.INFO)) {
                ROLAPLog.log("ROLAPCubes.SecurityAudit", viewCombinationRestriction.getAuditString());
            }
        }
        this.setIsAllDenied(viewCombinationRestriction);
        return viewCombinationRestriction;
    }

    private ROLAPUserSecurityContext createUserSecurityContextForNonSysAdmin() {
        Set<String> viewsForUser = this.getSecurityViewNamesForUserInContext();
        List<SecViewRestriction> restrictions = this.getViewRestrictionsInSortedOrder(viewsForUser);
        String securityKey = this.buildSecurityKey(restrictions);
        return new ROLAPUserSecurityContext(this, securityKey);
    }

    @Override
    public ROLAPUserSecurityContext createUserSecurityContext() {
        ROLAPContext rolapContext = ROLAPContext.get();
        if (rolapContext.isInternalUse()) {
            return ROLAPUserSecurityContext.USER_SECURITY_CONTEXT_SYSADMIN;
        }
        if (this.hasAllAccess) {
            return ROLAPUserSecurityContext.USER_SECURITY_CONTEXT_ALLACCESS;
        }
        boolean isSysAdmin = this.getIsSysAdminForUserInContext();
        ROLAPUserSecurityContext userSecurityContext = !isSysAdmin ? this.createUserSecurityContextForNonSysAdmin() : ROLAPUserSecurityContext.USER_SECURITY_CONTEXT_SYSADMIN;
        if (SecManager.isLogging()) {
            ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            if (env == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            ROLAPLog.log("ROLAPCubes.Security", "Caching security view combination key " + userSecurityContext.getSecViewCombinationKey() + " isSysAdmin: " + userSecurityContext.isSystemAdministrator() + " for user : " + ContentManager.getUserName(env.getRequestEnvironment()));
        }
        return userSecurityContext;
    }

    public ROLAPUserSecurityContext getUserSecurityContext() {
        if (this.overrideIsSysAdmin) {
            return ROLAPUserSecurityContext.USER_SECURITY_CONTEXT_SYSADMIN;
        }
        if (this.overrideModelViews != null || this.isSecurityAudit) {
            return this.createUserSecurityContextForNonSysAdmin();
        }
        ROLAPContext rolapContext = ROLAPContext.get();
        ROLAPCubeReservation cubeReservation = rolapContext.getReservation(this.cube);
        if (cubeReservation == null) {
            throw new IllegalStateException(String.format("Cannot retrieve user security context, ROLAP cube \"%s\" has not been reserved.", this.cube.getName()));
        }
        return cubeReservation.getUserSecurityContext();
    }

    private List<SecViewRestriction> getViewRestrictionsInSortedOrder(Set<String> viewsForUser) {
        ArrayList<String> viewNames = new ArrayList<String>(viewsForUser.size());
        viewNames.addAll(viewsForUser);
        Collections.sort(viewNames);
        ArrayList<SecViewRestriction> restrictions = new ArrayList<SecViewRestriction>();
        for (String viewName : viewNames) {
            SecViewRestriction restriction = this.viewRestrictions.get(viewName);
            if (restriction == null) continue;
            restrictions.add(restriction);
        }
        if (restrictions.size() == 0) {
            restrictions.add(this.denyAllView);
        }
        return restrictions;
    }

    private String buildSecurityKey(List<SecViewRestriction> restrictions) {
        ArrayList<String> names = new ArrayList<String>();
        for (SecViewRestriction restriction : restrictions) {
            names.add(restriction.getName());
            if (!restriction.isLookupRuleDefined()) continue;
            names.add(this.getExpandedFilterExpressions(restriction));
        }
        return UniqueNameGenerator.createUniqueName(names.toArray(new String[names.size()]));
    }

    @Override
    public void getLeafMemberCompositions(List<IMember> members, CompositionBuilder[] compositions) {
        for (int i = 0; i < members.size(); ++i) {
            IMember member = members.get(i);
            CompositionBuilder composition = compositions[i];
            if (member == null) {
                composition.setNext(true);
                continue;
            }
            IMember[] memsOut = this.applySecurity(new IMember[]{member}, member.getHierarchy());
            composition.setNext(memsOut != null && memsOut.length > 0 && !this.isValueSecured(member));
        }
    }

    private boolean getIsSysAdminForUserInContext() {
        boolean isSysAdmin = false;
        if (this.overrideIsSysAdmin) {
            return true;
        }
        if (this.overrideModelViews != null) {
            return false;
        }
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        Object reqEnv = env.getRequestEnvironment();
        List<ICMSessionIdentity> sessionIdentities = ContentManager.getIdentitiesList(reqEnv);
        for (ICMSessionIdentity sessionIdentity : sessionIdentities) {
            String identity = sessionIdentity.getIdentity();
            if (!identity.equals("CAMID(\"::System Administrators\")")) continue;
            isSysAdmin = true;
            if (!ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.TRACE)) break;
            ROLAPLog.logTrace("ROLAPCubes.Security", "{user: " + ContentManager.getUserName(reqEnv) + " is System Administrator and has all access");
            break;
        }
        return isSysAdmin;
    }

    private Set<String> getSecurityViewNamesForUserInContext() {
        Set<String> userModelViews = null;
        if (this.overrideModelViews != null) {
            return this.overrideModelViews;
        }
        try {
            ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            if (env == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            Object reqEnv = env.getRequestEnvironment();
            userModelViews = ContentManager.getModelViews(reqEnv, this.cube.getName(), this.securityModelViewSearchKey);
            if (ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.TRACE)) {
                ROLAPLog.logTrace("ROLAPCubes.Security", "{user : " + ContentManager.getUserName(reqEnv) + " - accessible model views : " + Arrays.toString(userModelViews.toArray()) + "}");
            }
        }
        catch (Exception e) {
            ROLAPLog.logError("ROLAPCubes.Security", "Error reading model view list for user from CM for cube " + UniqueNameGenerator.createUniqueName(this.cube.getName()) + PERIOD, e);
            throw XQERuntimeException.wrap(e);
        }
        return userModelViews;
    }

    private static boolean isLogging() {
        return ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO);
    }

    private List<String> findAllDeniedHierachies(SecViewCombinationRestriction viewCombinationRestriction) {
        ArrayList<String> deniedHierarchyNames = new ArrayList<String>();
        for (IDimension dimension : this.cube.getDimensions()) {
            for (IHierarchy hierarchy : dimension.getHierarchies()) {
                if (!viewCombinationRestriction.isRestricted(hierarchy)) continue;
                deniedHierarchyNames.add(hierarchy.getUniqueName());
            }
        }
        return deniedHierarchyNames;
    }

    public Map<String, SecViewRestriction> getViewRestrictions() {
        return this.viewRestrictions;
    }

    @Override
    public ROLAPCube getCube() {
        return this.cube;
    }

    public Map<String, ROLAPMetaView> getSecurityViewDefinitions() {
        return this.securityViewDefinitions;
    }

    public SecViewRestriction getDenyAllView() {
        return this.denyAllView;
    }

    public ConcurrentHashMap<String, SecViewCombinationRestriction> getViewCombinationsToRestrictionMap() {
        return this.viewCombinationsToRestrictionMap;
    }

    @Override
    public String getAuthorizationKeyForCurrentUser() {
        ROLAPUserSecurityContext userSecurityContext = this.getUserSecurityContext();
        return userSecurityContext.getSecViewCombinationKey();
    }

    public void setOverrideModelViews(Set<String> modelViews) {
        this.overrideModelViews = modelViews;
        this.overrideIsSysAdmin = false;
    }

    public void setOverrideIsSysAdmin(boolean isSysAdmin) {
        this.overrideIsSysAdmin = isSysAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areAllTuplesValuesVisible(ROLAPUserSecurityContext secContext, ITupleList tupleList) {
        ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Security", "Begin areAllTuplesValuesVisible() call on a tuplelist of size: " + tupleList.size());
        try {
            if (secContext.getIsAllAccess()) {
                boolean bl = true;
                return bl;
            }
            SecViewCombinationRestriction viewComboRestriction = secContext.getViewCombinationRestriction();
            if (viewComboRestriction.isSingleView() && viewComboRestriction.getSecuredValueHierarchies().size() == 0) {
                boolean bl = true;
                return bl;
            }
            List<SecViewRestriction> viewsForUser = viewComboRestriction.getViews();
            Set<IHierarchy> hierarchies = viewComboRestriction.getMemberOrValueRestrictedHierarchies();
            IHierarchy[] securedHierarchies = hierarchies.toArray(new IHierarchy[hierarchies.size()]);
            IMember[][] possibleSecuredMembers = tupleList.getMembers(securedHierarchies);
            CrossJoinedSet cjs = BlockTupleStorageUtil.createCjsFromMemberSelections(possibleSecuredMembers);
            ITupleList possibleSecuredTupleList = cjs.getTupleList();
            if (possibleSecuredTupleList != null) {
                if (possibleSecuredTupleList.size() >= tupleList.size()) {
                    ROLAPLog.logTrace("ROLAPCubes.Security", "Skipping all visible check for possible secured tuplelist of size: " + possibleSecuredTupleList.size());
                    boolean bl = false;
                    return bl;
                }
                ROLAPLog.logTrace("ROLAPCubes.Security", "Checking visiblity of possible secured tuplelist of size: " + possibleSecuredTupleList.size());
                for (ITuple tuple : possibleSecuredTupleList) {
                    if (this.isTupleValueVisibleHelper(secContext, tuple, viewComboRestriction, viewsForUser, hierarchies)) continue;
                    ROLAPLog.logTrace("ROLAPCubes.Security", "Tuple: " + tuple.toString() + " is not visible.");
                    boolean bl = false;
                    return bl;
                }
            }
            ROLAPLog.logTrace("ROLAPCubes.Security", "All tuple values are visible.");
            boolean bl = true;
            return bl;
        }
        finally {
            ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Security", "Finished areAllTuplesValuesVisible() call on a tuplelist of size: " + tupleList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areAllTuplesNotRestricted(ROLAPUserSecurityContext secContext, ITupleList tupleList) {
        ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Security", "Begin areAllTuplesNotRestricted() call on a tuplelist of size: " + tupleList.size());
        try {
            if (secContext.getIsAllAccess()) {
                boolean bl = true;
                return bl;
            }
            SecViewCombinationRestriction viewComboRestriction = secContext.getViewCombinationRestriction();
            Set<IHierarchy> hierarchies = viewComboRestriction.getMemberOrValueRestrictedHierarchies();
            IHierarchy[] securedHierarchies = hierarchies.toArray(new IHierarchy[hierarchies.size()]);
            IMember[][] possibleSecuredMembers = tupleList.getMembers(securedHierarchies);
            CrossJoinedSet cjs = BlockTupleStorageUtil.createCjsFromMemberSelections(possibleSecuredMembers);
            ITupleList possibleSecuredTupleList = cjs.getTupleList();
            if (possibleSecuredTupleList != null) {
                if (possibleSecuredTupleList.size() >= tupleList.size()) {
                    ROLAPLog.logTrace("ROLAPCubes.Security", "Skipping all tuples not restricted check on a possible secured tuplelist of size: " + possibleSecuredTupleList.size());
                    boolean bl = false;
                    return bl;
                }
                ROLAPLog.logTrace("ROLAPCubes.Security", "Checking isRestricted of possible secured tuplelist of size: " + possibleSecuredTupleList.size());
                ITupleIterator iterator = possibleSecuredTupleList.iterator();
                boolean[] tupleHierarchyHasSecuredMember = new boolean[securedHierarchies.length];
                for (int index = 0; index < tupleHierarchyHasSecuredMember.length; ++index) {
                    tupleHierarchyHasSecuredMember[index] = true;
                }
                while (iterator.hasNext()) {
                    ITuple tuple = iterator.next();
                    if (!this.isRestricted(tuple, tupleHierarchyHasSecuredMember, viewComboRestriction)) continue;
                    ROLAPLog.logTrace("ROLAPCubes.Security", "Tuple:" + tuple.toString() + " is restricted");
                    boolean bl = false;
                    return bl;
                }
            }
            ROLAPLog.logTrace("ROLAPCubes.Security", "All tuples are not restricted.");
            boolean bl = true;
            return bl;
        }
        finally {
            ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Security", "Finished areAllTuplesNotRestricted() call on a tuplelist of size: " + tupleList.size());
        }
    }

    @Override
    public boolean isTupleValueVisible(ROLAPUserSecurityContext secContext, ITuple tuple) {
        if (tuple == null || secContext.getIsAllAccess()) {
            return true;
        }
        SecViewCombinationRestriction viewComboRestriction = secContext.getViewCombinationRestriction();
        if (viewComboRestriction.isSingleView() && viewComboRestriction.getSecuredValueHierarchies().size() == 0) {
            return true;
        }
        List<SecViewRestriction> viewsForUser = viewComboRestriction.getViews();
        Set<IHierarchy> hierarchies = viewComboRestriction.getMemberOrValueRestrictedHierarchies();
        return this.isTupleValueVisibleHelper(secContext, tuple, viewComboRestriction, viewsForUser, hierarchies);
    }

    private boolean isTupleValueVisibleHelper(ROLAPUserSecurityContext secContext, ITuple tuple, SecViewCombinationRestriction viewComboRestriction, List<SecViewRestriction> viewsForUser, Set<IHierarchy> hierarchies) {
        boolean[] tupleNotVisibleInView = new boolean[viewsForUser.size()];
        for (IHierarchy hierarchy : hierarchies) {
            IMember member = tuple.getMember(hierarchy);
            if (viewComboRestriction.isSecuredValueMember(member = this.checkAndGetRolapCalculatedMember(member))) {
                return false;
            }
            int viewIdx = 0;
            for (SecViewRestriction view : viewsForUser) {
                if (!tupleNotVisibleInView[viewIdx] && view.isMemberAndOrValueRestricted(member, secContext.getSecViewCombinationKey())) {
                    tupleNotVisibleInView[viewIdx] = true;
                }
                ++viewIdx;
            }
        }
        for (int viewIdx = 0; viewIdx < tupleNotVisibleInView.length; ++viewIdx) {
            if (tupleNotVisibleInView[viewIdx]) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getCheckTupleValueVisbility() {
        if (this.isAllAccess()) {
            return false;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        if (viewCombinationRestriction.isAllAccessGranted()) {
            return false;
        }
        return !viewCombinationRestriction.isSingleView() || viewCombinationRestriction.getSecuredValueHierarchies().size() != 0;
    }

    @Override
    public boolean getMembersRollup(IHierarchy hierarchy) {
        if (this.isAllAccess()) {
            return true;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        if (viewCombinationRestriction.isAllAccessToNonCalcMembers()) {
            return true;
        }
        return !viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.member) && !viewCombinationRestriction.hasRestriction(hierarchy, SecurityType.value);
    }

    @Override
    public IMember[] getSecurityPaddingMembers(IHierarchy hierarchy, IMember member) {
        if (this.isAllAccess()) {
            return null;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        SecViewCombinationHierarchyRestriction hiearachyCombination = viewCombinationRestriction.getRestriction(hierarchy, SecurityType.member);
        if (hiearachyCombination != null) {
            return hiearachyCombination.getSecurityPaddingMembers(member);
        }
        return null;
    }

    @Override
    public IROLAPSecurityManager.MemberStatus getMemberStatus(IMember member) {
        if (this.isAllAccess()) {
            return IROLAPSecurityManager.MemberStatus.GRANTED;
        }
        if (member == null) {
            return IROLAPSecurityManager.MemberStatus.GRANTED;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        if (viewCombinationRestriction != null && !viewCombinationRestriction.isAllDenied()) {
            SecViewCombinationHierarchyRestriction hierachyCombination = viewCombinationRestriction.getRestriction(member.getHierarchy(), SecurityType.member);
            if (hierachyCombination != null) {
                return hierachyCombination.getMemberStatus(member, true);
            }
            return IROLAPSecurityManager.MemberStatus.GRANTED;
        }
        return IROLAPSecurityManager.MemberStatus.DENIED;
    }

    @Override
    public boolean hasSecurityPaddingMembers(ILevel level) {
        SecViewCombinationHierarchyRestriction hiearachyCombination;
        if (this.isAllAccess()) {
            return false;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        return viewCombinationRestriction != null && (hiearachyCombination = viewCombinationRestriction.getRestriction(level.getHierarchy(), SecurityType.member)) != null && hiearachyCombination.hasSecurityPaddingMembers(level);
    }

    @Override
    public boolean hasTupleSecurity() {
        return this.getCheckTupleValueVisbility();
    }

    @Override
    public boolean hasSecurityPaddingMembers(IHierarchy hierarchy) {
        SecViewCombinationHierarchyRestriction hiearachyCombination;
        if (this.isAllAccess()) {
            return false;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        return viewCombinationRestriction != null && (hiearachyCombination = viewCombinationRestriction.getRestriction(hierarchy, SecurityType.member)) != null && hiearachyCombination.hasSecurityPaddingMembers();
    }

    public void setIsAllDenied(SecViewCombinationRestriction viewCombinationRestriction) {
        if (viewCombinationRestriction.isAllDenied()) {
            this.isAllDenied = true;
        }
    }

    @Override
    public boolean isAllDenied() {
        return this.isAllDenied;
    }

    @Override
    public List<IProperty> applySecurity(List<IProperty> properties) {
        if (properties == null || properties.size() == 0 || this.isAllAccess()) {
            return properties;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        ArrayList<IProperty> outputProperies = new ArrayList<IProperty>(properties.size());
        for (IProperty property : properties) {
            if (viewCombinationRestriction.isSecuredAttribute(property)) continue;
            outputProperies.add(property);
        }
        if (properties.size() == outputProperies.size()) {
            return properties;
        }
        return outputProperies;
    }

    @Override
    public boolean isAttributeSecured(String propertyName, IHierarchy hierarchy) {
        if (propertyName == null || this.isAllAccess()) {
            return false;
        }
        SecViewCombinationRestriction viewCombinationRestriction = this.getViewCombinationRestriction();
        return viewCombinationRestriction.isSecuredAttribute(propertyName, hierarchy);
    }

    @Override
    public boolean isDimensionSecured(IDimension dimension) {
        SecViewCombinationRestriction viewComboRestriction = this.getViewCombinationRestriction();
        if (viewComboRestriction == null) {
            return false;
        }
        if (dimension.isMeasuresDimension()) {
            return false;
        }
        List<SecViewRestriction> viewsForUser = viewComboRestriction.getViews();
        HashSet<IDimension> grantedDimensions = new HashSet<IDimension>();
        HashSet<IDimension> deniedDimensions = new HashSet<IDimension>();
        for (SecViewRestriction view : viewsForUser) {
            grantedDimensions.addAll(view.getDimensionsGranted());
            deniedDimensions.addAll(view.getDimensionsDenied());
        }
        if (grantedDimensions.isEmpty()) {
            return deniedDimensions.contains(dimension);
        }
        return !grantedDimensions.contains(dimension) || deniedDimensions.contains(dimension);
    }

    private String getExpandedFilterExpressions(SecViewRestriction restriction) {
        if (!restriction.isLookupRuleDefined()) {
            return "";
        }
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (execEnv == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        reqEnv.initializeRequestPAC(execEnv.getConnectionElement());
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
        planEnv.setMetdataConnection(this.cube.getConnection());
        StringBuilder expandedFilterExp = new StringBuilder();
        MacroExpander expander = new MacroExpander();
        Collection<SecViewHierarchyLookupTableRestriction> ltRestrictions = restriction.getLookupTableRestrictions();
        for (SecViewHierarchyLookupTableRestriction ltRestriction : ltRestrictions) {
            List<String> filterExpressions = ltRestriction.getFilterExpressions();
            for (String filterExp : filterExpressions) {
                String expandedFilter = expander.expand(null, planEnv, filterExp);
                expandedFilterExp.append(expandedFilter);
            }
        }
        return expandedFilterExp.toString();
    }

    public SecurityLookupQueryCache getLookupQueryCache() {
        return this.mLookupQueryCache;
    }

    public void setIsSecurityAudit(boolean pIsSecurityAudit) {
        this.isSecurityAudit = pIsSecurityAudit;
    }

    public boolean getIsSecurityAudit() {
        return this.isSecurityAudit;
    }

    public class MostRecentlyCheckedAncestors {
        private Map<SecViewHierarchyRestriction, AncestorsSecurityCheckResult> mrcAncestors = new HashMap<SecViewHierarchyRestriction, AncestorsSecurityCheckResult>();
        private int ancestorLevelNumber;
        private AncestorsSecurityCheckResult currentCheckStatus;
        private SecViewHierarchyRestriction currentViewHierRest;

        public MostRecentlyCheckedAncestors(int ancLevelNumber) {
            this.ancestorLevelNumber = ancLevelNumber;
        }

        public void initAncestorCheckResult(IMember ancestor, SecViewHierarchyRestriction viewHierRestriction) {
            if (viewHierRestriction != this.currentViewHierRest) {
                this.currentCheckStatus = this.mrcAncestors.get(viewHierRestriction);
                this.currentViewHierRest = viewHierRestriction;
            }
            if (this.currentCheckStatus == null) {
                this.currentCheckStatus = new AncestorsSecurityCheckResult(this.ancestorLevelNumber);
                this.mrcAncestors.put(viewHierRestriction, this.currentCheckStatus);
            }
        }

        public Boolean getAncestorCheckResult(IMember ancestor, int ancestorIdx) {
            if (ancestor == this.currentCheckStatus.getAncestor(ancestorIdx)) {
                return this.currentCheckStatus.getCheckResult();
            }
            return null;
        }

        public void setCheckedAncestor(int ancestorIdx, IMember ancestor) {
            this.currentCheckStatus.setAncestor(ancestorIdx, ancestor);
        }

        public void setCheckedAncestorResult(int lastAncestorIdx, boolean checkResult) {
            this.currentCheckStatus.setCheckResult(checkResult);
            for (int i = lastAncestorIdx + 1; i < this.ancestorLevelNumber; ++i) {
                this.currentCheckStatus.setAncestor(i, null);
            }
        }
    }

    private class AncestorsSecurityCheckResult {
        private IMember[] ancestors;
        private boolean checkResult;

        AncestorsSecurityCheckResult(int ancestorLevelNumber) {
            this.ancestors = new IMember[ancestorLevelNumber];
        }

        public void setAncestor(int ancestorIdx, IMember ancestor) {
            this.ancestors[ancestorIdx] = ancestor;
        }

        public IMember getAncestor(int ancestorIdx) {
            return this.ancestors[ancestorIdx];
        }

        public void setCheckResult(boolean resultOfCheck) {
            this.checkResult = resultOfCheck;
        }

        public boolean getCheckResult() {
            return this.checkResult;
        }
    }

    public static enum SecurityType {
        value,
        member,
        attribute,
        member_LookupTable;

    }

    public static enum RuleType {
        deny_value,
        deny_member,
        deny_attribute,
        grant_value,
        grant_member,
        grant_attribute;


        boolean isValue() {
            return deny_value == this || grant_value == this;
        }

        boolean isMember() {
            return deny_member == this || grant_member == this;
        }

        boolean isGrant() {
            return grant_member == this || grant_value == this;
        }

        boolean isDeny() {
            return deny_member == this || deny_value == this;
        }
    }
}

