/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecViewHierarchyRestriction;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SecViewCombinationHierarchyRestriction {
    private String viewCombinationName;
    private SecViewHierarchyRestriction[] hierarchyRestrictions;
    private IHierarchy hierarchy;
    private ROLAPCube rolapCube;
    private IMember defaultMember = null;
    private HashSet<IMember> paddingMemberSet = new HashSet();
    private HashSet<ILevel> levelsWithPaddingMembers = new HashSet();
    private Map<ILevel, Integer> levelUnSecuredMemberCount = new HashMap<ILevel, Integer>();
    private SecManager.SecurityType securityType = null;
    private boolean isAllAccess;
    private SecViewHierarchyRestriction.GrantType grantType;
    private boolean isAllDenied;
    private boolean hasDeniedMembers = false;
    private boolean hasDeniedAttributes = false;
    private boolean hadGrantTypeOfExpr = false;
    private static final String RESTRICTIONS = " restrictions in view combination \"";
    private static final String QUOTE_CHAR = "\"";
    private static final String IN_CUBE = " in cube ";
    private static final String HIERARCHY = "Hierarchy ";
    private static final String MARKING_HIERARHY = "Marking hierachy ";
    private static final String AS_ALL_DENIED = " as all denied in view combination \"";
    private static final String ALL_ROOT_MEMBERS_ARE_SECURED = "\" because all root members are secured.";
    private HashSet<IMember> grantedSelves = new HashSet();
    private HashSet<IMember> grantedAncestors = new HashSet();
    private HashSet<IMember> deniedSelves = new HashSet();
    private HashSet<IMember> deniedAncestors = new HashSet();
    private HashSet<IMember> visibleAncestors = new HashSet();
    private HashSet<IProperty> deniedAttributes = new HashSet();
    private HashSet<IProperty> grantedAttributes = new HashSet();
    private boolean isAllAccessToNonCalcMembers;
    private static final String COMMA = ",";
    private static final String NEWLINE = "\n";

    public SecViewCombinationHierarchyRestriction(String pViewCombinationName, ROLAPCube cube, IHierarchy pHierarchy, SecManager.SecurityType pSecurityType) {
        this.viewCombinationName = pViewCombinationName;
        this.rolapCube = cube;
        this.hierarchy = pHierarchy;
        this.grantType = SecViewHierarchyRestriction.GrantType.NONE;
        this.isAllDenied = false;
        this.isAllAccess = true;
        this.hasDeniedMembers = false;
        this.hasDeniedAttributes = false;
        this.hierarchyRestrictions = new SecViewHierarchyRestriction[0];
        this.securityType = pSecurityType;
    }

    public boolean hasDeniedMembers() {
        return this.hasDeniedMembers;
    }

    public boolean hasDeniedAttributes() {
        return this.hasDeniedAttributes;
    }

    public boolean hasVisibleAncestors() {
        return this.visibleAncestors.size() > 0;
    }

    public boolean belongsToThisCombination(IMember m) {
        return this.paddingMemberSet.contains(m);
    }

    protected IHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public void addRestrictions(Set<SecViewHierarchyRestriction> hierRestrictions) {
        if (this.isAllDenied) {
            return;
        }
        for (SecViewHierarchyRestriction hierarchyRestriction : hierRestrictions) {
            if (hierarchyRestriction.isAllDenied()) {
                this.setAllDenied();
                return;
            }
            this.hasDeniedMembers |= hierarchyRestriction.hasDeniedMembers();
            this.hasDeniedAttributes |= hierarchyRestriction.hasDeniedAttributes();
            this.hadGrantTypeOfExpr |= hierarchyRestriction.getGrantType() == SecViewHierarchyRestriction.GrantType.EXPR;
            if (hierarchyRestriction.getGrantType() == SecViewHierarchyRestriction.GrantType.ALL) {
                this.grantType = SecViewHierarchyRestriction.GrantType.ALL;
                continue;
            }
            if (hierarchyRestriction.getGrantType() != SecViewHierarchyRestriction.GrantType.EXPR || this.grantType != SecViewHierarchyRestriction.GrantType.NONE) continue;
            this.grantType = SecViewHierarchyRestriction.GrantType.EXPR;
        }
        HashSet<SecViewHierarchyRestriction> newRestrictions = new HashSet<SecViewHierarchyRestriction>();
        if (this.hierarchyRestrictions != null && this.hierarchyRestrictions.length > 0) {
            newRestrictions.addAll(Arrays.asList(this.hierarchyRestrictions));
            newRestrictions.addAll(hierRestrictions);
            this.hierarchyRestrictions = newRestrictions.toArray(new SecViewHierarchyRestriction[newRestrictions.size()]);
        } else {
            this.hierarchyRestrictions = hierRestrictions.toArray(new SecViewHierarchyRestriction[hierRestrictions.size()]);
        }
    }

    public boolean isAllAccess() {
        return this.isAllAccess;
    }

    public boolean isAllDenied() {
        return this.isAllDenied;
    }

    public void initializeState(boolean allowMemberRollUpThroughViewCombination) {
        boolean bl = this.isAllAccess = !this.isAllDenied && !this.hasDeniedMembers && !this.hasDeniedAttributes && this.grantType != SecViewHierarchyRestriction.GrantType.EXPR && !this.hadGrantTypeOfExpr;
        if (SecManager.SecurityType.member == this.securityType || SecManager.SecurityType.member_LookupTable == this.securityType) {
            this.collectDeniedAndGrantedMembers();
            SecViewHierarchyRestriction.populateVisibleAncestors(this.visibleAncestors, this.grantedSelves, this.grantedAncestors);
            this.denyHierarchyIfAllRootMembersDenied();
            this.collectUnbalancedNodes();
            this.initializeDefaultMember();
        } else if (SecManager.SecurityType.attribute == this.securityType) {
            this.collectDeniedAndGrantedAttributes();
        }
        if (this.isAllAccess() || this.isAllDenied()) {
            this.hierarchyRestrictions = new SecViewHierarchyRestriction[0];
        }
        this.isAllAccessToNonCalcMembers = this.isAllAccess;
        if (!(this.isAllAccess || !allowMemberRollUpThroughViewCombination || this.isAllDenied || this.hasDeniedMembers || this.hasDeniedAttributes)) {
            Boolean hasAllAccess = true;
            for (IMember mem : this.hierarchy.getLevel(0).getMembers()) {
                if (this.hasAccessToMemberAndDescendants(mem)) continue;
                hasAllAccess = false;
                break;
            }
            this.isAllAccessToNonCalcMembers = hasAllAccess;
        }
        if (SecViewCombinationHierarchyRestriction.isLogging()) {
            ROLAPLog.log("ROLAPCubes.Security", HIERARCHY + this.hierarchy.getUniqueName() + IN_CUBE + this.rolapCube.getName() + " has " + SecManager.SecurityType.member.toString() + RESTRICTIONS + this.viewCombinationName + QUOTE_CHAR + ",  hasDeniedMembers: " + this.hasDeniedMembers() + ",  hasDeniedAttributes: " + this.hasDeniedAttributes() + ",  hasVisibleAncestors: " + this.hasVisibleAncestors() + ",  grantType: " + (Object)((Object)this.getGrantType()) + ",  isAllDenied : " + this.isAllDenied() + ",  isAllAccess : " + this.isAllAccess());
        }
    }

    boolean hasAccessToMemberAndDescendants(IMember mem) {
        if (this.grantedAncestors.contains(mem)) {
            return true;
        }
        if (this.grantedSelves.contains(mem)) {
            for (IMember child : mem.getChildren()) {
                if (this.hasAccessToMemberAndDescendants(child)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    private void denyHierarchyIfAllRootMembersDenied() {
        if (this.isAllDenied() || this.isAllAccess()) {
            return;
        }
        ROLAPLevel level = (ROLAPLevel)this.hierarchy.getLevel(0);
        List<IMember> members = level.getMembers(false, false);
        for (IMember member : members) {
            if (!(this.grantType == SecViewHierarchyRestriction.GrantType.EXPR ? this.isGrantedMember(member) || this.visibleAncestors.contains(member) : !this.isDeniedMember(member))) continue;
            return;
        }
        ROLAPLog.log("ROLAPCubes.Security", MARKING_HIERARHY + this.hierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(this.rolapCube.getName()) + AS_ALL_DENIED + this.viewCombinationName + ALL_ROOT_MEMBERS_ARE_SECURED);
        this.setAllDenied();
    }

    private boolean isDeniedMember(IMember member) {
        if (member == null) {
            return false;
        }
        if (this.deniedSelves.contains(member) || this.deniedAncestors.contains(member)) {
            return true;
        }
        for (IMember parent = member; parent != null; parent = parent.getParent()) {
            if (!this.deniedAncestors.contains(parent)) continue;
            return true;
        }
        return false;
    }

    private boolean isGrantedMember(IMember member) {
        if (member == null) {
            return false;
        }
        if (this.deniedSelves.contains(member) || this.deniedAncestors.contains(member)) {
            return false;
        }
        if (this.grantedSelves.contains(member) || this.grantedAncestors.contains(member)) {
            return true;
        }
        for (IMember parent = member.getParent(); parent != null; parent = parent.getParent()) {
            if (this.deniedAncestors.contains(parent)) {
                return false;
            }
            if (!this.grantedAncestors.contains(parent)) continue;
            return true;
        }
        return false;
    }

    protected void setAllDenied() {
        this.isAllDenied = true;
        this.isAllAccess = false;
        this.hasDeniedMembers = true;
        this.hasDeniedAttributes = true;
        this.grantType = SecViewHierarchyRestriction.GrantType.NONE;
        this.hierarchyRestrictions = new SecViewHierarchyRestriction[0];
        this.visibleAncestors.clear();
        this.paddingMemberSet = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeDefaultMember() {
        IMember originalDefaultMember = this.hierarchy.getDefaultMember();
        if (this.isAllAccess()) {
            this.defaultMember = originalDefaultMember;
        } else if (this.isAllDenied()) {
            this.defaultMember = null;
        } else {
            IROLAPSecurityManager.MemberStatus memberStatus = this.getMemberStatus(originalDefaultMember);
            if (memberStatus == IROLAPSecurityManager.MemberStatus.GRANTED) {
                this.defaultMember = originalDefaultMember;
                return;
            }
            List<ILevel> levels = this.hierarchy.getLevels();
            IMember commonVisibleAncestor = null;
            int levelIndex = 0;
            for (ILevel level : levels) {
                int numGrantedMembers = 0;
                int numVisibleAncestors = 0;
                IMember firstVisibleAncestor = null;
                IMember firstGrantedMember = null;
                List<IMember> members = ((ROLAPLevel)level).getMembers(false, false);
                for (IMember member : members) {
                    memberStatus = this.getMemberStatus(member);
                    if (memberStatus == IROLAPSecurityManager.MemberStatus.GRANTED) {
                        if (numGrantedMembers == 0) {
                            firstGrantedMember = member;
                        }
                        ++numGrantedMembers;
                        continue;
                    }
                    if (memberStatus != IROLAPSecurityManager.MemberStatus.VISIBLE_ANCESTOR) continue;
                    if (numVisibleAncestors == 0) {
                        firstVisibleAncestor = member;
                    }
                    ++numVisibleAncestors;
                }
                if (levelIndex == 0) {
                    if (numGrantedMembers > 0) {
                        this.defaultMember = firstGrantedMember;
                        break;
                    }
                    if (numVisibleAncestors > 1) {
                        this.defaultMember = firstVisibleAncestor;
                        break;
                    }
                    if (numVisibleAncestors != 1) {
                        ROLAPLog.log("ROLAPCubes.Security", MARKING_HIERARHY + this.hierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(this.rolapCube.getName()) + AS_ALL_DENIED + this.viewCombinationName + ALL_ROOT_MEMBERS_ARE_SECURED);
                        this.defaultMember = null;
                        this.setAllDenied();
                        return;
                    }
                    commonVisibleAncestor = firstVisibleAncestor;
                } else {
                    if (numGrantedMembers == 1) {
                        if (numVisibleAncestors == 0) {
                            this.defaultMember = firstGrantedMember;
                            break;
                        }
                        this.defaultMember = commonVisibleAncestor;
                        break;
                    }
                    if (numGrantedMembers > 1) {
                        this.defaultMember = commonVisibleAncestor;
                        break;
                    }
                    if (numGrantedMembers == 0) {
                        if (numVisibleAncestors > 1) {
                            this.defaultMember = commonVisibleAncestor;
                            break;
                        }
                        if (numVisibleAncestors == 1) {
                            commonVisibleAncestor = firstVisibleAncestor;
                        }
                    }
                }
                ++levelIndex;
            }
        }
        if (this.defaultMember == originalDefaultMember) return;
        String defaultMemberName = "";
        if (this.defaultMember != null) {
            defaultMemberName = this.defaultMember.getUniqueName();
            ROLAPLog.log("ROLAPCubes.Security", "Hierachy " + this.hierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(this.rolapCube.getName()) + " has its default member changed to " + defaultMemberName + " from " + this.hierarchy.getDefaultMember().getUniqueName() + " in view combination \"" + this.viewCombinationName + "\".");
            return;
        }
        this.setAllDenied();
        ROLAPLog.log("ROLAPCubes.Security", MARKING_HIERARHY + this.hierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(this.rolapCube.getName()) + AS_ALL_DENIED + this.viewCombinationName + "\" because there is no valid default member.");
    }

    public IMember getDefaultMember() {
        return this.defaultMember;
    }

    public SecViewHierarchyRestriction.GrantType getGrantType() {
        return this.grantType;
    }

    private IROLAPSecurityManager.MemberStatus getMemberStatus(IMember member) {
        if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR) {
            if (this.visibleAncestors.contains(member)) {
                return IROLAPSecurityManager.MemberStatus.VISIBLE_ANCESTOR;
            }
            if (this.isGrantedMember(member)) {
                return IROLAPSecurityManager.MemberStatus.GRANTED;
            }
            return IROLAPSecurityManager.MemberStatus.DENIED;
        }
        if (this.isDeniedMember(member)) {
            return IROLAPSecurityManager.MemberStatus.DENIED;
        }
        return IROLAPSecurityManager.MemberStatus.GRANTED;
    }

    public IROLAPSecurityManager.MemberStatus getMemberStatus(IMember member, boolean checkVisibleAncestor) {
        return this.getMemberStatus(member, checkVisibleAncestor, null, null);
    }

    public IROLAPSecurityManager.MemberStatus getMemberStatus(IMember member, boolean checkVisibleAncestor, SecManager.MostRecentlyCheckedAncestors mrcgAncestors, SecManager.MostRecentlyCheckedAncestors mrcdAncestors) {
        if (this.isAllDenied()) {
            return IROLAPSecurityManager.MemberStatus.DENIED;
        }
        if (this.isAllAccess()) {
            return IROLAPSecurityManager.MemberStatus.GRANTED;
        }
        if (member instanceof ROLAPSecurityPaddingMemberProxy) {
            if (this.belongsToThisCombination(member)) {
                return IROLAPSecurityManager.MemberStatus.SECURED_PADDING_MEMBER;
            }
            return IROLAPSecurityManager.MemberStatus.DENIED;
        }
        if (member instanceof NullMember) {
            return IROLAPSecurityManager.MemberStatus.GRANTED;
        }
        boolean isCalculatedMember = false;
        if (member.getType() == MemberTypeEnum.QUERY_CALCULATION || member.getType() == MemberTypeEnum.SESSION_CALCULATION) {
            isCalculatedMember = true;
            IMember parent = member.getParent();
            if (parent == null) {
                return IROLAPSecurityManager.MemberStatus.GRANTED;
            }
            member = parent;
        }
        if (this.hasDeniedMembers) {
            for (SecViewHierarchyRestriction restriction : this.hierarchyRestrictions) {
                if (!restriction.isDeniedMember(member, mrcdAncestors)) continue;
                return IROLAPSecurityManager.MemberStatus.DENIED;
            }
        }
        if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR) {
            for (SecViewHierarchyRestriction restriction : this.hierarchyRestrictions) {
                if (!restriction.isGrantedMember(member, mrcgAncestors)) continue;
                return IROLAPSecurityManager.MemberStatus.GRANTED;
            }
            if ((checkVisibleAncestor || isCalculatedMember) && this.visibleAncestors.contains(member)) {
                if (isCalculatedMember) {
                    return IROLAPSecurityManager.MemberStatus.GRANTED;
                }
                return IROLAPSecurityManager.MemberStatus.VISIBLE_ANCESTOR;
            }
            return IROLAPSecurityManager.MemberStatus.NONE;
        }
        return IROLAPSecurityManager.MemberStatus.GRANTED;
    }

    public IROLAPSecurityManager.AttributeStatus getAttributeStatus(IProperty property) {
        if (!this.hasDeniedAttributes && !this.hadGrantTypeOfExpr) {
            return IROLAPSecurityManager.AttributeStatus.GRANTED;
        }
        if (property instanceof NullMember) {
            return IROLAPSecurityManager.AttributeStatus.GRANTED;
        }
        if (this.hasDeniedAttributes) {
            for (SecViewHierarchyRestriction restriction : this.hierarchyRestrictions) {
                if (!restriction.isDeniedAttribute(property)) continue;
                return IROLAPSecurityManager.AttributeStatus.DENIED;
            }
        }
        if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR) {
            for (SecViewHierarchyRestriction restriction : this.hierarchyRestrictions) {
                if (!restriction.isGrantedAttribute(property)) continue;
                return IROLAPSecurityManager.AttributeStatus.GRANTED;
            }
            return IROLAPSecurityManager.AttributeStatus.NONE;
        }
        return IROLAPSecurityManager.AttributeStatus.GRANTED;
    }

    public IROLAPSecurityManager.AttributeStatus getAttributeStatus(String propertyName) {
        if (!this.hasDeniedAttributes && !this.hadGrantTypeOfExpr) {
            return IROLAPSecurityManager.AttributeStatus.GRANTED;
        }
        if (this.hasDeniedAttributes) {
            for (SecViewHierarchyRestriction restriction : this.hierarchyRestrictions) {
                if (!restriction.isDeniedAttribute(propertyName)) continue;
                return IROLAPSecurityManager.AttributeStatus.DENIED;
            }
        }
        if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR) {
            for (SecViewHierarchyRestriction restriction : this.hierarchyRestrictions) {
                if (!restriction.isGrantedAttribute(propertyName)) continue;
                return IROLAPSecurityManager.AttributeStatus.GRANTED;
            }
            return IROLAPSecurityManager.AttributeStatus.NONE;
        }
        return IROLAPSecurityManager.AttributeStatus.GRANTED;
    }

    private static boolean isLogging() {
        return ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO);
    }

    private void collectDeniedAndGrantedMembers() {
        for (SecViewHierarchyRestriction hierRestriction : this.hierarchyRestrictions) {
            if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR && hierRestriction.getGrantType() == SecViewHierarchyRestriction.GrantType.EXPR) {
                this.grantedSelves.addAll(hierRestriction.getGrantedSelves());
                this.grantedAncestors.addAll(hierRestriction.getGrantedAncestors());
            }
            if (!hierRestriction.hasDeniedMembers()) continue;
            this.deniedSelves.addAll(hierRestriction.getDeniedSelves());
            this.deniedAncestors.addAll(hierRestriction.getDeniedAncestors());
        }
        if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR) {
            SecViewHierarchyRestriction.removeDescendants(this.grantedAncestors, this.deniedAncestors, true);
            SecViewHierarchyRestriction.removeDescendants(this.grantedAncestors, this.grantedAncestors, false);
            SecViewHierarchyRestriction.removeDescendants(this.grantedSelves, this.deniedAncestors, true);
            SecViewHierarchyRestriction.removeDescendants(this.grantedSelves, this.grantedAncestors, true);
            this.grantedSelves.removeAll(this.deniedSelves);
            if (this.grantedSelves.size() == 0 && this.grantedAncestors.size() == 0) {
                this.setAllDenied();
                ROLAPLog.log("ROLAPCubes.Security", MARKING_HIERARHY + this.hierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(this.rolapCube.getName()) + AS_ALL_DENIED + this.viewCombinationName + "\" because there are no members granted.");
                return;
            }
        }
    }

    private void collectDeniedAndGrantedAttributes() {
        for (SecViewHierarchyRestriction hierRestriction : this.hierarchyRestrictions) {
            if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR && hierRestriction.getGrantType() == SecViewHierarchyRestriction.GrantType.EXPR) {
                this.grantedAttributes.addAll(hierRestriction.getGrantedAttributes());
            }
            if (!hierRestriction.hasDeniedAttributes()) continue;
            this.deniedAttributes.addAll(hierRestriction.getDeniedAttributes());
        }
        if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR) {
            this.grantedAttributes.removeAll(this.deniedAttributes);
            this.deniedAttributes.clear();
        }
    }

    private void collectUnbalancedNodes() {
        if (this.isAllAccess() || this.isAllDenied()) {
            return;
        }
        if (this.hierarchy.isParentChild()) {
            return;
        }
        HashSet<IMember> visitedMembers = new HashSet<IMember>();
        for (IMember deniedMember : this.deniedAncestors) {
            IMember member = deniedMember.getParent();
            if (member == null || visitedMembers.contains(member) || !this.isUnbalancedNode(member)) continue;
            this.addPaddingMembersUnbalancedNodes(member);
            visitedMembers.add(member);
        }
        if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR) {
            for (IMember member : this.grantedSelves) {
                if (visitedMembers.contains(member) || member.getLevel().isLeafLevel() || member.isCalculatedMember() || !this.isUnbalancedNode(member)) continue;
                this.addPaddingMembersUnbalancedNodes(member);
                visitedMembers.add(member);
            }
            for (IMember member : this.grantedAncestors) {
                if (visitedMembers.contains(member) || member.getLevel().isLeafLevel() || member.isCalculatedMember() || !this.isUnbalancedNode(member)) continue;
                this.addPaddingMembersUnbalancedNodes(member);
                visitedMembers.add(member);
            }
        }
        if (this.paddingMemberSet.size() > 0 && ROLAPLog.isOn("ROLAPCubes.Security")) {
            StringBuilder sb = new StringBuilder();
            for (IMember paddingMember : this.paddingMemberSet) {
                IMember unbalancedNode = paddingMember.getParent();
                if (unbalancedNode instanceof ROLAPSecurityPaddingMemberProxy) continue;
                sb.append(unbalancedNode.getName());
                sb.append(COMMA);
            }
            ROLAPLog.log("ROLAPCubes.Security", "Unbalanced nodes for hierarchy " + this.hierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(this.rolapCube.getName()) + " with view combination " + this.viewCombinationName + " : {" + sb.toString() + "}");
        }
    }

    private boolean isUnbalancedNode(IMember member) {
        boolean isUnbalancedNode = false;
        boolean isMemberGranted = false;
        if (this.grantType == SecViewHierarchyRestriction.GrantType.EXPR) {
            isMemberGranted = this.isGrantedMember(member);
        } else {
            boolean bl = isMemberGranted = !this.isDeniedMember(member);
        }
        if (isMemberGranted) {
            isUnbalancedNode = !this.hasVisibleChild(member);
        }
        return isUnbalancedNode;
    }

    private boolean hasVisibleChild(IMember member) {
        if (member instanceof ROLAPMemberProxy) {
            IOrderedMap<IMember> children = ((ROLAPMemberProxy)member).getChildrenOrderedMap();
            if (children != null) {
                for (IMember child : children) {
                    if (child instanceof ROLAPSecurityPaddingMemberProxy || !(this.grantType == SecViewHierarchyRestriction.GrantType.EXPR ? this.isGrantedMember(child) || this.visibleAncestors.contains(child) : !this.isDeniedMember(child))) continue;
                    return true;
                }
            }
        } else {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Member " + member.getUniqueName() + " is not of type ROLAPMemberProxy.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPaddingMembersUnbalancedNodes(IMember member) {
        IMember iMember = member;
        synchronized (iMember) {
            IMember[] paddingMembers = this.getDescendantPaddingMembers(member);
            if (paddingMembers == null && (paddingMembers = this.createPaddingMembersUnbalancedNodes(member)).length > 0) {
                ((ROLAPMemberProxy)member).setSecurityPaddingMember((ROLAPSecurityPaddingMemberProxy)paddingMembers[0]);
            }
            this.paddingMemberSet.addAll(Arrays.asList(paddingMembers));
        }
    }

    private IMember[] createPaddingMembersUnbalancedNodes(IMember member) {
        IMember[] paddingMembers = new IMember[member.getHierarchy().getLevelCount() - member.getLevel().getIndex() - 1];
        IMember parent = member;
        for (ILevel level = member.getLevel().getNextLevel(); level != null; level = level.getNextLevel()) {
            this.levelsWithPaddingMembers.add(level);
            paddingMembers[level.getIndex() - member.getLevel().getIndex() - 1] = new ROLAPSecurityPaddingMemberProxy(this.createSecurityPaddingMemberCacheKey(parent), "_SECURED_", level, parent);
            if (parent instanceof ROLAPSecurityPaddingMemberProxy) {
                ((ROLAPMemberProxy)parent).setSecurityPaddingMember((ROLAPSecurityPaddingMemberProxy)paddingMembers[level.getIndex() - member.getLevel().getIndex() - 1]);
            }
            parent = paddingMembers[level.getIndex() - member.getLevel().getIndex() - 1];
        }
        return paddingMembers;
    }

    private MetadataCacheKey createSecurityPaddingMemberCacheKey(IMember member) {
        IROLAPDimension d = ((IROLAPMember)member).getROLAPDimension();
        int maxMemberId = ((Dimension)member.getDimension()).getmaxMemberId();
        return new MetadataCacheKey(this.rolapCube.getDimensionIndex(d), maxMemberId);
    }

    public IMember[] getSecurityPaddingMembers(IMember member) {
        IMember[] paddingMembers = this.getDescendantPaddingMembers(member);
        if (paddingMembers != null && this.paddingMemberSet.contains(paddingMembers[0])) {
            return paddingMembers;
        }
        return null;
    }

    private IMember[] getDescendantPaddingMembers(IMember member) {
        IOrderedMap<IMember> childrenList = ((ROLAPMemberProxy)member).getChildrenOrderedMap();
        if (childrenList == null) {
            return null;
        }
        IMember paddingMember = childrenList.get("_SECURED_");
        if (paddingMember == null) {
            return null;
        }
        IMember[] paddingMembers = new IMember[member.getHierarchy().getLevelCount() - member.getLevel().getIndex() - 1];
        ILevel level = paddingMember.getLevel();
        while (level != null) {
            this.levelsWithPaddingMembers.add(level);
            paddingMembers[level.getIndex() - member.getLevel().getIndex() - 1] = paddingMember;
            level = null;
            childrenList = ((ROLAPMemberProxy)paddingMember).getChildrenOrderedMap();
            if (childrenList == null || (paddingMember = childrenList.get("_SECURED_")) == null) continue;
            level = paddingMember.getLevel();
        }
        return paddingMembers;
    }

    public boolean hasSecurityPaddingMembers() {
        return this.paddingMemberSet != null && this.paddingMemberSet.size() > 0;
    }

    public boolean hasSecurityPaddingMembers(ILevel level) {
        return this.levelsWithPaddingMembers.contains(level);
    }

    public Integer getUnSecuredMemberCount(ILevel level) {
        return this.levelUnSecuredMemberCount.get(level);
    }

    public void setUnSecuredMemberCount(ILevel level, Integer unsecMemberCount) {
        this.levelUnSecuredMemberCount.put(level, unsecMemberCount);
    }

    public String getAuditString() {
        String auditString = "";
        auditString = auditString + "Hierarchy: " + this.hierarchy.getUniqueName() + NEWLINE;
        if (this.isAllAccess()) {
            auditString = auditString + "isAllAccess : " + this.isAllAccess() + NEWLINE;
            return auditString;
        }
        if (this.isAllDenied()) {
            auditString = auditString + "isAllDenied : " + this.isAllDenied() + NEWLINE;
            return auditString;
        }
        if (this.hierarchy.getDimension().isMeasuresDimension()) {
            if (!this.grantedSelves.isEmpty() || !this.grantedAncestors.isEmpty()) {
                auditString = auditString + "Granted measures: ";
                for (IMember member : this.grantedSelves) {
                    auditString = auditString + member.getUniqueName();
                    auditString = auditString + COMMA;
                }
                for (IMember member : this.grantedAncestors) {
                    auditString = auditString + member.getUniqueName();
                    auditString = auditString + COMMA;
                }
                auditString = auditString + NEWLINE;
            }
            if (!this.deniedSelves.isEmpty() || !this.deniedAncestors.isEmpty()) {
                auditString = auditString + "Denied measures: ";
                for (IMember member : this.deniedSelves) {
                    auditString = auditString + member.getUniqueName();
                    auditString = auditString + COMMA;
                }
                for (IMember member : this.deniedAncestors) {
                    auditString = auditString + member.getUniqueName();
                    auditString = auditString + COMMA;
                }
                auditString = auditString + NEWLINE;
            }
        } else {
            if (!this.grantedSelves.isEmpty()) {
                auditString = auditString + "Granted members: ";
                for (IMember member : this.grantedSelves) {
                    auditString = auditString + member.getUniqueName();
                    auditString = auditString + COMMA;
                }
                auditString = auditString + NEWLINE;
            }
            if (!this.grantedAncestors.isEmpty()) {
                auditString = auditString + "Granted members and descendants: ";
                for (IMember member : this.grantedAncestors) {
                    auditString = auditString + member.getUniqueName();
                    auditString = auditString + COMMA;
                }
                auditString = auditString + NEWLINE;
            }
            if (!this.deniedSelves.isEmpty()) {
                auditString = auditString + "Denied members: ";
                for (IMember member : this.deniedSelves) {
                    auditString = auditString + member.getUniqueName();
                    auditString = auditString + COMMA;
                }
                auditString = auditString + NEWLINE;
            }
            if (!this.deniedAncestors.isEmpty()) {
                auditString = auditString + "Denied members and descendants: ";
                for (IMember member : this.deniedAncestors) {
                    auditString = auditString + member.getUniqueName();
                    auditString = auditString + COMMA;
                }
                auditString = auditString + NEWLINE;
            }
        }
        if (!this.grantedAttributes.isEmpty()) {
            auditString = auditString + "Granted attributes: ";
            for (IProperty property : this.grantedAttributes) {
                auditString = auditString + property.getUniqueName();
                auditString = auditString + NEWLINE;
            }
            auditString = auditString + NEWLINE;
        }
        if (!this.deniedAttributes.isEmpty()) {
            auditString = "Denied attributes: ";
            for (IProperty property : this.deniedAttributes) {
                auditString = auditString + property.getUniqueName();
                auditString = auditString + COMMA;
            }
            auditString = auditString + NEWLINE;
        }
        return auditString;
    }

    public boolean isAllAccessToNonCalcMembers() {
        return this.isAllAccessToNonCalcMembers;
    }
}

