/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLookupTableQueryItem;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaRule;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecurityLookupQueryItem;
import com.cognos.xqe.util.primitive.HashMapObjectInt;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;

public class SecurityLookupQuery {
    private final HashMap<String, SecurityLookupQueryItem> queryItems = new HashMap();
    private final ArrayList<ROLAPLevel> orderedLevelSequence = new ArrayList();
    private final HashMapObjectInt<String> queryItemsColumns = new HashMapObjectInt();
    private final String filter;
    private final ROLAPMetaRule.Scope mScope;
    private final HashMap<ROLAPLevel, BitSet> mLevelMainKeyColumn = new HashMap();
    private final ArrayList<String[]> mDataItemDefs = new ArrayList();
    private ROLAPHierarchy mHier;

    public SecurityLookupQuery(ROLAPHierarchy hier, List<ROLAPMetaLookupTableQueryItem> lookupTableQueryItems, String lookupFilterExp, ROLAPMetaRule.Scope scope) {
        this.mHier = hier;
        this.processQueryItems(lookupTableQueryItems);
        this.filter = lookupFilterExp;
        this.mScope = scope;
    }

    /*
     * WARNING - void declaration
     */
    private void processQueryItems(List<ROLAPMetaLookupTableQueryItem> lookupTableQueryItems) {
        for (ROLAPMetaLookupTableQueryItem rOLAPMetaLookupTableQueryItem : lookupTableQueryItems) {
            SecurityLookupQueryItem qi;
            String levelRef = rOLAPMetaLookupTableQueryItem.getLevelRef();
            if (levelRef == null) {
                levelRef = "";
            }
            if ((qi = this.queryItems.get(levelRef)) == null) {
                qi = new SecurityLookupQueryItem(levelRef);
                this.queryItems.put(levelRef, qi);
            }
            qi.add(rOLAPMetaLookupTableQueryItem.getQueryItemRef());
            if (this.queryItemsColumns.containsKey(rOLAPMetaLookupTableQueryItem.getQueryItemRef())) continue;
            this.queryItemsColumns.put(rOLAPMetaLookupTableQueryItem.getQueryItemRef(), this.queryItemsColumns.size());
            this.mDataItemDefs.add(new String[]{rOLAPMetaLookupTableQueryItem.getQueryItemRef(), rOLAPMetaLookupTableQueryItem.getQueryItemRef(), "ascending"});
        }
        if (!this.mHier.isParentChild()) {
            void var3_6;
            HashMap<ROLAPLevel, BitSet> levelBitMasks = new HashMap<ROLAPLevel, BitSet>();
            for (SecurityLookupQueryItem queryItem : this.queryItems.values()) {
                BitSet columnPositions = new BitSet();
                ArrayList<String> queryItemParts = queryItem.getKeyQueryItems();
                for (String queryItemPart : queryItemParts) {
                    int pos = this.queryItemsColumns.get(queryItemPart);
                    columnPositions.set(pos);
                }
                ROLAPLevel level = (ROLAPLevel)this.mHier.getLevel(queryItem.getLevelRef());
                levelBitMasks.put(level, columnPositions);
                int i = 0;
                for (ROLAPLevel storedLevel : this.orderedLevelSequence) {
                    if (storedLevel.getIndex() < level.getIndex()) break;
                    ++i;
                }
                this.orderedLevelSequence.add(i, level);
            }
            boolean bl = false;
            while (var3_6 < this.orderedLevelSequence.size()) {
                ROLAPLevel level = this.orderedLevelSequence.get((int)var3_6);
                BitSet levelBitMask = (BitSet)((BitSet)levelBitMasks.get(level)).clone();
                for (void j = var3_6 + true; j < this.orderedLevelSequence.size(); ++j) {
                    ROLAPLevel parentLevel = this.orderedLevelSequence.get((int)j);
                    levelBitMask.andNot((BitSet)levelBitMasks.get(parentLevel));
                }
                if (levelBitMask.isEmpty()) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_CannotFindIdentColumnForLevel, level.getName());
                }
                this.mLevelMainKeyColumn.put(level, levelBitMask);
                ++var3_6;
            }
        }
    }

    public HashMap<String, SecurityLookupQueryItem> getQueryItems() {
        return this.queryItems;
    }

    public String getFilterExpression() {
        return this.filter;
    }

    public ROLAPMetaRule.Scope getScope() {
        return this.mScope;
    }

    public ArrayList<String[]> getDataItemDefs() {
        return this.mDataItemDefs;
    }

    public IValue[] getKeys(ILevel level, IValue[] values) {
        boolean allNull = true;
        for (int i = 0; i < values.length; ++i) {
            if (values[i].isNull()) continue;
            allNull = false;
            break;
        }
        if (allNull) {
            Level l = (Level)this.mHier.getLevel(0);
            if (!l.isAllLevel()) {
                return null;
            }
            return new IValue[0];
        }
        ArrayList<IValue> keyValues = new ArrayList<IValue>();
        if (this.mHier.isParentChild()) {
            SecurityLookupQueryItem qi = this.queryItems.get("");
            for (String keyItem : qi.getKeyQueryItems()) {
                keyValues.add((IValue)values[this.queryItemsColumns.get(keyItem)].copy());
            }
        } else {
            SecurityLookupQueryItem qi = this.queryItems.get(level.getName());
            for (String keyItem : qi.getKeyQueryItems()) {
                keyValues.add((IValue)values[this.queryItemsColumns.get(keyItem)].copy());
            }
        }
        return keyValues.toArray(new IValue[keyValues.size()]);
    }

    public ILevel findLevel(IValue[] values) {
        if (this.mHier.isParentChild()) {
            return null;
        }
        BitSet columnValues = new BitSet();
        for (int i = 0; i < values.length; ++i) {
            IValue val = values[i];
            if (val.isNull()) continue;
            columnValues.set(i);
        }
        if (columnValues.isEmpty()) {
            Level l = (Level)this.mHier.getLevel(0);
            if (!l.isAllLevel()) {
                return null;
            }
            return l;
        }
        ROLAPLevel foundLevel = null;
        for (ROLAPLevel level : this.orderedLevelSequence) {
            BitSet mask = (BitSet)this.mLevelMainKeyColumn.get(level).clone();
            mask.and(columnValues);
            if (mask.isEmpty()) continue;
            foundLevel = level;
            break;
        }
        return foundLevel;
    }
}

