/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SecurityValidation {
    public static void validateHierarchyBalancedAtOriginalLevel(IHierarchy hierarchy, Set<IMember> deniedMembers) throws XQERuntimeException {
        HashSet<IMember> visitedMembers = new HashSet<IMember>();
        for (IMember deniedMember : deniedMembers) {
            IMember member = deniedMember.getParent();
            if (member == null || deniedMembers.contains(member) || visitedMembers.contains(member)) continue;
            if (SecurityValidation.isLeaf(member, deniedMembers)) {
                ILevel origLeafLevel = hierarchy.getLevel(hierarchy.getLevelCount() - 1);
                throw new XQERuntimeException(XQEMessageKeys.ROL_NewLeafMemberCreatedBySecurityRulesAtNewLevel, (Object)hierarchy.getName(), (Object)member.getUniqueName(), (Object)origLeafLevel.getUniqueName());
            }
            visitedMembers.add(member);
        }
    }

    private static boolean isLeaf(IMember member, Set<IMember> deniedMembers) {
        boolean leaf = true;
        List<IMember> children = member.getChildren();
        if (children != null) {
            for (IMember child : children) {
                if (deniedMembers.contains(child)) continue;
                leaf = false;
                break;
            }
        }
        return leaf;
    }
}

